/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Window
 *   XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes)
 *   Display	*display;
 *   Window	parent;
 *   int 	x;
 *   int 	y;
 *   unsigned int 	width;
 *   unsigned int 	height;
 *   unsigned int 	border_width;
 *   int 	depth;
 *   unsigned int 	class;
 *   Visual	*visual;
 *   unsigned long	valuemask;
 *   XSetWindowAttributes	*attributes;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XCreateWindow	1
char    *TestName = "XCreateWindow";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW parent
#define A_DRAWABLE parent


/*
 * Arguments to the XCreateWindow function
 */
static Display	*display;
static Window	parent;
static int 	x;
static int 	y;
static unsigned int 	width;
static unsigned int 	height;
static unsigned int 	border_width;
static int 	depth;
static unsigned int 	class;
static Visual	*visual;
static unsigned long	valuemask;
static XSetWindowAttributes	*attributes;



static XSetWindowAttributes	Atts;

static Window
interceptXCW(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes)
Display	*display;
Window	parent;
int 	x;
int 	y;
unsigned int 	width;
unsigned int 	height;
unsigned int 	border_width;
int 	depth;
unsigned int 	class;
Visual	*visual;
unsigned long	valuemask;
XSetWindowAttributes	*attributes;
{
Colormap	cm;
Visual	*vis;
XWindowAttributes	atts;

	/*
	 * Problem:  The colormap has to match the visual, however the default
	 * is CopyFromParent which is of no use when the parent has a different
	 * type to the window that is being created.
	 * If parent, visual, depths are not default and the test is not already
	 * setting the colormap and class is InputOutput then set an appropriate
	 * one here.
	 */
	if ((valuemask & CWColormap) == 0 &&
			(
			visual != DefaultVisual(Dsp, DefaultScreen(Dsp)) ||
			parent != DefaultRootWindow(Dsp) ||
			depth != DefaultDepth(Dsp, DefaultScreen(Dsp))
			)
		) {

		if (visual == CopyFromParent || class == CopyFromParent)
			XGetWindowAttributes(display, parent, &atts);

		if (visual == CopyFromParent) {
			vis = atts.visual;
		} else
			vis = visual;

		if (class == InputOutput || (class == CopyFromParent && atts.class == InputOutput)) {
			cm = makecolmap(display, vis, AllocNone);
			attributes->colormap = cm;
			valuemask |= CWColormap;
		}
	}

        /*
         * Set the border pixel value if not set to ensure that a depth
         * mismatch does not occur (since the default BorderPixel is
         * CopyFromParent) causing a BadMatch.
	 * We only need to do this for InputOutput windows, of course,
	 * otherwise we get a BadMatch for an attempted draw on an
	 * InputOnly window.
 	 * Also we must never ever do this if we are using a border pixmap.
         */
	if ( (valuemask & CWBorderPixmap) == 0 && 
		(valuemask & CWBorderPixel) == 0 &&
		( visual != DefaultVisual(Dsp, DefaultScreen(Dsp)) ||
	 	 parent != DefaultRootWindow(Dsp) ||
		 depth != DefaultDepth(Dsp, DefaultScreen(Dsp))
		))
	{

		if (class == CopyFromParent)
			XGetWindowAttributes(display, parent, &atts);

		if (class == InputOutput ||
			(class == CopyFromParent &&
			atts.class == InputOutput))
		{

			attributes->border_pixel = W_FG;
			valuemask |= CWBorderPixel;
		}
        }

	return XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
}
#define XCreateWindow interceptXCW


#include	"X11/cursorfont.h"


static int
checkatts(setatts, getatts, vmask)
XSetWindowAttributes	*setatts;
XWindowAttributes	*getatts;
unsigned long 	vmask;
{
int 	pass = 0, fail = 0;

	/*
	 * Maybe we should alway check everything??? (No vmask)
	 */
	if ((vmask&CWBitGravity) && setatts->bit_gravity != getatts->bit_gravity) {
		report("bit_gravity got %s, expected %s",
			bitgravityname(getatts->bit_gravity),
			bitgravityname(setatts->bit_gravity));
		FAIL;
	} else
		CHECK;

	if ((vmask&CWWinGravity) && setatts->win_gravity != getatts->win_gravity) {
		report("window_gravity got %s, expected %s",
			wingravityname(getatts->win_gravity),
			wingravityname(setatts->win_gravity));
		FAIL;
	} else
		CHECK;

	if ((vmask&CWBackingStore) && setatts->backing_store != getatts->backing_store) {
		report("backing_store got %s, expected %s",
			backingstorename(getatts->backing_store),
			backingstorename(setatts->backing_store));
		FAIL;
	} else
		CHECK;

	if ((vmask&CWBackingPlanes) && setatts->backing_planes != getatts->backing_planes) {
		report("backing_planes got 0x%x, expected 0x%x",
			getatts->backing_planes,
			setatts->backing_planes);
		FAIL;
	} else
		CHECK;

	if (setatts->backing_pixel != getatts->backing_pixel) {
		report("backing_pixel got 0x%x, expected 0x%x",
			getatts->backing_pixel,
			setatts->backing_pixel);
		FAIL;
	} else
		CHECK;

	if ((vmask&CWSaveUnder) && setatts->save_under != getatts->save_under) {
		report("save_under got %s, expected %s",
			boolname(getatts->save_under),
			boolname(setatts->save_under));
		FAIL;
	} else
		CHECK;

	if ((vmask&CWEventMask) && setatts->event_mask != getatts->your_event_mask) {
		report("event_mask got %s, expected %s",
			eventmaskname(getatts->your_event_mask),
			eventmaskname(setatts->event_mask));
		FAIL;
	} else
		CHECK;

	if ((vmask&CWDontPropagate) && setatts->do_not_propagate_mask != getatts->do_not_propagate_mask) {
		report("do_not_propagate_mask got %s, expected %s",
			eventmaskname(getatts->do_not_propagate_mask),
			eventmaskname(setatts->do_not_propagate_mask));
		FAIL;
	} else
		CHECK;

	if ((vmask&CWOverrideRedirect) && setatts->override_redirect != getatts->override_redirect) {
		report("override_redirect got %s, expected %s",
			boolname(getatts->override_redirect),
			boolname(setatts->override_redirect));
		FAIL;
	} else
		CHECK;

	if ((vmask&CWColormap) && setatts->colormap != getatts->colormap) {
		report("colormap got 0x%x, expected 0x%x",
			getatts->colormap,
			setatts->colormap);
		FAIL;
	} else
		CHECK;

	if (fail == 0 && pass == 10)
		return(0);
	else {
		if (fail)
			return(fail);
		else
			delete("Path check error in checkatts");
	}
	return(-1);
}



static Window	w;

static void
setinonly()
{
	class = InputOnly;
	depth = 0;
	visual = CopyFromParent;
	border_width = 0;
}


#define XCWA_NORMAL	0
#define XCWA_DEFCOLMAP	1
#define	XCWA_GRAVITY	2
#define XCWA_VISDEPTH	3

static Window
makeinout(mio_parent, mio_visual, mio_depth, mio_mode)
Window mio_parent;
Visual *mio_visual;
int	mio_depth;
int	mio_mode;
{
	Display	*mio_display;
	int	mio_x, mio_y;
	unsigned int	mio_width, mio_height;
	unsigned int	mio_border_width;
	unsigned int	mio_class;
	unsigned long	mio_valuemask;
	XSetWindowAttributes	*mio_aptr;
	XSetWindowAttributes	mio_a;
	

/* If we are passed a parent of None, then we need to set it ourselves. */
	if(mio_parent == None)
	{
		mio_parent = DRW(Dsp);
	}

	mio_display = Dsp;
	mio_x = 50;
	mio_y = 60;
	mio_width = 20;
	mio_height = 17;
	mio_border_width = 2;
	mio_class = InputOutput;
	mio_valuemask = 0;
	mio_aptr = &mio_a;

	switch(mio_mode)
	{
		case	XCWA_DEFCOLMAP:
			mio_valuemask = CWColormap;
			mio_a.colormap = makecolmap(mio_display, mio_visual, AllocNone);
			break;

		case	XCWA_GRAVITY:
			mio_valuemask = CWWinGravity;
			mio_a.win_gravity = NorthWestGravity;
			break;

                /*
                 * This new case is used whenever a window is to be created
                 * which has a different visual/depth than the parent window.
                 * It will ensure that all required window attributes are set
                 * to prevent a BadMatch error on window creation.
                 */
		case    XCWA_VISDEPTH:
			mio_valuemask = CWBorderPixel | CWColormap;
			mio_a.border_pixel = 0;
			mio_a.colormap = makecolmap(mio_display, mio_visual, 
						AllocNone);
			break;

		case	XCWA_NORMAL:
		default:
			break;
	}
	return(XCreateWindow(mio_display, mio_parent, mio_x, mio_y, mio_width,
			mio_height, mio_border_width, mio_depth, mio_class,
			mio_visual, mio_valuemask, mio_aptr));
}



/* Value list for use in test t048 */
static int 	classvallist[] = {
	InputOutput,
	InputOnly,
	CopyFromParent,
};


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	parent = DRW(Dsp);
	x = 50;
	y = 60;
	width = 20;
	height = 17;
	border_width = 2;
	depth = DefaultDepth(Dsp, DefaultScreen(Dsp));
	class = InputOutput;
	visual = DefaultVisual(Dsp, DefaultScreen(Dsp));
	valuemask = 0;
	attributes = &Atts;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Window	win;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XCreateWindow-1.(A)");
	report_assertion("A call to XCreateWindow creates an unmapped subwindow for a");
	report_assertion("specified parent window and returns the window ID of the");
	report_assertion("created window.");

	report_strategy("Call XCreateWindow.");
	report_strategy("Do simple checks on returned id.");

	tpstartup();
	setargs();
	startcall(display);
	if (isdeleted())
		return;
	win = XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
		tpcleanup();
		return;
	}
	if (win & 0xe0000000) {
		report("Window ID has some of top three bits set");
		FAIL;
	} else {
		XDestroyWindow(display, win);
		PASS;
	}


	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

XSetWindowAttributes	atts;
XWindowAttributes	getatts;
Window	win;
Colormap	cm;
Cursor		curs;
int 	n;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XCreateWindow-2.(A)");
	report_assertion("The window attributes specified in valuemask are set to the");
	report_assertion("values in the attributes structure.");

	report_strategy("Create window with all attributes set to non-default values.");
	report_strategy("Get the window attributes with XGetWindowAttributes.");
	report_strategy("Verify that they are the same as the ones set.");
	report_strategy("The attributes that can't be checked in this way are the subject of other");
	report_strategy("  assertions.");

	tpstartup();
	setargs();
	cm = XCreateColormap(display, DRW(display), DefaultVisual(display, DefaultScreen(display)), AllocNone);
	curs = XCreateFontCursor(display, XC_coffee_mug);

	atts.bit_gravity = SouthEastGravity;
	atts.win_gravity = EastGravity;
	atts.backing_store = WhenMapped;
	atts.backing_planes = 0xaaaaaaaa;
	atts.backing_pixel = 1;
	atts.save_under = True;
	atts.event_mask = PropertyChangeMask;
	atts.do_not_propagate_mask = KeyPressMask;
	atts.override_redirect = True;
	atts.colormap = cm;
	atts.cursor = curs;

	attributes = &atts;
	valuemask = CWBitGravity|CWWinGravity|CWBackingStore|CWBackingPlanes|
		CWBackingPixel|CWSaveUnder|CWEventMask|CWDontPropagate|
		CWOverrideRedirect|CWColormap|CWCursor;

	startcall(display);
	if (isdeleted())
		return;
	win = XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
		tpcleanup();
		return;
	}

	XGetWindowAttributes(display, win, &getatts);
	if (isdeleted())
		return;

	n = checkatts(attributes, &getatts, valuemask);
	if (n > 0) {
		report("There %s %d incorrect attribute%s", 
					(n>1)?"were":"was", n, (n>1)?"s":"");
		FAIL;
	} else if (n < 0) {
		/* already reported a path check error in checkatts */
		return;
	} else
		CHECK;

	XDestroyWindow(display, win);
	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

XSetWindowAttributes	atts;
XWindowAttributes	getatts;
Window	win;
int 	n;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XCreateWindow-3.(A)");
	report_assertion("Window attributes that are not specified in valuemask are");
	report_assertion("set to their default values.");

	report_strategy("Create window.");
	report_strategy("Check default values:");
	report_strategy("bit-gravity: Forget");
	report_strategy("win-gravity: NorthWest");
	report_strategy("backing-store: NotUseful");
	report_strategy("backing-planes: all ones");
	report_strategy("backing-pixel: zero");
	report_strategy("save-under: False");
	report_strategy("event-mask: empty set");
	report_strategy("do-not-propagate-mask: empty set");
	report_strategy("override-redirect: False");
	report_strategy("colormap: CopyFromParent");

	tpstartup();
	setargs();
	valuemask = 0;
	startcall(display);
	if (isdeleted())
		return;
	win = XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
		tpcleanup();
		return;
	}

	/* For the parent colormap */
	XGetWindowAttributes(display, DRW(display), &getatts);

	atts.bit_gravity = ForgetGravity;
	atts.win_gravity = NorthWestGravity;
	atts.backing_store = NotUseful;
	atts.backing_planes = 0xffffffff;
	atts.backing_pixel = 0;
	atts.save_under = False;
	atts.event_mask = 0;
	atts.do_not_propagate_mask = 0;
	atts.override_redirect = False;
	atts.colormap = getatts.colormap;

	if (XGetWindowAttributes(display, win, &getatts) == False) {
		delete("Could not get window attributes");
		return;
	} else
		CHECK;

	n = checkatts(&atts, &getatts, (long)~0);
	if (n > 0) {
		report("There %s %d incorrect attribute%s", 
					(n>1)?"were":"was", n, (n>1)?"s":"");
		FAIL;
	} else if (n < 0) {
		/* already reported a path check error in checkatts */
		return;
	} else
		CHECK;

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

XCreateWindowEvent	ge;
XEvent	event;
Window	win;
int 	n;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XCreateWindow-4.(A)");
	report_assertion("On a call to XCreateWindow a CreateNotify event is");
	report_assertion("generated on the parent window.");

	report_strategy("Create parent window.");
	report_strategy("Select SubstructureNotifyMask on parent window.");
	report_strategy("Create window.");
	report_strategy("Select NoEventMask on parent window.");
	report_strategy("Verify that a single CreateNotify event was generated.");
	report_strategy("Verify that the returned event structure was correct.");

	tpstartup();
	setargs();
	parent = defdraw(display, VI_WIN);

	XSelectInput(display, parent, SubstructureNotifyMask);

	trace("depth is %d", depth);
	trace("visual class is %s", displayclassname(visual->class));
	startcall(display);
	if (isdeleted())
		return;
	win = XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
		tpcleanup();
		return;
	}

	XSelectInput(display, parent, NoEventMask);

	if (getevent(Dsp, &event) != 1) {
		report("Expecting one event");
		FAIL;
		return;
	} else
		CHECK;

	/* Set up a good event structure of what we are expecting */
	ge.type = CreateNotify;
	ge.send_event = False;
	ge.display = display;
	ge.parent  = parent;
	ge.window  = win;
	ge.x = x;
	ge.y = y;
	ge.width   = width;
	ge.height  = height;
	ge.border_width = border_width;
	ge.override_redirect = False;

	n = checkevent((XEvent*)&ge, &event);
	if (n == 0) {
		CHECK;
	} else {
		report("Event incorrect");
		FAIL;
	}

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

Window	w1, w2;
int 	n;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XCreateWindow-5.(A)");
	report_assertion("The created window is placed on top in the stacking order");
	report_assertion("with respect to siblings.");

	report_strategy("Create a parent window.");
	report_strategy("Create two overlapping sibling windows.");
	report_strategy("Verify that second window is at top of stacking order.");
	report_strategy("Verify that first sibling is next in the stacking order.");

	tpstartup();
	setargs();
	parent = defdraw(display, VI_WIN);
	if (isdeleted())
		return;
	else
		CHECK;

	trace("depth is %d", depth);
	trace("visual class is %s", displayclassname(visual->class));
	startcall(display);
	if (isdeleted())
		return;
	w1 = XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
		tpcleanup();
		return;
	}
	startcall(display);
	if (isdeleted())
		return;
	w2 = XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
		tpcleanup();
		return;
	}

	if ((n = stackorder(display, w1)) != 0) {
		report("Stacking order for w1 was %d, expected 0", n);
		FAIL;
	} else if ((n = stackorder(display, w2)) != 1) {
		report("Stacking order for w2 was %d, expected 1", n);
		FAIL;
	} else
		CHECK;

	XDestroyWindow(display, w1);
	XDestroyWindow(display, w2);
	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

XVisualInfo	*vp;
Window	win;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XCreateWindow-6.(A)");
	report_assertion("The created window is not displayed.");

	report_strategy("Create window to use as parent.");
	report_strategy("Set background to other than W_BG.");
	report_strategy("Create window with XCreateWindow.");
	report_strategy("Verify that parent window is still clear.");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		parent = (Window)makedrawable(display, vp);

		attributes->background_pixel = W_FG;
		valuemask = CWBackPixel;
		startcall(display);
		if (isdeleted())
			return;
		win = XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
			tpcleanup();
			return;
		}

		if (checkclear(display, parent))
			CHECK;
		else {
			report("Created window was visible");
			FAIL;
		}
		XDestroyWindow(display, win);
	}
	CHECKPASS(nvinf());

	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

Status	s;
Window	win;
XWindowAttributes	atts;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XCreateWindow-7.(A)");
	report_assertion("When class is CopyFromParent, then the class is taken from");
	report_assertion("the parent window.");

	report_strategy("Create InputOutput window to use as parent.");
	report_strategy("Create window with class CopyFromParent.");
	report_strategy("Verify that class of created window is InputOutput.");
	report_strategy("Create InputOnly window to use as parent.");
	report_strategy("Create window with class CopyFromParent.");
	report_strategy("Verify that class of created window is InputOnly.");

	tpstartup();
	setargs();
	class = CopyFromParent;
	/*
	 * Have to set depth and border_width to zero as well,
	 * otherwise BadMatch errors will occur.
	 */
	depth = 0;
	border_width = 0;
	parent = defdraw(display, VI_WIN);
	startcall(display);
	if (isdeleted())
		return;
	win = XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
		tpcleanup();
		return;
	}

	s = XGetWindowAttributes(display, win, &atts);
	if (s == False) {
		delete("XGetWindowAttributes failed");
		return;
	} else
		CHECK;

	if (atts.class != InputOutput) {
		report("Class was %s, expecting InputOutput", classname(atts.class));
		FAIL;
	} else
		CHECK;

	XDestroyWindow(display, win);

	/* Now Input Only */
	parent = iponlywin(display);
	startcall(display);
	if (isdeleted())
		return;
	win = XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
		tpcleanup();
		return;
	}

	s = XGetWindowAttributes(display, win, &atts);
	if (s == False) {
		delete("XGetWindowAttributes failed");
		return;
	} else
		CHECK;

	if (atts.class != InputOnly) {
		report("Class was %s, expecting InputOnly", classname(atts.class));
		FAIL;
	} else
		CHECK;

	XDestroyWindow(display, win);
	CHECKPASS(4);

	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

Status	s;
Window	win;
XWindowAttributes	atts;
int 	parentdepth;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XCreateWindow-8.(A)");
	report_assertion("When depth is CopyFromParent and class is InputOutput,");
	report_assertion("then the depth is taken from the parent window.");

	report_strategy("Create InputOutput window to use as parent.");
	report_strategy("Create window with depth CopyFromParent.");
	report_strategy("Verify that depth of created window is same as the parent.");

	tpstartup();
	setargs();
	depth = CopyFromParent;
	parent = defdraw(display, VI_WIN);
	startcall(display);
	if (isdeleted())
		return;
	win = XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
		tpcleanup();
		return;
	}

	parentdepth = getdepth(display, parent);

	s = XGetWindowAttributes(display, win, &atts);
	if (s == False) {
		delete("XGetWindowAttributes failed");
		return;
	} else
		CHECK;

	if (atts.depth != parentdepth) {
		report("Depth was %d, expecting %d", atts.depth, parentdepth);
		FAIL;
	} else
		CHECK;

	XDestroyWindow(display, win);
	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

Status	s;
Window	win;
XWindowAttributes	atts;
XVisualInfo	*vp;
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XCreateWindow-9.(A)");
	report_assertion("When visual is CopyFromParent, then the visual is taken");
	report_assertion("from the parent window.");

	report_strategy("Create window to use as parent.");
	report_strategy("Create window with visual CopyFromParent.");
	report_strategy("Verify that visual of created window is same as the parent.");

	tpstartup();
	setargs();
	depth = CopyFromParent;
	visual = CopyFromParent;
	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		parent = makewin(display, vp);

		startcall(display);
		if (isdeleted())
			return;
		win = XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
			tpcleanup();
			return;
		}

		s = XGetWindowAttributes(display, win, &atts);
		if (s == False) {
			delete("XGetWindowAttributes failed");
			return;
		} else
			CHECK;

		if (atts.visual != vp->visual) {
			report("Visual was not same as parent");
			FAIL;
		} else
			CHECK;

		XDestroyWindow(display, win);
	}

	CHECKPASS(2*nvinf());

	tpcleanup();
	pfcount(pass, fail);
}

static void t010(){

Window	win;
struct	area	area;
int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XCreateWindow-10.(A)");
	report_assertion("The window is located such that the upper left outer corner");
	report_assertion("is at the co-ordinate specified by x and y relative to the");
	report_assertion("inside of the border of the parent window.");

	report_strategy("Create window with border and background pixel W_FG.");
	report_strategy("Map created window.");
	report_strategy("Verify position by direct check with checkarea.");

	tpstartup();
	setargs();
	border_width = 5;
	parent = defdraw(display, VI_WIN);
	attributes->border_pixel = W_FG;
	attributes->background_pixel = W_FG;
	valuemask = CWBackPixel|CWBorderPixel;

	startcall(display);
	if (isdeleted())
		return;
	win = XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
		tpcleanup();
		return;
	}

	XMapWindow(display, win);
	if (isdeleted())
		return;

	setarea(&area, x, y, width+2*border_width, height+2*border_width);

	if (checkarea(display, parent, &area, W_FG, W_BG, CHECK_ALL))
		CHECK;
	else {
		report("Window created in wrong position or with wrong size");
		FAIL;
	}

	XDestroyWindow(display, win);
	CHECKPASS(1);
	
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file commattr.mc */
static void t011(){

XVisualInfo	*vp;
int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion XCreateWindow-11.(A)");
	report_assertion("When the background-pixmap attribute is set to None and the");
	report_assertion("background_pixel attribute is not being set at the same");
	report_assertion("time, then the window has no defined background.");

	report_strategy("Set background-pixmap attribute to None.");
	report_strategy("Map window over a patterned background.");
	report_strategy("Verify that contents of the window are the same as the parent's.");

	tpstartup();
	setargs();

	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		parent = makedrawable(display, vp);
		pattern(display, parent);

		visual = vp->visual;
		depth  = vp->depth;
		valuemask = CWBackPixmap;
		attributes->background_pixmap = None;

		startcall(display);
		if (isdeleted())
			return;
		w = XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
			tpcleanup();
			return;
		}
		XMapWindow(display, w);
		if (isdeleted())
			continue;
		/*
		 * Use pixmap checking here because we want to check the border
		 * to prove that the window is really there, but transparent.
		 */
		PIXCHECK(display, parent);
	}

	CHECKPASS(nvinf());

	tpcleanup();
	pfcount(pass, fail);
}

static void t012(){

Pixmap	pm;
int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion XCreateWindow-12.(A)");
	report_assertion("When the background-pixmap attribute is set to");
	report_assertion("ParentRelative, then each time the background pixmap is");
	report_assertion("required it is taken from the parent window at the time that");
	report_assertion("it is required, with the background tile origin aligned with");
	report_assertion("the origin of the parent window.");

	report_strategy("Set background-pixmap to ParentRelative.");
	report_strategy("For a variety of parent backgrounds");
	report_strategy("  Clear child window.");
	report_strategy("  Verify that background changes to that set for the parent.");

	tpstartup();
	setargs();
	visual = CopyFromParent;
	depth = CopyFromParent;
	valuemask = CWBackPixmap;
	attributes->background_pixmap = ParentRelative;

	parent = defdraw(display, VI_WIN);
	startcall(display);
	if (isdeleted())
		return;
	w = XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
		tpcleanup();
		return;
	}
	XMapWindow(display, w);

	pm = maketile(display, parent);
	XSetWindowBackgroundPixmap(display, parent, pm);
	XClearWindow(display, w);

	if (checktile(display, w, (struct area *)0, -x-border_width, -y-border_width, pm))
		CHECK;
	else {
		report("ParentRelative check failed for 'maketile' background");
		FAIL;
	}

	pm = XCreatePixmap(display, parent, 10, 17, (int)getdepth(display, w));
	dclear(display, pm);
	pattern(display, pm);
	XSetWindowBackgroundPixmap(display, parent, pm);
	XClearWindow(display, w);
	if (checktile(display, w, (struct area *)0, -x-border_width, -y-border_width, pm))
		CHECK;
	else {
		report("ParentRelative check failed for 'pattern' background");
		FAIL;
	}

	XSetWindowBackground(display, parent, W_FG);
	XClearWindow(display, w);
	if (checkarea(display, w, (struct area *)0, W_FG, W_BG, CHECK_ALL))
		CHECK;
	else {
		report("ParentRelative check failed for plain background set to W_FG");
		FAIL;
	}

	CHECKPASS(3);

	tpcleanup();
	pfcount(pass, fail);
}

static void t013(){

Pixmap	pm;
int 	pass = 0, fail = 0;

 	report_purpose(13);

	report_assertion("Assertion XCreateWindow-13.(A)");
	report_assertion("When both background_pixel and background_pixmap are");
	report_assertion("specified, then background_pixel overrides background_pixmap.");

	report_strategy("Set both the background-pixel attribute and the background-pixmap attribute.");
	report_strategy("Map and clear window to ensure background is refreshed.");
	report_strategy("Verify that background is set to the pixel value.");

	tpstartup();
	setargs();
	parent = defdraw(display, VI_WIN);

	pm = maketile(display, parent);
	attributes->background_pixel = W_FG;
	attributes->background_pixmap = pm;
	valuemask = CWBackPixel|CWBackPixmap;

	/*
	 * For running with window managers during debugging, testing etc.
	 */
	if (config.debug_override_redirect) {
		attributes->override_redirect = True;
		valuemask |= CWOverrideRedirect;
	}

	startcall(display);
	if (isdeleted())
		return;
	w = XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
		tpcleanup();
		return;
	}
	XMapWindow(display, w);
	XClearWindow(display, w);

	if (checkarea(display, w, (struct area *)0, W_FG, W_FG, CHECK_ALL))
		CHECK;
	else {
		report("background pixel did not override background pixmap");
		FAIL;
	}

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t014(){

XVisualInfo	*vp;
static int 	pixlist[] = {
	0, 1, 3, 4, 17, 18, 200, 300, 303,
	0x1234, 0x12345, 0x123456, 0x1234567, 0x12345678};
long	pix;
int 	i;
int 	pass = 0, fail = 0;

 	report_purpose(14);

	report_assertion("Assertion XCreateWindow-14.(A)");
	report_assertion("When background_pixel is specified, then it is truncated to");
	report_assertion("the depth of the window.");

	report_strategy("For each visual");
	report_strategy("  Try variety of background pixel values.");
	report_strategy("  Verify that they are truncated to depth using checkarea.");

	tpstartup();
	setargs();
	visual = CopyFromParent;
	depth = CopyFromParent;

	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		parent = makedrawable(display, vp);

		for (i = 0; i < NELEM(pixlist); i++) {
			pix = pixlist[i];

			visual = vp->visual;
			depth  = vp->depth;
			valuemask = CWBackPixel;
			attributes->background_pixel = pix;

			startcall(display);
			if (isdeleted())
				return;
			w = XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
			endcall(display);
			if (geterr() != Success) {
				report("Got %s, Expecting Success", errorname(geterr()));
				FAIL;
				tpcleanup();
				return;
			}
			XMapWindow(display, w);
			XClearWindow(display, w);

			/*
			 * Check the whole background.  If the background was not all
			 * set to the same value then the error message could be
			 * confusing.
			 */
			debug(3, "  pix 0x%x", pix);
			debug(3, "  vp->depth 0x%x", vp->depth);
			debug(3, "  DEPTHMASK(vp->depth) 0x%x", DEPTHMASK(vp->depth));
			if (checkarea(display, w, (struct area *)0, pix&DEPTHMASK(vp->depth), 0, CHECK_ALL))
				CHECK;
			else {
				report("Background pixel was not truncated (value 0x%x)", pix);
				report("  Was 0x%x, expecting 0x%x", getpixel(display, w, 0, 0),
					pix&DEPTHMASK(vp->depth));
				FAIL;
			}
		}
	}

	CHECKPASS(nvinf() * NELEM(pixlist));

	tpcleanup();
	pfcount(pass, fail);
}

static void t015(){

Pixmap	pm;
XVisualInfo	*vp;
int 	pass = 0, fail = 0;

 	report_purpose(15);

	report_assertion("Assertion XCreateWindow-15.(A)");
	report_assertion("When border_pixmap is CopyFromParent, then the");
	report_assertion("border-pixmap attribute is copied from the parent window.");

	report_strategy("Create parent window.");
	report_strategy("Set parent border-pixmap attribute.");
	report_strategy("Set child window border-pixmap to CopyFromParent.");
	report_strategy("Ensure that window is mapped.");
	report_strategy("Pixmap verify to check that border is correct.");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		parent = makedrawable(display, vp);
		pm = maketile(display, parent);
		XSetWindowBorderPixmap(display, parent, pm);

		visual = vp->visual;
		depth = vp->depth;
		valuemask = CWBorderPixmap;
		attributes->border_pixmap = CopyFromParent;

		startcall(display);
		if (isdeleted())
			return;
		w = XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
			tpcleanup();
			return;
		}
		XMapWindow(display, w);

		PIXCHECK(display, parent);
	}

	CHECKPASS(nvinf());

	tpcleanup();
	pfcount(pass, fail);
}

static void t016(){

XVisualInfo	*vp;
static int 	pixlist[] = {
	0, 1, 3, 4, 17, 18, 200, 300, 303,
	0x1234, 0x12345, 0x123456, 0x1234567, 0x12345678};
long	pix;
long	borderpix;
int 	i;
int 	pass = 0, fail = 0;

 	report_purpose(16);

	report_assertion("Assertion XCreateWindow-16.(A)");
	report_assertion("When border_pixel is specified, then the value is truncated");
	report_assertion("to the depth of the window.");

	report_strategy("For each visual");
	report_strategy("  Set border-pixel to various values.");
	report_strategy("  Read one pixel back from the border.");
	report_strategy("  Verify that this pixel has been truncated to depth of window.");

	tpstartup();
	setargs();
	visual = CopyFromParent;
	depth = CopyFromParent;

	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		parent = makedrawable(display, vp);

		for (i = 0; i < NELEM(pixlist); i++) {
			pix = pixlist[i];

			attributes->border_pixel = pix;
			valuemask = CWBorderPixel;

			startcall(display);
			if (isdeleted())
				return;
			w = XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
			endcall(display);
			if (geterr() != Success) {
				report("Got %s, Expecting Success", errorname(geterr()));
				FAIL;
				tpcleanup();
				return;
			}
			XMapWindow(display, w);
			XClearWindow(display, w);

			borderpix = getpixel(display, w, -1, -1);
			debug(3, "  pix 0x%x", pix);
			debug(3, "  vp->depth 0x%x", vp->depth);
			debug(3, "  DEPTHMASK(vp->depth) 0x%x", DEPTHMASK(vp->depth));
			if (borderpix == (pix & DEPTHMASK(vp->depth)))
				CHECK;
			else {
				report("Border pixel was not truncated (value 0x%x)", pix);
				report("  Was 0x%x, expecting 0x%x", borderpix,
					pix & DEPTHMASK(vp->depth));
				FAIL;
			}
		}
	}

	CHECKPASS(nvinf() * NELEM(pixlist));

	tpcleanup();
	pfcount(pass, fail);
}

static void t017(){

XVisualInfo	*vp;
XWindowAttributes	getatts;
XWindowAttributes	parentatts;
int 	pass = 0, fail = 0;

 	report_purpose(17);

	report_assertion("Assertion XCreateWindow-17.(A)");
	report_assertion("When colormap is CopyFromParent, then the colormap");
	report_assertion("attribute is copied from the parent window.");

	report_strategy("Set colormap attribute to CopyFromParent.");
	report_strategy("Get attribute values.");
	report_strategy("Verify that colormap is same as for parent.");

	tpstartup();
	setargs();
	depth = CopyFromParent;
	visual = CopyFromParent;

	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		parent = makedrawable(display, vp);
		XGetWindowAttributes(display, parent, &parentatts);

		attributes->colormap = CopyFromParent;
		valuemask = CWColormap;

		startcall(display);
		if (isdeleted())
			return;
		w = XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
			tpcleanup();
			return;
		}

		XGetWindowAttributes(display, w, &getatts);

		if (getatts.colormap != parentatts.colormap) {
			report("Colormap CopyFromParent: Got 0x%x, expecting 0x%x",
				getatts.colormap, parentatts.colormap);
			FAIL;
		} else
			CHECK;

	}

	CHECKPASS(nvinf());
	tpcleanup();
	pfcount(pass, fail);
}

static void t018(){

Cursor pcur;
int 	pass = 0, fail = 0;

 	report_purpose(18);

	report_assertion("Assertion XCreateWindow-18.(B)");
	report_assertion("When the cursor attribute is set to None, then the cursor");
	report_assertion("of the parent window is used for the window and any change");
	report_assertion("in the parent window's cursor will cause an immediate change");
	report_assertion("in the window's cursor.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If extended testing is required:");
	report_strategy("  Create a parent window.");
	report_strategy("  Set the parent's cursor to a non-default cursor.");
	report_strategy("  Verify that the parent's cursor was set correctly.");
	report_strategy("  If XCreateWindow:");
	report_strategy("    Create a child window using XCreateWindow.");
	report_strategy("  Otherwise:");
	report_strategy("    Create and map a child window.");
	report_strategy("    Change the cursor attribute of the window to None using XCreateWindow.");
	report_strategy("  Warp the pointer to the child window.");
	report_strategy("  Verify that the current cursor is that of the parent.");
	report_strategy("  Verify that the child's cursor was set correctly.");
	report_strategy("  Set the parent's cursor to a different cursor.");
	report_strategy("  Verify that the parent's cursor was set correctly.");
	report_strategy("  Verify that the current cursor has changed to that of the parent.");

	tpstartup();
	setargs();
	/* If extended testing is required: */
	if(noext(0))
		return;

	pcur = makecur(display);
	valuemask = CWCursor;
	attributes->cursor = None;
	x = 10;
	y = 10;

		/* Create a parent window. */
	parent = defwin(display);
	
		/* Set the parent's cursor to a non-default cursor. */
	XDefineCursor(display, parent, pcur);

		/* Verify that the parent's cursor was set correctly. */
	if(curofwin(display, pcur, parent) == False) {
		delete("XDefineCursor() did not set the parent window's cursor correctly.");
		return;
	} else
		CHECK;

		/* Create and map a child window. */
	w = makeinout( parent , visual, depth, XCWA_NORMAL );
	XMapWindow(display, w);
		/* Change the cursor attribute of the window to None using XChangeWindowAttributes. */
	startcall(display);
	if (isdeleted())
		return;
	XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
		tpcleanup();
		return;
	}

		/* Warp the pointer to the child window. */
	warppointer(display, w, 0,0);

		/* Verify that the current cursor is that of the parent. */
	if(spriteiswin(display, parent) == False) {	
		report("The cursor used for the child window was not that of its parent.");
		FAIL;
	} else
		CHECK;

		/* Verify that the child's cursor was set correctly. */
	if(curofwin(display, None, w) == False) {
		report("Window's cursor was not set to None.");
		FAIL;
	} else
		CHECK;

	pcur = makecur2(display);

		/* Set the parent's cursor to a different cursor. */
	XDefineCursor(display, parent, pcur);

		/* Verify that the parent's cursor was set correctly. */
	if(curofwin(display, pcur, parent) == False) {
		delete("XDefineCursor() did not set the parent window's cursor correctly.");
		return;
	} else
		CHECK;

		/* Verify that the current cursor has changed to that of the parent. */
	if(spriteiswin(display, parent) == False) {	
		report("The cursor used for the child window was not that of its parent.");
		FAIL;
	} else
		CHECK;

	CHECKPASS(5);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EWin.mc */
/* End of included file error/EWin.mc */

/* Including from file error/EWin.mc */
static void t019(){

int 	pass = 0, fail = 0;

 	report_purpose(19);

	report_assertion("Assertion XCreateWindow-19.(A)");
	report_assertion("When a window argument does not name a valid Window, then a");
	report_assertion("BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
		tpcleanup();
		return;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EWin.mc */

static void t020(){

int 	pass = 0, fail = 0;

 	report_purpose(20);

	report_assertion("Assertion XCreateWindow-20.(A)");
	report_assertion("When background_pixmap is not a valid pixmap, None, or");
	report_assertion("ParentRelative, then a BadPixmap error occurs.");

	report_strategy("Call XCreateWindow with background_pixmap set to an invalid value.");
	report_strategy("Verify that a BadPixmap error occurs.");

	tpstartup();
	setargs();
	seterrdef();


	attributes->background_pixmap = badpixm(display);
	valuemask = CWBackPixmap;

	startcall(display);
	if (isdeleted())
		return;
	XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	endcall(display);
	if (geterr() != BadPixmap) {
		report("Got %s, Expecting BadPixmap", errorname(geterr()));
		FAIL;
		tpcleanup();
		return;
	}

	if (geterr() == BadPixmap)
		PASS;
	else
		FAIL;	/* Already reported */
	tpcleanup();
	pfcount(pass, fail);
}

static void t021(){

int 	pass = 0, fail = 0;

 	report_purpose(21);

	report_assertion("Assertion XCreateWindow-21.(A)");
	report_assertion("When border_pixmap is not a valid pixmap or CopyFromParent,");
	report_assertion("then a BadPixmap error occurs.");

	report_strategy("Call XCreateWindow with border_pixmap set to an invalid value.");
	report_strategy("Verify that a BadPixmap error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	attributes->border_pixmap = badpixm(display);
	valuemask = CWBorderPixmap;

	startcall(display);
	if (isdeleted())
		return;
	XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	endcall(display);
	if (geterr() != BadPixmap) {
		report("Got %s, Expecting BadPixmap", errorname(geterr()));
		FAIL;
		tpcleanup();
		return;
	}

	if (geterr() == BadPixmap)
		PASS;
	else
		FAIL;	/* Already reported */
	tpcleanup();
	pfcount(pass, fail);
}

static void t022(){

int 	pass = 0, fail = 0;

 	report_purpose(22);

	report_assertion("Assertion XCreateWindow-22.(A)");
	report_assertion("When colormap is not a valid Colormap resource or");
	report_assertion("CopyFromParent, then a BadColor error occurs.");

	report_strategy("Call XCreateWindow with colormap set to an invalid value.");
	report_strategy("Verify that a BadColor error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	attributes->colormap = badcolormap(display, DRW(display)); /* XXX */
	valuemask = CWColormap;

	startcall(display);
	if (isdeleted())
		return;
	XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	endcall(display);
	if (geterr() != BadColor) {
		report("Got %s, Expecting BadColor", errorname(geterr()));
		FAIL;
		tpcleanup();
		return;
	}

	if (geterr() == BadColor)
		PASS;
	else
		FAIL;	/* Already reported */
	tpcleanup();
	pfcount(pass, fail);
}

static void t023(){

int 	pass = 0, fail = 0;

 	report_purpose(23);

	report_assertion("Assertion XCreateWindow-23.(A)");
	report_assertion("When cursor is not a valid Cursor resource or None, then a");
	report_assertion("BadCursor error occurs.");

	report_strategy("Call XCreateWindow with cursor set to an invalid value.");
	report_strategy("Verify that a BadCursor error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	/* Set to a pixmap */
	attributes->cursor = maketile(display, DRW(display));
	valuemask = CWCursor;

	startcall(display);
	if (isdeleted())
		return;
	XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	endcall(display);
	if (geterr() != BadCursor) {
		report("Got %s, Expecting BadCursor", errorname(geterr()));
		FAIL;
		tpcleanup();
		return;
	}

	if (geterr() == BadCursor)
		PASS;
	else
		FAIL;	/* Already reported */
	tpcleanup();
	pfcount(pass, fail);
}

static void t024(){

int 	i;
int 	n;
unsigned long	vals[NM_LEN];
static	unsigned long	validbits[] = {
	CWWinGravity,
	CWEventMask,
	CWDontPropagate,
	CWOverrideRedirect,
	CWCursor,
	};
int 	pass = 0, fail = 0;

 	report_purpose(24);

	report_assertion("Assertion XCreateWindow-24.(A)");
	report_assertion("When the window has class InputOnly and valuemask contains");
	report_assertion("a bit set other than CWWinGravity, CWEventMask,");
	report_assertion("CWDontPropagate, CWOverrideRedirect and CWCursor, then a");
	report_assertion("BadMatch error occurs.");

	report_strategy("Set value mask to contain invalid bits.");
	report_strategy("Verify in each case, that a BadMatch error occurs.");

	tpstartup();
	setargs();
	seterrdef();
	setinonly();

	n = notmaskmember(validbits, NELEM(validbits), vals);

	for (i = 0; i < n; i++) {

		debug(1, "Trying arg of %d", vals[i]);

		valuemask = vals[i];
		startcall(display);
		if (isdeleted())
			return;
		XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
		endcall(display);
		if (geterr() != BadMatch) {
			report("Got %s, Expecting BadMatch", errorname(geterr()));
			FAIL;
			tpcleanup();
			return;
		}

		if (geterr() == BadMatch)
			CHECK;
		else {
			trace("Value of %d did not give BadMatch", vals[i]);
			FAIL;
		}
	}

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

static void t025(){

Pixmap	pm;
XVisualInfo	*vp;
int 	found = 0;
int 	pass = 0, fail = 0;

 	report_purpose(25);

	report_assertion("Assertion XCreateWindow-25.(C)");
	report_assertion("If windows with depth other than one are supported: When");
	report_assertion("background_pixmap and the window do not have the same depth,");
	report_assertion("then a BadMatch error occurs.");

	report_strategy("Use depth of 1 for the pixmap.");
	report_strategy("Find a visual not of depth 1.");
	report_strategy("If not such a visual");
	report_strategy("  UNSUPPORTED");
	report_strategy("else");
	report_strategy("  Attempt to set background_pixmap to the depth 1 pixmap.");
	report_strategy("  Verify that a BadMatch error occurs.");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		if (vp->depth != 1) {
			found = 1;
			break;
		}
	}

	if (!found) {
		unsupported("Only windows with depth one are supported");
		return;
	}

	depth = vp->depth;
	visual = vp->visual;
	pm = XCreatePixmap(display, DRW(display), 2, 2, 1);
	attributes->background_pixmap = pm;
	valuemask = CWBackPixmap;

	startcall(display);
	if (isdeleted())
		return;
	(void)XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
		tpcleanup();
		return;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;
	XFreePixmap(display, pm);
	tpcleanup();
	pfcount(pass, fail);
}

static void t026(){

XVisualInfo	*vp;
Pixmap	pm;
int 	*depths;
int 	count;
int 	found = 0;
int 	i;
int 	pass = 0, fail = 0;

 	report_purpose(26);

	report_assertion("Assertion XCreateWindow-26.(C)");
	report_assertion("If multiple screens are supported: When background_pixmap");
	report_assertion("and the window are not created for the same screen, then a");
	report_assertion("BadMatch error occurs.");

	report_strategy("If there is a pixmap depth on the alternate screen that has the same");
	report_strategy("depth as a visual on the test screen then");
	report_strategy("  Create pixmap on alternate screen.");
	report_strategy("  Attempt to set background-pixmap with the pixmap");
	report_strategy("  Verify that a BadMatch error occurs.");
	report_strategy("else");
	report_strategy("  UNSUPPORTED");

	tpstartup();
	setargs();
	if (config.alt_screen == -1) {
		unsupported("No alternate screen supported");
		return;
	}

	depths = XListDepths(display, config.alt_screen, &count);

	for (resetvinf(VI_WIN); (!found && nextvinf(&vp)); ) {
		for (i = 0; i < count; i++) {
			if (depths[i] == vp->depth)
			{
				found = 1;
				break;
			}	
		}
	}

	if (!found) {
		unsupported("Pixmaps of same depth as a window not supported on alt screen");
		return;
	}

	pm = XCreatePixmap(display, RootWindow(display, config.alt_screen),
		2, 3, vp->depth);

	attributes->background_pixmap = pm;
	valuemask = CWBackPixmap;

	startcall(display);
	if (isdeleted())
		return;
	XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
		tpcleanup();
		return;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;

	XFreePixmap(display, pm);
	tpcleanup();
	pfcount(pass, fail);
}

static void t027(){

XVisualInfo	*vp;
XVisualInfo	*vp2 = 0;
int 	found = 0;
int 	pass = 0, fail = 0;

 	report_purpose(27);

	report_assertion("Assertion XCreateWindow-27.(C)");
	report_assertion("If multiple window depths are supported: When");
	report_assertion("background_pixmap is ParentRelative and the window and the");
	report_assertion("parent window do not have the same depth, then a BadMatch");
	report_assertion("error occurs.");

	report_strategy("If two different depth windows are supported.");
	report_strategy("  Create window with different depth to parent.");
	report_strategy("  Attempt to set background_pixmap to ParentRelative.");
	report_strategy("  Verify that a BadMatch error occurs.");
	report_strategy("else");
	report_strategy("  UNSUPPORTED.");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		if (vp2 == 0) {
			vp2 = vp;
		} else if (vp->depth != vp2->depth) {
			found = 1;
			break;
		}
	}

	if (!found) {
		unsupported("Only one depth of window is supported");
		return;
	}

	parent = makedrawable(display, vp2);
	visual = vp->visual;
	depth = vp->depth;

	attributes->background_pixmap = ParentRelative;
	valuemask = CWBackPixmap;

	startcall(display);
	if (isdeleted())
		return;
	(void)XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
		tpcleanup();
		return;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

static void t028(){

Colormap	cm;
XVisualInfo	*vp,*vp1, *vinfo, vi;
int 	count;
int 	found = 0;
int 	i;
int 	pass = 0, fail = 0;

 	report_purpose(28);

	report_assertion("Assertion XCreateWindow-28.(A)");
	report_assertion("When colormap and the window are not created for the same");
	report_assertion("screen, then a BadMatch error occurs.");

	report_strategy("If multiple screens are supported:");
	report_strategy("  Obtain visual information about the alternate screen.");
	report_strategy("  Determine a visual type shared between the main and alternate screen.");
	report_strategy("  Create a colormap on the alternate screen.");
	report_strategy("  Attempt to set the colormap.");
	report_strategy("  Verify that a BadMatch error occurs.");
	report_strategy("else");
	report_strategy("  UNSUPPORTED");

	tpstartup();
	setargs();
	if (config.alt_screen == -1) {
		unsupported("No alternate screen supported");
		return;
	}

	vi.screen = config.alt_screen;
	vinfo = XGetVisualInfo(Dsp, VisualScreenMask, &vi, &count);

	for (resetvinf(VI_WIN); (!found && nextvinf(&vp)); ) {
		for (i = 0; i < count; i++) {
			vp1 = &vinfo[i];
			if (vp1->visual == vp->visual)
			{
				found = 1;
				break;
			}	
		}
	}

	if (!found) {
		unsupported("Cannot create a colormap on the alternate screen of the same visual type as a window on the main screen");
		return;
	}

	cm = XCreateColormap(display, RootWindow(display, config.alt_screen),
			vp1->visual, AllocNone);

	attributes->colormap = cm;
	valuemask = CWColormap;


	startcall(display);
	if (isdeleted())
		return;
	XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
		tpcleanup();
		return;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;

	XFreeColormap(display, cm);
	for(i=0; i<count; i++)
		XFree((char*)&vinfo[i]);
	tpcleanup();
	pfcount(pass, fail);
}

static void t029(){

XWindowAttributes p_attributes;
Colormap	cm;
int 	found = 0;
XVisualInfo	*vp;
int 	pass = 0, fail = 0;

 	report_purpose(29);

	report_assertion("Assertion XCreateWindow-29.(A)");
	report_assertion("When colormap and the window do not have the same visual");
	report_assertion("type, then a BadMatch error occurs.");

	report_strategy("If two different visual types are supported:");
	report_strategy("  Create colour map of different visual to window.");
	report_strategy("  Attempt to set colourmap to created colour map.");
	report_strategy("  Verify that a BadMatch error occurs.");
	report_strategy("else");
	report_strategy("  UNSUPPORTED.");

	tpstartup();
	setargs();

	XGetWindowAttributes(display, parent, &p_attributes);

	visual = p_attributes.visual;
	depth = p_attributes.depth;

	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		if (vp->visual != visual)
		{
			found = 1;
			break;
		}
	}

	if (!found) {
		unsupported("Only one visual type supported");
		return;
	}


	cm = XCreateColormap(display, DRW(display) , vp->visual, AllocNone);

	attributes->colormap = cm;
	valuemask = CWColormap;

	startcall(display);
	if (isdeleted())
		return;
	(void)XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
		tpcleanup();
		return;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;

	XFreeColormap(display, cm);
	tpcleanup();
	pfcount(pass, fail);
}

static void t030(){

Colormap	cm;
int 	pass = 0, fail = 0;

 	report_purpose(30);

	report_assertion("Assertion XCreateWindow-30.(A)");
	report_assertion("When colormap is CopyFromParent and the parent window has a");
	report_assertion("colormap of None, then a BadMatch error occurs.");

	report_strategy("Create a window with a colormap.");
	report_strategy("Free the colormap the window.");
	report_strategy("Call function with colormap of CopyFromParent.");
	report_strategy("Verify BadMatch error occurred.");

	tpstartup();
	setargs();
	parent = makeinout( DRW(display),
		XDefaultVisual(display, XDefaultScreen(display) ) ,
		CopyFromParent, XCWA_NORMAL);

	cm = XCreateColormap(display, parent ,
			XDefaultVisual(display, XDefaultScreen(display)),
			AllocNone);

	XSetWindowColormap(display, parent, cm);

	attributes->colormap = CopyFromParent;
	valuemask = CWColormap;

	XFreeColormap(display, cm);
	startcall(display);
	if (isdeleted())
		return;
	(void)XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
		tpcleanup();
		return;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

static void t031(){

int 	pass = 0, fail = 0;

 	report_purpose(31);

	report_assertion("Assertion XCreateWindow-31.(A)");
	report_assertion("When the window has class InputOnly and border_width is not");
	report_assertion("zero, then a BadMatch error occurs.");

	report_strategy("Set border_width to contain non zero.");
	report_strategy("Verify that a BadMatch error occurs.");

	tpstartup();
	setargs();
	seterrdef();
	setinonly();

	border_width = 1;

		startcall(display);
		if (isdeleted())
			return;
		XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
		endcall(display);
		if (geterr() != BadMatch) {
			report("Got %s, Expecting BadMatch", errorname(geterr()));
			FAIL;
			tpcleanup();
			return;
		}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

static void t032(){

int	i;
int	n;
unsigned long	vals[NM_LEN];
static	unsigned long	validbits[] = {
	ForgetGravity ,
	NorthWestGravity ,
	NorthGravity ,
	NorthEastGravity ,
	WestGravity ,
	CenterGravity ,
	EastGravity ,
	SouthWestGravity ,
	SouthGravity ,
	SouthEastGravity ,
	StaticGravity };
int 	pass = 0, fail = 0;

 	report_purpose(32);

	report_assertion("Assertion XCreateWindow-32.(A)");
	report_assertion("When bit_gravity is other than ForgetGravity,");
	report_assertion("NorthWestGravity, NorthGravity, NorthEastGravity,");
	report_assertion("WestGravity, CenterGravity, EastGravity, SouthWestGravity,");
	report_assertion("SouthGravity, SouthEastGravityor StaticGravity, then a");
	report_assertion("BadValue error occurs.");

	report_strategy("Set bit_gravity to a bad value.");
	report_strategy("Verify that BadValue is generated.");

	tpstartup();
	setargs();
	seterrdef();


	
	valuemask = CWBitGravity;

	n = notmaskmember(validbits, NELEM(validbits), vals);

	for (i = 0; i < n ; i++)
	{
		debug(1, "Trying bit_gravity of %d", vals[i]);

		attributes->bit_gravity = vals[i];

		startcall(display);
		if (isdeleted())
			return;
		XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
			tpcleanup();
			return;
		}

		if(geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}	

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

static void t033(){

int	i;
int	n;
unsigned long	vals[NM_LEN];
static	unsigned long	validbits[] = {
	UnmapGravity ,
	NorthWestGravity ,
	NorthGravity ,
	NorthEastGravity ,
	WestGravity ,
	CenterGravity ,
	EastGravity ,
	SouthWestGravity ,
	SouthGravity ,
	SouthEastGravity ,
	StaticGravity };
int 	pass = 0, fail = 0;

 	report_purpose(33);

	report_assertion("Assertion XCreateWindow-33.(A)");
	report_assertion("When win_gravity is other than UnmapGravity,");
	report_assertion("NorthWestGravity, NorthGravity, NorthEastGravity,");
	report_assertion("WestGravity, CenterGravity, EastGravity, SouthWestGravity,");
	report_assertion("SouthGravity, SouthEastGravityor StaticGravity, then a");
	report_assertion("BadValue error occurs.");

	report_strategy("Set win_gravity to a bad value.");
	report_strategy("Verify that BadValue is generated.");

	tpstartup();
	setargs();
	seterrdef();


	
	valuemask = CWWinGravity;

	n = notmaskmember(validbits, NELEM(validbits), vals);

	for (i = 0; i < n ; i++)
	{
		debug(1, "Trying win_gravity of %d", vals[i]);

		attributes->win_gravity = vals[i];

		startcall(display);
		if (isdeleted())
			return;
		XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
			tpcleanup();
			return;
		}

		if(geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}	

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

static void t034(){

int	i;
int	n;
long	vals[NM_LEN];
static	int 	validvalues[] = {
	NotUseful,
	WhenMapped,
	Always };
int 	pass = 0, fail = 0;

 	report_purpose(34);

	report_assertion("Assertion XCreateWindow-34.(A)");
	report_assertion("When backing_store is other than NotUseful, WhenMapped or");
	report_assertion("Always, then a BadValue error occurs.");

	report_strategy("Set backing_store to a bad value.");
	report_strategy("Verify that BadValue is generated.");

	tpstartup();
	setargs();
	seterrdef();


	
	valuemask = CWBackingStore;

	n = notmember(validvalues, NELEM(validvalues), vals);

	for (i = 0; i < n ; i++)
	{
		debug(1, "Trying backing_store of %d", vals[i]);

		attributes->backing_store = vals[i];

		startcall(display);
		if (isdeleted())
			return;
		XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
			tpcleanup();
			return;
		}

		if(geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}	

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

static void t035(){

int	i;
int	n;
long	vals[NM_LEN];
static	int 	validvalues[] = {
	True,
	False };
int 	pass = 0, fail = 0;

 	report_purpose(35);

	report_assertion("Assertion XCreateWindow-35.(A)");
	report_assertion("When save_under is other than True or False, then a");
	report_assertion("BadValue error occurs.");

	report_strategy("Set save_under to a bad value.");
	report_strategy("Verify that BadValue is generated.");

	tpstartup();
	setargs();
	seterrdef();

	
	valuemask = CWSaveUnder;

	n = notmember(validvalues, NELEM(validvalues), vals);

	for (i = 0; i < n ; i++)
	{
		debug(1, "Trying save_under of %d", vals[i]);

		attributes->save_under= vals[i];

		startcall(display);
		if (isdeleted())
			return;
		XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
			tpcleanup();
			return;
		}

		if(geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}	

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

static void t036(){

int	i;
int	n;
unsigned long	vals[NM_LEN];
static	unsigned long	validbits[] = {
	NoEventMask ,
	KeyPressMask ,
	KeyReleaseMask ,
	ButtonPressMask ,
	ButtonReleaseMask ,
	EnterWindowMask ,
	LeaveWindowMask ,
	PointerMotionMask ,
	PointerMotionHintMask ,
	Button1MotionMask ,
	Button2MotionMask ,
	Button3MotionMask ,
	Button4MotionMask ,
	Button5MotionMask ,
	ButtonMotionMask ,
	KeymapStateMask ,
	ExposureMask ,
	VisibilityChangeMask ,
	StructureNotifyMask ,
	ResizeRedirectMask ,
	SubstructureNotifyMask ,
	SubstructureRedirectMask ,
	FocusChangeMask ,
	PropertyChangeMask ,
	ColormapChangeMask ,
	OwnerGrabButtonMask };
int 	pass = 0, fail = 0;

 	report_purpose(36);

	report_assertion("Assertion XCreateWindow-36.(A)");
	report_assertion("When event_mask is other than a bitwise OR of any of");
	report_assertion("NoEventMask, KeyPressMask, KeyReleaseMask,");
	report_assertion("ButtonPressMask, ButtonReleaseMask, EnterWindowMask,");
	report_assertion("LeaveWindowMask, PointerMotionMask, PointerMotionHintMask,");
	report_assertion("Button1MotionMask, Button2MotionMask, Button3MotionMask,");
	report_assertion("Button4MotionMask, Button5MotionMask, ButtonMotionMask,");
	report_assertion("KeymapStateMask, ExposureMask, VisibilityChangeMask,");
	report_assertion("StructureNotifyMask, ResizeRedirectMask,");
	report_assertion("SubstructureNotifyMask, SubstructureRedirectMask,");
	report_assertion("FocusChangeMask, PropertyChangeMask, ColormapChangeMask or");
	report_assertion("OwnerGrabButtonMask, then a BadValue error occurs.");

	report_strategy("Set event_mask to a bad value.");
	report_strategy("Verify that BadValue is generated.");

	tpstartup();
	setargs();
	seterrdef();

	
	valuemask = CWEventMask;

	n = notmaskmember(validbits, NELEM(validbits), vals);

	for (i = 0; i < n ; i++)
	{
		debug(1, "Trying event_mask of %d", vals[i]);

		attributes->event_mask = vals[i];

		startcall(display);
		if (isdeleted())
			return;
		XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
			tpcleanup();
			return;
		}

		if(geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}	

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

static void t037(){

int	i;
int	n;
unsigned long	vals[NM_LEN];
static	unsigned long	validbits[] = {
	NoEventMask ,
	KeyPressMask ,
	KeyReleaseMask ,
	ButtonPressMask ,
	ButtonReleaseMask ,
	EnterWindowMask ,
	LeaveWindowMask ,
	PointerMotionMask ,
	PointerMotionHintMask ,
	Button1MotionMask ,
	Button2MotionMask ,
	Button3MotionMask ,
	Button4MotionMask ,
	Button5MotionMask ,
	ButtonMotionMask ,
	KeymapStateMask ,
	ExposureMask ,
	VisibilityChangeMask ,
	StructureNotifyMask ,
	ResizeRedirectMask ,
	SubstructureNotifyMask ,
	SubstructureRedirectMask ,
	FocusChangeMask ,
	PropertyChangeMask ,
	ColormapChangeMask ,
	OwnerGrabButtonMask };
int 	pass = 0, fail = 0;

 	report_purpose(37);

	report_assertion("Assertion XCreateWindow-37.(A)");
	report_assertion("When do_not_propagate_mask is other than a bitwise OR of");
	report_assertion("any of NoEventMask, KeyPressMask, KeyReleaseMask,");
	report_assertion("ButtonPressMask, ButtonReleaseMask, EnterWindowMask,");
	report_assertion("LeaveWindowMask, PointerMotionMask, PointerMotionHintMask,");
	report_assertion("Button1MotionMask, Button2MotionMask, Button3MotionMask,");
	report_assertion("Button4MotionMask, Button5MotionMask, ButtonMotionMask,");
	report_assertion("KeymapStateMask, ExposureMask, VisibilityChangeMask,");
	report_assertion("StructureNotifyMask, ResizeRedirectMask,");
	report_assertion("SubstructureNotifyMask, SubstructureRedirectMask,");
	report_assertion("FocusChangeMask, PropertyChangeMask, ColormapChangeMask or");
	report_assertion("OwnerGrabButtonMask, then a BadValue error occurs.");

	report_strategy("Set do_not_propagate_mask to a bad value.");
	report_strategy("Verify that BadValue is generated.");

	tpstartup();
	setargs();
	seterrdef();

	
	valuemask = CWDontPropagate ;

	n = notmaskmember(validbits, NELEM(validbits), vals);

	for (i = 0; i < n ; i++)
	{
		debug(1, "Trying do_not_propagate_mask of %d", vals[i]);

		attributes->do_not_propagate_mask = vals[i];

		startcall(display);
		if (isdeleted())
			return;
		XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
			tpcleanup();
			return;
		}

		if(geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}	

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

static void t038(){

int	i;
int	n;
long	vals[NM_LEN];
static	int 	validvalues[] = {
	True,
	False };
int 	pass = 0, fail = 0;

 	report_purpose(38);

	report_assertion("Assertion XCreateWindow-38.(A)");
	report_assertion("When override_redirect is other than True or False, then a");
	report_assertion("BadValue error occurs.");

	report_strategy("Set override_redirect to a bad value.");
	report_strategy("Verify that BadValue is generated.");

	tpstartup();
	setargs();
	seterrdef();

	
	valuemask = CWOverrideRedirect;

	n = notmember(validvalues, NELEM(validvalues), vals);

	for (i = 0; i < n ; i++)
	{
		debug(1, "Trying override_redirect of %d", vals[i]);

		attributes->override_redirect= vals[i];

		startcall(display);
		if (isdeleted())
			return;
		XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
			tpcleanup();
			return;
		}

		if(geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}	

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

static void t039(){

Pixmap	pm;
XVisualInfo	*vp;
int 	found = 0;
int 	pass = 0, fail = 0;

 	report_purpose(39);

	report_assertion("Assertion XCreateWindow-39.(C)");
	report_assertion("If windows with depth other than one are supported: When");
	report_assertion("border_pixmap and the window do not have the same depth,");
	report_assertion("then a BadMatch error occurs.");

	report_strategy("If a window with depth other than one is supported:");
	report_strategy("  Attempt to set border_pixmap with depth one.");
	report_strategy("  Verify that a BadMatch error occurs with a window depth other than one.");
	report_strategy("else");
	report_strategy("  UNSUPPORTED.");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		if (vp->depth != 1) {
			found = 1;
			break;
		}
	}

	if (!found) {
		unsupported("Only windows with depth one are supported");
		return;
	}

	parent = makewin(display, vp);
	pm =  XCreatePixmap(display, parent, 1, 1, 1);

	visual = vp->visual;
	depth = vp->depth;
	attributes->border_pixmap = pm ;
	valuemask = CWBorderPixmap;

	startcall(display);
	if (isdeleted())
		return;
	(void)XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
		tpcleanup();
		return;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;

	XFreePixmap(display, pm);
	tpcleanup();
	pfcount(pass, fail);
}

static void t040(){

XVisualInfo	*vp;
XVisualInfo	*vp2 = 0;
int 	found = 0;
int 	pass = 0, fail = 0;

 	report_purpose(40);

	report_assertion("Assertion XCreateWindow-40.(C)");
	report_assertion("If multiple window depths are supported: When border_pixmap");
	report_assertion("is CopyFromParent, and the window does not have the same");
	report_assertion("depth as the parent window, then a BadMatch error occurs.");

	report_strategy("If two different depth windows are supported.");
	report_strategy("  Create window with different depth to parent.");
	report_strategy("  Attempt to set border_pixmap to CopyFromParent.");
	report_strategy("  Verify that a BadMatch error occurs.");
	report_strategy("else");
	report_strategy("  UNSUPPORTED.");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		if (vp2 == 0) {
			vp2 = vp;
		} else if (vp->depth != vp2->depth) {
			found = 1;
			break;
		}
	}

	if (!found) {
		unsupported("Only one depth of window is supported");
		return;
	}

	parent = makedrawable(display, vp2);
	visual = vp->visual;
	depth = vp->depth;

	attributes->border_pixmap = CopyFromParent;
	valuemask = CWBorderPixmap;

	startcall(display);
	if (isdeleted())
		return;
	(void)XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
		tpcleanup();
		return;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

static void t041(){

int 	found = 0;
XVisualInfo	*vp;
XVisualInfo	*vp2;
int 	pass = 0, fail = 0;

 	report_purpose(41);

	report_assertion("Assertion XCreateWindow-41.(A)");
	report_assertion("When colormap is CopyFromParent and the window does not");
	report_assertion("have the same visual type as the parent window, then a");
	report_assertion("BadMatch error occurs.");

	report_strategy("If two different visual types are supported:");
	report_strategy("  Create a parent of one visual type");
	report_strategy("  Attempt to set colourmap to CopyFromParent on window of different visual type.");
	report_strategy("  Verify that a BadMatch error occurs.");
	report_strategy("else");
	report_strategy("  UNSUPPORTED.");

	tpstartup();
	setargs();

	vp2 = 0;

	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		if(vp2 == 0)
		{
			vp2 = vp;
		}
		else if (vp->visual !=  vp2->visual)
		{
			found = 1;
			break;
		}
	}

	if (!found) {
		unsupported("Only one visual type supported");
		return;
	}

	parent = (Window)makedrawable( display, vp2 );

	visual = vp->visual;
	depth  = vp->depth;

	attributes->colormap = CopyFromParent;
	valuemask = CWColormap;

	startcall(display);
	if (isdeleted())
		return;
	(void)XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
		tpcleanup();
		return;
	}
	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file commattr.mc */

static void t042(){

XVisualInfo	*vp;
int 	supported;
int 	pass = 0, fail = 0;

 	report_purpose(42);

	report_assertion("Assertion XCreateWindow-42.(A)");
	report_assertion("When class is InputOutput and the specified visual type and");
	report_assertion("depth are not supported for the screen, then a BadMatch");
	report_assertion("error occurs.");

	report_strategy("Find depth not supported by screen.");
	report_strategy("Set depth to the unsupported depth.");
	report_strategy("Set visual to a supported type");
	report_strategy("(doesn't seem possible to test unsupported visual portably)");
	report_strategy("Set class to InputOutput.");
	report_strategy("Attempt to create window.");
	report_strategy("Verify that BadMatch error occurs.");

	tpstartup();
	setargs();
	for (depth = 1; ; depth++) {
		supported = 0;
		for (resetvinf(VI_WIN); nextvinf(&vp); ) {
			if (vp->depth == depth)
				supported = 1;
		}
		if (!supported)
			break;
	}

	class = InputOutput;

	startcall(display);
	if (isdeleted())
		return;
	XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
		tpcleanup();
		return;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;	/* Already reported */

	tpcleanup();
	pfcount(pass, fail);
}

static void t043(){

int 	pass = 0, fail = 0;

 	report_purpose(43);

	report_assertion("Assertion XCreateWindow-43.(A)");
	report_assertion("When class is InputOutput and the parent window has class");
	report_assertion("InputOnly, then a BadMatch error occurs.");

	report_strategy("Create input only window with iponlywin().");
	report_strategy("Set class to InputOutput.");
	report_strategy("Create window with the input only window as parent.");
	report_strategy("Verify that a BadMatch error occurs.");

	tpstartup();
	setargs();
	parent = iponlywin(display);
	class = InputOutput;

	startcall(display);
	if (isdeleted())
		return;
	XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
		tpcleanup();
		return;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

static void t044(){

int 	pass = 0, fail = 0;

 	report_purpose(44);

	report_assertion("Assertion XCreateWindow-44.(A)");
	report_assertion("When class is InputOnly and the depth is not zero, then a");
	report_assertion("BadMatch error occurs.");

	report_strategy("Set class to InputOnly.");
	report_strategy("Set depth to 1.");
	report_strategy("Set border_width to 0 to avoid BadMatch error due to border width.");
	report_strategy("Call XCreateWindow.");
	report_strategy("Verify that BadMatch error occurs.");

	tpstartup();
	setargs();
	class = InputOnly;
	depth = 1;
	border_width = 0;

	startcall(display);
	if (isdeleted())
		return;
	XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
		tpcleanup();
		return;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;
	
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.2652 */
static void t045(){

int 	pass = 0, fail = 0;

 	report_purpose(45);

	report_assertion("Assertion XCreateWindow-45.(B)");
	report_assertion("When class is InputOnly and the specified visual type is");
	report_assertion("not supported by the screen, then a BadMatch error occurs.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.2652 */

static void t046(){

int 	pass = 0, fail = 0;

 	report_purpose(46);

	report_assertion("Assertion XCreateWindow-46.(A)");
	report_assertion("When the width or height is zero, then a BadValue error");
	report_assertion("occurs.");

	report_strategy("Set width and height in turn to be zero.");
	report_strategy("Call XCreateWindow.");
	report_strategy("Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	width = 0;
	height = 10;

	startcall(display);
	if (isdeleted())
		return;
	XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
		tpcleanup();
		return;
	}

	if (geterr() == BadValue)
		CHECK;
	else
		FAIL;

	width = 10;
	height = 0;

	startcall(display);
	if (isdeleted())
		return;
	XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
		tpcleanup();
		return;
	}

	if (geterr() == BadValue)
		CHECK;
	else
		FAIL;

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.2652 */
static void t047(){

int 	pass = 0, fail = 0;

 	report_purpose(47);

	report_assertion("Assertion XCreateWindow-47.(B)");
	report_assertion("When the specified visual type is invalid, then a BadValue");
	report_assertion("error occurs.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.2652 */

/* Including from file Mval.tmc.2652 */
/* End of included file Mval.tmc.2652 */

/* Including from file error/EVal.mc */
static void t048(){

#undef	VALUE_ARG
#define	VALUE_ARG class
#undef	VALUE_LIST
#define	VALUE_LIST classvallist
#undef NOTMEMTYPE
#define NOTMEMTYPE 
#undef	NOTMEMBER
#define	NOTMEMBER notmember
int 	i;
int 	n;
NOTMEMTYPE
long	vals[NM_LEN];
int 	pass = 0, fail = 0;

 	report_purpose(48);

	report_assertion("Assertion XCreateWindow-48.(A)");
	report_assertion("When the value of class is other than InputOutput,");
	report_assertion("InputOnly or CopyFromParent, then a BadValue error occurs.");

	report_strategy("Obtain a sequence of values which are not in the list specified by VALUE_LIST.");
	report_strategy("For each value:");
	report_strategy("  Call test function with this value in the VALUE_ARG argument.");
	report_strategy("  Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	n = NOTMEMBER(VALUE_LIST, NELEM(VALUE_LIST), vals);

	for (i = 0; i < n; i++) {

		debug(1, "Trying arg of %d", vals[i]);

		VALUE_ARG = vals[i];
		startcall(display);
		if (isdeleted())
			return;
		XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
			tpcleanup();
			return;
		}

		if (geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EVal.mc */

/* Including from file error/EAll.mc */
/* End of included file error/EAll.mc */

/* Including from file error/EAll.mc */
static void t049(){

int 	pass = 0, fail = 0;

 	report_purpose(49);

	report_assertion("Assertion XCreateWindow-49.(B)");
	report_assertion("When the server fails to allocate a required resource, then");
	report_assertion("a BadAlloc error occurs.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	report("There is no reliable method of testing that a BadAlloc error is generated");
	tet_result(TET_UNTESTED);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EAll.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ t016, 16 },
	{ t017, 17 },
	{ t018, 18 },
	{ t019, 19 },
	{ t020, 20 },
	{ t021, 21 },
	{ t022, 22 },
	{ t023, 23 },
	{ t024, 24 },
	{ t025, 25 },
	{ t026, 26 },
	{ t027, 27 },
	{ t028, 28 },
	{ t029, 29 },
	{ t030, 30 },
	{ t031, 31 },
	{ t032, 32 },
	{ t033, 33 },
	{ t034, 34 },
	{ t035, 35 },
	{ t036, 36 },
	{ t037, 37 },
	{ t038, 38 },
	{ t039, 39 },
	{ t040, 40 },
	{ t041, 41 },
	{ t042, 42 },
	{ t043, 43 },
	{ t044, 44 },
	{ t045, 45 },
	{ t046, 46 },
	{ t047, 47 },
	{ t048, 48 },
	{ t049, 49 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = fontstartup;
void	(*tet_cleanup)() = fontcleanup;
