/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XSetWindowBorderWidth(display, w, width)
 *   Display	*display;
 *   Window	w;
 *   unsigned int width;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XSetWindowBorderWidth	1
char    *TestName = "XSetWindowBorderWidth";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW w
#define A_DRAWABLE w


/*
 * Arguments to the XSetWindowBorderWidth function
 */
static Display	*display;
static Window	w;
static unsigned int width;



struct	area	area;

void
tpXSWBWstart()
{
	tpstartup();

	area.x = 15;
	area.y = 15;
	area.width = 30;
	area.height= 30;

}

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	w = 0;
	width = 4;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	w = ErrdefWindow;
}

static void t001(){

Window	parent, child;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XSetWindowBorderWidth-1.(A)");
	report_assertion("A call to XSetWindowBorderWidth sets the border width of");
	report_assertion("the specified window to width.");

	report_strategy("Create parent window with a child.");
	report_strategy("Call XSetWindowBorderWidth to set the window border width to 4.");
	report_strategy("Verify that window border width was set using Pixchecking");
	report_strategy("Call XSetWindowBorderWidth to set the window border width to 10.");
	report_strategy("Verify that window border width was set using Pixchecking");

	tpXSWBWstart();
	setargs();
	trace("Starting");
/* Create parent window with a child. */
	parent = defwin(display);
	trace("Parent made");
	child = crechild(display, parent, &area);
	trace("Child made");

/* Call xname to set the window border width to 4. */
	w = child;
	width = 4;
	startcall(display);
	if (isdeleted())
		return;
	XSetWindowBorderWidth(display, w, width);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	trace("Called %s first time", TestName);

/* Verify that window border width was set using Pixchecking */
	PIXCHECK(display, parent);
	trace("Pixchecked");

/*  Call xname to set the window border width to 10. */
	w = child;
	width = 10;
	startcall(display);
	if (isdeleted())
		return;
	XSetWindowBorderWidth(display, w, width);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	trace("Called %s second time", TestName);

/* Verify that window border width was set using Pixchecking */
	PIXCHECK(display, parent);
	trace("Pixchecked");
	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.3644 */
static void t002(){

int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XSetWindowBorderWidth-2.(B)");
	report_assertion("When the window is a root window, then a call to");
	report_assertion("XSetWindowBorderWidth has no affect.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpXSWBWstart();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.3644 */

static void t003(){

Display	*client1, *client2;
Window	parent, one; 
XImage	*image;
XSetWindowAttributes	attr;
XEvent	ev;
int	numevent;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XSetWindowBorderWidth-3.(A)");
	report_assertion("When the override-redirect attribute of the window is False");
	report_assertion("and some other client has selected SubstructureRedirectMask");
	report_assertion("on the parent window, then a ConfigureRequest event is");
	report_assertion("generated, and the window configuration is not changed.");

	report_strategy("Create client1 and client2.");
	report_strategy("Create a window and child window one");
	report_strategy("Save parent window image as reference image.");
	report_strategy("Set override-redirect on window one to False.");
	report_strategy("Select SubstructureRedirectMask events on the parent window for client2.");
	report_strategy("Call XSetWindowBorderWidth on window one for client1.");
	report_strategy("Verify that no events were delivered to client1.");
	report_strategy("Verify that a correct ConfigureRequest event was delivered to client2.");
	report_strategy("Verify that no further processing occurred by comparing the window");
	report_strategy("	to our reference window.");

	tpXSWBWstart();
	setargs();
/* Create client1 and client2. */
	client1 = opendisplay();
	if (client1 == NULL) {
		delete("could not create client1");
		return;
	}
	else
		CHECK;
	client2 = opendisplay();
	if (client2 == NULL) {
		delete("could not create client2");
		return;
	}
	else
		CHECK;

/* Create a window and child window one */
	parent = defwin(client1);
	one = crechild(client1, parent, &area);

/* Save parent window image as reference image. */
	image = savimage(client1, parent);

/* Set override-redirect on window one to False. */
	attr.override_redirect = False;
	XChangeWindowAttributes(client1, one, CWOverrideRedirect, &attr);

/* Select SubstructureRedirectMask events on the parent window for client2. */
	XSelectInput(client2, parent, SubstructureRedirectMask);
	XSync(client2, True);

/* Call xname on window one for client1. */
	display = client1;
	w = one;
	startcall(display);
	if (isdeleted())
		return;
	XSetWindowBorderWidth(display, w, width);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(client2, False);

/* Verify that no events were delivered to client1. */
	numevent = getevent(client1, &ev);
	if (numevent != 0) {
		FAIL;
		report("%d unexpected %s delivered to client1",
			numevent, (numevent==1)?"event was":"events were");
		report("%sevent was %s", (numevent!=1)?"first ":"", eventname(ev.type));
		while(getevent(client1, &ev) != 0)
			report("next event was %s", eventname(ev.type));
	} else
		CHECK;

/* Verify that a correct ConfigureRequest event was delivered to client2. */
	numevent = getevent(client2, &ev);
	if (numevent != 1) {
		FAIL;
		report("Expecting a single ConfigureRequest event");
		report("Received %d events", numevent);
		if (numevent != 0) {
			report("First event was %s", eventname(ev.type));
			while(getevent(client2, &ev) != 0)
				report("next event was %s", eventname(ev.type));
		}
	} else	{
		XConfigureRequestEvent	good;

		good.type = ConfigureRequest;
		good.serial = 0;
		good.send_event = False;
		good.display = client2;
		good.parent = parent;
		good.window = one;
		good.x	= area.x;
		good.y  = area.y;
		good.width = area.width;
		good.height = area.height;
		good.border_width = width;
		good.above = None;
		good.detail= None;
		good.value_mask = CWBorderWidth;

		if ( checkevent((XEvent *)&good, &ev) )
			FAIL;
		else
			CHECK;
	}

/* Verify that no further processing occurred by comparing the window */
/* 	to our reference window. */
	if (!compsavimage(client1, parent, image)) {
		FAIL;
	} else
		CHECK;
	
	CHECKPASS(5);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

Display	*client1, *client2;
Window	parent, one; 
XEvent	ev;
int	numevent;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XSetWindowBorderWidth-4.(A)");
	report_assertion("When the border width actually changes, then a");
	report_assertion("ConfigureNotify event is generated.");

	report_strategy("Create client1 and client2.");
	report_strategy("Create a window and child window one");
	report_strategy("Select StructureNotifyMask events on the window one for client1. ");
	report_strategy("Select SubstructureNotifyMask events on the parent window for client2.");
	report_strategy("Call XSetWindowBorderWidth on window one for client1.");
	report_strategy("Verify that a single ConfigureNotify event was delivered to client1.");
	report_strategy("Verify that a single ConfigureNotify event was delivered to client2.");

	tpXSWBWstart();
	setargs();
/* Create client1 and client2. */
	client1 = opendisplay();
	if (client1 == NULL) {
		delete("could not create client1");
		return;
	}
	else
		CHECK;
	client2 = opendisplay();
	if (client2 == NULL) {
		delete("could not create client2");
		return;
	}
	else
		CHECK;

/* Create a window and child window one */
	parent = defwin(client1);
	one = crechild(client1, parent, &area);

/* Select StructureNotifyMask events on the window one for client1.  */
	XSelectInput(client1, one, StructureNotifyMask);
	XSync(client1, True);

/* Select SubstructureNotifyMask events on the parent window for client2. */
	XSelectInput(client2, parent, SubstructureNotifyMask);
	XSync(client2, True);

/* Call xname on window one for client1. */
	display = client1;
	w = one;
	startcall(display);
	if (isdeleted())
		return;
	XSetWindowBorderWidth(display, w, width);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(client2, False);

/* Verify that a single ConfigureNotify event was delivered to client1. */
	numevent = getevent(client1, &ev);
	if (numevent != 1) {
		FAIL;
		report("Expecting a single ConfigureNotify event on client1");
		report("Received %d events", numevent);
		if (numevent != 0) {
			report("First event was %s", eventname(ev.type));
			while(getevent(client1, &ev) != 0)
				report("next event was %s", eventname(ev.type));
		}
	} else	{
		XConfigureEvent	good;

		good.type = ConfigureNotify;
		good.serial = 0;
		good.send_event = False;
		good.display = client1;
		good.event = one;
		good.window = one;
		good.x	= area.x;
		good.y  = area.y;
		good.width = area.width;
		good.height = area.height;
		good.border_width = width;
		good.above = None;
		good.override_redirect = ev.xconfigure.override_redirect;

		if ( checkevent((XEvent *)&good, &ev) )
			FAIL;
		else
			CHECK;
	}

/* Verify that a single ConfigureNotify event was delivered to client2. */
	numevent = getevent(client2, &ev);
	if (numevent != 1) {
		FAIL;
		report("Expecting a single ConfigureNotify event on client2");
		report("Received %d events", numevent);
		if (numevent != 0) {
			report("First event was %s", eventname(ev.type));
			while(getevent(client2, &ev) != 0)
				report("next event was %s", eventname(ev.type));
		}
	} else	{
		XConfigureEvent good;

		good.type = ConfigureNotify;
		good.serial = 0;
		good.send_event = False;
		good.display = client2;
		good.event = parent;
		good.window = one;
		good.x	= area.x;
		good.y  = area.y;
		good.width = area.width;
		good.height = area.height;
		good.border_width = width;
		good.above = None;
		good.override_redirect = ev.xconfigure.override_redirect;

		if ( checkevent((XEvent *)&good, &ev) )
			FAIL;
		else
			CHECK;
	}
	CHECKPASS(4);

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

Window	parent, win1, win2;
struct	area	area2;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XSetWindowBorderWidth-5.(A)");
	report_assertion("When a call to XSetWindowBorderWidth uncovers part of any");
	report_assertion("window that was formerly obscured, then either Expose events");
	report_assertion("are generated or the contents are restored from backing");
	report_assertion("store.");

	report_strategy("Create a parent window, and the test windows win1 and win2. ");
	report_strategy("Select ExposureMask events on win1");
	report_strategy("Set window border on win2 to cover some of win1");
	report_strategy("Set window border on win2 to expose some of win1");
	report_strategy("Verify that Expose events were generated or that win2 was");
	report_strategy("	recovered from Backing Store.");

	tpXSWBWstart();
	setargs();
/* Create a parent window, and the test windows win1 and win2.  */
	parent = defwin(display);
	win1 = crechild(display, parent, &area);
	setforexpose(display, win1);

	area2.x = area.x + area.width + 5;
	area2.y = area.y + 5;
	area2.width = 10;
	area2.height= 10;
	win2 = crechild(display, parent, &area2);	

/* Select ExposureMask events on win1 */
	XSelectInput(display, win1, ExposureMask);

/* Set window border on win2 to cover some of win1 */
	w = win2;
	width = 10;
	startcall(display);
	if (isdeleted())
		return;
	XSetWindowBorderWidth(display, w, width);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	
/* Set window border on win2 to expose some of win1 */
	w = win2;
	width = 2;
	startcall(display);
	if (isdeleted())
		return;
	XSetWindowBorderWidth(display, w, width);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that Expose events were genereated or that win2 was */
/* 	recovered from Backing Store. */
	if (!exposecheck(display, win1)) {
		report("Neither Expose events or backing store procesing");
		report("could correctly restore the window contents.");
		FAIL;
	} else
		CHECK;
	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EMat4.mc */
/* End of included file error/EMat4.mc */

/* Including from file error/EMat4.mc */
static void t006(){

int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XSetWindowBorderWidth-6.(A)");
	report_assertion("When the window argument is an InputOnly window then a");
	report_assertion("BadMatch error occurs.");

	report_strategy("Create an InputOnly window.");
	report_strategy("Call test function using InputOnly window as the window argument.");
	report_strategy("Verify that a BadMatch error occurs.");

	tpXSWBWstart();
	setargs();
	seterrdef();

	A_WINDOW = iponlywin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XSetWindowBorderWidth(display, w, width);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EMat4.mc */

/* Including from file error/EWin.mc */
/* End of included file error/EWin.mc */

/* Including from file error/EWin.mc */
static void t007(){

int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XSetWindowBorderWidth-7.(A)");
	report_assertion("When a window argument does not name a valid Window, then a");
	report_assertion("BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpXSWBWstart();
	setargs();
	seterrdef();

	A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XSetWindowBorderWidth(display, w, width);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EWin.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
