/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Status
 *   XQueryTree(display, w, root_return, parent_return, children_return, nchildren_return)
 *   Display *display;
 *   Window w;
 *   Window *root_return;
 *   Window *parent_return;
 *   Window **children_return;
 *   unsigned int *nchildren_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XQueryTree	1
char    *TestName = "XQueryTree";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW w
#define A_DRAWABLE w


/*
 * Arguments to the XQueryTree function
 */
static Display *display;
static Window w;
static Window *root_return;
static Window *parent_return;
static Window **children_return;
static unsigned int *nchildren_return;


static int 	StatusReturn;

/* These are the store locations for the returned data */
static	Window	root;
static	Window	parent;
static	Window	*children;
static	unsigned int	nchildren;

/* Window structure template */
/* A window with three child windows, one of which has */
/* 3 overlapping children */
static	char *QTtemplate[] = {
	".",
	"one . (10,10) 80x70",
	"onec1 one (5,5) 30x30",
	"onec2 one (15,10) 15x15",
	"onec3 one (10,15) 15x15",
	"two . (20,50) 40x20",
	"three . (55,20) 20x20",
};
static	int NQTtemplate = NELEM(QTtemplate);

static	char *QT2template[] = {
	".",
	"one . (10,10) 80x70",
	"o1 one (5,5) 40x40",
	"two . (25,25) 10x10",
	"o2 one (30,30) 40x35",
	"o3 one (20,50) 45x10",
	"o4 one (60,10) 10x10",
	"o5 one (15,35) 30x20",
};
static int NQT2template = NELEM(QT2template);


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	w = 0;
	root_return = &root;
	parent_return = &parent;
	children_return = &children;
	nchildren_return = &nchildren;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	w = ErrdefWindow;
}

static void t001(){

Window realparent;
struct buildtree *tree;
Window one, two, three;
Window childarray[3];
int loop;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XQueryTree-1.(A)");
	report_assertion("A successful call to XQueryTree returns non-zero, the root");
	report_assertion("window ID in root_return, the parent window of the");
	report_assertion("specified window w in parent_return, a pointer to the list");
	report_assertion("of children windows of specified window w in children_return,");
	report_assertion("and the number of children in the list for the specified");
	report_assertion("window w in nchildren_return.");

	report_strategy("Create a window hierarchy.");
	report_strategy("Call XQueryTree to query the window tree.");
	report_strategy("Verify that the root window, parent window, number of children and");
	report_strategy("	the children array were returned as expected.");

	tpstartup();
	setargs();
/* Create a window hierarchy. */
	realparent = defwin(display);
	tree = buildtree(display, realparent, QTtemplate, NQTtemplate);
	one = btntow(tree, "one");
	two = btntow(tree, "two");
	three = btntow(tree, "three");
	childarray[0] = btntow(tree, "onec1"); 
	childarray[1] = btntow(tree, "onec2");
	childarray[2] = btntow(tree, "onec3");
	trace("root window is %0x", DefaultRootWindow(Dsp));
	trace("parent is %0x", realparent);
	trace("one is %0x", one);
	trace("two is %0x", two);
	trace("three is %0x", three);
	for(loop=0; loop<3; loop++)
		trace("onec%d is %0x", loop, childarray[loop]);

/* Call xname to query the window tree. */
#ifdef TESTING
	w = realparent;
#else
	w = one;
#endif
	parent = None;
	root = None;
	children = (Window *)NULL;
	nchildren = -1;
	startcall(display);
	if (isdeleted())
		return;
	StatusReturn = XQueryTree(display, w, root_return, parent_return, children_return, nchildren_return);
	endcall(display);
	if (StatusReturn == 0) {
		report("Status returned was %d", StatusReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that the root window, parent window, number of children and */
/* 	the children array were returned as expected. */


	if (root != DefaultRootWindow(Dsp)) {	
		FAIL;
		report("%s returned an unexpected value for the root window", TestName);
		report("Expected: %0x", DefaultRootWindow(Dsp)); 
		report("Returned: %0x", root);
	} else
		CHECK;

	if (parent != realparent) {
		FAIL;
		report("%s returned an unexpected value for the parent window", TestName);
		report("Expected: %0x", realparent);
		report("Returned: %0x", parent);
	} else
		CHECK;

	if (nchildren != 3) {
		FAIL;
		report("%s returned an unexpected number of child windows", TestName);
		report("Expected: 3");
		report("Returned: %d", nchildren);
		for(loop=0; loop<nchildren; loop++)
			report("children[%d] is  %0x", loop, children[loop]);
	} else {
		for(loop=0; loop<nchildren; loop++)
		{
			if(children[loop] != childarray[loop]) {
				FAIL;
				report("children array [%d] returned unexpected window", loop);
				report("Expected: %0x", childarray[loop]);
				report("Returned: %0x", children[loop]);
			} else
				CHECK;
		}
		XFree((char*)children);
	}

	CHECKPASS(5);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Window realparent;
struct buildtree *tree;
Window one, two;
Window childarray[5];
int loop;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XQueryTree-2.(A)");
	report_assertion("A call to XQueryTree returns the child windows of the");
	report_assertion("specified window w in children_return in current stacking");
	report_assertion("order from bottommost first to topmost last.");

	report_strategy("Create a window hierarchy.");
	report_strategy("Call XQueryTree to query the window tree.");
	report_strategy("Verify that the children array was returned as expected.");

	tpstartup();
	setargs();
/* Create a window hierarchy. */
	realparent = defwin(display);
	tree = buildtree(display, realparent, QT2template, NQT2template);
	one = btntow(tree, "one");
	two = btntow(tree, "two");
	childarray[0] = btntow(tree, "o1");
	childarray[1] = btntow(tree, "o2");
	childarray[2] = btntow(tree, "o3"); 
	childarray[3] = btntow(tree, "o4");
	childarray[4] = btntow(tree, "o5");
	trace("root window is %0x", DefaultRootWindow(Dsp));
	trace("parent is %0x", realparent);
	trace("one is %0x", one);
	trace("two is %0x", two);
	for(loop=0; loop<5; loop++)
		trace("one child %d is %0x", loop, childarray[loop]);

/* Call xname to query the window tree. */
#ifdef TESTING
	w = realparent;
#else
	w = one;
#endif
	parent = None;
	root = None;
	children = (Window *)NULL;
	nchildren = -1;
	startcall(display);
	if (isdeleted())
		return;
	StatusReturn = XQueryTree(display, w, root_return, parent_return, children_return, nchildren_return);
	endcall(display);
	if (StatusReturn == 0) {
		report("Status returned was %d", StatusReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that the children array was returned as expected. */
	if (nchildren != 5) {
		FAIL;
		report("%s returned an unexpected number of child windows", TestName);
		report("Expected: 5");
		report("Returned: %d", nchildren);
		for(loop=0; loop<nchildren; loop++)
			report("children[%d] is  %0x", loop, children[loop]);
	} else {
		for(loop=0; loop<nchildren; loop++)
		{
			if(children[loop] != childarray[loop]) {
				FAIL;
				report("children array [%d] returned unexpected window", loop);
				report("Expected: %0x", childarray[loop]);
				report("Returned: %0x", children[loop]);
			} else
				CHECK;
		}
		XFree((char*)children);
	}

	CHECKPASS(5);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EWin.mc */
/* End of included file error/EWin.mc */

/* Including from file error/EWin.mc */
static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XQueryTree-3.(A)");
	report_assertion("When a window argument does not name a valid Window, then a");
	report_assertion("BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	StatusReturn = XQueryTree(display, w, root_return, parent_return, children_return, nchildren_return);
	endcall(display);
	if (StatusReturn != 0) {
		report("Status returned was %d", StatusReturn);
		FAIL;
	}
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EWin.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
