/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtCallCallbacks()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

extern WidgetClass avsObjClass;
char client_stuff1[] = "Four score and seven years ago";
char client_stuff2[] = "The lazy brown dog";
char call_stuff[] = "My love she speaks like silence";

Widget labelw_good;

/*
** Procedure XtCBP_ProcOne
*/
void XtCBP_ProcOne(w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	
	tet_infoline("TEST: Widget passed correctly");
	if (w != labelw_good) {
		tet_infoline("ERROR: Object not passed correctly");
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Client_data passed correctly");
	if (client_data == NULL) {
		sprintf(ebuf, "ERROR: Expected client data = \"%s\", was NULL", client_stuff1);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	} else {
		if (strcmp(client_data, client_stuff1) != 0) {
			sprintf(ebuf, "ERROR: Expected client data = \"%s\", was \"%s\"", client_stuff1, client_data);
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
		}
	}
	tet_infoline("TEST: Call_data passed correctly");
	if (call_data == NULL) {
		sprintf(ebuf, "ERROR: Expected call data = \"%s\", was NULL", call_stuff);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	} else {
		if (strcmp(call_data, call_stuff) != 0) {
			sprintf(ebuf, "ERROR: Expected call data = \"%s\", was \"%s\"", call_stuff, call_data);
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
		}
	}
	avs_set_event(1, 1);
}
/*
** Procedure XtCBP_ProcTwo
*/
void XtCBP_ProcTwo(w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	tet_infoline("TEST: Widget passed correctly");
	if (w != labelw_good) {
		tet_infoline("ERROR: Object not passed correctly");
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Client_data passed correctly");
	if (client_data == NULL) {
		sprintf(ebuf, "ERROR: Expected client data = \"%s\", was NULL", client_stuff2);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	} else {
		if (strcmp(client_data, client_stuff2) != 0) {
			sprintf(ebuf, "ERROR: Expected client data = \"%s\", was \"%s\"", client_stuff2, client_data);
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
		}
	}
	tet_infoline("TEST: Call_data passed correctly");
	if (call_data == NULL) {
		sprintf(ebuf, "ERROR: Expected call data = \"%s\", was NULL", call_stuff);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	} else {
		if (strcmp(call_data, call_stuff) != 0) {
			sprintf(ebuf, "ERROR: Expected call data = \"%s\", was \"%s\"", call_stuff, call_data);
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
		}
	}
	avs_set_event(2, 1);
}


#define T_XtCallCallbacks	1
char    *TestName = "XtCallCallbacks";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int first, second, third;
int call_data = 0;
XtCallbackRec callbacks[3] = {
	{ (XtCallbackProc)XtCBP_ProcOne, client_stuff1 },
	{ (XtCallbackProc)XtCBP_ProcTwo, client_stuff2},
	{ (XtCallbackProc) NULL,	 (XtPointer)NULL }
};
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtCallCallbacks-1.(A)");
	report_assertion("A successful call to void XtCallCallbacks(w, callback_name,");
	report_assertion("call_data) shall call each callback procedure in the widget");
	report_assertion("w's callback list specified by callback_name, passing the");
	report_assertion("client data registered with the procedure and call_data as");
	report_assertion("arguments.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tcalcbcks1", "XtCallCallbacks");
	tet_infoline("PREP: Create labelw_good widget in boxw1 widget");
	labelw_good = (Widget) CreateLabelWidget("Hello", boxw1);
	tet_infoline("PREP: Add callback procedure XtCBP_Proc to labelw_good");
	XtAddCallbacks(labelw_good,
			XtNdestroyCallback,
			&callbacks[0]
			);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Invoke callbacks");
	XtCallCallbacks(labelw_good, XtNdestroyCallback, call_stuff);
	tet_infoline("TEST: All procedures were invoked");
	first = avs_get_event(1);
	check_dec(1, first, "XtCBP_ProcOne invoked count");
	second = avs_get_event(2);
	check_dec(1, second, "XtCBP_ProcTwo invoked count");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3384 */
/* End of included file Mdefcode.tmc.3384 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
