/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   XtActionHookId
 *   XtAppAddActionHook()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

#include <xt/SquareCelP.h>
extern char *event_names[];
char client_stuff[] = "These are the times that try men's souls";
int flag;
/*an action procedure*/
void AvsWidAction1(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	if (avs_get_event(1) == 0) {
		sprintf(ebuf, "ERROR: Action hook procedure was not called before action procedure");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	avs_set_event(2,1);
	exit(0);
}
#define AVS_WID_ACTION1 "AvsWidAction1"
XtActionsRec actions1[] = {
	{AVS_WID_ACTION1, AvsWidAction1},
};
/*an action hook procedure*/
void XtAHP1_Proc(widget, client_data, action_name, event, params, num_params)
Widget widget;
XtPointer client_data;
String action_name;
XEvent *event;
String *params;
Cardinal *num_params;
{
		avs_set_event(1, 1); 
		flag = 1;
	tet_infoline("TEST: Widget passed correctly to hook procedure");
	if (widget != boxw1) {
		sprintf(ebuf, "ERROR: Expected widget = %#x, received %#x", boxw1, widget);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Client_data passed correctly to hook procedure");
	if (client_data == NULL) {
		sprintf(ebuf, "ERROR: Expected client_data = \"%s\", received NULL", client_stuff);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	} else {
		if (strcmp(client_data, client_stuff) != 0) {
			sprintf(ebuf, "ERROR: Expected client_data = \"%s\", received \"%s\"", client_stuff, client_data);
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
		}
	}
	tet_infoline("TEST: Action name is passed correctly to hook proc");
	if (strcmp(action_name, "AvsWidAction1") != 0) {
		sprintf(ebuf, "ERROR: Expected action_name = AvsWidAction1, received \"%s\"", action_name);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Event is passed correctly to hook proc");
	if (event->type != ButtonPress) {
		sprintf(ebuf, "ERROR: Expected ButtonPress event, received \"%s\"", event_names[event->type]);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
}

/*an action procedure*/
void AvsWidAction2(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	if (avs_get_event(1) == 0) {
		sprintf(ebuf, "ERROR: Action hook procedure was not called before action procedure");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	avs_set_event(2,1);
	exit(0);
}
#define AVS_WID_ACTION2 "AvsWidAction2"
XtActionsRec actions2[] = {
	{AVS_WID_ACTION2, AvsWidAction2},
};
/*an action hook procedure*/
void XtAHP2_Proc(widget, client_data, action_name, event, params, num_params)
Widget widget;
XtPointer client_data;
String action_name;
XEvent *event;
String *params;
Cardinal *num_params;
{
	avs_set_event(1, 1); 
	flag = 1;
	tet_infoline("TEST: Widget passed correctly to hook procedure");
	if (widget != boxw1) {
		sprintf(ebuf, "ERROR: Expected widget = %#x, received %#x", boxw1, widget);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Client_data passed correctly to hook procedure");
	if (client_data == NULL) {
		sprintf(ebuf, "ERROR: Expected client_data = \"%s\", received NULL", client_stuff);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	} else {
		if (strcmp(client_data, client_stuff) != 0) {
			sprintf(ebuf, "ERROR: Expected client_data = \"%s\", received \"%s\"", client_stuff, client_data);
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
		}
	}
	tet_infoline("TEST: Action name is passed correctly to hook proc");
	if (strcmp(action_name, "AvsWidAction2") != 0) {
		sprintf(ebuf, "ERROR: Expected action_name = AvsWidAction2, received \"%s\"", action_name);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Event is passed correctly to hook proc");
	if (event->type != ButtonPress) {
		sprintf(ebuf, "ERROR: Expected ButtonPress event, received \"%s\"", event_names[event->type]);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
}
/*an action procedure*/
void AvsWidAction3(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	if (flag != 2) {
		sprintf(ebuf, "ERROR: Action hook procedures not called before action procedure");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	avs_set_event(1,1);
	exit(0);
}
#define AVS_WID_ACTION3 "AvsWidAction3"
XtActionsRec actions3[] = {
	{AVS_WID_ACTION3, AvsWidAction3},
};
/*another action hook procedure*/
void XtAHP3a_Proc(widget, client_data, action_name, event, params, num_params)
Widget widget;
XtPointer client_data;
String action_name;
XEvent *event;
String *params;
Cardinal *num_params;
{
		flag++;
		avs_set_event(3, flag); 
	tet_infoline("TEST: Widget passed correctly to hook procedure");
	if (widget != boxw1) {
		sprintf(ebuf, "ERROR: Expected widget = %#x, received %#x", boxw1, widget);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Action name is passed correctly to hook proc");
	if (strcmp(action_name, "AvsWidAction3") != 0) {
		sprintf(ebuf, "ERROR: Expected action_name = AvsWidAction3, received \"%s\"", action_name);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Event is passed correctly to hook proc");
	if (event->type != ButtonPress) {
		sprintf(ebuf, "ERROR: Expected ButtonPress event, received \"%s\"", event_names[event->type]);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
}
/*an action hook procedure*/
void XtAHP3_Proc(widget, client_data, action_name, event, params, num_params)
Widget widget;
XtPointer client_data;
String action_name;
XEvent *event;
String *params;
Cardinal *num_params;
{
	flag++;
	avs_set_event(2, flag); 
	tet_infoline("TEST: Widget passed correctly to hook procedure");
	if (widget != boxw1) {
		sprintf(ebuf, "ERROR: Expected widget = %#x, received %#x", boxw1, widget);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Action name is passed correctly to hook proc");
	if (strcmp(action_name, "AvsWidAction3") != 0) {
		sprintf(ebuf, "ERROR: Expected action_name = AvsWidAction3, received \"%s\"", action_name);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Event is passed correctly to hook proc");
	if (event->type != ButtonPress) {
		sprintf(ebuf, "ERROR: Expected ButtonPress event, received \"%s\"", event_names[event->type]);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
}
/*an action procedure*/
void AvsWidAction4(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	if (flag != 2) {
		sprintf(ebuf, "ERROR: Action hook procedures not called before action procedure");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	avs_set_event(1,1);
	exit(0);
}
#define AVS_WID_ACTION4 "AvsWidAction4"
XtActionsRec actions4[] = {
	{AVS_WID_ACTION4, AvsWidAction4},
};
/*an action hook procedure*/
void XtAHP4_Proc(widget, client_data, action_name, event, params, num_params)
Widget widget;
XtPointer client_data;
String action_name;
XEvent *event;
String *params;
Cardinal *num_params;
{
		flag++;
		avs_set_event(flag+1, 1); 
	tet_infoline("TEST: Widget passed correctly to hook procedure");
	if (widget != boxw1) {
		sprintf(ebuf, "ERROR: Expected widget = %#x, received %#x", boxw1, widget);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	if (client_data != NULL) {
		tet_infoline("TEST: Client_data passed correctly to hook procedure");
		if (strcmp(client_data, client_stuff) != 0) {
			sprintf(ebuf, "ERROR: Expected client_data = \"%s\", received \"%s\"", client_stuff, client_data);
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
		}
	}
	tet_infoline("TEST: Action name is passed correctly to hook proc");
	if (strcmp(action_name, "AvsWidAction4") != 0) {
		sprintf(ebuf, "ERROR: Expected action_name = AvsWidAction4, received \"%s\"", action_name);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Event is passed correctly to hook proc");
	if (event->type != ButtonPress) {
		sprintf(ebuf, "ERROR: Expected ButtonPress event, received \"%s\"", event_names[event->type]);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
}
/*an action procedure*/
void AvsWidAction5(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	if (flag != 2) {
		sprintf(ebuf, "ERROR: Action hook procedures not called before action procedure");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	avs_set_event(1,1);
	exit(0);
}
#define AVS_WID_ACTION5 "AvsWidAction5"
XtActionsRec actions5[] = {
	{AVS_WID_ACTION5, AvsWidAction5},
};
/*an action hook procedure*/
void XtAHP5_Proc(widget, client_data, action_name, event, params, num_params)
Widget widget;
XtPointer client_data;
String action_name;
XEvent *event;
String *params;
Cardinal *num_params;
{
	flag++;
	avs_set_event(flag+1, 1); 
	tet_infoline("TEST: Widget passed correctly to hook procedure");
	if (widget != boxw1) {
		sprintf(ebuf, "ERROR: Expected widget = %#x, received %#x", boxw1, widget);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	if (client_data != NULL) {
		tet_infoline("TEST: Client_data passed correctly to hook procedure");
		if (strcmp(client_data, client_stuff) != 0) {
			sprintf(ebuf, "ERROR: Expected client_data = \"%s\", received \"%s\"", client_stuff, client_data);
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
		}
	}
	tet_infoline("TEST: Action name is passed correctly to hook proc");
	if (strcmp(action_name, "AvsWidAction5") != 0) {
		sprintf(ebuf, "ERROR: Expected action_name = AvsWidAction5, received \"%s\"", action_name);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Event is passed correctly to hook proc");
	if (event->type != ButtonPress) {
		sprintf(ebuf, "ERROR: Expected ButtonPress event, received \"%s\"", event_names[event->type]);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
}


#define T_XtAppAddActionHook	1
char    *TestName = "XtAppAddActionHook";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Widget squarew;
XEvent event;
int status1, status2;
pid_t pid2;
XtTranslations translations;
static char trans_good[] = "#replace	\n\
 <BtnDown>:	AvsWidAction1()";
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtAppAddActionHook-1.(A)");
	report_assertion("A successful call to XtActionHookId XtAppAddActionHook(app,");
	report_assertion("proc, client_data) shall register proc as the procedure that");
	report_assertion("will be called just before any action procedure is");
	report_assertion("dispatched in the application context app and return an");
	report_assertion("identifier for it.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tapadachk1", "XtAppAddActionHook");
	tet_infoline("PREP: Register action procedure with resource manager");
	XtAppAddActions(app_ctext, actions1, XtNumber(actions1));
	tet_infoline("PREP: Add translation into widget");
	translations = XtParseTranslationTable(trans_good);
	XtOverrideTranslations(boxw1, translations);
	tet_infoline("PREP: Add an action hook procedure");
	XtAppAddActionHook(app_ctext, XtAHP1_Proc, client_stuff);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send ButtonPress event to invoke action");
	send_event(boxw1, ButtonPress, ButtonPressMask, TRUE);
	tet_infoline("TEST: Action hook and action procedures are invoked");
	XtAppMainLoop(app_ctext);
	LKROF(pid2, AVSXTTIMEOUT-2);
	status1 = avs_get_event(1);
	check_dec(1, status1, "XtAHP1_Proc invoked status");
	status2 = avs_get_event(2);
	check_dec(1, status2, "Action procedure invoked status");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.1116 */
/* End of included file Mdefcode.tmc.1116 */

static void t002(){

Widget squarew;
XEvent event;
int status1, status2;
pid_t pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtAppAddActionHook-2.(A)");
	report_assertion("A call to XtActionHookId XtAppAddActionHook(app, proc,");
	report_assertion("client_data) shall register proc as the procedure that will");
	report_assertion("be called before an action procedure is invoked by a call to");
	report_assertion("XtCallActionProc.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tapadachk2", "XtAppAddActionHook");
	tet_infoline("PREP: Register action procedure with resource manager");
	XtAppAddActions(app_ctext, actions2, XtNumber(actions2));
	tet_infoline("PREP: Add an action hook procedure");
	XtAppAddActionHook(app_ctext, XtAHP2_Proc, client_stuff);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Invoke action procedure");
	event.type = ButtonPress;
	XtCallActionProc(boxw1, AVS_WID_ACTION2, &event,
			(String *)NULL, (Cardinal)0);
	tet_infoline("TEST: Action hook and action procedures are invoked");
	XtAppMainLoop(app_ctext);
	LKROF(pid2, AVSXTTIMEOUT-2);
	status1 = avs_get_event(1);
	check_dec(1, status1, "XtAHP2_Proc invoked status");
	status2 = avs_get_event(2);
	check_dec(1, status2, "Action procedure invoked status");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.1116 */
/* End of included file Mdefcode.tmc.1116 */

static void t003(){

Widget squarew;
XEvent event;
int status1, status2;
pid_t pid2;
XtTranslations translations;
static char trans_good[] = "#replace	\n\
	 <BtnDown>:	AvsWidAction3()";
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtAppAddActionHook-3.(A)");
	report_assertion("When multiple action hook procedures have been registered");
	report_assertion("for an application context by calls to XtActionHookId");
	report_assertion("XtAppAddActionHook(app, proc, client_data) they shall be");
	report_assertion("called in the reverse order of their registration.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tapadachk3", "XtAppAddActionHook");
	tet_infoline("PREP: Register action procedure with resource manager");
	XtAppAddActions(app_ctext, actions3, XtNumber(actions3));
	tet_infoline("PREP: Add translation into widget");
	translations = XtParseTranslationTable(trans_good);
	XtOverrideTranslations(boxw1, translations);
	tet_infoline("PREP: Add an action hook procedure");
	XtAppAddActionHook(app_ctext, XtAHP3_Proc, client_stuff);
	tet_infoline("PREP: Add another action hook procedure");
	XtAppAddActionHook(app_ctext, XtAHP3a_Proc, client_stuff);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send ButtonPress event to invoke action");
	send_event(boxw1, ButtonPress, ButtonPressMask, TRUE);
	tet_infoline("TEST: Action hook and action procedures are invoked, order is correct");
	XtAppMainLoop(app_ctext);
	LKROF(pid2, AVSXTTIMEOUT-2);
	status1 = avs_get_event(2);
	check_dec(2, status1, "invokation of first action hook proc");
	status1 = avs_get_event(3);
	check_dec(1, status1, "invokation of second action hook proc");
	status2 = avs_get_event(1);
	check_dec(1, status2, "Action procedure invoked status");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.1116 */
/* End of included file Mdefcode.tmc.1116 */

static void t004(){

Widget squarew;
XEvent event;
int status1, status2;
pid_t pid2;
XtTranslations translations;
static char trans_good[] = "#replace	\n\
 <BtnDown>:	AvsWidAction1()";
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtAppAddActionHook-4.(A)");
	report_assertion("A successful call to XtActionHookId XtAppAddActionHook(app,");
	report_assertion("proc, client_data) shall cause client_data to be passed to");
	report_assertion("proc when it is invoked.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tapadachk1", "XtAppAddActionHook");
	tet_infoline("PREP: Register action procedure with resource manager");
	XtAppAddActions(app_ctext, actions1, XtNumber(actions1));
	tet_infoline("PREP: Add translation into widget");
	translations = XtParseTranslationTable(trans_good);
	XtOverrideTranslations(boxw1, translations);
	tet_infoline("PREP: Add an action hook procedure");
	XtAppAddActionHook(app_ctext, XtAHP1_Proc, client_stuff);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send ButtonPress event to invoke action");
	send_event(boxw1, ButtonPress, ButtonPressMask, TRUE);
	tet_infoline("TEST: Action hook and action procedures are invoked");
	XtAppMainLoop(app_ctext);
	LKROF(pid2, AVSXTTIMEOUT-2);
	status1 = avs_get_event(1);
	check_dec(1, status1, "XtAHP1_Proc invoked status");
	status2 = avs_get_event(2);
	check_dec(1, status2, "Action procedure invoked status");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.1116 */
/* End of included file Mdefcode.tmc.1116 */

static void t005(){

Widget squarew;
XEvent event;
int status1, status2;
pid_t pid2;
XtTranslations translations;
static char trans_good[] = "#replace	\n\
	 <BtnDown>:	AvsWidAction4()";
pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtAppAddActionHook-5.(A)");
	report_assertion("An action hook procedure registered multiple times with a");
	report_assertion("call to XtActionHookId XtAppAddActionHook(app, proc,");
	report_assertion("client_data) with different client_data shall be called");
	report_assertion("multiple times when an action is dispatched.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tapadachk4", "XtAppAddActionHook");
	tet_infoline("PREP: Register action procedure with resource manager");
	XtAppAddActions(app_ctext, actions4, XtNumber(actions4));
	tet_infoline("PREP: Add translation into widget");
	translations = XtParseTranslationTable(trans_good);
	XtOverrideTranslations(boxw1, translations);
	tet_infoline("PREP: Add an action hook procedure");
	XtAppAddActionHook(app_ctext, XtAHP4_Proc, client_stuff);
	tet_infoline("PREP: Add it again with other client_data");
	XtAppAddActionHook(app_ctext, XtAHP4_Proc, NULL);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send ButtonPress event to invoke action");
	send_event(boxw1, ButtonPress, ButtonPressMask, TRUE);
	tet_infoline("TEST: Action hook and action procedures are invoked, order is correct");
	XtAppMainLoop(app_ctext);
	LKROF(pid2, AVSXTTIMEOUT-2);
	status1 = avs_get_event(2);
	check_dec(1, status1, "first invocation action hook proc");
	status1 = avs_get_event(3);
	check_dec(1, status1, "second invocation of action hook proc");
	status2 = avs_get_event(1);
	check_dec(1, status2, "invocation of action procedure");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.1116 */
/* End of included file Mdefcode.tmc.1116 */

static void t006(){

Widget squarew;
XEvent event;
int status1, status2;
pid_t pid2;
XtTranslations translations;
static char trans_good[] = "#replace	\n\
	 <BtnDown>:	AvsWidAction5()";
pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtAppAddActionHook-6.(A)");
	report_assertion("An action hook procedure registered multiple times with a");
	report_assertion("call to XtActionHookId XtAppAddActionHook(app, proc,");
	report_assertion("client_data) with the same client_data shall be called");
	report_assertion("multiple times when an action is dispatched.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tapadachk5", "XtAppAddActionHook");
	tet_infoline("PREP: Register action procedure with resource manager");
	XtAppAddActions(app_ctext, actions5, XtNumber(actions5));
	tet_infoline("PREP: Add translation into widget");
	translations = XtParseTranslationTable(trans_good);
	XtOverrideTranslations(boxw1, translations);
	tet_infoline("PREP: Add an action hook procedure");
	XtAppAddActionHook(app_ctext, XtAHP5_Proc, client_stuff);
	tet_infoline("PREP: Add it again with the same client_data");
	XtAppAddActionHook(app_ctext, XtAHP5_Proc, client_stuff);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send ButtonPress event to invoke action");
	send_event(boxw1, ButtonPress, ButtonPressMask, TRUE);
	tet_infoline("TEST: Action hook and action procedures are invoked, order is correct");
	XtAppMainLoop(app_ctext);
	LKROF(pid2, AVSXTTIMEOUT-2);
	status1 = avs_get_event(2);
	check_dec(1, status1, "first invocation action hook proc");
	status1 = avs_get_event(3);
	check_dec(1, status1, "second invocation of action hook proc");
	status2 = avs_get_event(1);
	check_dec(1, status2, "invocation of action procedure");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.1116 */
/* End of included file Mdefcode.tmc.1116 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
