/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

int bits_per_char = 0;
void get_bits_per_char()
{
	unsigned char testVar;
	testVar = 1;
	while (testVar != 0) {
		testVar = testVar << 1;
		bits_per_char++;
	}
}


#define T_DataTypes	1
char    *TestName = "DataTypes";



int 	tet_thistest;

static void t001(){

	Boolean testVar;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion DataTypes-1.(A)");
	report_assertion("The data type Boolean shall be able to hold a zero or");
	report_assertion("non-zero value.");
	FORK(pid);
	initconfig();

	tet_infoline("TEST: Size of Boolean");
	if (sizeof(testVar) < 1) {
		sprintf(ebuf, "ERROR: Size of Boolean is %d, expected at least 1", sizeof(testVar));
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.2012 */
/* End of included file Mdefcode.tmc.2012 */

static void t002(){

	Cardinal testVar;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion DataTypes-2.(A)");
	report_assertion("The data type Cardinal shall be an unsigned datum with a");
	report_assertion("minimum range of 0 through 2**16-1.");
	FORK(pid);
	initconfig();

	get_bits_per_char();
	tet_infoline("TEST: Size of Cardinal");
	if (sizeof(testVar) < 16/bits_per_char) {
		sprintf(ebuf, "ERROR: Size of Cardinal is %d bits, expected at least 16", sizeof(testVar)*bits_per_char);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Cardinal is unsigned");
	testVar = -1;
	if (testVar < 0) {
		tet_infoline("ERROR: Cardinal was signed");
		tet_result(TET_FAIL);
	}
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.2012 */
/* End of included file Mdefcode.tmc.2012 */

static void t003(){

	Dimension testVar;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion DataTypes-3.(A)");
	report_assertion("The data type Dimension shall be an unsigned datum with a");
	report_assertion("minimum range of 0 through 2**16-1.");
	FORK(pid);
	initconfig();

	get_bits_per_char();
	tet_infoline("TEST: Size of Dimension");
	if (sizeof(testVar) < 16/bits_per_char) {
		sprintf(ebuf, "ERROR: Size of Dimension is %d bits, expected at least 16", sizeof(testVar)*bits_per_char);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Dimension is unsigned");
	testVar = -1;
	if (testVar < 0) {
		tet_infoline("ERROR: Dimension is signed");
		tet_result(TET_FAIL);
	}
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.2012 */
/* End of included file Mdefcode.tmc.2012 */

static void t004(){

	Position testVar;
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion DataTypes-4.(A)");
	report_assertion("The data type Position shall be a signed datum with a");
	report_assertion("minimum range of -2**15 through 2**15-1.");
	FORK(pid);
	initconfig();

	get_bits_per_char();
	tet_infoline("TEST: Size of Position");
	if (sizeof(testVar) < 16/bits_per_char) {
		sprintf(ebuf, "ERROR: Size of Position is %d bits, expected at least 16", sizeof(testVar)*bits_per_char);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Position is signed");
	testVar = -1;
	if (testVar > 0) {
		tet_infoline("ERROR: Position is unsigned");
		tet_result(TET_FAIL);
	}
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.2012 */
/* End of included file Mdefcode.tmc.2012 */

static void t005(){

XtPointer testVar;
char *ptestChar;
int *ptestInt;
long testLong;	
int (*pfunc)();
struct {int temp;} *ptestStruct;
pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion DataTypes-5.(A)");
	report_assertion("The data type XtPointer shall be a datum large enough to");
	report_assertion("contain the largest of a char*, int*, function pointer,");
	report_assertion("structure pointer, or long value.");
	FORK(pid);
	initconfig();

	tet_infoline("TEST: Size of XtPointer");
	if (sizeof(testVar) < sizeof(ptestChar)) {
		sprintf(ebuf, "ERROR: Size of XtPointer(%d) is less than that of *char(%d)", sizeof(testVar), sizeof(ptestChar));
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	if (sizeof(testVar) < sizeof(ptestInt)) {
		sprintf(ebuf, "ERROR: Size of XtPointer(%d) is less than that of *int(%d)", sizeof(testVar), sizeof(ptestInt));
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	if (sizeof(testVar) < sizeof(testLong)) {
		sprintf(ebuf, "ERROR: Size of XtPointer(%d) is less than that of *long(%d)", sizeof(testVar), sizeof(testLong));
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	if (sizeof(testVar) < sizeof(ptestStruct)) {
		sprintf(ebuf, "ERROR: Size of XtPointer(%d) is less than that of *struct(%d)", sizeof(testVar), sizeof(ptestStruct));
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	if (sizeof(testVar) < sizeof(pfunc)) {
		sprintf(ebuf, "ERROR: Size of Pointer(%d) is less than that of *function(%d)", sizeof(testVar), sizeof(pfunc));
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.2012 */
/* End of included file Mdefcode.tmc.2012 */

static void t006(){

char testChar, *ptestChar;
int testInt, *ptestInt;
long testLong;	
struct {int temp;} testStruct, *ptestStruct;
pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion DataTypes-6.(A)");
	report_assertion("A pointer to any type or function or a long value may be");
	report_assertion("converted to an XtPointer and back again and the results");
	report_assertion("will compare equal to the original value.");
	FORK(pid);
	initconfig();

	tet_infoline("TEST: Values can be cooerced to XtPointer without change");
	ptestChar = &testChar;
	if ((XtPointer)(ptestChar) != &testChar) {
		sprintf(ebuf, "ERROR: *char changed value when cooerced to XtPointer");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	ptestInt = &testInt;
	if ((XtPointer)(ptestInt) != &testInt) {
		sprintf(ebuf, "ERROR: *int changed value when cooerced to XtPointer");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	ptestStruct = &testStruct;
	if ((XtPointer)(ptestStruct) != &testStruct) {
		sprintf(ebuf, "ERROR: *struct changed value when cooerced to XtPointer");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	testLong = (long)&testStruct;
	if ((XtPointer)(testLong) != &testStruct) {
		sprintf(ebuf, "ERROR: long changed value when cooerced to XtPointer");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.2012 */
/* End of included file Mdefcode.tmc.2012 */

static void t007(){

XtArgVal testVar;
XtPointer testPoint;
Cardinal testCard;
Dimension testDim;
Position testPos;
pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion DataTypes-7.(A)");
	report_assertion("The data type XtArgVal shall be a datum large enough to");
	report_assertion("contain an XtPointer, Cardinal, Dimension or Position value.");
	FORK(pid);
	initconfig();

	tet_infoline("TEST: Size of XtArgVal");
	if (sizeof(testVar) < sizeof(testPoint)) {
		sprintf(ebuf, "ERROR: Size of XtArgVal(%d) is less than that of XtPointerchar(%d)", sizeof(testVar), sizeof(testPoint));
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	if (sizeof(testVar) < sizeof(testCard)) {
		sprintf(ebuf, "ERROR: Size of XtArgVal(%d) is less than that of Cardinal(%d)", sizeof(testVar), sizeof(testCard));
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	if (sizeof(testVar) < sizeof(testDim)) {
		sprintf(ebuf, "ERROR: Size of XtArgVal(%d) is less than that of Dimension(%d)", sizeof(testVar), sizeof(testDim));
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	if (sizeof(testVar) < sizeof(testPos)) {
		sprintf(ebuf, "ERROR: Size of XtArgVal(%d) is less than that of Position(%d)", sizeof(testVar), sizeof(testPos));
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.2012 */
/* End of included file Mdefcode.tmc.2012 */

static void t008(){

	XtEnum testVar;
pid_t	pid;

 	report_purpose(8);

	report_assertion("Assertion DataTypes-8.(A)");
	report_assertion("The data type XtEnum shall be able to hold least 128");
	report_assertion("distinct values, two of which are the symbolic values True");
	report_assertion("and False.");
	FORK(pid);
	initconfig();

	get_bits_per_char();
	tet_infoline("TEST: Size of XtEnum");
	if (sizeof(testVar)*bits_per_char < 7) {
		sprintf(ebuf, "ERROR: Size of XtEnum is %d bits, expected at least 7", sizeof(testVar)*bits_per_char);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: True and False fit in XtEnum");
	testVar = True;
	if (testVar != True) {
		tet_infoline("ERROR: True does not fit in XtEnum");
		tet_result(TET_FAIL);
	}
	testVar = False;
	if (testVar != False) {
		tet_infoline("ERROR: False does not fit in XtEnum");
		tet_result(TET_FAIL);
	}
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.2012 */
/* End of included file Mdefcode.tmc.2012 */

static void t009(){

pid_t	pid;

 	report_purpose(9);

	report_assertion("Assertion DataTypes-9.(A)");
	report_assertion("The symbols TRUE and FALSE shall be equal to True and");
	report_assertion("False, respectively.");
	FORK(pid);
	initconfig();

	if (TRUE != True) {
		sprintf(ebuf, "ERROR: TRUE(%d) not equal to True(%d)", TRUE, True);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	if (FALSE != False) {
		sprintf(ebuf, "ERROR: FALSE(%d) not equal to False(%d)", FALSE, False);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.2012 */
/* End of included file Mdefcode.tmc.2012 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
