/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   EventMask
 *   XtBuildEventMask()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

/*
** XtEVT1_Proc
*/
void XtEVT1_Proc(w, client_data, event, continue_to_process)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *continue_to_process;
{
}
/*
** XtEVT2_Proc
*/
void XtEVT2_Proc(w, client_data, event, continue_to_process)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *continue_to_process;
{
}
void XtACT2_Proc(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
}
/*
** XtEVT3_Proc
*/
void XtEVT3_Proc(w, client_data, event, continue_to_process)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *continue_to_process;
{
}
void XtACT3_Proc(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
}



#define T_XtBuildEventMask	1
char    *TestName = "XtBuildEventMask";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Widget labelw_msg;
EventMask event_mask_good;
EventMask events_selected;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtBuildEventMask-1.(A)");
	report_assertion("A successful call to EventMask XtBuildEventMask(w) shall");
	report_assertion("return the event mask for the widget w that is the logical");
	report_assertion("OR of all event masks for event handlers registered on the");
	report_assertion("widget with XtAddEventHandler and XtInsertEventHandler and");
	report_assertion("all event translations, including accelerators, installed on");
	report_assertion("the specified widget.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tbuevtmsk1", "XtBuildEventMask");
	tet_infoline("PREP: Create a test labelw_msg widget");
	labelw_msg = (Widget) CreateLabelWidget("ApTest", boxw1);
	tet_infoline("PREP: Register handler for KeyPress and Release events");
	events_selected = (KeyPressMask | KeyReleaseMask);
	XtAddEventHandler(labelw_msg,
		 events_selected,
		 False,
		 XtEVT1_Proc,
		 (Widget)topLevel
		 );
	tet_infoline("PREP: Realize widgets");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Event mask has KeyPress and Release set");
	event_mask_good = XtBuildEventMask(labelw_msg);
	if ((event_mask_good & events_selected) != events_selected) {
		sprintf(ebuf, "ERROR: expected mask to include %#x, mask was %#x", events_selected, event_mask_good);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.2612 */
/* End of included file Mdefcode.tmc.2612 */

static void t002(){

Widget labelw_msg;
EventMask event_mask_good, events_selected;
pid_t pid2;
XtTranslations translations;
static char trans_good[] = "#replace	\n\
	 <BtnDown>:	XtACT2_Proc()";
static XtActionsRec actions[] = {
	 {"XtACT2_Proc", (XtActionProc)XtACT2_Proc},
	};
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtBuildEventMask-2.(A)");
	report_assertion("The event mask returned by a call to EventMask");
	report_assertion("XtBuildEventMask(w) shall reflect all event translations and");
	report_assertion("accelerators installed for the widget w.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tbuevtmsk2", "XtBuildEventMask");
	tet_infoline("PREP: Create a test widget");
	labelw_msg = (Widget) CreateLabelWidget("ApTest", boxw1);
	tet_infoline("PREP: Register handler for KeyPress and Release events");
	events_selected = KeyPressMask|KeyReleaseMask;	
	XtAddEventHandler(labelw_msg,
		 events_selected,
		 False,
		 XtEVT2_Proc,
		 (Widget)topLevel
		 );
	tet_infoline("PREP: Add translations for ButtonPress");
	XtAppAddActions(app_ctext, actions, 1);
	translations = XtParseTranslationTable(trans_good);
	XtAugmentTranslations(labelw_msg, translations);
	tet_infoline("PREP: Realize widgets");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Event mask has KeyPress and Release set");
	event_mask_good = XtBuildEventMask(labelw_msg);
	if ((event_mask_good & events_selected) != events_selected) {
		sprintf(ebuf, "ERROR: expected mask to include %#x, mask was %#x", events_selected, event_mask_good);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Event mask has ButtonPress set");
	if ((event_mask_good & ButtonPressMask) != ButtonPressMask) {
		sprintf(ebuf, "ERROR: expected mask to include %#x, mask was %#x", ButtonPressMask, event_mask_good);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.2612 */
/* End of included file Mdefcode.tmc.2612 */

static void t003(){

Widget labelw_msg;
EventMask event_mask_good, events_selected;
pid_t pid2;
XtTranslations translations;
static char trans_good[] = "#replace	\n\
	 <BtnDown>:	XtACT3_Proc()";
static XtActionsRec actions[] = {
	 {"XtACT3_Proc", (XtActionProc)XtACT3_Proc},
	};
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtBuildEventMask-3.(A)");
	report_assertion("The event mask returned by a call to EventMask");
	report_assertion("XtBuildEventMask(w) reflect the addition or removal or event");
	report_assertion("handlers and translations.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tbuevtmsk3", "XtBuildEventMask");
	tet_infoline("PREP: Create a test widget");
	labelw_msg = (Widget) CreateLabelWidget("ApTest", boxw1);
	tet_infoline("PREP: Realize widgets");
	XtRealizeWidget(topLevel);
	events_selected = KeyPressMask|KeyReleaseMask;
	tet_infoline("PREP: Register handler for KeyPress and Release events");
	XtAddEventHandler(labelw_msg,
		 events_selected,
		 False,
		 XtEVT3_Proc,
		 NULL
		 );
	tet_infoline("TEST: Event mask has KeyPress and Release set");
	event_mask_good = XtBuildEventMask(labelw_msg);
	if ((event_mask_good & events_selected) != events_selected) {
		sprintf(ebuf, "ERROR: Expected mask to include %#x, mask was %#x", events_selected, event_mask_good);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("PREP: Add translations for ButtonPress");
	XtAppAddActions(app_ctext, actions, 1);
	translations = XtParseTranslationTable(trans_good);
	XtAugmentTranslations(labelw_msg, translations);
	event_mask_good = XtBuildEventMask(labelw_msg);
	tet_infoline("TEST: Event mask has ButtonPress set");
	if ((event_mask_good & ButtonPressMask) != ButtonPressMask) {
		sprintf(ebuf, "ERROR: Expected mask to include %#x, mask was %#x", ButtonPressMask, event_mask_good);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("PREP: Remove the event handler");
	XtRemoveEventHandler(labelw_msg,
		 events_selected,
		 False,
		 XtEVT3_Proc,
		 NULL
		 );
	tet_infoline("TEST: Event mask does not have KeyPress or Release set");
	event_mask_good = XtBuildEventMask(labelw_msg);
	if ((event_mask_good & events_selected) != 0) {
		sprintf(ebuf, "ERROR: Expected mask to not include %#x, mask was %#x", events_selected, event_mask_good);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("PREP: Remove translations");
	XtUninstallTranslations(labelw_msg);
	tet_infoline("TEST: Event mask does not have ButtonPress set");
	event_mask_good = XtBuildEventMask(labelw_msg);
	if ((event_mask_good & ButtonPressMask) != 0) {
		sprintf(ebuf, "ERROR: Expected mask to not include %#x, mask was %#x", ButtonPressMask, event_mask_good);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.2612 */
/* End of included file Mdefcode.tmc.2612 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
