#ifndef CYGONCE_HAL_HAL_INTR_H
#define CYGONCE_HAL_HAL_INTR_H

//==========================================================================
//
//      hal_intr.h
//
//      HAL Interrupt and clock support
//
//==========================================================================
//####COPYRIGHTBEGIN####
//
// -------------------------------------------
// The contents of this file are subject to the Cygnus eCos Public License
// Version 1.0 (the "License"); you may not use this file except in
// compliance with the License.  You may obtain a copy of the License at
// http://sourceware.cygnus.com/ecos
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the
// License for the specific language governing rights and limitations under
// the License.
//
// The Original Code is eCos - Embedded Cygnus Operating System, released
// October 31, 1998.
//
// The Initial Developer of the Original Code is Cygnus.  Portions created
// by Cygnus are Copyright (C) 1998,1999 Cygnus Solutions.  All Rights Reserved.
// -------------------------------------------
//
//####COPYRIGHTEND####
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    proven
// Contributors: proven, jskov
// Date:         1999-02-20
// Purpose:      Define Interrupt support
// Description:  The macros defined here provide the HAL APIs for handling
//               interrupts and the clock.
//              
// Usage:
//               #include <cyg/hal/hal_intr.h>
//               ...
//
//####DESCRIPTIONEND####
//
//==========================================================================

#include <pkgconf/hal.h>
#include <pkgconf/hal_i386.h>

#include <cyg/infra/cyg_type.h>
#include <cyg/hal/hal_platform_ints.h>

#ifdef CYGPKG_HAL_I386_LINUX
#include <pkgconf/hal_i386_linux.h>     // CYGSEM_HAL_I386_LINUX_REAL_TIME
#endif

// pjo, 18 sep 1999
#ifdef CYGPKG_HAL_I386_PC
#include <pkgconf/hal_i386_pc.h>
#ifdef CYGPKG_KERNEL
#include <pkgconf/kernel.h>
#include <cyg/kernel/ktypes.h>
#include <cyg/kernel/kapi.h>
#endif /* CYGPKG_KERNEL */
#endif /* CYGPKG_HAL_I386_PC */

//--------------------------------------------------------------------------
// Interrupt vectors.

#define CYGNUM_HAL_VECTOR_NMI                0

#define CYGNUM_HAL_VSR_MIN                   0
#define CYGNUM_HAL_VSR_MAX                   0
#define CYGNUM_HAL_VSR_COUNT                 ( CYGNUM_HAL_VSR_MAX + 1 )

#define CYGNUM_HAL_EXCEPTION_MIN             0
#define CYGNUM_HAL_EXCEPTION_MAX             0
#define CYGNUM_HAL_EXCEPTION_COUNT           ( CYGNUM_HAL_EXCEPTION_MAX + 1 )


#ifdef CYGPKG_HAL_I386_LINUX
// Additional vectors on Linux. These match the Linux signals.
#define CYGNUM_HAL_VECTOR_SIGHUP             1
#define CYGNUM_HAL_VECTOR_SIGINT             2
#define CYGNUM_HAL_VECTOR_SIGQUIT            3
#define CYGNUM_HAL_VECTOR_SIGILL             4
#define CYGNUM_HAL_VECTOR_SIGTRAP            5
#define CYGNUM_HAL_VECTOR_SIGIOT             6
#define CYGNUM_HAL_VECTOR_SIGBUS             7
#define CYGNUM_HAL_VECTOR_SIGFPE             8
#define CYGNUM_HAL_VECTOR_SIGKILL            9
#define CYGNUM_HAL_VECTOR_SIGUSR1           10
#define CYGNUM_HAL_VECTOR_SIGSEGV           11
#define CYGNUM_HAL_VECTOR_SIGUSR2           12
#define CYGNUM_HAL_VECTOR_SIGPIPE           13
#define CYGNUM_HAL_VECTOR_SIGALRM           14
#define CYGNUM_HAL_VECTOR_SIGTERM           15
#define CYGNUM_HAL_VECTOR_SIGCHLD           17
#define CYGNUM_HAL_VECTOR_SIGCONT           18
#define CYGNUM_HAL_VECTOR_SIGSTOP           19
#define CYGNUM_HAL_VECTOR_SIGTSTP           20
#define CYGNUM_HAL_VECTOR_SIGTTIN           21
#define CYGNUM_HAL_VECTOR_SIGTTOU           22
#define CYGNUM_HAL_VECTOR_SIGURG            23
#define CYGNUM_HAL_VECTOR_SIGXCPU           24
#define CYGNUM_HAL_VECTOR_SIGXFSZ           25
#define CYGNUM_HAL_VECTOR_SIGVTALRM         26
#define CYGNUM_HAL_VECTOR_SIGPROF           27
#define CYGNUM_HAL_VECTOR_SIGWINCH          28
#define CYGNUM_HAL_VECTOR_SIGIO             29
#define CYGNUM_HAL_VECTOR_SIGPWR            30

#undef CYGNUM_HAL_ISR_MAX
#define CYGNUM_HAL_ISR_MAX                    CYGNUM_HAL_VECTOR_SIGPWR

// Generic exception vector names
#define CYGNUM_HAL_EXCEPTION_INTERRUPT            CYGNUM_HAL_VECTOR_SIGINT
#define CYGNUM_HAL_EXCEPTION_ILLEGAL_INSTRUCTION  CYGNUM_HAL_VECTOR_SIGILL
#define CYGNUM_HAL_EXCEPTION_TRAP                 CYGNUM_HAL_VECTOR_SIGTRAP
#define CYGNUM_HAL_EXCEPTION_DATA_ACCESS          CYGNUM_HAL_VECTOR_SIGBUS
#define CYGNUM_HAL_EXCEPTION_FPU                  CYGNUM_HAL_VECTOR_SIGFPE
#define CYGNUM_HAL_EXCEPTION_STACK_OVERFLOW       CYGNUM_HAL_VECTOR_SIGSEGV

#undef CYGNUM_HAL_EXCEPTION_MAX
#define CYGNUM_HAL_EXCEPTION_MAX          CYGNUM_HAL_EXCEPTION_STACK_OVERFLOW

// The vector used by the Real time clock
#ifdef CYGSEM_HAL_I386_LINUX_REAL_TIME
#define CYGNUM_HAL_INTERRUPT_RTC              CYGNUM_HAL_VECTOR_SIGALRM
#else
#define CYGNUM_HAL_INTERRUPT_RTC              CYGNUM_HAL_VECTOR_SIGVTALRM
#endif

#endif // ifdef CYGPKG_HAL_I386_LINUX


// pjo...18 Sep 1999
#ifdef CYGPKG_HAL_I386_PC

// Physical interrupts connected to the CPU.
#undef CYGNUM_HAL_VSR_MIN
#undef CYGNUM_HAL_VSR_MAX
#undef CYGNUM_HAL_VSR_COUNT
#undef CYGNUM_HAL_VECTOR_NMI
#define CYGNUM_HAL_VECTOR_DIV0			0
#define CYGNUM_HAL_VECTOR_DEBUG			1
#define CYGNUM_HAL_VECTOR_NMI			2
#define CYGNUM_HAL_VECTOR_BREAKPOINT		3
#define CYGNUM_HAL_VECTOR_OVERFLOW		4
#define CYGNUM_HAL_VECTOR_BOUND			5
#define CYGNUM_HAL_VECTOR_OPCODE		6
#define CYGNUM_HAL_VECTOR_NO_DEVICE		7
#define CYGNUM_HAL_VECTOR_DOUBLE_FAULT		8
#define CYGNUM_HAL_VECTOR_INVALID_TSS		10
#define CYGNUM_HAL_VECTOR_SEGV			11
#define CYGNUM_HAL_VECTOR_STACK_FAULT		12
#define CYGNUM_HAL_VECTOR_PROTECTION		13
#define CYGNUM_HAL_VECTOR_PAGE			14
#define CYGNUM_HAL_VECTOR_FPE			16
#define CYGNUM_HAL_VECTOR_ALIGNMENT		17
#define CYGNUM_HAL_VSR_MIN			0
#define CYGNUM_HAL_VSR_MAX                  	255
#define CYGNUM_HAL_VSR_COUNT			(CYGNUM_HAL_VSR_MAX - CYGNUM_HAL_VSR_MIN + 1)


// Common exception vectors.
#undef CYGNUM_HAL_EXCEPTION_MIN
#undef CYGNUM_HAL_EXCEPTION_MAX
#undef CYGNUM_HAL_EXCEPTION_COUNT
#define CYGNUM_HAL_EXCEPTION_ILLEGAL_INSTRUCTION CYGNUM_HAL_VECTOR_OPCODE
#define CYGNUM_HAL_EXCEPTION_INTERRUPT		CYGNUM_HAL_VECTOR_BREAKPOINT
#define CYGNUM_HAL_EXCEPTION_CODE_ACCESS	CYGNUM_HAL_VECTOR_PROTECTION
#define CYGNUM_HAL_EXCEPTION_DATA_ACCESS	CYGNUM_HAL_VECTOR_PAGE
#define CYGNUM_HAL_EXCEPTION_TRAP		CYGNUM_HAL_VECTOR_DEBUG
#define CYGNUM_HAL_EXCEPTION_FPU		CYGNUM_HAL_VECTOR_FPE
#define CYGNUM_HAL_EXCEPTION_STACK_OVERFLOW	CYGNUM_HAL_VECTOR_SEGV
#define CYGNUM_HAL_EXCEPTION_MIN		0
#define CYGNUM_HAL_EXCEPTION_MAX		255
#define CYGNUM_HAL_EXCEPTION_COUNT		(CYGNUM_HAL_EXCEPTION_MAX - CYGNUM_HAL_EXCEPTION_MIN + 1)


// These really are wild guesses on my part...
#define CYGNUM_HAL_VECTOR_SIGBUS            	CYGNUM_HAL_EXCEPTION_DATA_ACCESS
#define CYGNUM_HAL_VECTOR_SIGFPE            	CYGNUM_HAL_EXCEPTION_FPU
#define CYGNUM_HAL_VECTOR_SIGSEGV           	CYGNUM_HAL_VECTOR_SEGV

#define PC_HARDWARE_IRQ_OFFSET			32

# if 0
#define CYGNUM_HAL_INTERRUPT_RTC		0
#define CYGNUM_HAL_VECTOR_RTC			(PC_HARDWARE_IRQ_OFFSET + CYGNUM_HAL_INTERRUPT_RTC)
# endif

# if 0
#define CYGNUM_HAL_VECTOR_SIGALRM			CYGNUM_HAL_INTERRUPT_CLOCK
#define CYGNUM_HAL_INTERRUPT_RTC			CYGNUM_HAL_VECTOR_SIGALRM
#endif



#endif // ifdef CYGPKG_HAL_I386_PC

//--------------------------------------------------------------------------
// Static data used by HAL

// ISR tables
externC volatile CYG_ADDRESS  cyg_hal_interrupt_handlers[CYGNUM_HAL_ISR_COUNT];
externC volatile CYG_ADDRWORD cyg_hal_interrupt_data[CYGNUM_HAL_ISR_COUNT];
externC volatile CYG_ADDRESS  cyg_hal_interrupt_objects[CYGNUM_HAL_ISR_COUNT];

// VSR table
externC volatile CYG_ADDRESS  cyg_hal_vsr_table[CYGNUM_HAL_VSR_COUNT];


#ifdef CYGPKG_HAL_I386_LINUX
// Interrupt controler emulation variables.
externC volatile int cyg_hal_interrupts_disabled;
externC volatile int cyg_hal_interrupts_deferred;
externC volatile int cyg_hal_interrupts_unhandled[CYGNUM_HAL_ISR_COUNT];
#endif

//--------------------------------------------------------------------------
// Interrupt state storage

typedef cyg_uint32 CYG_INTERRUPT_STATE;

//--------------------------------------------------------------------------
// Interrupt control macros

#ifdef CYGPKG_HAL_I386_LINUX

externC void cyg_hal_default_interrupt_vsr(int vector);
externC void cyg_hal_default_exception_vsr(int vector);
externC int  cyg_hal_sys_sigprocmask(int, const long*, long*);

#define HAL_ENABLE_INTERRUPTS()                                            \
    CYG_MACRO_START                                                        \
    cyg_ucount8 _i_;                                                       \
    cyg_hal_interrupts_disabled = 0;                                       \
    if (cyg_hal_interrupts_deferred) {                                     \
        cyg_hal_interrupts_deferred = 0;                                   \
        for (_i_ = CYGNUM_HAL_ISR_MIN; _i_ <= CYGNUM_HAL_ISR_MAX; _i_++) { \
            if (cyg_hal_interrupts_unhandled[_i_]) {                       \
                cyg_hal_default_interrupt_vsr(_i_);                        \
            }                                                              \
        }                                                                  \
    }                                                                      \
    CYG_MACRO_END

#define HAL_DISABLE_INTERRUPTS(_old_)           \
    CYG_MACRO_START                             \
    (_old_) = cyg_hal_interrupts_disabled++;    \
    CYG_MACRO_END

#define HAL_RESTORE_INTERRUPTS(_old_)                                   \
    CYG_MACRO_START                                                     \
    cyg_ucount8 _i_;                                                    \
    cyg_hal_interrupts_disabled = (_old_);                              \
    if (0 == cyg_hal_interrupts_disabled) {                             \
        if (cyg_hal_interrupts_deferred) {                              \
            cyg_hal_interrupts_deferred = 0;                            \
            for (_i_ = CYGNUM_HAL_ISR_MIN; _i_ <= CYGNUM_HAL_ISR_MAX;   \
                 _i_++){                                                \
                if (cyg_hal_interrupts_unhandled[_i_]) {                \
                    cyg_hal_default_interrupt_vsr(_i_);                 \
                }                                                       \
            }                                                           \
        }                                                               \
    }                                                                   \
    CYG_MACRO_END

#define HAL_QUERY_INTERRUPTS(_old_)             \
    CYG_MACRO_START                             \
    (_old_) = !cyg_hal_interrupts_disabled;     \
    CYG_MACRO_END

// FIXME: Must interract with the disable/enable macro.
// --proven 19981005
#define LINUX_SIG_UNBLOCK 1
#define HAL_INTERRUPT_ACKNOWLEDGE( _vector_ )                   \
    CYG_MACRO_START                                             \
    long _old_, _new_;                                          \
    _new_ = 0xffffffff;                                         \
    cyg_hal_interrupts_unhandled[_vector_] = 0;                 \
    cyg_hal_sys_sigprocmask(LINUX_SIG_UNBLOCK, &_new_, &_old_); \
    CYG_MACRO_END

#endif // ifdef CYGPKG_HAL_I386_LINUX

// pjo, 21 Sep 1999
#ifdef CYGPKG_HAL_I386_PC

#define HAL_ENABLE_INTERRUPTS()						\
	CYG_MACRO_START							\
	asm ("sti") ;							\
	CYG_MACRO_END

// Note the semicolon after CYG_MACRO_END--there's a bug
// in hal_diag.c where they didn't include the semicolon properly.
#define HAL_DISABLE_INTERRUPTS(_old_) 					\
	CYG_MACRO_START							\
	{	register int x ;						\
		asm (								\
			"pushfl ;"						\
			"popl %0 ;"						\
			"cli"							\
			:	"=r" (x)						\
			) ;							\
		(_old_) = (x & 0x200)? 1 : 0 ;					\
	} \
	CYG_MACRO_END ;

#define HAL_RESTORE_INTERRUPTS(_old_)					\
	CYG_MACRO_START							\
	{	if (_old_)							\
			asm ("sti");						\
		else								\
			asm ("cli");						\
	} \
	CYG_MACRO_END

#define HAL_QUERY_INTERRUPTS(_old_) \
	CYG_MACRO_START \
	{	register int x ; \
		asm ("pushfl ;" \
			"popl %0" \
		:	"=r" (x) \
		); \
		(_old_) = (x & 0x200)? 1 : 0 ; \
	} \
	CYG_MACRO_END

#define HAL_INTERRUPT_ACKNOWLEDGE( _vector_ ) \
	CYG_MACRO_START \
	{   int x = (_vector_) - PC_HARDWARE_IRQ_OFFSET; \
		if ((x >= 8) && (x < 16)) \
		{	asm( \
				"movb $0x20, %%al;" \
				"outb %%al, $0xA0;" \
				:	/* No outputs. */ \
				:	/* No inputs. */ \
				:	"eax" \
				); \
		} \
		if ((x >= 0) && (x < 8)) \
		{	asm( \
				"movb $0x20, %%al;" \
				"outb %%al, $0x20;" \
				:	/* No outputs. */ \
				:	/* No inputs. */ \
				:	"eax" \
				); \
		} \
	} \
	CYG_MACRO_END

#endif

//---------------------------------------------------------------------------
// Translate a vector number into an ISR table index.

#ifdef CYGPKG_HAL_I386_LINUX
// The native linux port doesn't support chained interrupts --proven 19981005
#define HAL_TRANSLATE_VECTOR(_vector_,_index_) (_index_) = (_vector_)
#endif


// pjo, 21 Sep 1999
#ifdef CYGPKG_HAL_I386_PC
#define HAL_TRANSLATE_VECTOR(_vector_,_index_) ((_index_) = (_vector_))
#endif

//---------------------------------------------------------------------------
// Interrupt and VSR attachment macros
externC cyg_uint32 cyg_hal_default_isr(CYG_ADDRWORD vector, CYG_ADDRWORD data);

#define HAL_INTERRUPT_IN_USE( _vector_, _state_)        \
    CYG_MACRO_START                                     \
    cyg_uint32 _index_;                                 \
    HAL_TRANSLATE_VECTOR ((_vector_), _index_);         \
                                                        \
    if (cyg_hal_interrupt_handlers[_index_]             \
        ==(CYG_ADDRESS)&cyg_hal_default_isr)            \
        (_state_) = 0;                                  \
    else                                                \
        (_state_) = 1;                                  \
    CYG_MACRO_END

#define HAL_INTERRUPT_ATTACH( _vector_, _isr_, _data_, _object_ )       \
    CYG_MACRO_START                                                     \
    cyg_uint32 _index_;                                                 \
    HAL_TRANSLATE_VECTOR((_vector_), _index_);                          \
                                                                        \
    if (cyg_hal_interrupt_handlers[_index_]                             \
        ==(CYG_ADDRESS)&cyg_hal_default_isr)                            \
    {                                                                   \
        cyg_hal_interrupt_handlers[_index_] = (CYG_ADDRESS)(_isr_);     \
        cyg_hal_interrupt_data[_index_] = (CYG_ADDRWORD)(_data_);       \
        cyg_hal_interrupt_objects[_index_] = (CYG_ADDRESS)(_object_);   \
    }                                                                   \
    CYG_MACRO_END

#define HAL_INTERRUPT_DETACH( _vector_, _isr_ ) \
    CYG_MACRO_START                             \
    cyg_uint32 _index_;                         \
    HAL_TRANSLATE_VECTOR((_vector_), _index_);  \
                                                \
    if (cyg_hal_interrupt_handlers[_index_]     \
        == (CYG_ADDRESS)(_isr_))                \
    {                                           \
        cyg_hal_interrupt_handlers[_index_] =   \
            (CYG_ADDRESS)&cyg_hal_default_isr;  \
        cyg_hal_interrupt_data[_index_] = 0;    \
        cyg_hal_interrupt_objects[_index_] = 0; \
    }                                           \
    CYG_MACRO_END

#define HAL_VSR_GET( _vector_, _pvsr_ )                         \
    *((CYG_ADDRESS *)(_pvsr_)) = cyg_hal_vsr_table[(_vector_)];
    

#define HAL_VSR_SET( _vector_, _vsr_, _poldvsr_ )                       \
    CYG_MACRO_START                                                     \
    if( (_poldvsr_) != NULL )                                           \
        *(CYG_ADDRESS *)(_poldvsr_) = cyg_hal_vsr_table[(_vector_)];    \
    cyg_hal_vsr_table[(_vector_)] = (CYG_ADDRESS)(_vsr_);               \
    CYG_MACRO_END

//---------------------------------------------------------------------------
// Interrupt controller access

#ifdef CYGPKG_HAL_I386_LINUX

#define HAL_INTERRUPT_MASK( _vector_ )                          \
    CYG_MACRO_START                                             \
    /* Use sigblock to mask a vector */                         \
    CYG_EMPTY_STATEMENT;                                        \
    CYG_MACRO_END

#define HAL_INTERRUPT_UNMASK( _vector_ )                        \
    CYG_MACRO_START                                             \
    /* Use sigunblock to mask a vector */                       \
    CYG_EMPTY_STATEMENT;                                        \
    CYG_MACRO_END

// The native linux port doesn't have configurable interrupts.
#define HAL_INTERRUPT_CONFIGURE( _vector_, _level_, _up_ )      

// The native linux port doesn't have interrupt levels.
#define HAL_INTERRUPT_SET_LEVEL( _vector_, _level_ )            

#endif // ifdef CYGPKG_HAL_I386_LINUX

// pjo, 5 oct 1999
#ifdef CYGPKG_HAL_I386_PC

#ifdef CYGPKG_KERNEL
externC void hal_pc_interrupt_in_use(cyg_vector vector, int * inUse);
externC void hal_pc_interrupt_attach(cyg_vector vector, cyg_ISR_t routine,
		CYG_ADDRWORD parameter, void * object);
externC void hal_pc_interrupt_detach(cyg_vector vector, cyg_ISR_t routine);

#if 0
#undef HAL_INTERRUPT_IN_USE
#define HAL_INTERRUPT_IN_USE( _vector_, _state_)        \
	hal_pc_interrupt_in_use(_vector_, &(_state_))
#endif

#undef HAL_INTERRUPT_ATTACH
#define HAL_INTERRUPT_ATTACH( _vector_, _isr_, _data_, _object_ )       \
	hal_pc_interrupt_attach(_vector_, _isr_, _data_, _object_)

#undef HAL_INTERRUPT_DETACH
#define HAL_INTERRUPT_DETACH( _vector_, _isr_ ) \
    hal_pc_interrupt_detach(_vector_, _isr_)
#endif /* CYGPKG_KERNEL */

#if 0
#undef HAL_VSR_GET
#define HAL_VSR_GET( _vector_, _pvsr_ )                         \
    *((CYG_ADDRESS *)(_pvsr_)) = cyg_hal_vsr_table[(_vector_)];
    
#undef HAL_VSR_SET
#define HAL_VSR_SET( _vector_, _vsr_, _poldvsr_ )                       \
    hal_pc_vsr_set(_vector_, _vsr_, _poldvsr_)
#endif

#endif



// pjo, 21 Sep 1999
#ifdef CYGPKG_HAL_I386_PC

#define HAL_INTERRUPT_MASK( _vector_ )                          \
    CYG_MACRO_START                                             \
	{   int x = (_vector_) - PC_HARDWARE_IRQ_OFFSET;		\
		if (x >= 8)							\
		{	x = 1 << (x - 8) ;					\
		asm(							\
			"inb $0xA1, %%al;"				\
			"orl %0, %%eax;"				\
			"outb %%al, $0xA1;"				\
			:	/* No outputs. */				\
			:	"g" (x)						\
			:	"eax"						\
			);							\
		}								\
		else							\
		{	x = 1 << x ;						\
		asm(							\
			"inb $0x21, %%al;"				\
			"orl %0, %%eax;"				\
			"outb %%al, $0x21;"				\
			:	/* No outputs. */				\
			:	"g" (x)						\
			:	"eax"						\
			);							\
		}								\
	} \
    CYG_MACRO_END

#define HAL_INTERRUPT_UNMASK( _vector_ )                        \
    CYG_MACRO_START                                             \
    int x = (_vector_) - PC_HARDWARE_IRQ_OFFSET;		\
    if (x >= 8)							\
    {	x = ~(1 << (x - 8)) ;					\
	asm(							\
		"inb $0xA1, %%al;"				\
		"andl %0, %%eax;"				\
		"outb %%al, $0xA1;"				\
	    :	/* No outputs. */				\
	    :	"g" (x)						\
	    :	"eax"						\
	    );							\
    }								\
    else							\
    {	x = ~(1 << x) ;						\
	asm(							\
		"inb $0x21, %%al;"				\
		"andl %0, %%eax;"				\
		"outb %%al, $0x21;"				\
	    :	/* No outputs. */				\
	    :	"g" (x)						\
	    :	"eax"						\
	    );							\
    }								\
    CYG_MACRO_END


#define HAL_INTERRUPT_CONFIGURE( _vector_, _level_, _up_ )      

#define HAL_INTERRUPT_SET_LEVEL( _vector_, _level_ )            

#endif // ifdef CYGPKG_HAL_I386_PC




//---------------------------------------------------------------------------
// Clock control

#ifdef CYGPKG_HAL_I386_LINUX

struct hal_timeval {
    long tv_sec;
    long tv_usec;
};
struct hal_itimerval {
    struct hal_timeval it_interval;
    struct hal_timeval it_value;
};

externC int cyg_hal_sys_setitimer(int, const struct hal_itimerval*,
                                  struct hal_itimerval*);
externC int cyg_hal_sys_getitimer(int, struct hal_itimerval*);

#ifdef CYGSEM_HAL_I386_LINUX_REAL_TIME
#define CYGNUM_HAL_TIMER_TYPE 0         // ITIMER_REAL
#else
#define CYGNUM_HAL_TIMER_TYPE 1         // ITIMER_VIRTUAL
#endif

#define HAL_CLOCK_INITIALIZE( _period_ )                                \
    CYG_MACRO_START                                                     \
    struct hal_itimerval new_itimerval, old;                            \
                                                                        \
    new_itimerval.it_interval.tv_sec = 0;                               \
    new_itimerval.it_interval.tv_usec = (_period_);                     \
    new_itimerval.it_value.tv_sec = 0;                                  \
    new_itimerval.it_value.tv_usec = (_period_);                        \
    /* Use setitimer to set the realtime clock */                       \
    cyg_hal_sys_setitimer(CYGNUM_HAL_TIMER_TYPE, &new_itimerval, &old); \
    CYG_MACRO_END

// The clock reinitializes itself.
#define HAL_CLOCK_RESET( _vector_, _period_ )

// This timer counts down, so subtract from set value.
#define HAL_CLOCK_READ( _pvalue_ )                                      \
    CYG_MACRO_START                                                     \
    struct hal_itimerval old_itimerval;                                 \
    cyg_hal_sys_getitimer(CYGNUM_HAL_TIMER_TYPE, &old_itimerval);       \
    *(_pvalue_) = old_itimerval.it_interval.tv_usec -                   \
      old_itimerval.it_value.tv_usec;                                   \
    CYG_MACRO_END

#define HAL_CLOCK_LATENCY( _pvalue_ )           \
    HAL_CLOCK_READ((_pvalue_))

#endif // ifdef CYGPKG_HAL_I386_LINUX


//---------------------------------------------------------------------------
#endif // ifndef CYGONCE_HAL_HAL_INTR_H
// End of hal_intr.h
