/* Unwinder test program.

   Copyright 2006, 2007, 2008, 2009, 2010 Free Software Foundation, Inc.

   This file is part of GDB.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

#ifdef __VLE__
#define STWU "e_stwu"
#define STW "e_stw"
#define BLR "se_blr"
#define BL "e_bl"
#define LWZ "e_lwz"
#define STB "e_stb"
#define ADDI "e_addi"
#define MTLR "se_mtlr"
#define MFLR "se_mflr"
#define MR "se_mr"
#define LIS "e_lis"
#define LMW "e_lmw"
#define BCL "e_bcl"
#define STMW "e_stmw"
#define BaltL "e_bl"
#else
#define STWU "stwu"
#define STW "stw"
#define BLR "blr"
#define BL "bl"
#define LWZ "lwz"
#define STB "stb"
#define ADDI "addi"
#define MTLR "mtlr"
#define MR "mr"
#define MFLR "mflr"
#define LIS "lis"
#define LMW "lmw"
#define BCL "bcl"
#define STMW "stmw"
#define BaltL "bcl- 20,31,"
#endif

#ifdef SYMBOL_PREFIX
#define SYMBOL(str)	SYMBOL_PREFIX #str
#else
#define SYMBOL(str)	#str
#endif

void gdb2029 (void);

int
main (void)
{
  gdb2029 ();
  optimized_1 ();
  return 0;
}

void
optimized_1_marker (void)
{
}

void
gdb2029_marker (void)
{
}

/* A typical PIC prologue from GCC.  */

asm(".text\n"
    "    .p2align 3\n"
    SYMBOL (gdb2029) ":\n"
    "	" STWU " %r1, -32(%r1)\n"
    "	" MFLR " %r0\n"
    "	" BaltL " .+4\n"
    "	" STW " %r30, 24(%r1)\n"
    "	" MFLR " %r30\n"
    "	" STW " %r0, 36(%r1)\n"
    "	" BL "	gdb2029_marker\n"
    "	" LWZ " %r0, 36(%r1)\n"
    "	" LWZ " %r30, 24(%r1)\n"
    "	" MTLR " %r0\n"
    "	" ADDI " %r1, %r1, 32\n"
    "	" BLR "\n"
    );

/* A heavily scheduled prologue.  */
asm(".text\n"
    "	.p2align 3\n"
    SYMBOL (optimized_1) ":\n"
    "	" STWU " %r1,-32(%r1)\n"
    "	" LIS " %r9,32\n"
    "	" LIS " %r11,8\n"
    "	" MFLR " %r0\n"
    "	" ADDI " %r11,%r11,16\n"
    "	" STMW " %r27,12(%r1)\n"
    "	" ADDI " %r31,%r9,16\n"
    "	cmplw	%cr7,%r31,%r11\n"
    "	" STW " %r0,36(%r1)\n"
    "	" MR " %r30,%r3\n"
    "	" BL " optimized_1_marker\n"
    "	" LWZ " %r0,36(%r1)\n"
    "	" LMW " %r27,12(%r1)\n"
    "	" ADDI " %r1,%r1,32\n"
    "	" BLR "\n"
     );
