#include <stdio.h>

#include <cyg/kernel/kapi.h>            /* All the kernel specific stuff */
#include <cyg/devs/common/table.h>
/* also include pkgconf/system.h because it has the CYG_HAL_POWERPC
   macro to check if the POWERPC architecture is defined */
#include <pkgconf/system.h>

#define NTHREADS 1
#define STACKSIZE 4096

static cyg_handle_t thread[NTHREADS];
static cyg_thread thread_obj[NTHREADS];
static char stack[NTHREADS][STACKSIZE];

static void simple_prog(CYG_ADDRESS data)
{
    /* we do not yet have serial drivers for the PowerPC, so just
       don't compile this code for that platform */
#ifndef CYG_HAL_POWERPC

    Cyg_IORB iorb;
    cyg_addrword_t my_io_cookie;
    
    /* set the I/O cookie to point to our favorite serial device */
#ifdef CYG_DEVICE_SERIAL_RS232_MN10300_1_NAME
    my_io_cookie = stdeval1_serial1;
#endif /* CYG_DEVICE_SERIAL_RS232_MN10300_1_NAME */


#ifdef CYG_DEVICE_SERIAL_RS232_TX39_NAME
    my_io_cookie = jmr3904_serial;
#endif /* CYG_DEVICE_SERIAL_RS232_TX39_NAME */

    iorb.buffer = "This is test 1\n";
    iorb.buffer_length = 15; /* strlen(iorb.data); */
    cyg_write_blocking(my_io_cookie, &iorb);
    printf("Done with my non-blocking serial write\n");
#else  /* CYG_HAL_POWERPC */
    printf("No serial driver is available for the PowerPC yet\n");
#endif /* CYG_HAL_POWERPC */
}

void cyg_user_start(void)
{
    cyg_thread_create(4, simple_prog, (cyg_addrword_t) 0, "serial1",
                      (void *)stack[0], STACKSIZE, &thread[0], &thread_obj[0]);
    cyg_thread_resume(thread[0]);
}
