/* { dg-do compile } */
// TODO: remove need for --param=analyzer-max-svalue-depth=25 here:
/* { dg-options "-fanalyzer --param=analyzer-max-svalue-depth=25" } */
/* { dg-additional-options "-Wno-pedantic" } */
/* { dg-require-effective-target analyzer } */

/* See notes in this header.  */
#include "taint-CVE-2011-0521.h"

/* Adapted from dvb_ca_ioctl in drivers/media/dvb/ttpci/av7110_ca.c and
   dvb_usercopy in drivers/media/dvb/dvb-core/dvbdev.c

   Further simplified from -3; merge into a single function; drop the mutex,
   remove control flow.  */

int test_1(struct file *file, unsigned int cmd, unsigned long arg)
{
	char    sbuf[128];
	void    *parg = sbuf;

	if (copy_from_user(parg, (void __user *)arg, sizeof(sbuf)))
	  return -1;

	{
		struct dvb_device *dvbdev = file->private_data;
		struct av7110 *av7110 = dvbdev->priv;
		unsigned long arg = (unsigned long) parg;

		/* case CA_GET_SLOT_INFO:  */
		ca_slot_info_t *info=(ca_slot_info_t *)parg;

		if (info->num > 1)
			return -EINVAL;
		av7110->ci_slot[info->num].num = info->num; /* { dg-warning "attacker-controlled value" } */
		av7110->ci_slot[info->num].type = FW_CI_LL_SUPPORT(av7110->arm_app) ?
							CA_CI_LINK : CA_CI;
		memcpy(info, &av7110->ci_slot[info->num], sizeof(ca_slot_info_t));
	}

	copy_to_user((void __user *)arg, parg, sizeof(sbuf));

	return 0;
}
