/* CPU family header for @cpu@.

THIS FILE IS MACHINE GENERATED WITH CGEN.

Copyright 1996, 1997, 1998, 1999, 2000, 2001, 2002 Free Software Foundation, Inc.

This file is part of the GNU simulators.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/

#ifndef CPU_@CPU@_H
#define CPU_@CPU@_H

/* Maximum number of instructions that are fetched at a time.
   This is for LIW type instructions sets (e.g. m32r).  */
#define MAX_LIW_INSNS 1

/* Maximum number of instructions that can be executed in parallel.  */
#define MAX_PARALLEL_INSNS 1

/* CPU state information.  */
typedef struct {
  /* Hardware elements.  */
  struct {
  /* Program counter */
  UDI h_pc;
#define GET_H_PC() CPU (h_pc)
#define SET_H_PC(x) \
do { \
{\
CPU (h_ism) = ANDDI ((x), 1);\
CPU (h_pc) = ANDDI ((x), INVDI (1));\
}\
;} while (0)
  /* General purpose integer registers */
  DI h_gr[64];
#define GET_H_GR(index) ((((index) == (63))) ? (0) : (CPU (h_gr[index])))
#define SET_H_GR(index, x) \
do { \
if ((((index)) != (63))) {\
CPU (h_gr[(index)]) = (x);\
} else {\
((void) 0); /*nop*/\
}\
;} while (0)
  /* Control registers */
  DI h_cr[64];
#define GET_H_CR(index) ((((index) == (0))) ? (ZEXTSIDI (CPU (h_sr))) : (CPU (h_cr[index])))
#define SET_H_CR(index, x) \
do { \
if ((((index)) == (0))) {\
CPU (h_sr) = (x);\
} else {\
CPU (h_cr[(index)]) = (x);\
}\
;} while (0)
  /* Status register */
  SI h_sr;
#define GET_H_SR() CPU (h_sr)
#define SET_H_SR(x) (CPU (h_sr) = (x))
  /* Floating point status and control register */
  SI h_fpscr;
#define GET_H_FPSCR() CPU (h_fpscr)
#define SET_H_FPSCR(x) (CPU (h_fpscr) = (x))
  /* Single precision floating point registers */
  SF h_fr[64];
#define GET_H_FR(a1) CPU (h_fr)[a1]
#define SET_H_FR(a1, x) (CPU (h_fr)[a1] = (x))
  /* Single precision floating point register pairs */
  DF h_fp[32];
#define GET_H_FP(a1) CPU (h_fp)[a1]
#define SET_H_FP(a1, x) (CPU (h_fp)[a1] = (x))
  /* Branch target registers */
  DI h_tr[8];
#define GET_H_TR(a1) CPU (h_tr)[a1]
#define SET_H_TR(a1, x) (CPU (h_tr)[a1] = (x))
  /* Current instruction set mode */
  BI h_ism;
#define GET_H_ISM() CPU (h_ism)
#define SET_H_ISM(x) \
do { \
cgen_rtx_error (current_cpu, "cannot set ism directly");\
;} while (0)
  } hardware;
#define CPU_CGEN_HW(cpu) (& (cpu)->cpu_data.hardware)
} @CPU@_CPU_DATA;

/* Virtual regs.  */

#define GET_H_FRBIT() ANDSI (SRLSI (CPU (h_sr), 14), 1)
#define SET_H_FRBIT(x) \
do { \
CPU (h_sr) = ORSI (ANDSI (CPU (h_sr), (~ (((1) << (14))))), SLLSI ((x), 14));\
;} while (0)
#define GET_H_SZBIT() ANDSI (SRLSI (CPU (h_sr), 13), 1)
#define SET_H_SZBIT(x) \
do { \
CPU (h_sr) = ORSI (ANDSI (CPU (h_sr), (~ (((1) << (13))))), SLLSI ((x), 13));\
;} while (0)
#define GET_H_PRBIT() ANDSI (SRLSI (CPU (h_sr), 12), 1)
#define SET_H_PRBIT(x) \
do { \
CPU (h_sr) = ORSI (ANDSI (CPU (h_sr), (~ (((1) << (12))))), SLLSI ((x), 12));\
;} while (0)
#define GET_H_FV(index) CPU (h_fr[MULQI (ANDQI (index, 15), 4)])
#define SET_H_FV(index, x) \
do { \
CPU (h_fr[MULQI (ANDQI ((index), 15), 4)]) = (x);\
;} while (0)
#define GET_H_FMTX(index) CPU (h_fr[MULQI (ANDQI (index, 3), 16)])
#define SET_H_FMTX(index, x) \
do { \
CPU (h_fr[MULQI (ANDQI ((index), 3), 16)]) = (x);\
;} while (0)
#define GET_H_DR(index) SUBWORDDIDF (ORDI (SLLDI (ZEXTSIDI (SUBWORDSFSI (CPU (h_fr[index]))), 32), ZEXTSIDI (SUBWORDSFSI (CPU (h_fr[((index) + (1))])))))
#define SET_H_DR(index, x) \
do { \
{\
CPU (h_fr[(index)]) = SUBWORDSISF (SUBWORDDFSI ((x), 0));\
CPU (h_fr[(((index)) + (1))]) = SUBWORDSISF (SUBWORDDFSI ((x), 1));\
}\
;} while (0)
#define GET_H_ENDIAN() sh64_endian (current_cpu)
#define SET_H_ENDIAN(x) \
do { \
cgen_rtx_error (current_cpu, "cannot alter target byte order mid-program");\
;} while (0)

/* Cover fns for register access.  */
UDI @cpu@_h_pc_get (SIM_CPU *);
void @cpu@_h_pc_set (SIM_CPU *, UDI);
DI @cpu@_h_gr_get (SIM_CPU *, UINT);
void @cpu@_h_gr_set (SIM_CPU *, UINT, DI);
DI @cpu@_h_cr_get (SIM_CPU *, UINT);
void @cpu@_h_cr_set (SIM_CPU *, UINT, DI);
SI @cpu@_h_sr_get (SIM_CPU *);
void @cpu@_h_sr_set (SIM_CPU *, SI);
SI @cpu@_h_fpscr_get (SIM_CPU *);
void @cpu@_h_fpscr_set (SIM_CPU *, SI);
BI @cpu@_h_frbit_get (SIM_CPU *);
void @cpu@_h_frbit_set (SIM_CPU *, BI);
BI @cpu@_h_szbit_get (SIM_CPU *);
void @cpu@_h_szbit_set (SIM_CPU *, BI);
BI @cpu@_h_prbit_get (SIM_CPU *);
void @cpu@_h_prbit_set (SIM_CPU *, BI);
SF @cpu@_h_fr_get (SIM_CPU *, UINT);
void @cpu@_h_fr_set (SIM_CPU *, UINT, SF);
DF @cpu@_h_fp_get (SIM_CPU *, UINT);
void @cpu@_h_fp_set (SIM_CPU *, UINT, DF);
SF @cpu@_h_fv_get (SIM_CPU *, UINT);
void @cpu@_h_fv_set (SIM_CPU *, UINT, SF);
SF @cpu@_h_fmtx_get (SIM_CPU *, UINT);
void @cpu@_h_fmtx_set (SIM_CPU *, UINT, SF);
DF @cpu@_h_dr_get (SIM_CPU *, UINT);
void @cpu@_h_dr_set (SIM_CPU *, UINT, DF);
DI @cpu@_h_tr_get (SIM_CPU *, UINT);
void @cpu@_h_tr_set (SIM_CPU *, UINT, DI);
BI @cpu@_h_endian_get (SIM_CPU *);
void @cpu@_h_endian_set (SIM_CPU *, BI);
BI @cpu@_h_ism_get (SIM_CPU *);
void @cpu@_h_ism_set (SIM_CPU *, BI);

/* These must be hand-written.  */
extern CPUREG_FETCH_FN @cpu@_fetch_register;
extern CPUREG_STORE_FN @cpu@_store_register;

typedef struct {
  int empty;
} MODEL_SH5_DATA;

/* The ARGBUF struct.  */
struct argbuf {
  /* These are the baseclass definitions.  */
  IADDR addr;
  const IDESC *idesc;
  char trace_p;
  char profile_p;
  /* ??? Temporary hack for skip insns.  */
  char skip_count;
  char unused;
  /* cpu specific data follows */
  CGEN_INSN_INT insn;
  int written;
};

/* A cached insn.

   ??? SCACHE used to contain more than just argbuf.  We could delete the
   type entirely and always just use ARGBUF, but for future concerns and as
   a level of abstraction it is left in.  */

struct scache {
  struct argbuf argbuf;
};

/* Macros to simplify extraction, reading and semantic code.
   These define and assign the local vars that contain the insn's fields.  */

#define EXTRACT_IFMT_EMPTY_VARS \
  unsigned int length;
#define EXTRACT_IFMT_EMPTY_CODE \
  length = 0; \

#define EXTRACT_IFMT_ADD_VARS \
  UINT f_op; \
  UINT f_left; \
  UINT f_ext; \
  UINT f_right; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_ADD_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_ext = EXTRACT_LSB0_UINT (insn, 32, 19, 4); \
  f_right = EXTRACT_LSB0_UINT (insn, 32, 15, 6); \
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_ADDI_VARS \
  UINT f_op; \
  UINT f_left; \
  INT f_disp10; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_ADDI_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_disp10 = EXTRACT_LSB0_INT (insn, 32, 19, 10); \
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_ALLOCO_VARS \
  UINT f_op; \
  UINT f_left; \
  UINT f_ext; \
  SI f_disp6x32; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_ALLOCO_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_ext = EXTRACT_LSB0_UINT (insn, 32, 19, 4); \
  f_disp6x32 = ((EXTRACT_LSB0_INT (insn, 32, 15, 6)) << (5)); \
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_BEQ_VARS \
  UINT f_op; \
  UINT f_left; \
  UINT f_ext; \
  UINT f_right; \
  UINT f_likely; \
  UINT f_8_2; \
  UINT f_tra; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_BEQ_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_ext = EXTRACT_LSB0_UINT (insn, 32, 19, 4); \
  f_right = EXTRACT_LSB0_UINT (insn, 32, 15, 6); \
  f_likely = EXTRACT_LSB0_UINT (insn, 32, 9, 1); \
  f_8_2 = EXTRACT_LSB0_UINT (insn, 32, 8, 2); \
  f_tra = EXTRACT_LSB0_UINT (insn, 32, 6, 3); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_BEQI_VARS \
  UINT f_op; \
  UINT f_left; \
  UINT f_ext; \
  INT f_imm6; \
  UINT f_likely; \
  UINT f_8_2; \
  UINT f_tra; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_BEQI_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_ext = EXTRACT_LSB0_UINT (insn, 32, 19, 4); \
  f_imm6 = EXTRACT_LSB0_INT (insn, 32, 15, 6); \
  f_likely = EXTRACT_LSB0_UINT (insn, 32, 9, 1); \
  f_8_2 = EXTRACT_LSB0_UINT (insn, 32, 8, 2); \
  f_tra = EXTRACT_LSB0_UINT (insn, 32, 6, 3); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_BLINK_VARS \
  UINT f_op; \
  UINT f_25; \
  UINT f_trb; \
  UINT f_ext; \
  UINT f_right; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_BLINK_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_25 = EXTRACT_LSB0_UINT (insn, 32, 25, 3); \
  f_trb = EXTRACT_LSB0_UINT (insn, 32, 22, 3); \
  f_ext = EXTRACT_LSB0_UINT (insn, 32, 19, 4); \
  f_right = EXTRACT_LSB0_UINT (insn, 32, 15, 6); \
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_BRK_VARS \
  UINT f_op; \
  UINT f_left; \
  UINT f_ext; \
  UINT f_right; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_BRK_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_ext = EXTRACT_LSB0_UINT (insn, 32, 19, 4); \
  f_right = EXTRACT_LSB0_UINT (insn, 32, 15, 6); \
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_BYTEREV_VARS \
  UINT f_op; \
  UINT f_left; \
  UINT f_ext; \
  UINT f_right; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_BYTEREV_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_ext = EXTRACT_LSB0_UINT (insn, 32, 19, 4); \
  f_right = EXTRACT_LSB0_UINT (insn, 32, 15, 6); \
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_FABSD_VARS \
  UINT f_op; \
  UINT f_ext; \
  UINT f_left; \
  UINT f_right; \
  UINT f_left_right; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_FABSD_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_ext = EXTRACT_LSB0_UINT (insn, 32, 19, 4); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_right = EXTRACT_LSB0_UINT (insn, 32, 15, 6); \
  f_left_right = f_left;\
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_FABSS_VARS \
  UINT f_op; \
  UINT f_ext; \
  UINT f_left; \
  UINT f_right; \
  UINT f_left_right; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_FABSS_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_ext = EXTRACT_LSB0_UINT (insn, 32, 19, 4); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_right = EXTRACT_LSB0_UINT (insn, 32, 15, 6); \
  f_left_right = f_left;\
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_FADDD_VARS \
  UINT f_op; \
  UINT f_left; \
  UINT f_ext; \
  UINT f_right; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_FADDD_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_ext = EXTRACT_LSB0_UINT (insn, 32, 19, 4); \
  f_right = EXTRACT_LSB0_UINT (insn, 32, 15, 6); \
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_FADDS_VARS \
  UINT f_op; \
  UINT f_left; \
  UINT f_ext; \
  UINT f_right; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_FADDS_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_ext = EXTRACT_LSB0_UINT (insn, 32, 19, 4); \
  f_right = EXTRACT_LSB0_UINT (insn, 32, 15, 6); \
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_FCMPEQD_VARS \
  UINT f_op; \
  UINT f_left; \
  UINT f_ext; \
  UINT f_right; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_FCMPEQD_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_ext = EXTRACT_LSB0_UINT (insn, 32, 19, 4); \
  f_right = EXTRACT_LSB0_UINT (insn, 32, 15, 6); \
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_FCMPEQS_VARS \
  UINT f_op; \
  UINT f_left; \
  UINT f_ext; \
  UINT f_right; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_FCMPEQS_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_ext = EXTRACT_LSB0_UINT (insn, 32, 19, 4); \
  f_right = EXTRACT_LSB0_UINT (insn, 32, 15, 6); \
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_FCNVDS_VARS \
  UINT f_op; \
  UINT f_ext; \
  UINT f_left; \
  UINT f_right; \
  UINT f_left_right; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_FCNVDS_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_ext = EXTRACT_LSB0_UINT (insn, 32, 19, 4); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_right = EXTRACT_LSB0_UINT (insn, 32, 15, 6); \
  f_left_right = f_left;\
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_FCNVSD_VARS \
  UINT f_op; \
  UINT f_ext; \
  UINT f_left; \
  UINT f_right; \
  UINT f_left_right; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_FCNVSD_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_ext = EXTRACT_LSB0_UINT (insn, 32, 19, 4); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_right = EXTRACT_LSB0_UINT (insn, 32, 15, 6); \
  f_left_right = f_left;\
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_FGETSCR_VARS \
  UINT f_op; \
  UINT f_left; \
  UINT f_ext; \
  UINT f_right; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_FGETSCR_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_ext = EXTRACT_LSB0_UINT (insn, 32, 19, 4); \
  f_right = EXTRACT_LSB0_UINT (insn, 32, 15, 6); \
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_FIPRS_VARS \
  UINT f_op; \
  UINT f_left; \
  UINT f_ext; \
  UINT f_right; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_FIPRS_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_ext = EXTRACT_LSB0_UINT (insn, 32, 19, 4); \
  f_right = EXTRACT_LSB0_UINT (insn, 32, 15, 6); \
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_FLDD_VARS \
  UINT f_op; \
  UINT f_left; \
  SI f_disp10x8; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_FLDD_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_disp10x8 = ((EXTRACT_LSB0_INT (insn, 32, 19, 10)) << (3)); \
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_FLDP_VARS \
  UINT f_op; \
  UINT f_left; \
  SI f_disp10x8; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_FLDP_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_disp10x8 = ((EXTRACT_LSB0_INT (insn, 32, 19, 10)) << (3)); \
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_FLDS_VARS \
  UINT f_op; \
  UINT f_left; \
  SI f_disp10x4; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_FLDS_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_disp10x4 = ((EXTRACT_LSB0_INT (insn, 32, 19, 10)) << (2)); \
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_FLDXD_VARS \
  UINT f_op; \
  UINT f_left; \
  UINT f_ext; \
  UINT f_right; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_FLDXD_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_ext = EXTRACT_LSB0_UINT (insn, 32, 19, 4); \
  f_right = EXTRACT_LSB0_UINT (insn, 32, 15, 6); \
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_FLDXP_VARS \
  UINT f_op; \
  UINT f_left; \
  UINT f_ext; \
  UINT f_right; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_FLDXP_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_ext = EXTRACT_LSB0_UINT (insn, 32, 19, 4); \
  f_right = EXTRACT_LSB0_UINT (insn, 32, 15, 6); \
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_FMOVDQ_VARS \
  UINT f_op; \
  UINT f_ext; \
  UINT f_left; \
  UINT f_right; \
  UINT f_left_right; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_FMOVDQ_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_ext = EXTRACT_LSB0_UINT (insn, 32, 19, 4); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_right = EXTRACT_LSB0_UINT (insn, 32, 15, 6); \
  f_left_right = f_left;\
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_FMOVLS_VARS \
  UINT f_op; \
  UINT f_left; \
  UINT f_ext; \
  UINT f_right; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_FMOVLS_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_ext = EXTRACT_LSB0_UINT (insn, 32, 19, 4); \
  f_right = EXTRACT_LSB0_UINT (insn, 32, 15, 6); \
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_FMOVSL_VARS \
  UINT f_op; \
  UINT f_ext; \
  UINT f_left; \
  UINT f_right; \
  UINT f_left_right; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_FMOVSL_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_ext = EXTRACT_LSB0_UINT (insn, 32, 19, 4); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_right = EXTRACT_LSB0_UINT (insn, 32, 15, 6); \
  f_left_right = f_left;\
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_FPUTSCR_VARS \
  UINT f_op; \
  UINT f_ext; \
  UINT f_left; \
  UINT f_right; \
  UINT f_left_right; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_FPUTSCR_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_ext = EXTRACT_LSB0_UINT (insn, 32, 19, 4); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_right = EXTRACT_LSB0_UINT (insn, 32, 15, 6); \
  f_left_right = f_left;\
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_FSTXD_VARS \
  UINT f_op; \
  UINT f_left; \
  UINT f_ext; \
  UINT f_right; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_FSTXD_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_ext = EXTRACT_LSB0_UINT (insn, 32, 19, 4); \
  f_right = EXTRACT_LSB0_UINT (insn, 32, 15, 6); \
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_FTRVS_VARS \
  UINT f_op; \
  UINT f_left; \
  UINT f_ext; \
  UINT f_right; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_FTRVS_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_ext = EXTRACT_LSB0_UINT (insn, 32, 19, 4); \
  f_right = EXTRACT_LSB0_UINT (insn, 32, 15, 6); \
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_GETCFG_VARS \
  UINT f_op; \
  UINT f_left; \
  UINT f_ext; \
  INT f_disp6; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_GETCFG_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_ext = EXTRACT_LSB0_UINT (insn, 32, 19, 4); \
  f_disp6 = EXTRACT_LSB0_INT (insn, 32, 15, 6); \
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_GETCON_VARS \
  UINT f_op; \
  UINT f_left; \
  UINT f_ext; \
  UINT f_right; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_GETCON_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_ext = EXTRACT_LSB0_UINT (insn, 32, 19, 4); \
  f_right = EXTRACT_LSB0_UINT (insn, 32, 15, 6); \
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_LDL_VARS \
  UINT f_op; \
  UINT f_left; \
  SI f_disp10x4; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_LDL_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_disp10x4 = ((EXTRACT_LSB0_INT (insn, 32, 19, 10)) << (2)); \
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_LDQ_VARS \
  UINT f_op; \
  UINT f_left; \
  SI f_disp10x8; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_LDQ_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_disp10x8 = ((EXTRACT_LSB0_INT (insn, 32, 19, 10)) << (3)); \
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_MMACNFX_WL_VARS \
  UINT f_op; \
  UINT f_ext; \
  UINT f_right; \
  UINT f_right; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_MMACNFX_WL_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_ext = EXTRACT_LSB0_UINT (insn, 32, 19, 4); \
  f_right = EXTRACT_LSB0_UINT (insn, 32, 15, 6); \
  f_right = EXTRACT_LSB0_UINT (insn, 32, 15, 6); \
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_MOVI_VARS \
  UINT f_op; \
  INT f_imm16; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_MOVI_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_imm16 = EXTRACT_LSB0_INT (insn, 32, 25, 16); \
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_ORI_VARS \
  UINT f_op; \
  UINT f_left; \
  INT f_imm10; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_ORI_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_imm10 = EXTRACT_LSB0_INT (insn, 32, 19, 10); \
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_PREFI_VARS \
  UINT f_op; \
  UINT f_left; \
  UINT f_ext; \
  SI f_disp6x32; \
  UINT f_right; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_PREFI_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_ext = EXTRACT_LSB0_UINT (insn, 32, 19, 4); \
  f_disp6x32 = ((EXTRACT_LSB0_INT (insn, 32, 15, 6)) << (5)); \
  f_right = EXTRACT_LSB0_UINT (insn, 32, 15, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_PTA_VARS \
  UINT f_op; \
  DI f_disp16; \
  UINT f_likely; \
  UINT f_8_2; \
  UINT f_tra; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_PTA_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_disp16 = ((((EXTRACT_LSB0_INT (insn, 32, 25, 16)) << (2))) + (pc)); \
  f_likely = EXTRACT_LSB0_UINT (insn, 32, 9, 1); \
  f_8_2 = EXTRACT_LSB0_UINT (insn, 32, 8, 2); \
  f_tra = EXTRACT_LSB0_UINT (insn, 32, 6, 3); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_PTABS_VARS \
  UINT f_op; \
  UINT f_left; \
  UINT f_ext; \
  UINT f_right; \
  UINT f_likely; \
  UINT f_8_2; \
  UINT f_tra; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_PTABS_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_ext = EXTRACT_LSB0_UINT (insn, 32, 19, 4); \
  f_right = EXTRACT_LSB0_UINT (insn, 32, 15, 6); \
  f_likely = EXTRACT_LSB0_UINT (insn, 32, 9, 1); \
  f_8_2 = EXTRACT_LSB0_UINT (insn, 32, 8, 2); \
  f_tra = EXTRACT_LSB0_UINT (insn, 32, 6, 3); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_PUTCON_VARS \
  UINT f_op; \
  UINT f_left; \
  UINT f_ext; \
  UINT f_right; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_PUTCON_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_ext = EXTRACT_LSB0_UINT (insn, 32, 19, 4); \
  f_right = EXTRACT_LSB0_UINT (insn, 32, 15, 6); \
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_SHARI_VARS \
  UINT f_op; \
  UINT f_left; \
  UINT f_ext; \
  UINT f_uimm6; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_SHARI_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_ext = EXTRACT_LSB0_UINT (insn, 32, 19, 4); \
  f_uimm6 = EXTRACT_LSB0_UINT (insn, 32, 15, 6); \
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_SHORI_VARS \
  UINT f_op; \
  UINT f_uimm16; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_SHORI_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_uimm16 = EXTRACT_LSB0_UINT (insn, 32, 25, 16); \
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_STW_VARS \
  UINT f_op; \
  UINT f_left; \
  SI f_disp10x2; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_STW_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_disp10x2 = ((EXTRACT_LSB0_INT (insn, 32, 19, 10)) << (1)); \
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

#define EXTRACT_IFMT_TRAPA_VARS \
  UINT f_op; \
  UINT f_left; \
  UINT f_ext; \
  UINT f_right; \
  UINT f_dest; \
  UINT f_rsvd; \
  unsigned int length;
#define EXTRACT_IFMT_TRAPA_CODE \
  length = 4; \
  f_op = EXTRACT_LSB0_UINT (insn, 32, 31, 6); \
  f_left = EXTRACT_LSB0_UINT (insn, 32, 25, 6); \
  f_ext = EXTRACT_LSB0_UINT (insn, 32, 19, 4); \
  f_right = EXTRACT_LSB0_UINT (insn, 32, 15, 6); \
  f_dest = EXTRACT_LSB0_UINT (insn, 32, 9, 6); \
  f_rsvd = EXTRACT_LSB0_UINT (insn, 32, 3, 4); \

/* Collection of various things for the trace handler to use.  */

typedef struct trace_record {
  IADDR pc;
  /* FIXME:wip */
} TRACE_RECORD;

#endif /* CPU_@CPU@_H */
