/* Simulator model support for @cpu@.

THIS FILE IS MACHINE GENERATED WITH CGEN.

Copyright 1996, 1997, 1998, 1999, 2000, 2001, 2002 Free Software Foundation, Inc.

This file is part of the GNU simulators.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/

#define WANT_CPU @cpu@
#define WANT_CPU_@CPU@

#include "sim-main.h"

/* The profiling data is recorded here, but is accessed via the profiling
   mechanism.  After all, this is information for profiling.  */

#if WITH_PROFILE_MODEL_P

/* Model handlers for each insn.  */

static int
model_sh5_add (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_addl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_addi (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADDI_VARS /* f-op f-left f-disp10 f-dest f-rsvd */
  EXTRACT_IFMT_ADDI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_addil (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADDI_VARS /* f-op f-left f-disp10 f-dest f-rsvd */
  EXTRACT_IFMT_ADDI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_addzl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_alloco (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ALLOCO_VARS /* f-op f-left f-ext f-disp6x32 f-dest f-rsvd */
  EXTRACT_IFMT_ALLOCO_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_and (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_andc (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_andi (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADDI_VARS /* f-op f-left f-disp10 f-dest f-rsvd */
  EXTRACT_IFMT_ADDI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_beq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BEQ_VARS /* f-op f-left f-ext f-right f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_BEQ_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_beqi (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BEQI_VARS /* f-op f-left f-ext f-imm6 f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_BEQI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_bge (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BEQ_VARS /* f-op f-left f-ext f-right f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_BEQ_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_bgeu (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BEQ_VARS /* f-op f-left f-ext f-right f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_BEQ_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_bgt (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BEQ_VARS /* f-op f-left f-ext f-right f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_BEQ_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_bgtu (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BEQ_VARS /* f-op f-left f-ext f-right f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_BEQ_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_blink (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BLINK_VARS /* f-op f-25 f-trb f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BLINK_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_bne (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BEQ_VARS /* f-op f-left f-ext f-right f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_BEQ_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_bnei (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BEQ_VARS /* f-op f-left f-ext f-right f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_BEQ_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_brk (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRK_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BRK_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_byterev (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BYTEREV_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BYTEREV_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_cmpeq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_cmpgt (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_cmpgtu (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_cmveq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_cmvne (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fabsd (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FABSD_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FABSD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fabss (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FABSS_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FABSS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_faddd (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FADDD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FADDD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fadds (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FADDS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FADDS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fcmpeqd (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FCMPEQD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FCMPEQD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fcmpeqs (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FCMPEQS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FCMPEQS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fcmpged (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FCMPEQD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FCMPEQD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fcmpges (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FCMPEQS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FCMPEQS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fcmpgtd (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FCMPEQD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FCMPEQD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fcmpgts (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FCMPEQS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FCMPEQS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fcmpund (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FCMPEQD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FCMPEQD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fcmpuns (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FCMPEQS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FCMPEQS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fcnvds (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FCNVDS_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FCNVDS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fcnvsd (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FCNVSD_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FCNVSD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fdivd (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FADDD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FADDD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fdivs (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FADDS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FADDS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fgetscr (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FGETSCR_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FGETSCR_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fiprs (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FIPRS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FIPRS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fldd (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FLDD_VARS /* f-op f-left f-disp10x8 f-dest f-rsvd */
  EXTRACT_IFMT_FLDD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fldp (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FLDP_VARS /* f-op f-left f-disp10x8 f-dest f-rsvd */
  EXTRACT_IFMT_FLDP_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_flds (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FLDS_VARS /* f-op f-left f-disp10x4 f-dest f-rsvd */
  EXTRACT_IFMT_FLDS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fldxd (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FLDXD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FLDXD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fldxp (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FLDXP_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FLDXP_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fldxs (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FLDXD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FLDXD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_floatld (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FCNVSD_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FCNVSD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_floatls (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FABSS_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FABSS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_floatqd (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FABSD_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FABSD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_floatqs (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FCNVDS_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FCNVDS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fmacs (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FADDS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FADDS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fmovd (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FABSD_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FABSD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fmovdq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FMOVDQ_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FMOVDQ_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fmovls (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FMOVLS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FMOVLS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fmovqd (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FMOVLS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FMOVLS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fmovs (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FABSS_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FABSS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fmovsl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FMOVSL_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FMOVSL_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fmuld (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FADDD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FADDD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fmuls (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FADDS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FADDS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fnegd (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FABSD_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FABSD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fnegs (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FABSS_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FABSS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fputscr (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FPUTSCR_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FPUTSCR_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fsqrtd (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FABSD_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FABSD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fsqrts (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FABSS_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FABSS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fstd (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FLDD_VARS /* f-op f-left f-disp10x8 f-dest f-rsvd */
  EXTRACT_IFMT_FLDD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fstp (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FLDP_VARS /* f-op f-left f-disp10x8 f-dest f-rsvd */
  EXTRACT_IFMT_FLDP_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fsts (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FLDS_VARS /* f-op f-left f-disp10x4 f-dest f-rsvd */
  EXTRACT_IFMT_FLDS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fstxd (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FSTXD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FSTXD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fstxp (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FLDXP_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FLDXP_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fstxs (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FLDXD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FLDXD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fsubd (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FADDS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FADDS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fsubs (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FADDS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FADDS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ftrcdl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FCNVDS_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FCNVDS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ftrcsl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FABSS_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FABSS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ftrcdq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FCNVDS_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FCNVDS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ftrcsq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FCNVSD_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FCNVSD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ftrvs (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FTRVS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FTRVS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_getcfg (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_GETCFG_VARS /* f-op f-left f-ext f-disp6 f-dest f-rsvd */
  EXTRACT_IFMT_GETCFG_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_getcon (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_GETCON_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_GETCON_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_gettr (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BLINK_VARS /* f-op f-25 f-trb f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BLINK_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_icbi (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ALLOCO_VARS /* f-op f-left f-ext f-disp6x32 f-dest f-rsvd */
  EXTRACT_IFMT_ALLOCO_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldb (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADDI_VARS /* f-op f-left f-disp10 f-dest f-rsvd */
  EXTRACT_IFMT_ADDI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_LDL_VARS /* f-op f-left f-disp10x4 f-dest f-rsvd */
  EXTRACT_IFMT_LDL_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_LDQ_VARS /* f-op f-left f-disp10x8 f-dest f-rsvd */
  EXTRACT_IFMT_LDQ_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldub (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADDI_VARS /* f-op f-left f-disp10 f-dest f-rsvd */
  EXTRACT_IFMT_ADDI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_lduw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADDI_VARS /* f-op f-left f-disp10 f-dest f-rsvd */
  EXTRACT_IFMT_ADDI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADDI_VARS /* f-op f-left f-disp10 f-dest f-rsvd */
  EXTRACT_IFMT_ADDI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldhil (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_GETCFG_VARS /* f-op f-left f-ext f-disp6 f-dest f-rsvd */
  EXTRACT_IFMT_GETCFG_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldhiq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_GETCFG_VARS /* f-op f-left f-ext f-disp6 f-dest f-rsvd */
  EXTRACT_IFMT_GETCFG_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldlol (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_GETCFG_VARS /* f-op f-left f-ext f-disp6 f-dest f-rsvd */
  EXTRACT_IFMT_GETCFG_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldloq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_GETCFG_VARS /* f-op f-left f-ext f-disp6 f-dest f-rsvd */
  EXTRACT_IFMT_GETCFG_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldxb (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldxl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldxq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldxub (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldxuw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldxw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mabsl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BYTEREV_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BYTEREV_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mabsw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BYTEREV_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BYTEREV_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_maddl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_maddw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_maddsl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_maddsub (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_maddsw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mcmpeqb (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mcmpeql (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mcmpeqw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mcmpgtl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mcmpgtub (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mcmpgtw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mcmv (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mcnvslw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mcnvswb (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mcnvswub (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mextr1 (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mextr2 (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mextr3 (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mextr4 (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mextr5 (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mextr6 (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mextr7 (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mmacfxwl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mmacnfx_wl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_MMACNFX_WL_VARS /* f-op f-ext f-right f-right f-dest f-rsvd */
  EXTRACT_IFMT_MMACNFX_WL_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mmull (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mmulw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mmulfxl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mmulfxw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mmulfxrpw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mmulhiwl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mmullowl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mmulsumwq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movi (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_MOVI_VARS /* f-op f-imm16 f-dest f-rsvd */
  EXTRACT_IFMT_MOVI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mpermw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_msadubq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mshaldsl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mshaldsw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mshardl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mshardw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mshardsq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mshfhib (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mshfhil (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mshfhiw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mshflob (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mshflol (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mshflow (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mshlldl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mshlldw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mshlrdl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mshlrdw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_msubl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_msubw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_msubsl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_msubsub (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_msubsw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mulsl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mulul (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_nop (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRK_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BRK_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_nsb (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BYTEREV_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BYTEREV_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ocbi (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ALLOCO_VARS /* f-op f-left f-ext f-disp6x32 f-dest f-rsvd */
  EXTRACT_IFMT_ALLOCO_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ocbp (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ALLOCO_VARS /* f-op f-left f-ext f-disp6x32 f-dest f-rsvd */
  EXTRACT_IFMT_ALLOCO_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ocbwb (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ALLOCO_VARS /* f-op f-left f-ext f-disp6x32 f-dest f-rsvd */
  EXTRACT_IFMT_ALLOCO_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_or (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ori (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ORI_VARS /* f-op f-left f-imm10 f-dest f-rsvd */
  EXTRACT_IFMT_ORI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_prefi (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_PREFI_VARS /* f-op f-left f-ext f-disp6x32 f-right f-rsvd */
  EXTRACT_IFMT_PREFI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_pta (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_PTA_VARS /* f-op f-disp16 f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_PTA_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ptabs (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_PTABS_VARS /* f-op f-left f-ext f-right f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_PTABS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ptb (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_PTA_VARS /* f-op f-disp16 f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_PTA_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ptrel (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_PTABS_VARS /* f-op f-left f-ext f-right f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_PTABS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_putcfg (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_GETCFG_VARS /* f-op f-left f-ext f-disp6 f-dest f-rsvd */
  EXTRACT_IFMT_GETCFG_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_putcon (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_PUTCON_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_PUTCON_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_rte (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRK_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BRK_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shard (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shardl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shari (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_SHARI_VARS /* f-op f-left f-ext f-uimm6 f-dest f-rsvd */
  EXTRACT_IFMT_SHARI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_sharil (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_SHARI_VARS /* f-op f-left f-ext f-uimm6 f-dest f-rsvd */
  EXTRACT_IFMT_SHARI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shlld (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shlldl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shlli (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_SHARI_VARS /* f-op f-left f-ext f-uimm6 f-dest f-rsvd */
  EXTRACT_IFMT_SHARI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shllil (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_SHARI_VARS /* f-op f-left f-ext f-uimm6 f-dest f-rsvd */
  EXTRACT_IFMT_SHARI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shlrd (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shlrdl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shlri (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_SHARI_VARS /* f-op f-left f-ext f-uimm6 f-dest f-rsvd */
  EXTRACT_IFMT_SHARI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shlril (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_SHARI_VARS /* f-op f-left f-ext f-uimm6 f-dest f-rsvd */
  EXTRACT_IFMT_SHARI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shori (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_SHORI_VARS /* f-op f-uimm16 f-dest f-rsvd */
  EXTRACT_IFMT_SHORI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_sleep (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRK_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BRK_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_stb (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADDI_VARS /* f-op f-left f-disp10 f-dest f-rsvd */
  EXTRACT_IFMT_ADDI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_stl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_LDL_VARS /* f-op f-left f-disp10x4 f-dest f-rsvd */
  EXTRACT_IFMT_LDL_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_stq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_LDQ_VARS /* f-op f-left f-disp10x8 f-dest f-rsvd */
  EXTRACT_IFMT_LDQ_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_stw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_STW_VARS /* f-op f-left f-disp10x2 f-dest f-rsvd */
  EXTRACT_IFMT_STW_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_sthil (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_GETCFG_VARS /* f-op f-left f-ext f-disp6 f-dest f-rsvd */
  EXTRACT_IFMT_GETCFG_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_sthiq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_GETCFG_VARS /* f-op f-left f-ext f-disp6 f-dest f-rsvd */
  EXTRACT_IFMT_GETCFG_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_stlol (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_GETCFG_VARS /* f-op f-left f-ext f-disp6 f-dest f-rsvd */
  EXTRACT_IFMT_GETCFG_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_stloq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_GETCFG_VARS /* f-op f-left f-ext f-disp6 f-dest f-rsvd */
  EXTRACT_IFMT_GETCFG_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_stxb (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_stxl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_stxq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_stxw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_sub (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_subl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_swapq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_synci (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRK_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BRK_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_synco (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRK_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BRK_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_trapa (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_TRAPA_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_TRAPA_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_xor (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_xori (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += @cpu@_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

/* We assume UNIT_NONE == 0 because the tables don't always terminate
   entries with it.  */

/* Model timing data for `sh5'.  */

static const INSN_TIMING sh5_timing[] = {
  { @PREFIX@_INSN_X_INVALID, 0, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_X_AFTER, 0, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_X_BEFORE, 0, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_X_CTI_CHAIN, 0, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_X_CHAIN, 0, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_X_BEGIN, 0, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_ADD, model_sh5_add, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_ADDL, model_sh5_addl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_ADDI, model_sh5_addi, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_ADDIL, model_sh5_addil, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_ADDZL, model_sh5_addzl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_ALLOCO, model_sh5_alloco, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_AND, model_sh5_and, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_ANDC, model_sh5_andc, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_ANDI, model_sh5_andi, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_BEQ, model_sh5_beq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_BEQI, model_sh5_beqi, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_BGE, model_sh5_bge, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_BGEU, model_sh5_bgeu, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_BGT, model_sh5_bgt, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_BGTU, model_sh5_bgtu, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_BLINK, model_sh5_blink, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_BNE, model_sh5_bne, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_BNEI, model_sh5_bnei, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_BRK, model_sh5_brk, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_BYTEREV, model_sh5_byterev, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_CMPEQ, model_sh5_cmpeq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_CMPGT, model_sh5_cmpgt, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_CMPGTU, model_sh5_cmpgtu, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_CMVEQ, model_sh5_cmveq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_CMVNE, model_sh5_cmvne, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FABSD, model_sh5_fabsd, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FABSS, model_sh5_fabss, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FADDD, model_sh5_faddd, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FADDS, model_sh5_fadds, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FCMPEQD, model_sh5_fcmpeqd, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FCMPEQS, model_sh5_fcmpeqs, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FCMPGED, model_sh5_fcmpged, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FCMPGES, model_sh5_fcmpges, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FCMPGTD, model_sh5_fcmpgtd, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FCMPGTS, model_sh5_fcmpgts, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FCMPUND, model_sh5_fcmpund, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FCMPUNS, model_sh5_fcmpuns, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FCNVDS, model_sh5_fcnvds, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FCNVSD, model_sh5_fcnvsd, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FDIVD, model_sh5_fdivd, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FDIVS, model_sh5_fdivs, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FGETSCR, model_sh5_fgetscr, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FIPRS, model_sh5_fiprs, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FLDD, model_sh5_fldd, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FLDP, model_sh5_fldp, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FLDS, model_sh5_flds, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FLDXD, model_sh5_fldxd, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FLDXP, model_sh5_fldxp, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FLDXS, model_sh5_fldxs, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FLOATLD, model_sh5_floatld, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FLOATLS, model_sh5_floatls, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FLOATQD, model_sh5_floatqd, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FLOATQS, model_sh5_floatqs, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FMACS, model_sh5_fmacs, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FMOVD, model_sh5_fmovd, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FMOVDQ, model_sh5_fmovdq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FMOVLS, model_sh5_fmovls, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FMOVQD, model_sh5_fmovqd, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FMOVS, model_sh5_fmovs, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FMOVSL, model_sh5_fmovsl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FMULD, model_sh5_fmuld, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FMULS, model_sh5_fmuls, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FNEGD, model_sh5_fnegd, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FNEGS, model_sh5_fnegs, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FPUTSCR, model_sh5_fputscr, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FSQRTD, model_sh5_fsqrtd, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FSQRTS, model_sh5_fsqrts, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FSTD, model_sh5_fstd, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FSTP, model_sh5_fstp, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FSTS, model_sh5_fsts, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FSTXD, model_sh5_fstxd, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FSTXP, model_sh5_fstxp, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FSTXS, model_sh5_fstxs, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FSUBD, model_sh5_fsubd, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FSUBS, model_sh5_fsubs, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FTRCDL, model_sh5_ftrcdl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FTRCSL, model_sh5_ftrcsl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FTRCDQ, model_sh5_ftrcdq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FTRCSQ, model_sh5_ftrcsq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_FTRVS, model_sh5_ftrvs, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_GETCFG, model_sh5_getcfg, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_GETCON, model_sh5_getcon, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_GETTR, model_sh5_gettr, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_ICBI, model_sh5_icbi, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_LDB, model_sh5_ldb, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_LDL, model_sh5_ldl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_LDQ, model_sh5_ldq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_LDUB, model_sh5_ldub, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_LDUW, model_sh5_lduw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_LDW, model_sh5_ldw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_LDHIL, model_sh5_ldhil, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_LDHIQ, model_sh5_ldhiq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_LDLOL, model_sh5_ldlol, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_LDLOQ, model_sh5_ldloq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_LDXB, model_sh5_ldxb, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_LDXL, model_sh5_ldxl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_LDXQ, model_sh5_ldxq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_LDXUB, model_sh5_ldxub, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_LDXUW, model_sh5_ldxuw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_LDXW, model_sh5_ldxw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MABSL, model_sh5_mabsl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MABSW, model_sh5_mabsw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MADDL, model_sh5_maddl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MADDW, model_sh5_maddw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MADDSL, model_sh5_maddsl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MADDSUB, model_sh5_maddsub, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MADDSW, model_sh5_maddsw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MCMPEQB, model_sh5_mcmpeqb, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MCMPEQL, model_sh5_mcmpeql, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MCMPEQW, model_sh5_mcmpeqw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MCMPGTL, model_sh5_mcmpgtl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MCMPGTUB, model_sh5_mcmpgtub, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MCMPGTW, model_sh5_mcmpgtw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MCMV, model_sh5_mcmv, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MCNVSLW, model_sh5_mcnvslw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MCNVSWB, model_sh5_mcnvswb, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MCNVSWUB, model_sh5_mcnvswub, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MEXTR1, model_sh5_mextr1, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MEXTR2, model_sh5_mextr2, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MEXTR3, model_sh5_mextr3, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MEXTR4, model_sh5_mextr4, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MEXTR5, model_sh5_mextr5, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MEXTR6, model_sh5_mextr6, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MEXTR7, model_sh5_mextr7, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MMACFXWL, model_sh5_mmacfxwl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MMACNFX_WL, model_sh5_mmacnfx_wl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MMULL, model_sh5_mmull, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MMULW, model_sh5_mmulw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MMULFXL, model_sh5_mmulfxl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MMULFXW, model_sh5_mmulfxw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MMULFXRPW, model_sh5_mmulfxrpw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MMULHIWL, model_sh5_mmulhiwl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MMULLOWL, model_sh5_mmullowl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MMULSUMWQ, model_sh5_mmulsumwq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MOVI, model_sh5_movi, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MPERMW, model_sh5_mpermw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MSADUBQ, model_sh5_msadubq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MSHALDSL, model_sh5_mshaldsl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MSHALDSW, model_sh5_mshaldsw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MSHARDL, model_sh5_mshardl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MSHARDW, model_sh5_mshardw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MSHARDSQ, model_sh5_mshardsq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MSHFHIB, model_sh5_mshfhib, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MSHFHIL, model_sh5_mshfhil, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MSHFHIW, model_sh5_mshfhiw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MSHFLOB, model_sh5_mshflob, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MSHFLOL, model_sh5_mshflol, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MSHFLOW, model_sh5_mshflow, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MSHLLDL, model_sh5_mshlldl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MSHLLDW, model_sh5_mshlldw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MSHLRDL, model_sh5_mshlrdl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MSHLRDW, model_sh5_mshlrdw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MSUBL, model_sh5_msubl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MSUBW, model_sh5_msubw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MSUBSL, model_sh5_msubsl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MSUBSUB, model_sh5_msubsub, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MSUBSW, model_sh5_msubsw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MULSL, model_sh5_mulsl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_MULUL, model_sh5_mulul, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_NOP, model_sh5_nop, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_NSB, model_sh5_nsb, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_OCBI, model_sh5_ocbi, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_OCBP, model_sh5_ocbp, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_OCBWB, model_sh5_ocbwb, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_OR, model_sh5_or, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_ORI, model_sh5_ori, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_PREFI, model_sh5_prefi, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_PTA, model_sh5_pta, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_PTABS, model_sh5_ptabs, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_PTB, model_sh5_ptb, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_PTREL, model_sh5_ptrel, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_PUTCFG, model_sh5_putcfg, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_PUTCON, model_sh5_putcon, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_RTE, model_sh5_rte, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_SHARD, model_sh5_shard, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_SHARDL, model_sh5_shardl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_SHARI, model_sh5_shari, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_SHARIL, model_sh5_sharil, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_SHLLD, model_sh5_shlld, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_SHLLDL, model_sh5_shlldl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_SHLLI, model_sh5_shlli, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_SHLLIL, model_sh5_shllil, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_SHLRD, model_sh5_shlrd, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_SHLRDL, model_sh5_shlrdl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_SHLRI, model_sh5_shlri, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_SHLRIL, model_sh5_shlril, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_SHORI, model_sh5_shori, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_SLEEP, model_sh5_sleep, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_STB, model_sh5_stb, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_STL, model_sh5_stl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_STQ, model_sh5_stq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_STW, model_sh5_stw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_STHIL, model_sh5_sthil, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_STHIQ, model_sh5_sthiq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_STLOL, model_sh5_stlol, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_STLOQ, model_sh5_stloq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_STXB, model_sh5_stxb, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_STXL, model_sh5_stxl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_STXQ, model_sh5_stxq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_STXW, model_sh5_stxw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_SUB, model_sh5_sub, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_SUBL, model_sh5_subl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_SWAPQ, model_sh5_swapq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_SYNCI, model_sh5_synci, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_SYNCO, model_sh5_synco, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_TRAPA, model_sh5_trapa, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_XOR, model_sh5_xor, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { @PREFIX@_INSN_XORI, model_sh5_xori, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
};

#endif /* WITH_PROFILE_MODEL_P */

static void
sh5_model_init (SIM_CPU *cpu)
{
  CPU_MODEL_DATA (cpu) = (void *) zalloc (sizeof (MODEL_SH5_DATA));
}

#if WITH_PROFILE_MODEL_P
#define TIMING_DATA(td) td
#else
#define TIMING_DATA(td) 0
#endif

static const MODEL sh5_models[] =
{
  { "sh5", & sh5_mach, MODEL_SH5, TIMING_DATA (& sh5_timing[0]), sh5_model_init },
  { 0 }
};

/* The properties of this cpu's implementation.  */

static const MACH_IMP_PROPERTIES @cpu@_imp_properties =
{
  sizeof (SIM_CPU),
#if WITH_SCACHE
  sizeof (SCACHE)
#else
  0
#endif
};


static void
@cpu@_prepare_run (SIM_CPU *cpu)
{
  if (CPU_IDESC (cpu) == NULL)
    @cpu@_init_idesc_table (cpu);
}

static const CGEN_INSN *
@cpu@_get_idata (SIM_CPU *cpu, int inum)
{
  return CPU_IDESC (cpu) [inum].idata;
}

static void
sh5_init_cpu (SIM_CPU *cpu)
{
  CPU_REG_FETCH (cpu) = sh64_fetch_register;
  CPU_REG_STORE (cpu) = sh64_store_register;
  CPU_PC_FETCH (cpu) = sh64_h_pc_get;
  CPU_PC_STORE (cpu) = sh64_h_pc_set;
  CPU_GET_IDATA (cpu) = @cpu@_get_idata;
  CPU_MAX_INSNS (cpu) = @CPU@_INSN_XORI + 1;
  CPU_INSN_NAME (cpu) = cgen_insn_name;
  CPU_FULL_ENGINE_FN (cpu) = @cpu@_engine_run_full;
#if WITH_FAST
  CPU_FAST_ENGINE_FN (cpu) = @cpu@_engine_run_fast;
#else
  CPU_FAST_ENGINE_FN (cpu) = @cpu@_engine_run_full;
#endif
}

const MACH sh5_mach =
{
  "sh5", "sh5", MACH_SH5,
  32, 32, & sh5_models[0], & sh64_imp_properties,
  sh5_init_cpu,
  @cpu@_prepare_run
};

