/* Simulator model support for sh64.

THIS FILE IS MACHINE GENERATED WITH CGEN.

Copyright 1996, 1997, 1998, 1999, 2000, 2001, 2002 Free Software Foundation, Inc.

This file is part of the GNU simulators.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/

#define WANT_CPU sh64
#define WANT_CPU_SH64

#include "sim-main.h"

/* The profiling data is recorded here, but is accessed via the profiling
   mechanism.  After all, this is information for profiling.  */

#if WITH_PROFILE_MODEL_P

/* Model handlers for each insn.  */

static int
model_sh5_add_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_addi_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADDI_COMPACT_VARS /* f-op4 f-rn f-imm8 */
  EXTRACT_IFMT_ADDI_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_addc_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_addv_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_and_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_AND_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_AND_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_andi_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ANDI_COMPACT_VARS /* f-op8 f-imm8 */
  EXTRACT_IFMT_ANDI_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_andb_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ANDB_COMPACT_VARS /* f-op8 f-imm8 */
  EXTRACT_IFMT_ANDB_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_bf_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BF_COMPACT_VARS /* f-op8 f-disp8 */
  IADDR i_disp8;
  EXTRACT_IFMT_BF_COMPACT_CODE
  i_disp8 = f_disp8;
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_bfs_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BF_COMPACT_VARS /* f-op8 f-disp8 */
  IADDR i_disp8;
  EXTRACT_IFMT_BF_COMPACT_CODE
  i_disp8 = f_disp8;
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_bra_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRA_COMPACT_VARS /* f-op4 f-disp12 */
  IADDR i_disp12;
  EXTRACT_IFMT_BRA_COMPACT_CODE
  i_disp12 = f_disp12;
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_braf_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_brk_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRK_COMPACT_VARS /* f-op16 */
  EXTRACT_IFMT_BRK_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_bsr_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRA_COMPACT_VARS /* f-op4 f-disp12 */
  IADDR i_disp12;
  EXTRACT_IFMT_BRA_COMPACT_CODE
  i_disp12 = f_disp12;
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_bsrf_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_bt_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BF_COMPACT_VARS /* f-op8 f-disp8 */
  IADDR i_disp8;
  EXTRACT_IFMT_BF_COMPACT_CODE
  i_disp8 = f_disp8;
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_bts_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BF_COMPACT_VARS /* f-op8 f-disp8 */
  IADDR i_disp8;
  EXTRACT_IFMT_BF_COMPACT_CODE
  i_disp8 = f_disp8;
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_clrmac_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRK_COMPACT_VARS /* f-op16 */
  EXTRACT_IFMT_BRK_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_clrs_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRK_COMPACT_VARS /* f-op16 */
  EXTRACT_IFMT_BRK_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_clrt_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRK_COMPACT_VARS /* f-op16 */
  EXTRACT_IFMT_BRK_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_cmpeq_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_cmpeqi_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ANDB_COMPACT_VARS /* f-op8 f-imm8 */
  EXTRACT_IFMT_ANDB_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_cmpge_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_cmpgt_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_cmphi_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_cmphs_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_cmppl_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_cmppz_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_cmpstr_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_div0s_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_div0u_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRK_COMPACT_VARS /* f-op16 */
  EXTRACT_IFMT_BRK_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_div1_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_dmulsl_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_dmulul_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_dt_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_extsb_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_extsw_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_extub_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_extuw_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fabs_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FABS_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_FABS_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fadd_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_FADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fcmpeq_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_FADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fcmpgt_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_FADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fcnvds_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FCNVDS_COMPACT_VARS /* f-op4 f-dn f-8-1 f-sub8 */
  EXTRACT_IFMT_FCNVDS_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fcnvsd_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FCNVDS_COMPACT_VARS /* f-op4 f-dn f-8-1 f-sub8 */
  EXTRACT_IFMT_FCNVDS_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fdiv_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_FADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fipr_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FIPR_COMPACT_VARS /* f-op4 f-vn f-vm f-sub8 */
  EXTRACT_IFMT_FIPR_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_flds_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FLDS_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_FLDS_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fldi0_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FLDS_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_FLDS_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fldi1_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FLDS_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_FLDS_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_float_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FABS_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_FABS_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fmac_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FMAC_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_FMAC_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fmov1_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FMAC_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_FMAC_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fmov2_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FMOV2_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_FMOV2_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fmov3_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FMOV2_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_FMOV2_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fmov4_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FMOV2_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_FMOV2_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fmov5_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FMOV5_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_FMOV5_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fmov6_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FMOV5_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_FMOV5_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fmov7_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FMOV5_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_FMOV5_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fmul_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_FADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fneg_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FABS_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_FABS_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_frchg_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRK_COMPACT_VARS /* f-op16 */
  EXTRACT_IFMT_BRK_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fschg_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRK_COMPACT_VARS /* f-op16 */
  EXTRACT_IFMT_BRK_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fsqrt_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FABS_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_FABS_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fsts_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FLDS_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_FLDS_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fsub_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_FADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ftrc_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FABS_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_FABS_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ftrv_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FTRV_COMPACT_VARS /* f-op4 f-vn f-sub10 */
  EXTRACT_IFMT_FTRV_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_jmp_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_jsr_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldc_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldcl_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_lds_fpscr_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldsl_fpscr_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_lds_fpul_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldsl_fpul_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_lds_mach_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldsl_mach_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_lds_macl_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldsl_macl_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_lds_pr_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldsl_pr_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_macl_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_macw_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mov_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_AND_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_AND_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movi_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADDI_COMPACT_VARS /* f-op4 f-rn f-imm8 */
  EXTRACT_IFMT_ADDI_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movb1_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movb2_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movb3_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movb4_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ANDB_COMPACT_VARS /* f-op8 f-imm8 */
  EXTRACT_IFMT_ANDB_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movb5_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_MOVB5_COMPACT_VARS /* f-op8 f-rm f-imm4 */
  EXTRACT_IFMT_MOVB5_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movb6_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movb7_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movb8_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movb9_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ANDB_COMPACT_VARS /* f-op8 f-imm8 */
  EXTRACT_IFMT_ANDB_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movb10_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_MOVB5_COMPACT_VARS /* f-op8 f-rm f-imm4 */
  EXTRACT_IFMT_MOVB5_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movl1_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movl2_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movl3_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movl4_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_MOVL4_COMPACT_VARS /* f-op8 f-imm8x4 */
  EXTRACT_IFMT_MOVL4_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movl5_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_MOVL5_COMPACT_VARS /* f-op4 f-rn f-rm f-imm4x4 */
  EXTRACT_IFMT_MOVL5_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movl6_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movl7_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movl8_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movl9_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_MOVL4_COMPACT_VARS /* f-op8 f-imm8x4 */
  EXTRACT_IFMT_MOVL4_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movl10_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_MOVL10_COMPACT_VARS /* f-op4 f-rn f-imm8x4 */
  EXTRACT_IFMT_MOVL10_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movl11_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_MOVL5_COMPACT_VARS /* f-op4 f-rn f-rm f-imm4x4 */
  EXTRACT_IFMT_MOVL5_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movw1_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movw2_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movw3_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movw4_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_MOVW4_COMPACT_VARS /* f-op8 f-imm8x2 */
  EXTRACT_IFMT_MOVW4_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movw5_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_MOVW5_COMPACT_VARS /* f-op8 f-rm f-imm4x2 */
  EXTRACT_IFMT_MOVW5_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movw6_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movw7_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movw8_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movw9_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_MOVW4_COMPACT_VARS /* f-op8 f-imm8x2 */
  EXTRACT_IFMT_MOVW4_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movw10_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_MOVW10_COMPACT_VARS /* f-op4 f-rn f-imm8x2 */
  EXTRACT_IFMT_MOVW10_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movw11_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_MOVW5_COMPACT_VARS /* f-op8 f-rm f-imm4x2 */
  EXTRACT_IFMT_MOVW5_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mova_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_MOVL4_COMPACT_VARS /* f-op8 f-imm8x4 */
  EXTRACT_IFMT_MOVL4_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movcal_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movt_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mull_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mulsw_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_muluw_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_neg_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_negc_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_nop_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRK_COMPACT_VARS /* f-op16 */
  EXTRACT_IFMT_BRK_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_not_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_AND_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_AND_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ocbi_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ocbp_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ocbwb_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_or_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_AND_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_AND_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ori_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ANDI_COMPACT_VARS /* f-op8 f-imm8 */
  EXTRACT_IFMT_ANDI_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_orb_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ANDB_COMPACT_VARS /* f-op8 f-imm8 */
  EXTRACT_IFMT_ANDB_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_pref_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_rotcl_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_rotcr_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_rotl_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_rotr_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_rts_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRK_COMPACT_VARS /* f-op16 */
  EXTRACT_IFMT_BRK_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_sets_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRK_COMPACT_VARS /* f-op16 */
  EXTRACT_IFMT_BRK_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_sett_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRK_COMPACT_VARS /* f-op16 */
  EXTRACT_IFMT_BRK_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shad_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shal_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shar_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shld_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shll_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shll2_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shll8_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shll16_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shlr_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shlr2_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shlr8_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shlr16_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_stc_gbr_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_stcl_gbr_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_sts_fpscr_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_stsl_fpscr_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_sts_fpul_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_stsl_fpul_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_sts_mach_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_stsl_mach_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_sts_macl_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_stsl_macl_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_sts_pr_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_stsl_pr_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_sub_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_subc_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_subv_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_swapb_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_swapw_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_tasb_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRAF_COMPACT_VARS /* f-op4 f-rn f-sub8 */
  EXTRACT_IFMT_BRAF_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_trapa_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ANDI_COMPACT_VARS /* f-op8 f-imm8 */
  EXTRACT_IFMT_ANDI_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_tst_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_tsti_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ANDI_COMPACT_VARS /* f-op8 f-imm8 */
  EXTRACT_IFMT_ANDI_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_tstb_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ANDB_COMPACT_VARS /* f-op8 f-imm8 */
  EXTRACT_IFMT_ANDB_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_xor_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_AND_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_AND_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_xori_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ANDI_COMPACT_VARS /* f-op8 f-imm8 */
  EXTRACT_IFMT_ANDI_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_xorb_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ANDB_COMPACT_VARS /* f-op8 f-imm8 */
  EXTRACT_IFMT_ANDB_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_xtrct_compact (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_COMPACT_VARS /* f-op4 f-rn f-rm f-sub4 */
  EXTRACT_IFMT_ADD_COMPACT_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_add (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_addl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_addi (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADDI_VARS /* f-op f-left f-disp10 f-dest f-rsvd */
  EXTRACT_IFMT_ADDI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_addil (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADDI_VARS /* f-op f-left f-disp10 f-dest f-rsvd */
  EXTRACT_IFMT_ADDI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_addzl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_alloco (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ALLOCO_VARS /* f-op f-left f-ext f-disp6x32 f-dest f-rsvd */
  EXTRACT_IFMT_ALLOCO_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_and (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_andc (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_andi (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADDI_VARS /* f-op f-left f-disp10 f-dest f-rsvd */
  EXTRACT_IFMT_ADDI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_beq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BEQ_VARS /* f-op f-left f-ext f-right f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_BEQ_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_beqi (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BEQI_VARS /* f-op f-left f-ext f-imm6 f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_BEQI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_bge (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BEQ_VARS /* f-op f-left f-ext f-right f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_BEQ_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_bgeu (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BEQ_VARS /* f-op f-left f-ext f-right f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_BEQ_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_bgt (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BEQ_VARS /* f-op f-left f-ext f-right f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_BEQ_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_bgtu (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BEQ_VARS /* f-op f-left f-ext f-right f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_BEQ_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_blink (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BLINK_VARS /* f-op f-25 f-trb f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BLINK_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_bne (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BEQ_VARS /* f-op f-left f-ext f-right f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_BEQ_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_bnei (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BEQ_VARS /* f-op f-left f-ext f-right f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_BEQ_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_brk (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRK_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BRK_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_byterev (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BYTEREV_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BYTEREV_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_cmpeq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_cmpgt (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_cmpgtu (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_cmveq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_cmvne (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fabsd (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FABSD_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FABSD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fabss (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FABSS_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FABSS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_faddd (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FADDD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FADDD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fadds (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FADDS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FADDS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fcmpeqd (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FCMPEQD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FCMPEQD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fcmpeqs (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FCMPEQS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FCMPEQS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fcmpged (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FCMPEQD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FCMPEQD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fcmpges (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FCMPEQS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FCMPEQS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fcmpgtd (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FCMPEQD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FCMPEQD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fcmpgts (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FCMPEQS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FCMPEQS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fcmpund (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FCMPEQD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FCMPEQD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fcmpuns (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FCMPEQS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FCMPEQS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fcnvds (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FCNVDS_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FCNVDS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fcnvsd (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FCNVSD_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FCNVSD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fdivd (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FADDD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FADDD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fdivs (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FADDS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FADDS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fgetscr (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FGETSCR_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FGETSCR_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fiprs (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FIPRS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FIPRS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fldd (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FLDD_VARS /* f-op f-left f-disp10x8 f-dest f-rsvd */
  EXTRACT_IFMT_FLDD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fldp (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FLDP_VARS /* f-op f-left f-disp10x8 f-dest f-rsvd */
  EXTRACT_IFMT_FLDP_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_flds (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FLDS_VARS /* f-op f-left f-disp10x4 f-dest f-rsvd */
  EXTRACT_IFMT_FLDS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fldxd (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FLDXD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FLDXD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fldxp (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FLDXP_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FLDXP_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fldxs (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FLDXD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FLDXD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_floatld (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FCNVSD_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FCNVSD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_floatls (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FABSS_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FABSS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_floatqd (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FABSD_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FABSD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_floatqs (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FCNVDS_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FCNVDS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fmacs (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FADDS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FADDS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fmovd (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FABSD_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FABSD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fmovdq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FMOVDQ_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FMOVDQ_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fmovls (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FMOVLS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FMOVLS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fmovqd (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FMOVLS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FMOVLS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fmovs (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FABSS_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FABSS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fmovsl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FMOVSL_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FMOVSL_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fmuld (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FADDD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FADDD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fmuls (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FADDS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FADDS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fnegd (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FABSD_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FABSD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fnegs (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FABSS_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FABSS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fputscr (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FPUTSCR_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FPUTSCR_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fsqrtd (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FABSD_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FABSD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fsqrts (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FABSS_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FABSS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fstd (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FLDD_VARS /* f-op f-left f-disp10x8 f-dest f-rsvd */
  EXTRACT_IFMT_FLDD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fstp (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FLDP_VARS /* f-op f-left f-disp10x8 f-dest f-rsvd */
  EXTRACT_IFMT_FLDP_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fsts (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FLDS_VARS /* f-op f-left f-disp10x4 f-dest f-rsvd */
  EXTRACT_IFMT_FLDS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fstxd (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FSTXD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FSTXD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fstxp (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FLDXP_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FLDXP_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fstxs (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FLDXD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FLDXD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fsubd (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FADDS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FADDS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_fsubs (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FADDS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FADDS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ftrcdl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FCNVDS_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FCNVDS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ftrcsl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FABSS_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FABSS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ftrcdq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FCNVDS_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FCNVDS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ftrcsq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FCNVSD_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FCNVSD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ftrvs (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_FTRVS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FTRVS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_getcfg (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_GETCFG_VARS /* f-op f-left f-ext f-disp6 f-dest f-rsvd */
  EXTRACT_IFMT_GETCFG_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_getcon (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_GETCON_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_GETCON_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_gettr (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BLINK_VARS /* f-op f-25 f-trb f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BLINK_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_icbi (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ALLOCO_VARS /* f-op f-left f-ext f-disp6x32 f-dest f-rsvd */
  EXTRACT_IFMT_ALLOCO_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldb (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADDI_VARS /* f-op f-left f-disp10 f-dest f-rsvd */
  EXTRACT_IFMT_ADDI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_LDL_VARS /* f-op f-left f-disp10x4 f-dest f-rsvd */
  EXTRACT_IFMT_LDL_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_LDQ_VARS /* f-op f-left f-disp10x8 f-dest f-rsvd */
  EXTRACT_IFMT_LDQ_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldub (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADDI_VARS /* f-op f-left f-disp10 f-dest f-rsvd */
  EXTRACT_IFMT_ADDI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_lduw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADDI_VARS /* f-op f-left f-disp10 f-dest f-rsvd */
  EXTRACT_IFMT_ADDI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADDI_VARS /* f-op f-left f-disp10 f-dest f-rsvd */
  EXTRACT_IFMT_ADDI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldhil (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_GETCFG_VARS /* f-op f-left f-ext f-disp6 f-dest f-rsvd */
  EXTRACT_IFMT_GETCFG_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldhiq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_GETCFG_VARS /* f-op f-left f-ext f-disp6 f-dest f-rsvd */
  EXTRACT_IFMT_GETCFG_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldlol (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_GETCFG_VARS /* f-op f-left f-ext f-disp6 f-dest f-rsvd */
  EXTRACT_IFMT_GETCFG_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldloq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_GETCFG_VARS /* f-op f-left f-ext f-disp6 f-dest f-rsvd */
  EXTRACT_IFMT_GETCFG_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldxb (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldxl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldxq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldxub (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldxuw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ldxw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mabsl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BYTEREV_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BYTEREV_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mabsw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BYTEREV_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BYTEREV_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_maddl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_maddw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_maddsl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_maddsub (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_maddsw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mcmpeqb (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mcmpeql (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mcmpeqw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mcmpgtl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mcmpgtub (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mcmpgtw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mcmv (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mcnvslw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mcnvswb (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mcnvswub (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mextr1 (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mextr2 (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mextr3 (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mextr4 (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mextr5 (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mextr6 (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mextr7 (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mmacfxwl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mmacnfx_wl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_MMACNFX_WL_VARS /* f-op f-ext f-right f-right f-dest f-rsvd */
  EXTRACT_IFMT_MMACNFX_WL_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mmull (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mmulw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mmulfxl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mmulfxw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mmulfxrpw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mmulhiwl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mmullowl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mmulsumwq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_movi (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_MOVI_VARS /* f-op f-imm16 f-dest f-rsvd */
  EXTRACT_IFMT_MOVI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mpermw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_msadubq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mshaldsl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mshaldsw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mshardl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mshardw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mshardsq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mshfhib (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mshfhil (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mshfhiw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mshflob (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mshflol (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mshflow (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mshlldl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mshlldw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mshlrdl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mshlrdw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_msubl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_msubw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_msubsl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_msubsub (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_msubsw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mulsl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_mulul (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_nop (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRK_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BRK_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_nsb (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BYTEREV_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BYTEREV_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ocbi (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ALLOCO_VARS /* f-op f-left f-ext f-disp6x32 f-dest f-rsvd */
  EXTRACT_IFMT_ALLOCO_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ocbp (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ALLOCO_VARS /* f-op f-left f-ext f-disp6x32 f-dest f-rsvd */
  EXTRACT_IFMT_ALLOCO_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ocbwb (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ALLOCO_VARS /* f-op f-left f-ext f-disp6x32 f-dest f-rsvd */
  EXTRACT_IFMT_ALLOCO_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_or (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ori (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ORI_VARS /* f-op f-left f-imm10 f-dest f-rsvd */
  EXTRACT_IFMT_ORI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_prefi (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_PREFI_VARS /* f-op f-left f-ext f-disp6x32 f-right f-rsvd */
  EXTRACT_IFMT_PREFI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_pta (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_PTA_VARS /* f-op f-disp16 f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_PTA_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ptabs (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_PTABS_VARS /* f-op f-left f-ext f-right f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_PTABS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ptb (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_PTA_VARS /* f-op f-disp16 f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_PTA_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_ptrel (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_PTABS_VARS /* f-op f-left f-ext f-right f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_PTABS_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_putcfg (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_GETCFG_VARS /* f-op f-left f-ext f-disp6 f-dest f-rsvd */
  EXTRACT_IFMT_GETCFG_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_putcon (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_PUTCON_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_PUTCON_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_rte (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRK_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BRK_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shard (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shardl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shari (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_SHARI_VARS /* f-op f-left f-ext f-uimm6 f-dest f-rsvd */
  EXTRACT_IFMT_SHARI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_sharil (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_SHARI_VARS /* f-op f-left f-ext f-uimm6 f-dest f-rsvd */
  EXTRACT_IFMT_SHARI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shlld (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shlldl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shlli (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_SHARI_VARS /* f-op f-left f-ext f-uimm6 f-dest f-rsvd */
  EXTRACT_IFMT_SHARI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shllil (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_SHARI_VARS /* f-op f-left f-ext f-uimm6 f-dest f-rsvd */
  EXTRACT_IFMT_SHARI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shlrd (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shlrdl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shlri (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_SHARI_VARS /* f-op f-left f-ext f-uimm6 f-dest f-rsvd */
  EXTRACT_IFMT_SHARI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shlril (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_SHARI_VARS /* f-op f-left f-ext f-uimm6 f-dest f-rsvd */
  EXTRACT_IFMT_SHARI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_shori (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_SHORI_VARS /* f-op f-uimm16 f-dest f-rsvd */
  EXTRACT_IFMT_SHORI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_sleep (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRK_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BRK_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_stb (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADDI_VARS /* f-op f-left f-disp10 f-dest f-rsvd */
  EXTRACT_IFMT_ADDI_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_stl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_LDL_VARS /* f-op f-left f-disp10x4 f-dest f-rsvd */
  EXTRACT_IFMT_LDL_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_stq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_LDQ_VARS /* f-op f-left f-disp10x8 f-dest f-rsvd */
  EXTRACT_IFMT_LDQ_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_stw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_STW_VARS /* f-op f-left f-disp10x2 f-dest f-rsvd */
  EXTRACT_IFMT_STW_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_sthil (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_GETCFG_VARS /* f-op f-left f-ext f-disp6 f-dest f-rsvd */
  EXTRACT_IFMT_GETCFG_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_sthiq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_GETCFG_VARS /* f-op f-left f-ext f-disp6 f-dest f-rsvd */
  EXTRACT_IFMT_GETCFG_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_stlol (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_GETCFG_VARS /* f-op f-left f-ext f-disp6 f-dest f-rsvd */
  EXTRACT_IFMT_GETCFG_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_stloq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_GETCFG_VARS /* f-op f-left f-ext f-disp6 f-dest f-rsvd */
  EXTRACT_IFMT_GETCFG_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_stxb (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_stxl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_stxq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_stxw (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_sub (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_subl (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_swapq (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_synci (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRK_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BRK_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_synco (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_BRK_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BRK_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_trapa (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_TRAPA_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_TRAPA_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_xor (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

static int
model_sh5_xori (SIM_CPU *current_cpu, void *sem_arg)
{
  const ARGBUF * UNUSED abuf = SEM_ARGBUF ((SEM_ARG) sem_arg);
  const IDESC * UNUSED idesc = abuf->idesc;
  int cycles = 0;
  IADDR UNUSED pc = GET_H_PC ();
  CGEN_INSN_INT insn = abuf->insn;
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE
  {
    int referenced = 0;
    int UNUSED insn_referenced = abuf->written;
    cycles += sh64_model_sh5_u_exec (current_cpu, idesc, 0, referenced);
  }
  return cycles;
}

/* We assume UNIT_NONE == 0 because the tables don't always terminate
   entries with it.  */

/* Model timing data for `sh5'.  */

static const INSN_TIMING sh5_timing[] = {
  { SH64_COMPACT,MEDIA_INSN_X_INVALID, 0, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_X_AFTER, 0, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_X_BEFORE, 0, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_X_CTI_CHAIN, 0, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_X_CHAIN, 0, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_X_BEGIN, 0, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_ADD_COMPACT, model_sh5_add_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_ADDI_COMPACT, model_sh5_addi_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_ADDC_COMPACT, model_sh5_addc_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_ADDV_COMPACT, model_sh5_addv_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_AND_COMPACT, model_sh5_and_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_ANDI_COMPACT, model_sh5_andi_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_ANDB_COMPACT, model_sh5_andb_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_BF_COMPACT, model_sh5_bf_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_BFS_COMPACT, model_sh5_bfs_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_BRA_COMPACT, model_sh5_bra_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_BRAF_COMPACT, model_sh5_braf_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_BRK_COMPACT, model_sh5_brk_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_BSR_COMPACT, model_sh5_bsr_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_BSRF_COMPACT, model_sh5_bsrf_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_BT_COMPACT, model_sh5_bt_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_BTS_COMPACT, model_sh5_bts_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_CLRMAC_COMPACT, model_sh5_clrmac_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_CLRS_COMPACT, model_sh5_clrs_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_CLRT_COMPACT, model_sh5_clrt_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_CMPEQ_COMPACT, model_sh5_cmpeq_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_CMPEQI_COMPACT, model_sh5_cmpeqi_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_CMPGE_COMPACT, model_sh5_cmpge_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_CMPGT_COMPACT, model_sh5_cmpgt_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_CMPHI_COMPACT, model_sh5_cmphi_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_CMPHS_COMPACT, model_sh5_cmphs_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_CMPPL_COMPACT, model_sh5_cmppl_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_CMPPZ_COMPACT, model_sh5_cmppz_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_CMPSTR_COMPACT, model_sh5_cmpstr_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_DIV0S_COMPACT, model_sh5_div0s_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_DIV0U_COMPACT, model_sh5_div0u_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_DIV1_COMPACT, model_sh5_div1_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_DMULSL_COMPACT, model_sh5_dmulsl_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_DMULUL_COMPACT, model_sh5_dmulul_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_DT_COMPACT, model_sh5_dt_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_EXTSB_COMPACT, model_sh5_extsb_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_EXTSW_COMPACT, model_sh5_extsw_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_EXTUB_COMPACT, model_sh5_extub_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_EXTUW_COMPACT, model_sh5_extuw_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FABS_COMPACT, model_sh5_fabs_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FADD_COMPACT, model_sh5_fadd_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FCMPEQ_COMPACT, model_sh5_fcmpeq_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FCMPGT_COMPACT, model_sh5_fcmpgt_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FCNVDS_COMPACT, model_sh5_fcnvds_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FCNVSD_COMPACT, model_sh5_fcnvsd_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FDIV_COMPACT, model_sh5_fdiv_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FIPR_COMPACT, model_sh5_fipr_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FLDS_COMPACT, model_sh5_flds_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FLDI0_COMPACT, model_sh5_fldi0_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FLDI1_COMPACT, model_sh5_fldi1_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FLOAT_COMPACT, model_sh5_float_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FMAC_COMPACT, model_sh5_fmac_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FMOV1_COMPACT, model_sh5_fmov1_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FMOV2_COMPACT, model_sh5_fmov2_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FMOV3_COMPACT, model_sh5_fmov3_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FMOV4_COMPACT, model_sh5_fmov4_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FMOV5_COMPACT, model_sh5_fmov5_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FMOV6_COMPACT, model_sh5_fmov6_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FMOV7_COMPACT, model_sh5_fmov7_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FMUL_COMPACT, model_sh5_fmul_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FNEG_COMPACT, model_sh5_fneg_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FRCHG_COMPACT, model_sh5_frchg_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FSCHG_COMPACT, model_sh5_fschg_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FSQRT_COMPACT, model_sh5_fsqrt_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FSTS_COMPACT, model_sh5_fsts_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FSUB_COMPACT, model_sh5_fsub_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FTRC_COMPACT, model_sh5_ftrc_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FTRV_COMPACT, model_sh5_ftrv_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_JMP_COMPACT, model_sh5_jmp_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_JSR_COMPACT, model_sh5_jsr_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_LDC_COMPACT, model_sh5_ldc_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_LDCL_COMPACT, model_sh5_ldcl_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_LDS_FPSCR_COMPACT, model_sh5_lds_fpscr_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_LDSL_FPSCR_COMPACT, model_sh5_ldsl_fpscr_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_LDS_FPUL_COMPACT, model_sh5_lds_fpul_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_LDSL_FPUL_COMPACT, model_sh5_ldsl_fpul_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_LDS_MACH_COMPACT, model_sh5_lds_mach_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_LDSL_MACH_COMPACT, model_sh5_ldsl_mach_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_LDS_MACL_COMPACT, model_sh5_lds_macl_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_LDSL_MACL_COMPACT, model_sh5_ldsl_macl_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_LDS_PR_COMPACT, model_sh5_lds_pr_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_LDSL_PR_COMPACT, model_sh5_ldsl_pr_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MACL_COMPACT, model_sh5_macl_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MACW_COMPACT, model_sh5_macw_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOV_COMPACT, model_sh5_mov_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVI_COMPACT, model_sh5_movi_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVB1_COMPACT, model_sh5_movb1_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVB2_COMPACT, model_sh5_movb2_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVB3_COMPACT, model_sh5_movb3_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVB4_COMPACT, model_sh5_movb4_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVB5_COMPACT, model_sh5_movb5_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVB6_COMPACT, model_sh5_movb6_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVB7_COMPACT, model_sh5_movb7_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVB8_COMPACT, model_sh5_movb8_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVB9_COMPACT, model_sh5_movb9_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVB10_COMPACT, model_sh5_movb10_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVL1_COMPACT, model_sh5_movl1_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVL2_COMPACT, model_sh5_movl2_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVL3_COMPACT, model_sh5_movl3_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVL4_COMPACT, model_sh5_movl4_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVL5_COMPACT, model_sh5_movl5_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVL6_COMPACT, model_sh5_movl6_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVL7_COMPACT, model_sh5_movl7_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVL8_COMPACT, model_sh5_movl8_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVL9_COMPACT, model_sh5_movl9_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVL10_COMPACT, model_sh5_movl10_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVL11_COMPACT, model_sh5_movl11_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVW1_COMPACT, model_sh5_movw1_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVW2_COMPACT, model_sh5_movw2_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVW3_COMPACT, model_sh5_movw3_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVW4_COMPACT, model_sh5_movw4_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVW5_COMPACT, model_sh5_movw5_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVW6_COMPACT, model_sh5_movw6_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVW7_COMPACT, model_sh5_movw7_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVW8_COMPACT, model_sh5_movw8_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVW9_COMPACT, model_sh5_movw9_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVW10_COMPACT, model_sh5_movw10_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVW11_COMPACT, model_sh5_movw11_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVA_COMPACT, model_sh5_mova_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVCAL_COMPACT, model_sh5_movcal_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVT_COMPACT, model_sh5_movt_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MULL_COMPACT, model_sh5_mull_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MULSW_COMPACT, model_sh5_mulsw_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MULUW_COMPACT, model_sh5_muluw_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_NEG_COMPACT, model_sh5_neg_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_NEGC_COMPACT, model_sh5_negc_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_NOP_COMPACT, model_sh5_nop_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_NOT_COMPACT, model_sh5_not_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_OCBI_COMPACT, model_sh5_ocbi_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_OCBP_COMPACT, model_sh5_ocbp_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_OCBWB_COMPACT, model_sh5_ocbwb_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_OR_COMPACT, model_sh5_or_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_ORI_COMPACT, model_sh5_ori_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_ORB_COMPACT, model_sh5_orb_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_PREF_COMPACT, model_sh5_pref_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_ROTCL_COMPACT, model_sh5_rotcl_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_ROTCR_COMPACT, model_sh5_rotcr_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_ROTL_COMPACT, model_sh5_rotl_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_ROTR_COMPACT, model_sh5_rotr_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_RTS_COMPACT, model_sh5_rts_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SETS_COMPACT, model_sh5_sets_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SETT_COMPACT, model_sh5_sett_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SHAD_COMPACT, model_sh5_shad_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SHAL_COMPACT, model_sh5_shal_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SHAR_COMPACT, model_sh5_shar_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SHLD_COMPACT, model_sh5_shld_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SHLL_COMPACT, model_sh5_shll_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SHLL2_COMPACT, model_sh5_shll2_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SHLL8_COMPACT, model_sh5_shll8_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SHLL16_COMPACT, model_sh5_shll16_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SHLR_COMPACT, model_sh5_shlr_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SHLR2_COMPACT, model_sh5_shlr2_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SHLR8_COMPACT, model_sh5_shlr8_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SHLR16_COMPACT, model_sh5_shlr16_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_STC_GBR_COMPACT, model_sh5_stc_gbr_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_STCL_GBR_COMPACT, model_sh5_stcl_gbr_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_STS_FPSCR_COMPACT, model_sh5_sts_fpscr_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_STSL_FPSCR_COMPACT, model_sh5_stsl_fpscr_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_STS_FPUL_COMPACT, model_sh5_sts_fpul_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_STSL_FPUL_COMPACT, model_sh5_stsl_fpul_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_STS_MACH_COMPACT, model_sh5_sts_mach_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_STSL_MACH_COMPACT, model_sh5_stsl_mach_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_STS_MACL_COMPACT, model_sh5_sts_macl_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_STSL_MACL_COMPACT, model_sh5_stsl_macl_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_STS_PR_COMPACT, model_sh5_sts_pr_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_STSL_PR_COMPACT, model_sh5_stsl_pr_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SUB_COMPACT, model_sh5_sub_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SUBC_COMPACT, model_sh5_subc_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SUBV_COMPACT, model_sh5_subv_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SWAPB_COMPACT, model_sh5_swapb_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SWAPW_COMPACT, model_sh5_swapw_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_TASB_COMPACT, model_sh5_tasb_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_TRAPA_COMPACT, model_sh5_trapa_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_TST_COMPACT, model_sh5_tst_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_TSTI_COMPACT, model_sh5_tsti_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_TSTB_COMPACT, model_sh5_tstb_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_XOR_COMPACT, model_sh5_xor_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_XORI_COMPACT, model_sh5_xori_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_XORB_COMPACT, model_sh5_xorb_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_XTRCT_COMPACT, model_sh5_xtrct_compact, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_ADD, model_sh5_add, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_ADDL, model_sh5_addl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_ADDI, model_sh5_addi, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_ADDIL, model_sh5_addil, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_ADDZL, model_sh5_addzl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_ALLOCO, model_sh5_alloco, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_AND, model_sh5_and, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_ANDC, model_sh5_andc, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_ANDI, model_sh5_andi, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_BEQ, model_sh5_beq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_BEQI, model_sh5_beqi, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_BGE, model_sh5_bge, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_BGEU, model_sh5_bgeu, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_BGT, model_sh5_bgt, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_BGTU, model_sh5_bgtu, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_BLINK, model_sh5_blink, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_BNE, model_sh5_bne, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_BNEI, model_sh5_bnei, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_BRK, model_sh5_brk, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_BYTEREV, model_sh5_byterev, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_CMPEQ, model_sh5_cmpeq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_CMPGT, model_sh5_cmpgt, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_CMPGTU, model_sh5_cmpgtu, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_CMVEQ, model_sh5_cmveq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_CMVNE, model_sh5_cmvne, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FABSD, model_sh5_fabsd, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FABSS, model_sh5_fabss, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FADDD, model_sh5_faddd, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FADDS, model_sh5_fadds, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FCMPEQD, model_sh5_fcmpeqd, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FCMPEQS, model_sh5_fcmpeqs, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FCMPGED, model_sh5_fcmpged, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FCMPGES, model_sh5_fcmpges, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FCMPGTD, model_sh5_fcmpgtd, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FCMPGTS, model_sh5_fcmpgts, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FCMPUND, model_sh5_fcmpund, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FCMPUNS, model_sh5_fcmpuns, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FCNVDS, model_sh5_fcnvds, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FCNVSD, model_sh5_fcnvsd, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FDIVD, model_sh5_fdivd, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FDIVS, model_sh5_fdivs, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FGETSCR, model_sh5_fgetscr, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FIPRS, model_sh5_fiprs, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FLDD, model_sh5_fldd, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FLDP, model_sh5_fldp, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FLDS, model_sh5_flds, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FLDXD, model_sh5_fldxd, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FLDXP, model_sh5_fldxp, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FLDXS, model_sh5_fldxs, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FLOATLD, model_sh5_floatld, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FLOATLS, model_sh5_floatls, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FLOATQD, model_sh5_floatqd, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FLOATQS, model_sh5_floatqs, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FMACS, model_sh5_fmacs, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FMOVD, model_sh5_fmovd, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FMOVDQ, model_sh5_fmovdq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FMOVLS, model_sh5_fmovls, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FMOVQD, model_sh5_fmovqd, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FMOVS, model_sh5_fmovs, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FMOVSL, model_sh5_fmovsl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FMULD, model_sh5_fmuld, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FMULS, model_sh5_fmuls, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FNEGD, model_sh5_fnegd, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FNEGS, model_sh5_fnegs, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FPUTSCR, model_sh5_fputscr, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FSQRTD, model_sh5_fsqrtd, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FSQRTS, model_sh5_fsqrts, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FSTD, model_sh5_fstd, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FSTP, model_sh5_fstp, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FSTS, model_sh5_fsts, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FSTXD, model_sh5_fstxd, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FSTXP, model_sh5_fstxp, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FSTXS, model_sh5_fstxs, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FSUBD, model_sh5_fsubd, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FSUBS, model_sh5_fsubs, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FTRCDL, model_sh5_ftrcdl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FTRCSL, model_sh5_ftrcsl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FTRCDQ, model_sh5_ftrcdq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FTRCSQ, model_sh5_ftrcsq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_FTRVS, model_sh5_ftrvs, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_GETCFG, model_sh5_getcfg, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_GETCON, model_sh5_getcon, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_GETTR, model_sh5_gettr, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_ICBI, model_sh5_icbi, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_LDB, model_sh5_ldb, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_LDL, model_sh5_ldl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_LDQ, model_sh5_ldq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_LDUB, model_sh5_ldub, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_LDUW, model_sh5_lduw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_LDW, model_sh5_ldw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_LDHIL, model_sh5_ldhil, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_LDHIQ, model_sh5_ldhiq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_LDLOL, model_sh5_ldlol, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_LDLOQ, model_sh5_ldloq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_LDXB, model_sh5_ldxb, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_LDXL, model_sh5_ldxl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_LDXQ, model_sh5_ldxq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_LDXUB, model_sh5_ldxub, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_LDXUW, model_sh5_ldxuw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_LDXW, model_sh5_ldxw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MABSL, model_sh5_mabsl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MABSW, model_sh5_mabsw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MADDL, model_sh5_maddl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MADDW, model_sh5_maddw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MADDSL, model_sh5_maddsl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MADDSUB, model_sh5_maddsub, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MADDSW, model_sh5_maddsw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MCMPEQB, model_sh5_mcmpeqb, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MCMPEQL, model_sh5_mcmpeql, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MCMPEQW, model_sh5_mcmpeqw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MCMPGTL, model_sh5_mcmpgtl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MCMPGTUB, model_sh5_mcmpgtub, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MCMPGTW, model_sh5_mcmpgtw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MCMV, model_sh5_mcmv, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MCNVSLW, model_sh5_mcnvslw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MCNVSWB, model_sh5_mcnvswb, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MCNVSWUB, model_sh5_mcnvswub, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MEXTR1, model_sh5_mextr1, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MEXTR2, model_sh5_mextr2, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MEXTR3, model_sh5_mextr3, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MEXTR4, model_sh5_mextr4, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MEXTR5, model_sh5_mextr5, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MEXTR6, model_sh5_mextr6, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MEXTR7, model_sh5_mextr7, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MMACFXWL, model_sh5_mmacfxwl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MMACNFX_WL, model_sh5_mmacnfx_wl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MMULL, model_sh5_mmull, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MMULW, model_sh5_mmulw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MMULFXL, model_sh5_mmulfxl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MMULFXW, model_sh5_mmulfxw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MMULFXRPW, model_sh5_mmulfxrpw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MMULHIWL, model_sh5_mmulhiwl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MMULLOWL, model_sh5_mmullowl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MMULSUMWQ, model_sh5_mmulsumwq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MOVI, model_sh5_movi, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MPERMW, model_sh5_mpermw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MSADUBQ, model_sh5_msadubq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MSHALDSL, model_sh5_mshaldsl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MSHALDSW, model_sh5_mshaldsw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MSHARDL, model_sh5_mshardl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MSHARDW, model_sh5_mshardw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MSHARDSQ, model_sh5_mshardsq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MSHFHIB, model_sh5_mshfhib, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MSHFHIL, model_sh5_mshfhil, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MSHFHIW, model_sh5_mshfhiw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MSHFLOB, model_sh5_mshflob, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MSHFLOL, model_sh5_mshflol, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MSHFLOW, model_sh5_mshflow, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MSHLLDL, model_sh5_mshlldl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MSHLLDW, model_sh5_mshlldw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MSHLRDL, model_sh5_mshlrdl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MSHLRDW, model_sh5_mshlrdw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MSUBL, model_sh5_msubl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MSUBW, model_sh5_msubw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MSUBSL, model_sh5_msubsl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MSUBSUB, model_sh5_msubsub, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MSUBSW, model_sh5_msubsw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MULSL, model_sh5_mulsl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_MULUL, model_sh5_mulul, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_NOP, model_sh5_nop, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_NSB, model_sh5_nsb, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_OCBI, model_sh5_ocbi, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_OCBP, model_sh5_ocbp, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_OCBWB, model_sh5_ocbwb, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_OR, model_sh5_or, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_ORI, model_sh5_ori, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_PREFI, model_sh5_prefi, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_PTA, model_sh5_pta, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_PTABS, model_sh5_ptabs, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_PTB, model_sh5_ptb, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_PTREL, model_sh5_ptrel, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_PUTCFG, model_sh5_putcfg, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_PUTCON, model_sh5_putcon, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_RTE, model_sh5_rte, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SHARD, model_sh5_shard, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SHARDL, model_sh5_shardl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SHARI, model_sh5_shari, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SHARIL, model_sh5_sharil, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SHLLD, model_sh5_shlld, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SHLLDL, model_sh5_shlldl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SHLLI, model_sh5_shlli, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SHLLIL, model_sh5_shllil, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SHLRD, model_sh5_shlrd, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SHLRDL, model_sh5_shlrdl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SHLRI, model_sh5_shlri, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SHLRIL, model_sh5_shlril, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SHORI, model_sh5_shori, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SLEEP, model_sh5_sleep, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_STB, model_sh5_stb, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_STL, model_sh5_stl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_STQ, model_sh5_stq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_STW, model_sh5_stw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_STHIL, model_sh5_sthil, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_STHIQ, model_sh5_sthiq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_STLOL, model_sh5_stlol, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_STLOQ, model_sh5_stloq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_STXB, model_sh5_stxb, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_STXL, model_sh5_stxl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_STXQ, model_sh5_stxq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_STXW, model_sh5_stxw, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SUB, model_sh5_sub, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SUBL, model_sh5_subl, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SWAPQ, model_sh5_swapq, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SYNCI, model_sh5_synci, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_SYNCO, model_sh5_synco, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_TRAPA, model_sh5_trapa, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_XOR, model_sh5_xor, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
  { SH64_COMPACT,MEDIA_INSN_XORI, model_sh5_xori, { { (int) UNIT_SH5_U_EXEC, 1, 1 } } },
};

#endif /* WITH_PROFILE_MODEL_P */

static void
sh5_model_init (SIM_CPU *cpu)
{
  CPU_MODEL_DATA (cpu) = (void *) zalloc (sizeof (MODEL_SH5_DATA));
}

#if WITH_PROFILE_MODEL_P
#define TIMING_DATA(td) td
#else
#define TIMING_DATA(td) 0
#endif

static const MODEL sh4_models[] =
{
  { 0 }
};

static const MODEL sh5_models[] =
{
  { "sh5", & sh5_mach, MODEL_SH5, TIMING_DATA (& sh5_timing[0]), sh5_model_init },
  { 0 }
};

/* The properties of this cpu's implementation.  */

static const MACH_IMP_PROPERTIES sh64_imp_properties =
{
  sizeof (SIM_CPU),
#if WITH_SCACHE
  sizeof (SCACHE)
#else
  0
#endif
};


static void
sh64_prepare_run (SIM_CPU *cpu)
{
  if (CPU_IDESC (cpu) == NULL)
    sh64_init_idesc_table (cpu);
}

static const CGEN_INSN *
sh64_get_idata (SIM_CPU *cpu, int inum)
{
  return CPU_IDESC (cpu) [inum].idata;
}

static void
sh4_init_cpu (SIM_CPU *cpu)
{
  CPU_REG_FETCH (cpu) = sh64_fetch_register;
  CPU_REG_STORE (cpu) = sh64_store_register;
  CPU_PC_FETCH (cpu) = sh64_h_pc_get;
  CPU_PC_STORE (cpu) = sh64_h_pc_set;
  CPU_GET_IDATA (cpu) = sh64_get_idata;
  CPU_MAX_INSNS (cpu) = SH64_INSN_XORI + 1;
  CPU_INSN_NAME (cpu) = cgen_insn_name;
  CPU_FULL_ENGINE_FN (cpu) = sh64_engine_run_full;
#if WITH_FAST
  CPU_FAST_ENGINE_FN (cpu) = sh64_engine_run_fast;
#else
  CPU_FAST_ENGINE_FN (cpu) = sh64_engine_run_full;
#endif
}

const MACH sh4_mach =
{
  "sh4", "sh4", MACH_SH4,
  32, 32, & sh4_models[0], & sh64_imp_properties,
  sh4_init_cpu,
  sh64_prepare_run
};

static void
sh5_init_cpu (SIM_CPU *cpu)
{
  CPU_REG_FETCH (cpu) = sh64_fetch_register;
  CPU_REG_STORE (cpu) = sh64_store_register;
  CPU_PC_FETCH (cpu) = sh64_h_pc_get;
  CPU_PC_STORE (cpu) = sh64_h_pc_set;
  CPU_GET_IDATA (cpu) = sh64_get_idata;
  CPU_MAX_INSNS (cpu) = SH64_INSN_XORI + 1;
  CPU_INSN_NAME (cpu) = cgen_insn_name;
  CPU_FULL_ENGINE_FN (cpu) = sh64_engine_run_full;
#if WITH_FAST
  CPU_FAST_ENGINE_FN (cpu) = sh64_engine_run_fast;
#else
  CPU_FAST_ENGINE_FN (cpu) = sh64_engine_run_full;
#endif
}

const MACH sh5_mach =
{
  "sh5", "sh5", MACH_SH5,
  32, 32, & sh5_models[0], & sh64_imp_properties,
  sh5_init_cpu,
  sh64_prepare_run
};

