/* All the definitions needed by the machine code. */

/* the non-group */

#define NOGROUP 0

/* Goals for both groups and individuals. */

#define NOGOAL 0
#define DRIFT 1
#define HITTARGET 2
#define CAPTARGET 3
#define BESIEGE 4
#define OCCUPYHEX 5
#define EXPLORE 6
#define DEFEND 7
#define LOAD 8
#define APPROACH 9
#define RELOAD 10
#define FINDTRANS 11

/* router flags */

#define SAMEPATH 1
#define EXPLORE_PATH 2

extern bool delaymove;

typedef struct a_area {
  short number;           /* area number */
  short x, y;             /* center of area */
  short allied_units;     /* How many units on our side here. */
  short allied_makers;    /* How many of our makers */
  short neutral_makers;    /* How many of neutral makers */
  short makers;           /* Total number of makers */
  short unexplored;       /* Number of unseem hexes in area. */
  short allied_bases;     /* Total number of our bases, includes towns */
  short border;           /* True if this is a border area. */
  short nearby;           /* Is this close to a location we have bases. */
  short unit_request;     /* Priority on request for units. */
  struct a_unit *units[MAXUTYPES]; /* Units in area */
  short requested_units[MAXUTYPES]; /* units we should move to area. */
  short num_units[MAXUTYPES]; /* units we should move to area. */
} Area;

/* values for unit_request */
#define NO_UNITS 0
#define GUARD_BASE 1
#define PATROL_AREA 2
#define EXPLORE_AREA 3
#define DEFEND_AREA 4
#define GUARD_TOWN 6
#define GUARD_BORDER 2
#define GUARD_BORDER_TOWN 10
#define DEFEND_BASE 20
#define DEFEND_TOWN 50

/* This structure is where machine sides keep all the plans and planning */
/* related data. */
/* Group 0 is never actually used (a sort of a dummy for various purposes). */

typedef struct a_plan {
    short estimate[MAXSIDES][MAXUTYPES];  /* estimated numbers of units */
    short allies[MAXSIDES][MAXUTYPES];  /* strength of other alliances */
    short cx, cy;               /* "centroid" of all our units */
    short lastreplan;           /* last turn we rechecked the plans */
    short demand[MAXUTYPES];    /* worth of each utype w.r.t. strategy */
} Plan;

/* Encapsulate some pointer-chasing and casting messiness. */

#define side_plan(s) ((Plan *) (s)->plan)

/* Malloced integer array accessors and modifers. */

#define aref(m,x,y) ((m)[(x)+world.width*(y)])

#define aset(m,x,y,v) ((m)[(x)+world.width*(y)] = (v))


extern int movetries;

extern int unit_count;
extern int explore_priority;
extern int defend_priority;
extern int attack_priority;
extern bool worths_known;

extern char shortbuf[BUFSIZE];         /* buffer for short unit description */

/* General collections of numbers used by all machine players. */

extern int fraction[MAXTTYPES];        /* percentages of terrain types in world */
extern int unit_hexes[MAXUTYPES];      /* hexes of terrain in world unit can move on */
extern int bw[MAXUTYPES];              /* how much is a unit worth */
extern int bhw[MAXUTYPES][MAXUTYPES];  /* basic worth for hitting */
extern int bcw[MAXUTYPES][MAXUTYPES];  /* basic worth for capturing */
extern int maxoccupant[MAXUTYPES];     /* total capacity of a transport */
extern int ave_build_time[MAXUTYPES];  /* Average length of time to build a unit */
extern int *localworth;                /* for evaluation of nearby hexes */

#ifdef REGIONS
extern short *unit_region[MAXUTYPES];  
     /* Regions a unit within which unit can move */
extern int *unit_region_size[MAXUTYPES];
    /* How many hexes in each region. not necessarily contiguous,
       but decent estimate.  Allows lakes to be spotted. */
extern short num_regions[MAXUTYPES];   /* Number of regions for this unit type */
extern short *units_in_region[MAXUTYPES]; /* Number of units currently in region */
extern long munit_regions;            /* Regions current unit can reach */
typedef struct _coords
{
  int x, y;
} coords;

#endif /* REGIONS */

extern Area *area_info;       /* info about areas, shared for all sides */
#define NUMTOPAREAS 5
extern Area *top_areas[NUMTOPAREAS];       /* Areas requesting the most units. */

extern bool can_move_in_dir[NUMDIRS];  /* directions it make sence to try to move in */

/* Some basic ranges for prioritizing a units tasks. */
#define EXPLORE_VAL 2500
#define FAVORABLE_COMBAT 5000
#define UNFAVORABLE_COMBAT 4000
#define CAPTURE_MAKER 50000
#define CAPTURE_OTHER 20000
#define PATROL_VAL 100
#define HEAD_FOR_GOAL 2300
#define MEET_TRANSPORT 3000

extern int bestworth, bestx, besty;

extern Unit *munit;                    /* Unit being decided about */

extern Side *mside;                    /* Side whose unit is being decided about */
extern bool base_building;             /* true if base building is possible. */

extern int explore_priority, defend_priority, attack_priority;
extern bool worths_known;
extern int route_max_distance;

/* in mvars.c */
extern short areas_wide;      /* number of areas in x direction */
extern short areas_high;      /* number of areas in y direction */
#define area_index(x,y) (((y) / AREA_SIZE) * areas_wide + (x) / AREA_SIZE)

/* in minit.c */
extern void init_mplayers();

/* in mutil.c */
extern char *unit_desig(Unit *unit);
extern bool can_produce(Unit *unit);
extern int unit_strength(int ut);
extern make_unitlists(Side *side);
extern void update_areas(Side *side);
extern void find_border_areas(Side *side);
extern void determine_unit_request(Side *side);
extern void assign_units(Side *side);
extern int fullness(Unit *unit);
extern bool occupant_could_capture(Unit *unit, int etype);
extern bool can_capture_neighbor(Unit *unit);
extern bool occupant_can_capture_neighbor(Unit *unit);
extern bool follow_plan(Unit *unit);
extern bool no_possible_moves(Unit *unit);
extern bool can_move(Unit *unit);
extern int out_of_ammo(Unit *unit);
extern bool good_haven_p(int x, int y);
extern bool haven_p(int x, int y);
extern bool shop_p(int x, int y);
extern int survival_time(Unit *unit);
extern long regions_around(int u, int x, int y, bool center);
extern void free_plan(Mplan *plan);
extern Mplan *find_route(int ut, int maxdist, int fx, int fy, int tx, int ty);
extern bool survive_to_build_base(Unit *unit);
extern bool exact_survive_to_build_base(Unit *unit);
extern bool base_nearby(Unit *unit, int range);
extern bool any_base_nearby(Unit *unit, int range);
extern bool neutral_base_nearby(Unit *unit, int range);
extern int units_nearby(int x, int y, int dist, int type);
extern bool find_closest_unit(int x0, int y0, int maxdist, 
    int (*pred)(), int *rxp, int *ryp);

/* in mproduce.c */
extern bool change_machine_product(Unit *unit);
extern int machine_product(Unit *unit);

/* in mplay.c */
extern void init_machine_turn(Side *side);
extern bool might_be_captured(Unit *unit);
extern void find_worths(int range);
extern void machine_move(Unit *unit);
