/* ConjectureHistoryOverview.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.conjecture.history;

import be.ugent.caagt.swirl.subwindows.Subwindow;

import java.awt.Dimension;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.WindowConstants;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

import org.grinvin.list.ConjectureHistoryListModel;

/**
 * View of the conjecture history
 */
public class ConjectureHistoryOverview extends JPanel implements ListDataListener {
    
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("org.grinvin.conjecture.history.resources");
    
    public static JFrame getView(ConjectureHistoryListModel conjectureHistory){
        JFrame frame = new JFrame(BUNDLE.getString("chistory.overview.title"));
        frame.setContentPane(new JScrollPane(new ConjectureHistoryOverview(conjectureHistory)));
        frame.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
        frame.setPreferredSize(new Dimension(650, 350));
        frame.pack();
        return frame;
    }

    public void intervalAdded(ListDataEvent e) {
        init();
    }

    public void intervalRemoved(ListDataEvent e) {
        init();
    }

    public void contentsChanged(ListDataEvent e) {
        init();
    }
    
    private ConjectureHistoryListModel conjectureHistory;
    
    /**
     * Creates a new instance of ConjectureHistoryOverview
     */
    public ConjectureHistoryOverview(ConjectureHistoryListModel conjectureHistory) {
        super();
        this.conjectureHistory = conjectureHistory;
        conjectureHistory.addListDataListener(this);
        setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
        init();
    }
    
    private synchronized void init() {
        this.removeAll();
        for(int i = 0; i<conjectureHistory.size(); i++)
            add(new Subwindow(conjectureHistory.get(i).getPanel(), i<conjectureHistory.size()-2));
        revalidate();
    }
}
