/* TabbedPaneHelpManager.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.help;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.help.CSH.Manager;
import javax.help.HelpSet;
import javax.swing.JTabbedPane;
import javax.swing.plaf.TabbedPaneUI;

/**
 * Provides dynamic map ID assignment for a JTabbedPane.
 */
public class TabbedPaneHelpManager implements Manager {
    
    private final JTabbedPane pane;
    
    private final Map<Component,String> ids;
    
    /** Creates a new instance of FactoryListHelpManager */
    public TabbedPaneHelpManager(JTabbedPane pane) {
        this.pane = pane;
        ids = new HashMap<Component,String>();
    }
    
    /**
     * Adds the given ID for the given component.
     */
    public void putId(Component comp, String id){
        ids.put(comp, id);
    }
    
    public HelpSet getHelpSet(Object object, AWTEvent aWTEvent) {
        return HelpManager.getHelpSet();
    }
    
    public String getHelpIDString(Object object, AWTEvent aWTEvent) {
        if(object.equals(pane)){
            if(aWTEvent instanceof MouseEvent){
                MouseEvent e = (MouseEvent) aWTEvent;
                Point parentPosition = ((Component)e.getSource()).getLocationOnScreen();
                Point panePosition = pane.getLocationOnScreen();
                e.translatePoint(parentPosition.x - panePosition.x, parentPosition.y - panePosition.y);
                TabbedPaneUI ui = pane.getUI();
                if (ui == null)
                    return null;
                else {
                    int index = ui.tabForCoordinate(pane, e.getX(), e.getY());
                    if (index >= 0)
                        return ids.get(pane.getComponentAt(index));
                    else
                        return null;
                }
            } else if (aWTEvent instanceof ActionEvent) {
                return ids.get(pane.getSelectedComponent());
            } else
                return null;
        } else
            return null;
    }
    
}
