/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant;

import java.io.File;
import java.io.FileFilter;
import org.apache.tools.ant.BuildException;
import org.tigris.subversion.svnant.SvnCommand;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class Ignore
extends SvnCommand {
    private File file = null;
    private boolean failonerror = false;
    private File dir = null;
    private boolean recurse = false;
    private String pattern;
    private ISVNClientAdapter svnClient;

    public void execute(ISVNClientAdapter iSVNClientAdapter) throws BuildException {
        this.svnClient = iSVNClientAdapter;
        this.validateAttributes();
        this.log("Svn : Putting patterns to svn:ignore property :");
        if (this.file != null) {
            this.svnIgnoreFile(this.file);
        }
        if (this.dir != null) {
            this.svnIgnorePattern(this.dir, this.pattern, this.recurse);
        }
    }

    protected void validateAttributes() throws BuildException {
        if (this.file == null && this.dir == null) {
            throw new BuildException("file or dir must be set");
        }
        if (this.dir != null) {
            if (this.file != null) {
                throw new BuildException("file must not be set when dir attribute is present");
            }
            if (this.pattern == null) {
                throw new BuildException("pattern must be set when dir attribute is present");
            }
        }
        if (this.file != null && this.pattern != null) {
            throw new BuildException("pattern must not be set when file attribute is present");
        }
    }

    private void svnIgnoreFile(File file) throws BuildException {
        if (file.exists()) {
            try {
                this.svnClient.addToIgnoredPatterns(file.getParentFile(), file.getName());
            }
            catch (SVNClientException sVNClientException) {
                throw new BuildException("Can't add file " + file.getAbsolutePath() + "to svn:ignore", (Throwable)sVNClientException);
            }
        } else {
            String string = "Warning: Could not find file " + file.getAbsolutePath();
            if (!this.failonerror) {
                this.log(string);
            } else {
                throw new BuildException(string);
            }
        }
    }

    private void svnIgnorePattern(File file, String string, boolean bl) throws BuildException {
        this.svnIgnorePattern(file, string);
        if (bl) {
            File[] fileArray = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() && !file.getName().equals(Ignore.this.svnClient.getAdminDirectoryName());
                }
            });
            for (int i = 0; i < fileArray.length; ++i) {
                this.svnIgnorePattern(fileArray[i], string, true);
            }
        }
    }

    private void svnIgnorePattern(File file, String string) throws BuildException {
        if (file.exists()) {
            if (!file.isDirectory()) {
                this.log("Can't add a pattern to svn:ignore for a file. It needs to be a directory");
            } else {
                try {
                    this.svnClient.addToIgnoredPatterns(file, string);
                }
                catch (SVNClientException sVNClientException) {
                    throw new BuildException("Can't add pattern " + string + " to svn:ignore for " + file.getAbsolutePath(), (Throwable)sVNClientException);
                }
            }
        } else {
            String string2 = "Warning: Could not find directory " + file.getAbsolutePath();
            if (!this.failonerror) {
                this.log(string2);
            } else {
                throw new BuildException(string2);
            }
        }
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setDir(File file) {
        this.dir = file;
    }

    public void setRecurse(boolean bl) {
        this.recurse = bl;
    }

    public void setPattern(String string) {
        this.pattern = string;
    }
}

