/*
 * $Id: SHD_invert.c 35853 2011-03-28 17:08:33Z campbellbarton $
 *
 * ***** BEGIN GPL LICENSE BLOCK *****
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * The Original Code is Copyright (C) 2005 Blender Foundation.
 * All rights reserved.
 *
 * The Original Code is: all of this file.
 *
 * Contributor(s): none yet.
 *
 * ***** END GPL LICENSE BLOCK *****
 */

/** \file blender/nodes/intern/SHD_nodes/SHD_invert.c
 *  \ingroup shdnodes
 */


#include "../SHD_util.h"



/* **************** INVERT ******************** */ 
static bNodeSocketType sh_node_invert_in[]= { 
	{ SOCK_VALUE, 1, "Fac", 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f}, 
	{ SOCK_RGBA, 1, "Color", 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f}, 
	{ -1, 0, "" } 
};

static bNodeSocketType sh_node_invert_out[]= { 
	{ SOCK_RGBA, 0, "Color", 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f}, 
	{ -1, 0, "" } 
};

static void node_shader_exec_invert(void *UNUSED(data), bNode *UNUSED(node), bNodeStack **in, 
bNodeStack **out) 
{
	float col[3], facm;

	col[0] = 1.0f - in[1]->vec[0];
	col[1] = 1.0f - in[1]->vec[1];
	col[2] = 1.0f - in[1]->vec[2];
	
	/* if fac, blend result against original input */
	if (in[0]->vec[0] < 1.0f) {
		facm = 1.0f - in[0]->vec[0];

		col[0] = in[0]->vec[0]*col[0] + (facm*in[1]->vec[0]);
		col[1] = in[0]->vec[0]*col[1] + (facm*in[1]->vec[1]);
		col[2] = in[0]->vec[0]*col[2] + (facm*in[1]->vec[2]);
	}
	
	VECCOPY(out[0]->vec, col);
}

static int gpu_shader_invert(GPUMaterial *mat, bNode *UNUSED(node), GPUNodeStack *in, GPUNodeStack *out)
{
	return GPU_stack_link(mat, "invert", in, out);
}

void register_node_type_sh_invert(ListBase *lb)
{
	static bNodeType ntype;

	node_type_base(&ntype, SH_NODE_INVERT, "Invert", NODE_CLASS_OP_COLOR, NODE_OPTIONS,
		sh_node_invert_in, sh_node_invert_out);
	node_type_size(&ntype, 90, 80, 100);
	node_type_exec(&ntype, node_shader_exec_invert);
	node_type_gpu(&ntype, gpu_shader_invert);

	nodeRegisterType(lb, &ntype);
}


