/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: RecentFileGroup.java,v 1.3 2004/12/12 05:29:29 pietschy Exp $
 */
package org.pietschy.command.demo.file;

import org.pietschy.command.CommandManager;
import org.pietschy.command.file.AbstractRecentFileGroup;

import javax.swing.*;
import java.io.File;

/**
 *
 * @version $Revision: 1.3 $
 * @author andrewp
 */
public class RecentFileGroup
extends AbstractRecentFileGroup
{
   FileDemoPanel fileDemoPanel;

   public RecentFileGroup(CommandManager manager, String id)
   {
      super(manager, id);
   }

   public void
   openFile(File file)
   {
      JOptionPane.showMessageDialog(fileDemoPanel, "You've chosen to re-open \"" + file.getName() + "\"");
   }

   public void
   setFileDemoPanel(FileDemoPanel fileDemoPanel)
   {
      this.fileDemoPanel = fileDemoPanel;
   }
}
