/*
 * Decompiled with CFR 0.152.
 */
package org.boehn.kmlframework.kml;

import java.util.List;
import org.boehn.kmlframework.kml.AltitudeModeEnum;
import org.boehn.kmlframework.kml.Geometry;
import org.boehn.kmlframework.kml.Kml;
import org.boehn.kmlframework.kml.KmlException;
import org.boehn.kmlframework.kml.Point;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineString
extends Geometry {
    private Boolean extrude;
    private Boolean tessellate;
    private AltitudeModeEnum altitudeMode;
    private List<Point> coordinates;

    public LineString() {
    }

    public LineString(Boolean extrude, Boolean tessellate, AltitudeModeEnum altitudeMode, List<Point> coordinates) {
        this.extrude = extrude;
        this.tessellate = tessellate;
        this.altitudeMode = altitudeMode;
        this.coordinates = coordinates;
    }

    public Boolean getExtrude() {
        return this.extrude;
    }

    public void setExtrude(Boolean extrude) {
        this.extrude = extrude;
    }

    public Boolean getTessellate() {
        return this.tessellate;
    }

    public void setTessellate(Boolean tessellate) {
        this.tessellate = tessellate;
    }

    public AltitudeModeEnum getAltitudeMode() {
        return this.altitudeMode;
    }

    public void setAltitudeMode(AltitudeModeEnum altitudeMode) {
        this.altitudeMode = altitudeMode;
    }

    public List<Point> getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(List<Point> coordinates) {
        this.coordinates = coordinates;
    }

    @Override
    public void write(Kml kml) throws KmlException {
        if (this.coordinates == null || this.coordinates.size() < 2) {
            throw new KmlException("LineString must contain at least 2 points");
        }
        kml.println("<LineString" + this.getIdAndTargetIdFormatted(kml) + ">", 1);
        if (this.extrude != null) {
            kml.println("<extrude>" + LineString.booleanToInt(this.extrude) + "</extrude>");
        }
        if (this.tessellate != null) {
            kml.println("<tessellate>" + LineString.booleanToInt(this.tessellate) + "</tessellate>");
        }
        if (this.altitudeMode != null) {
            kml.println("<altitudeMode>" + (Object)((Object)this.altitudeMode) + "</altitudeMode>");
        }
        if (this.coordinates != null) {
            kml.print("<coordinates>");
            boolean firstLoop = true;
            for (Point point : this.coordinates) {
                if (firstLoop) {
                    firstLoop = false;
                } else {
                    kml.print(" ");
                }
                kml.print(point.getLongitudeLatitudeAltitudeString());
            }
            kml.println("</coordinates>");
        }
        kml.println(-1, "</LineString>");
    }

    @Override
    public void writeDelete(Kml kml) throws KmlException {
        kml.println("<LineString" + this.getIdAndTargetIdFormatted(kml) + "></>");
    }
}

