%define name libwpd-bindings
%define version 0.1.0
%define  RELEASE 1
%define  release     %{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}

Name: %{name}
Summary: Language bindings for libwpd library
Version: %{version}
Release: %{release}
Source: %{name}-%{version}.tar.gz
Group: System Environment/Libraries
URL: http://libwpd.sf.net/
BuildRoot: %{_tmppath}/%{name}-%{version}-buildroot
License: LGPL
BuildRequires: libwpd-devel >= 0.9.0, gcc-c++, libstdc++-devel
BuildRequires: swig, mono-core, gcc-java

%description
This package provides language bindings for libwpd library.
Currently supported: Java and C#

%package -n libwpd-java
Summary: Java bindings for libwpd library
Group: Applications/Publishing

%description -n libwpd-java
Java language bindings for libwpd library.

%package -n libwpd-sharp
Summary: C# bindings for libwpd library.
Group: Development/Libraries

%description -n libwpd-sharp
C# language bindings for libwpd library.

%prep
%__rm -rf $RPM_BUILD_ROOT

%setup -q -n %{name}-%{version}

%build
./configure --prefix=%{_prefix} \
	    --libdir=%{_prefix}/%_lib \
	    --libexecdir=%{_prefix}/lib

%__make

%install
umask 022

%__make DESTDIR=$RPM_BUILD_ROOT install
%__rm -rf $RPM_BUILD_ROOT%{_libdir}/*.la

%clean
%__rm -rf $RPM_BUILD_ROOT $RPM_BUILD_DIR/file.list.%{name}

%files -n libwpd-java
%defattr(644,root,root,755)
%{_libdir}/libwpd-java-0.1.so
%{_datadir}/java/wpd-0.1.jar

%files -n libwpd-sharp
%defattr(644,root,root,755)
%{_libdir}/libwpd-sharp-0.1.so
%{_prefix}/lib/mono/*
%{_libdir}/pkgconfig/libwpd-sharp-0.1.pc

%changelog
* Thu Nov  6 2008 Fridrich Strba <fridrich.strba@bluewin.ch>
- initial rpm packate
