/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file XmlViewNodeAttributes.h
    \brief Definition of XmlViewNode Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Thu Jun 16 12:02:55 2011
*/
   

#ifndef XmlViewNodeAttributes_H
#define XmlViewNodeAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "Transformation.h"

namespace magics {

class XmlNode;



class XmlViewNodeAttributes 
{
public:
//  --  constructor
    XmlViewNodeAttributes();
    
//  --  destructor
    virtual ~XmlViewNodeAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const XmlViewNodeAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  If set to cropped, the projection will force a resize of the output to respect the aspect ratio.. Useful in the context of the web..  If set to fitted, the projection willbe expendef to fill the space! a resize of the output to respect the aspect ratio.. Useful in the context of the web.. 
    \param fitted Setting view_fitted_mode - default=off
*/
	void setFitted(string fitted) 
		{ fitted_ =  fitted; } 
	string getFitted() const 
		{ return fitted_; } 
        
/*!
    Magics Information:
    \brief  Projection required(CYLINDRICAL/ POLAR_STEREOGRAPHIC/ MERCATOR/SATELLITE/LAMBERT/AITOFF/OCEAN_SECTION/NONE) 
    \param transformation Setting subpage_map_projection - default=cylindrical
*/
	void setTransformation(Transformation* transformation) 
		{ auto_ptr<Transformation> tmp(transformation); transformation_ = tmp; } 
	const Transformation&  getTransformation() const 
		{ return *transformation_; }
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	string fitted_;
	auto_ptr<Transformation> transformation_;

private:
  
	friend ostream& operator<<(ostream& s,const XmlViewNodeAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
