/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file MetaData.h
    \brief Implementation of the Template class MetaData.
    
    Magics Team - ECMWF 2006
    
    Started: Thu 5-Jan-2006
    
    Changes:
    
*/



#include "MetaData.h"
#include "Timer.h"

using namespace magics;

MetaDataVisitor::MetaDataVisitor() 
{
	meta_.push_back(this);
}


MetaDataVisitor::~MetaDataVisitor() 
{
	meta_.erase(std::remove(meta_.begin(),meta_.end(), this), meta_.end());
}

/*!
 Class information are given to the output-stream.
*/		
void MetaDataVisitor::print(ostream& out)  const
{
	out << "MetaData[";
	out << "]";
}


void MetaDataVisitor::close()
{
	//Log::dev() << " MetaData::write --->  " << meta << " in file[" << path_ << "]" << endl;
	return;
	ofstream out(path_.c_str());
	out << "<metadata>\n";
	for (const_iterator entry = begin(); entry != end(); ++entry)
		out << **entry;
	out << "</metadata>\n";
	out.close();
	
	
}

void MetaDataVisitor::collectMetaData()
{
	Log::dev() << "----MetaData::visit-----" << endl;
	parent_->visit(*this);
	close();
	
	
	try {
	 ofstream out(profile_.c_str());
		
		out << "{\n\"magics timers\" : {" << endl;

		string s = "";
		                    
		for (vector<ProfileInfo>::const_iterator web = Timer::begin(); web != Timer::end(); ++web) {
			out << s;
			out << *web << endl;
			s = ",";
		}
		
		out << "}\n}" << endl;
	}

	catch ( ...) {}
		

	ofstream out(javascript_.c_str());
	
	out        << "{";

	string s = "";
	                    
	for (map<string, string>::const_iterator web = web_.begin(); web != web_.end(); ++web) {		
		out << s;
		out << "\"" << web->first << "\":" <<  web->second;
		s = ",";
	}

	out << "}";
	out.close();
}

void MetaDataVisitor::metadata(map<string, string>& data)
{
    string quote = "\"";
	data["magics_version"] = quote + MAGICS_VERSION + quote;
    data["filename"] = javascript_;
    parent_->visit(*this);
    close();
}

vector<MetaDataVisitor*> MetaDataVisitor::meta_;

void MetaDataVisitor::collect() 
{
	for ( vector<MetaDataVisitor*>::iterator meta = meta_.begin(); meta != meta_.end(); ++meta ) 
		(*meta)->collectMetaData();
}
		

