/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file NetcdfDecoder.h
    \brief Implementation of the Template class NetcdfDecoder.
    
    Magics Team - ECMWF 2004
    
    Started: Tue 17-Feb-2004
    
    Changes:
    
*/



#include "NetcdfDecoder.h"
#include "Factory.h"
#include "Transformation.h"


using namespace magics;

template <class P>
NetcdfDecoder<P>::NetcdfDecoder(): data_(0)
{
}

template <class P>
NetcdfDecoder<P>::~NetcdfDecoder() 
{
}


/*!
 Class information are given to the output-stream.
*/	
template <class P>	
void NetcdfDecoder<P>::print(ostream& out)  const
{
	out << "NetcdfDecoder[";
	NetcdfDecoderAttributes::print(out);
	out << "]";
}
template <class P>	
void NetcdfDecoder<P>::visit(MagnifierVisitor& magnify) 
{
	try {
	vector<PaperPoint> thin;
	vector<PaperPoint> all;
	const Transformation& transformation = magnify.transformation();
	
	
	transformation.thin(matrix(), thin, all);
	
	for (vector<PaperPoint>::iterator point = thin.begin(); point != thin.end(); ++point) {
		 magnify.add(*point);
	}
	for (vector<PaperPoint>::iterator point = all.begin(); point != all.end(); ++point) {
			 magnify.addMore(*point);
	}
	}
	catch (...) {}
	
		 
	
	 
}
template <class P>	
void NetcdfDecoder<P>::visit(MetaDataCollector& collector)
{
	// jsut look for MV_Format
	MetaDataCollector::iterator format = collector.find("MV_Format");
	if ( format != collector.end() ) {
		format->second = "netcdf";
	}
	
	(*interpretor_).visit(collector);
	
}
template <class P>	
void NetcdfDecoder<P>::visit(ValuesCollector& values)
{
	(*interpretor_).visit(values);
}

