/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file ShapeDecoder.cc
    \brief Implementation of the Template class ShapeDecoder.
    
    Magics Team - ECMWF 2005
    
    Started: Mon 12-Dec-2005
    
    Changes:
    
*/



#include "ShapeDecoder.h"
#include "CustomisedPoint.h"
#include "shapefil.h"

using namespace magics;


ShapeDecoder::ShapeDecoder() 
{
}


ShapeDecoder::~ShapeDecoder() 
{
}

/*!
 Class information are given to the output-stream.
*/	
	
void ShapeDecoder::print(ostream& out)  const
{
	out << "ShapeDecoder[";
	out << "]";
}

void ShapeDecoder::decode()
{
	vector<string> all;
	string no;
	decode(no, all);
}

void ShapeDecoder::customisedPoints(const std::set<string>&, CustomisedPointsList& out)
{
	

	try {
		SHPHandle	hSHP;
		DBFHandle   hDBF;  
		char    szTitle[12];

		int     nWidth, nDecimals;
		int		nShapeType, nEntities, i, iPart;
	    double 	adfMinBound[4], adfMaxBound[4];
	    string shp = path_ + ".shp";
	    string dbf = path_ + ".dbf";
	    hSHP = SHPOpen( shp.c_str(), "rb" ); 
	    hDBF = DBFOpen( dbf.c_str(), "rb" );
	    
		SHPGetInfo( hSHP, &nEntities, &nShapeType, adfMinBound, adfMaxBound );
		//cout << dbf << "-------------------->" << endl;
		map<string, int> attributes;
		
		for( i = 0; i < DBFGetFieldCount(hDBF); i++ ) {
		            DBFFieldType    eType;
		            eType = DBFGetFieldInfo( hDBF, i, szTitle, &nWidth, &nDecimals );      
		            attributes.insert(make_pair(szTitle, i));
		 }
		
		string filter = "NAME";
		map<string, int>::iterator index =  filter.empty() ? attributes.end() : attributes.find(filter);
		
		string capital = "FEATURECLA";
		map<string, int>::iterator indexc = attributes.find(capital);;
		vector<string> needs;
	   //needs.push_back("Admin-1 capital");
	    needs.push_back("Admin-0 capital");
		
       
        
		for( i = 0; i < nEntities; i++ )
		    {
			int		j;
		        SHPObject	*psShape;

		        string capital =  DBFReadStringAttribute(hDBF, i, indexc->second);
		
			    bool add =false;
			    for (vector<string>::const_iterator need = needs.begin(); need != needs.end(); ++need) {
			    		if (*need ==  capital ) {
			    				add = true;
			    				break;
			    		}
			    }
			    
			
			    if ( !add )
			    	continue;
			    psShape = SHPReadObject( hSHP, i );
				string name = ( index != attributes.end() ) ? DBFReadStringAttribute(hDBF, i, index->second) : "?";
				 			
					
				if (psShape->nVertices == 1) {

			    
			    
			    	CustomisedPoint* point = new CustomisedPoint();
			    		point->latitude(psShape->padfY[0]);
			    		point->longitude(psShape->padfX[0]);
			    		point->identifier(name);
			    	    out.push_back(point);
			    	   

			    	
			}


			SHPDestroyObject( psShape );
		    }
			
	
		        
		       
		    

		    SHPClose( hSHP );
	
	}
	catch (...)
	{
		Log::error() << "Shape file : can not be opened " << path_ << endl;
	}
	Log::dev() << "Shape file--->" << this->size() << endl; 
}

void ShapeDecoder::decode(const string& filter, const vector<string>& values) 
{
	if ( !this->empty() ) return;
	try {
		SHPHandle	hSHP;
		DBFHandle   hDBF;  
		char    szTitle[12];

		int     nWidth, nDecimals;
		int		nShapeType, nEntities, i, iPart;
	    double 	adfMinBound[4], adfMaxBound[4];
	    string shp = path_ + ".shp";
	    string dbf = path_ + ".dbf";
	    hSHP = SHPOpen( shp.c_str(), "rb" ); 
	    hDBF = DBFOpen( dbf.c_str(), "rb" );
	    
		SHPGetInfo( hSHP, &nEntities, &nShapeType, adfMinBound, adfMaxBound );
		//cout << dbf << "-------------------->" << endl;
		map<string, int> attributes;
		
		for( i = 0; i < DBFGetFieldCount(hDBF); i++ ) {
		            DBFFieldType    eType;
		            eType = DBFGetFieldInfo( hDBF, i, szTitle, &nWidth, &nDecimals );      
		            attributes.insert(make_pair(szTitle, i));
		 }
		
		
		map<string, int>::iterator index =  filter.empty() ? attributes.end() : attributes.find(filter);
		
		
		if ( index == attributes.end() && !filter.empty() ) {
			Log::warning() << "SahepeDecoder: can not find attribute " << filter << endl;
		}
		
       
        
		for( i = 0; i < nEntities; i++ )
		    {
			int		j;
		        SHPObject	*psShape;

			psShape = SHPReadObject( hSHP, i );
		
			bool add = true;
			if 	( index != attributes.end() ) { 
				string s = DBFReadStringAttribute(hDBF, i, index->second);
				add = false;
				for (vector<string>::const_iterator val = values.begin(); val != values.end(); ++val) {
					if (magCompare(*val, s)) {
						add = true;
						break;
					}
				}
					
		    }            
			if ( add)  {
				push_back(new PointsList<GeoPoint>());

					
					

			for( j = 0, iPart = 1; j < psShape->nVertices; j++ )
			{
		                     
			    if( iPart < psShape->nParts
		                && psShape->panPartStart[iPart] == j )
			    {
		                
		                iPart++;
		                
		                push_back(new PointsList<GeoPoint>());
			    }
			    else
			   

			    	this->back()->push_back(GeoPoint(psShape->padfX[j], psShape->padfY[j], i));	
			}

			} 
			SHPDestroyObject( psShape );
		    }
			
	
		        
		       
		    

		    SHPClose( hSHP );
	
	}
	catch (...)
	{
		Log::error() << "Shape file : can not be opened " << path_ << endl;
	}
	Log::dev() << "Shape file--->" << this->size() << endl; 
}


