/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file MgQScene.cc
    \brief Definition of MgQScene
    \author Graphics Section, ECMWF

    Started: June 2010
*/


#include "MgQScene.h"

#include <QDebug>
#include <QGraphicsItem>
#include <QPainter>
#include <QStyleOptionGraphicsItem>

#include "MgQBaseNode.h"

MgQScene::MgQScene(QObject *parent) : QGraphicsScene(parent)
{
	rootNode_=0;

	annotationNode_=new MgQBaseNode("annotation");	
	addItem(annotationNode_);
	//rootNode->setEnabled(false);
	//rootNode->setVisible(false); 
}

MgQScene::~MgQScene()
{
}

void MgQScene::renderContents(QPainter *painter, const QStyleOptionGraphicsItem* option,
			     const QRectF &targetRect, const QRectF &sourceRect,bool renderAllNodes)
{
	//Save painter state
	painter->save();
  
	//Find the ideal x / y scaling ratio to fit \a source into \a target.
    	qreal xratio = targetRect.width() / sourceRect.width();
    	qreal yratio = targetRect.height() / sourceRect.height();
 
	//Keep aspect ratio
	xratio = yratio = qMin(xratio, yratio);

	qDebug() << "CLIPPING " << sourceRect << targetRect;
    	
	//Set clipping
	painter->setClipRect(targetRect);

	//Tranform the painter
	QTransform painterTransform;
	painterTransform *= QTransform()
                        .translate(targetRect.left(), targetRect.top())
                        .scale(xratio, yratio)
                        .translate(-sourceRect.left(), -sourceRect.top());
    	painter->setWorldTransform(painterTransform, true);

	qDebug() << "CLIP TRANSFORMED" << painter->transform().mapRect(sourceRect) << painter->transform().mapRect(targetRect);
	
	if(renderAllNodes)
	{
		renderItemRecursively(annotationNode_,painter,option);
	}
	renderItemRecursively(rootNode_,painter,option);

	painter->restore();
}

void MgQScene::renderContents(QPainter *painter,
			      const QRectF &targetRect, const QRectF &sourceRect)
{
	QStyleOptionGraphicsItem option;
	renderContents(painter,&option,targetRect,sourceRect);
}

void MgQScene::renderItemRecursively(QGraphicsItem* item,QPainter *painter,const QStyleOptionGraphicsItem *option)
{
	//
	if(checkNodeIsVisible(item) == true &&
	   checkNodeType(item,MgQ::PreviewLayoutNode) == false)
	{
		painter->save();
		painter->setTransform(item->sceneTransform(), true);
		item->paint(painter, option, 0);
          	painter->restore();

		foreach(QGraphicsItem *childItem,item->childItems())
		{
			renderItemRecursively(childItem,painter,option);
		}
	}
}


bool MgQScene::checkNodeIsVisible(QGraphicsItem *item)
{
	if(item->data(MgQ::NodeIsVisibleKey).isNull()) 
	{
		return true;
	}
	else	 
	{
	    	return item->data(MgQ::NodeIsVisibleKey).toBool();
	}
}


bool MgQScene::checkNodeType(QGraphicsItem *item,int type)
{
	if(item->data(MgQ::NodeTypeKey).isNull()) 
	{
		return false;
	}
	else	 
	{
	    	return item->data(MgQ::NodeTypeKey).toInt() == type;
	}
}
