/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file AxisMethodAttributes.h
    \brief Definition of AxisMethod Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Thu Jun 16 12:02:58 2011
*/
   

#ifndef AxisMethodAttributes_H
#define AxisMethodAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"



namespace magics {

class XmlNode;



class AxisMethodAttributes 
{
public:
//  --  constructor
    AxisMethodAttributes();
    
//  --  destructor
    virtual ~AxisMethodAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const AxisMethodAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Value at beginning of axis in user units 
    \param min Setting axis_min_value - default=0
*/
	void setMin(double min) 
		{ min_ =  min; } 
	double getMin() const 
		{ return min_; } 
        
/*!
    Magics Information:
    \brief  Value at end of axis in user units 
    \param max Setting axis_max_value - default=0
*/
	void setMax(double max) 
		{ max_ =  max; } 
	double getMax() const 
		{ return max_; } 
        
/*!
    Magics Information:
    \brief  Interval between ticks in user units 
    \param interval Setting axis_tick_interval - default=INT_MAX
*/
	void setInterval(double interval) 
		{ interval_ =  interval; } 
	double getInterval() const 
		{ return interval_; } 
        
/*!
    Magics Information:
    \brief  Number of minor ticks between 2 ticks 
    \param minor_tick_count Setting axis_minor_tick_count - default=4
*/
	void setMinor_tick_count(int minor_tick_count) 
		{ minor_tick_count_ =  minor_tick_count; } 
	int getMinor_tick_count() const 
		{ return minor_tick_count_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	double min_;
	double max_;
	double interval_;
	int minor_tick_count_;

private:
  
	friend ostream& operator<<(ostream& s,const AxisMethodAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
