/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file CoastPlotting.h
    \brief Definition of the Template class CoastPlotting.
    
    Magics Team - ECMWF 2004
    
    Started: Mon 2-Feb-2004
    
    Changes:
    
*/
#ifndef CoastPlotting_H
#define CoastPlotting_H

#include "magics.h"

#include "CoastPlottingAttributes.h"
#include "BasicSceneObject.h"
#include "BasicGraphicsObject.h"
#include "GeoPoint.h"
#include "Factory.h"
#include "Translator.h"

namespace magics {
	
class PreviewVisitor;

class NoCoastPlotting: public CoastPlottingAttributes{
public :
	NoCoastPlotting();
	virtual ~NoCoastPlotting() {}
    
	void set(const XmlNode& node)
	{
		CoastPlottingAttributes::set(node);
	}
	virtual void toxml(ostream& out, int tab) const
	{
		CoastPlottingAttributes::toxml(out, tab);
	}   
	virtual void set(const map<string, string>& map)
	{
		CoastPlottingAttributes::set(map);    
	}
	bool accept(const string& node) { return CoastPlottingAttributes::accept(node); }
	virtual NoCoastPlotting* clone() const
	{
		return new NoCoastPlotting();
	}
	virtual void operator()(DrawingVisitor& parent);
	virtual void operator()(PreviewVisitor&) {}
	virtual void layer(BasicGraphicsObjectContainer*) {}
    
protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream& out) const { out << "NoCoastPlotting\n"; } 
		typedef void (NoCoastPlotting::*Action)(DrawingVisitor&);	
		std::map<string, Action> riversMethods_;
		
		void rivers(DrawingVisitor&);
		void ignore(DrawingVisitor&) {}
		
		void layers(map<string, Action>&, const string&, DrawingVisitor&);
private:
    //! Copy constructor - No copy allowed
	NoCoastPlotting(const NoCoastPlotting&);
    //! Overloaded << operator to copy - No copy allowed
	NoCoastPlotting& operator=(const NoCoastPlotting&);

// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const NoCoastPlotting& p)
		{ p.print(s); return s; }
};

class CoastPlotting: public NoCoastPlotting {

public:
	
	CoastPlotting();
	virtual ~CoastPlotting();

	virtual NoCoastPlotting* clone() const {
		CoastPlotting* object = new CoastPlotting();
		object->copy(*this);
		return object;
	}

	
	
	virtual void operator()(DrawingVisitor&);
	virtual void operator()(PreviewVisitor&);

protected:
	//! Method to print string about this class on to a stream of type ostream (virtual).
	virtual void print(ostream&) const; 
	void prepareGlobal(const Layout&);
	void decode(const Layout&);
	

	
	static string resolution_; 
	static VectorOfPointers<vector<PolyCoast* > > global_;
	static VectorOfPointers<vector<PolyCoast* > > shiftedGlobal_;
	VectorOfPointers<vector<PolyCoast* > >   coastlines_;
};

template <>
class Translator<string, NoCoastPlotting> { 
public:
	NoCoastPlotting* operator()(const string& val )
	{
		return SimpleObjectMaker<NoCoastPlotting>::create(val);
	}     

	NoCoastPlotting* magics(const string& param)
	{
		string val;
		ParameterManager::get(param, val);
		return (*this)(val);
	}
};

} // namespace magics
#endif
