/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file DateAxisAttributes.cc
    \brief Implemtation of DateAxis Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Thu Jun 16 12:02:58 2011
*/    

#include "DateAxisAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "Translator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


DateAxisAttributes::DateAxisAttributes():
	method_(Translator<string, DateAxisMethod>().magics("axis_date_type")),
	date_min_(ParameterManager::getString("axis_date_min_value")),
	date_max_(ParameterManager::getString("axis_date_max_value")),
	reference_(ParameterManager::getString("axis_date_reference")),
	hours_(Translator<string, HourDateAxis>().magics("axis_hours_label")),
	days_(Translator<string, DayDateAxis>().magics("axis_days_label")),
	months_(Translator<string, NoMonthDateAxis>().magics("axis_months_label")),
	years_(Translator<string, YearDateAxis>().magics("axis_years_label"))
{
} 



DateAxisAttributes::~DateAxisAttributes()
{
}

    
void DateAxisAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	prefix[0] = "axis_date";
	prefix[1] = "axis";

	setMember(prefix, "axis_date_type", method_, params);
	setAttribute(prefix, "axis_date_min_value", date_min_, params);
	setAttribute(prefix, "axis_date_max_value", date_max_, params);
	setAttribute(prefix, "axis_date_reference", reference_, params);
	setMember(prefix, "axis_hours_label", hours_, params);
	setMember(prefix, "axis_days_label", days_, params);
	setMember(prefix, "axis_months_label", months_, params);
	setMember(prefix, "axis_years_label", years_, params);
}

void DateAxisAttributes::copy(const DateAxisAttributes& other)
{
	setMethod(other.method_->clone());
	date_min_ = other.date_min_;
	date_max_ = other.date_max_;
	reference_ = other.reference_;
	setHours(other.hours_->clone());
	setDays(other.days_->clone());
	setMonths(other.months_->clone());
	setYears(other.years_->clone());
} 


bool DateAxisAttributes::accept(const string& node)
{	
	if ( magCompare(node, "date")  )
		return true;

	if ( acceptNode(node, method_) )
		return true;

	if ( acceptNode(node, hours_) )
		return true;

	if ( acceptNode(node, days_) )
		return true;

	if ( acceptNode(node, months_) )
		return true;

	if ( acceptNode(node, years_) )
		return true;
	return false;
}

void DateAxisAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "date") )
		set(node.attributes());
	else {
		setMember(node.name(), method_, node);
		setMember(node.name(), hours_, node);
		setMember(node.name(), days_, node);
		setMember(node.name(), months_, node);
		setMember(node.name(), years_, node);
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
		setMember((*elt)->name(), method_, *(*elt)); 
		setMember((*elt)->name(), hours_, *(*elt)); 
		setMember((*elt)->name(), days_, *(*elt)); 
		setMember((*elt)->name(), months_, *(*elt)); 
		setMember((*elt)->name(), years_, *(*elt)); 
	}
}

void DateAxisAttributes::print(ostream& out)  const
{
	out << "DateAxisAttributes[";
	out << "method = " << *method_;
	out << ", date_min = " << date_min_;
	out << ", date_max = " << date_max_;
	out << ", reference = " << reference_;
	out << ", hours = " << *hours_;
	out << ", days = " << *days_;
	out << ", months = " << *months_;
	out << ", years = " << *years_;
	out << "]" << "\n";
}


void DateAxisAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
	string tab;
	for ( int t = 0; t < tabs; t++) tab = tab + "	";
	
	out << tab << "<" << tag << "\n";
	out << tab << "\taxis_date_min_value = \'" << date_min_ << "\'\n";
	out << tab << "\taxis_date_max_value = \'" << date_max_ << "\'\n";
	out << tab << "\taxis_date_reference = \'" << reference_ << "\'\n";
	out << tab << ">";

 	method_->toxml(out, tabs+1);
 	hours_->toxml(out, tabs+1);
 	days_->toxml(out, tabs+1);
 	months_->toxml(out, tabs+1);
 	years_->toxml(out, tabs+1);

	out << tab << "</" << tag << ">\n";
}

static MagicsParameter<string> axis_date_type("axis_date_type", "days", " New Magics: Parameter axis_date_type  sent to new Magics[XYSystem].  ");
static MagicsParameter<string> axis_date_min_value("axis_date_min_value", "undef", " New Magics: Parameter axis_date_min_value sent to new Magics[XYSystem].  ");
static MagicsParameter<string> axis_date_max_value("axis_date_max_value", "undef", " New Magics: Parameter axis_date_max_value sent to new Magics[XYSystem].  ");
static MagicsParameter<string> axis_date_reference("axis_date_reference", "undef", " New Magics: Parameter axis_date_max_value sent to new Magics[XYSystem].  ");
static MagicsParameter<string> axis_hours_label("axis_hours_label", "off", " New Magics: Parameter axis_hours_label sent to new Magics[XYSystem].  ");
static MagicsParameter<string> axis_days_label("axis_days_label", "both", " New Magics: Parameter axis_days_label  sent to new Magics[XYSystem].  ");
static MagicsParameter<string> axis_months_label("axis_months_label", "on", "");
static MagicsParameter<string> axis_years_label("axis_years_label", "on", " New Magics: Parameter axis_years_label  sent to new Magics[XYSystem].  ");
#include "DateAxisMethod.h"
static SimpleObjectMaker<DateHourAxisMethod, DateAxisMethod> hours_DateHourAxisMethod("hours");
static SimpleObjectMaker<DateDayAxisMethod, DateAxisMethod> days_DateDayAxisMethod("days");
static SimpleObjectMaker<DateMonthAxisMethod, DateAxisMethod> months_DateMonthAxisMethod("months");
static SimpleObjectMaker<DateYearAxisMethod, DateAxisMethod> years_DateYearAxisMethod("years");
#include "HourDateAxis.h"
static SimpleObjectMaker<HourDateAxis, HourDateAxis> on_HourDateAxis("on");
static SimpleObjectMaker<HourDateAxis, HourDateAxis> hours_HourDateAxis("hours");
static SimpleObjectMaker<NoHourDateAxis, HourDateAxis> off_NoHourDateAxis("off");
static SimpleObjectMaker<NoHourDateAxis, HourDateAxis> nohours_NoHourDateAxis("nohours");
#include "DayDateAxis.h"
static SimpleObjectMaker<DayDateAxis, DayDateAxis> day_DayDateAxis("day");
static SimpleObjectMaker<NumberDayDateAxis, DayDateAxis> number_NumberDayDateAxis("number");
static SimpleObjectMaker<BothDayDateAxis, DayDateAxis> both_BothDayDateAxis("both");
static SimpleObjectMaker<NoDayDateAxis, DayDateAxis> off_NoDayDateAxis("off");
#include "MonthDateAxis.h"
static SimpleObjectMaker<MonthDateAxis, NoMonthDateAxis> on_MonthDateAxis("on");
static SimpleObjectMaker<MonthDateAxis, NoMonthDateAxis> month_MonthDateAxis("month");
static SimpleObjectMaker<NoMonthDateAxis, NoMonthDateAxis> off_NoMonthDateAxis("off");
static SimpleObjectMaker<NoMonthDateAxis, NoMonthDateAxis> nomonth_NoMonthDateAxis("nomonth");
#include "YearDateAxis.h"
static SimpleObjectMaker<YearDateAxis, YearDateAxis> on_YearDateAxis("on");
static SimpleObjectMaker<YearDateAxis, YearDateAxis> year_YearDateAxis("year");
static SimpleObjectMaker<NoYearDateAxis, YearDateAxis> off_NoYearDateAxis("off");
static SimpleObjectMaker<NoYearDateAxis, YearDateAxis> noyear_NoYearDateAxis("noyear");
