/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file EfiGraphAttributes.cc
    \brief Implemtation of EfiGraph Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Thu Jun 16 12:02:55 2011
*/    

#include "EfiGraphAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "Translator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


EfiGraphAttributes::EfiGraphAttributes():
	box_colour_(Translator<stringarray, stringarray>().magics("efi_box_colour_array")),
	border_colour_(Translator<string, Colour>().magics("efi_box_border_colour")),
	border_thickness_(ParameterManager::getInt("efi_box_border_thickness")),
	border_style_(Translator<string, LineStyle>().magics("efi_box_border_line_style")),
	normal_colour_(Translator<string, Colour>().magics("efi_normal_colour")),
	normal_thickness_(ParameterManager::getInt("efi_normal_thickness")),
	normal_style_(Translator<string, LineStyle>().magics("efi_normal_line_style")),
	font_(ParameterManager::getString("efi_font")),
	font_size_(ParameterManager::getDouble("efi_font_size")),
	font_style_(ParameterManager::getString("efi_font_style")),
	font_colour_(Translator<string, Colour>().magics("efi_font_colour"))
{
} 



EfiGraphAttributes::~EfiGraphAttributes()
{
}

    
void EfiGraphAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	prefix[0] = "efi";

	setAttribute(prefix, "efi_box_colour_array", box_colour_, params);
	setAttribute(prefix, "efi_box_border_colour", border_colour_, params);
	setAttribute(prefix, "efi_box_border_thickness", border_thickness_, params);
	setAttribute(prefix, "efi_box_border_line_style", border_style_, params);
	setAttribute(prefix, "efi_normal_colour", normal_colour_, params);
	setAttribute(prefix, "efi_normal_thickness", normal_thickness_, params);
	setAttribute(prefix, "efi_normal_line_style", normal_style_, params);
	setAttribute(prefix, "efi_font", font_, params);
	setAttribute(prefix, "efi_font_size", font_size_, params);
	setAttribute(prefix, "efi_font_style", font_style_, params);
	setAttribute(prefix, "efi_font_colour", font_colour_, params);
}

void EfiGraphAttributes::copy(const EfiGraphAttributes& other)
{
	box_colour_ = other.box_colour_;
	setBorder_colour(other.border_colour_->clone());
	border_thickness_ = other.border_thickness_;
	border_style_ = other.border_style_;
	setNormal_colour(other.normal_colour_->clone());
	normal_thickness_ = other.normal_thickness_;
	normal_style_ = other.normal_style_;
	font_ = other.font_;
	font_size_ = other.font_size_;
	font_style_ = other.font_style_;
	setFont_colour(other.font_colour_->clone());
} 


bool EfiGraphAttributes::accept(const string& node)
{	
	if ( magCompare(node, "efigraph")  )
		return true;
	return false;
}

void EfiGraphAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "efigraph") )
		set(node.attributes());
	else {
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
	}
}

void EfiGraphAttributes::print(ostream& out)  const
{
	out << "EfiGraphAttributes[";
	out << "box_colour = " << box_colour_;
	out << ", border_colour = " << *border_colour_;
	out << ", border_thickness = " << border_thickness_;
	out << ", border_style = " << border_style_;
	out << ", normal_colour = " << *normal_colour_;
	out << ", normal_thickness = " << normal_thickness_;
	out << ", normal_style = " << normal_style_;
	out << ", font = " << font_;
	out << ", font_size = " << font_size_;
	out << ", font_style = " << font_style_;
	out << ", font_colour = " << *font_colour_;
	out << "]" << "\n";
}


void EfiGraphAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
	string tab;
	for ( int t = 0; t < tabs; t++) tab = tab + "	";
	
	out << tab << "<" << tag << "\n";
	out << tab << "\tefi_box_colour_array = \'" << box_colour_ << "\'\n";
	out << tab << "\tefi_box_border_colour = \'" << *border_colour_ << "\'\n";
	out << tab << "\tefi_box_border_thickness = \'" << border_thickness_ << "\'\n";
	out << tab << "\tefi_box_border_line_style = \'" << border_style_ << "\'\n";
	out << tab << "\tefi_normal_colour = \'" << *normal_colour_ << "\'\n";
	out << tab << "\tefi_normal_thickness = \'" << normal_thickness_ << "\'\n";
	out << tab << "\tefi_normal_line_style = \'" << normal_style_ << "\'\n";
	out << tab << "\tefi_font = \'" << font_ << "\'\n";
	out << tab << "\tefi_font_size = \'" << font_size_ << "\'\n";
	out << tab << "\tefi_font_style = \'" << font_style_ << "\'\n";
	out << tab << "\tefi_font_colour = \'" << *font_colour_ << "\'\n";
	out << tab << ">";


	out << tab << "</" << tag << ">\n";
}

static MagicsParameter<stringarray> efi_box_colour_array("efi_box_colour_array", stringarray(), "");
static MagicsParameter<string> efi_box_border_colour("efi_box_border_colour", "black", "");
static MagicsParameter<int> efi_box_border_thickness("efi_box_border_thickness", 1, "");
static MagicsParameter<string> efi_box_border_line_style("efi_box_border_line_style", "solid", "");
static MagicsParameter<string> efi_normal_colour("efi_normal_colour", "black", "");
static MagicsParameter<int> efi_normal_thickness("efi_normal_thickness", 4, "");
static MagicsParameter<string> efi_normal_line_style("efi_normal_line_style", "solid", "");
static MagicsParameter<string> efi_font("efi_font", "sansserif", "");
static MagicsParameter<double> efi_font_size("efi_font_size", 0.25, "");
static MagicsParameter<string> efi_font_style("efi_font_style", "", "");
static MagicsParameter<string> efi_font_colour("efi_font_colour", "black", "");
