/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file GraphSymbol.h
    \brief Definition of the Template class GraphSymbol.
    
    Magics Team - ECMWF 2005
    
    Started: Tue 6-Dec-2005
    
    Changes:
    
*/

#ifndef GraphSymbol_H
#define GraphSymbol_H

#include "magics.h"
#include "Translator.h"
#include "Factory.h"
#include "PointsHandler.h"
#include "GraphSymbolAttributes.h"

namespace magics {

class GraphSymbol: public GraphSymbolAttributes {

public:
	GraphSymbol();
	virtual ~GraphSymbol();
    
	virtual void set(const XmlNode&)
	{
		Log::dev() << "(const XmlNode&) > to be checked!\n";
	}
	virtual void set(const map<string, string>&)
	{
		Log::dev() << "(const map<string, string&) > to be checked!\n";
	}
	virtual GraphSymbol* clone() const
	{
		Log::dev() << "clone() > to be checked!\n";
		return new GraphSymbol();
	}
    
	virtual void operator()(vector<UserPoint>& data, BasicGraphicsObjectContainer& parent);
	virtual void legend(PaperPoint&, BasicGraphicsObjectContainer&);
    
protected:
	//! Method to print string about this class on to a stream of type ostream (virtual).
	virtual void print(ostream&) const; 

private:
    //! Copy constructor - No copy allowed
	GraphSymbol(const GraphSymbol&);
    //! Overloaded << operator to copy - No copy allowed
	GraphSymbol& operator=(const GraphSymbol&);

// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const GraphSymbol& p)
		{ p.print(s); return s; }
};


class NoGraphSymbol: public GraphSymbol {
public:
	NoGraphSymbol()   {}
	~NoGraphSymbol() {}
	GraphSymbol* clone() const { return new NoGraphSymbol();  }
	
	void operator()(vector<UserPoint>& , BasicGraphicsObjectContainer& ){}
	void legend(PaperPoint&, BasicGraphicsObjectContainer&) {}
};	


template <>
class Translator<string, GraphSymbol> { 
public:
	GraphSymbol* operator()(const string& val )
	{
		return SimpleObjectMaker<GraphSymbol>::create(val);
	}     

	GraphSymbol* magics(const string& param)
	{
		string val;
		ParameterManager::get(param, val);
		return (*this)(val);
	}
};

} // namespace magics
#endif
