/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file MonthDateAxisAttributes.cc
    \brief Implemtation of MonthDateAxis Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Thu Jun 16 12:02:58 2011
*/    

#include "MonthDateAxisAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "Translator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


MonthDateAxisAttributes::MonthDateAxisAttributes():
	colour_(Translator<string, Colour>().magics("axis_months_label_colour")),
	quality_(ParameterManager::getString("axis_months_label_quality")),
	height_(ParameterManager::getDouble("axis_months_label_height")),
	composition_(Translator<string, MonthMethodComposition>().magics("axis_months_label_composition"))
{
} 



MonthDateAxisAttributes::~MonthDateAxisAttributes()
{
}

    
void MonthDateAxisAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	prefix[0] = "axis_months";
	prefix[1] = "axis";

	setAttribute(prefix, "axis_months_label_colour", colour_, params);
	setAttribute(prefix, "axis_months_label_quality", quality_, params);
	setAttribute(prefix, "axis_months_label_height", height_, params);
	setMember(prefix, "axis_months_label_composition", composition_, params);
}

void MonthDateAxisAttributes::copy(const MonthDateAxisAttributes& other)
{
	setColour(other.colour_->clone());
	quality_ = other.quality_;
	height_ = other.height_;
	setComposition(other.composition_->clone());
} 


bool MonthDateAxisAttributes::accept(const string& node)
{	
	if ( magCompare(node, "month")  )
		return true;

	if ( acceptNode(node, composition_) )
		return true;
	return false;
}

void MonthDateAxisAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "month") )
		set(node.attributes());
	else {
		setMember(node.name(), composition_, node);
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
		setMember((*elt)->name(), composition_, *(*elt)); 
	}
}

void MonthDateAxisAttributes::print(ostream& out)  const
{
	out << "MonthDateAxisAttributes[";
	out << "colour = " << *colour_;
	out << ", quality = " << quality_;
	out << ", height = " << height_;
	out << ", composition = " << *composition_;
	out << "]" << "\n";
}


void MonthDateAxisAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
	string tab;
	for ( int t = 0; t < tabs; t++) tab = tab + "	";
	
	out << tab << "<" << tag << "\n";
	out << tab << "\taxis_months_label_colour = \'" << *colour_ << "\'\n";
	out << tab << "\taxis_months_label_quality = \'" << quality_ << "\'\n";
	out << tab << "\taxis_months_label_height = \'" << height_ << "\'\n";
	out << tab << ">";

 	composition_->toxml(out, tabs+1);

	out << tab << "</" << tag << ">\n";
}

static MagicsParameter<string> axis_months_label_colour("axis_months_label_colour", "automatic", " New Magics: Parameter axis_months_label_ colour sent to new Magics[XYSystem].  ");
static MagicsParameter<string> axis_months_label_quality("axis_months_label_quality", "medium", " New Magics: Parameter axis_months_label_quality sent to new Magics[XYSystem].  ");
static MagicsParameter<double> axis_months_label_height("axis_months_label_height", 0.2, " New Magics: Parameter axis_months_label_height sent to new Magics[XYSystem].  ");
static MagicsParameter<string> axis_months_label_composition("axis_months_label_composition", "three", " New Magics: Parameter axis_months_label_composition  sent to new Magics[XYSystem].  ");
#include "MonthMethodComposition.h"
static SimpleObjectMaker<MonthMethodComposition, MonthMethodComposition> three_MonthMethodComposition("three");
static SimpleObjectMaker<MonthMethodComposition, MonthMethodComposition> shortmonth_MonthMethodComposition("shortmonth");
static SimpleObjectMaker<OneMonthMethodComposition, MonthMethodComposition> one_OneMonthMethodComposition("one");
static SimpleObjectMaker<OneMonthMethodComposition, MonthMethodComposition> veryshortmonth_OneMonthMethodComposition("veryshortmonth");
static SimpleObjectMaker<FullMonthMethodComposition, MonthMethodComposition> full_FullMonthMethodComposition("full");
static SimpleObjectMaker<FullMonthMethodComposition, MonthMethodComposition> month_FullMonthMethodComposition("month");
static SimpleObjectMaker<MonthYearMethodComposition, MonthMethodComposition> monthandyear_MonthYearMethodComposition("monthandyear");
