/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file ImportActionAttributes.h
    \brief Definition of ImportAction Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Tue Nov 22 10:53:39 2011
*/
   

#ifndef ImportActionAttributes_H
#define ImportActionAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"



namespace magics {

class XmlNode;



class ImportActionAttributes 
{
public:
//  --  constructor
    ImportActionAttributes();
    
//  --  destructor
    virtual ~ImportActionAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const ImportActionAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief File to import 
    \param path Setting import_file_name - default=
*/
	void setPath(const string& path) 
		{ path_ =  path; } 
	const string& getPath() const 
		{ return path_; } 
        
/*!
    Magics Information:
    \brief Valid Time  
    \param valid_time Setting import_valid_time - default=
*/
	void setValid_time(const string& valid_time) 
		{ valid_time_ =  valid_time; } 
	const string& getValid_time() const 
		{ return valid_time_; } 
        
/*!
    Magics Information:
    \brief Metview info : which service created this image
    \param service Setting service - default=
*/
	void setService(const string& service) 
		{ service_ =  service; } 
	const string& getService() const 
		{ return service_; } 
        
/*!
    Magics Information:
    \brief Metview info : which url created this image : add it in the titles
    \param url Setting url - default=
*/
	void setUrl(const string& url) 
		{ url_ =  url; } 
	const string& getUrl() const 
		{ return url_; } 
        
/*!
    Magics Information:
    \brief Metview info :Short name to be put in the layers!
    \param short_name Setting layers - default=
*/
	void setShort_name(const string& short_name) 
		{ short_name_ =  short_name; } 
	const string& getShort_name() const 
		{ return short_name_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	string path_;
	string valid_time_;
	string service_;
	string url_;
	string short_name_;

private:
  
	friend ostream& operator<<(ostream& s,const ImportActionAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
