# Movable Type (r) Open Source (C) 2005-2008 Six Apart, Ltd.
# This program is distributed under the terms of the
# GNU General Public License, version 2.
#
#
# $Id: fr.pm 2920 2008-08-11 21:43:19Z bchoate $

package MT::L10N::fr;
use strict;
use MT::L10N;
use MT::L10N::en_us;
use vars qw( @ISA %Lexicon );
@ISA = qw( MT::L10N::en_us );

## The following is the translation table.

%Lexicon = (

## php/lib/function.mtassettype.php
	'image' => 'image',
	'Image' => 'Image',
	'file' => 'fichier',
	'File' => 'Fichier',
	'audio' => 'Audio',
	'Audio' => 'Audio',
	'video' => 'Vido',
	'Video' => 'Vido',

## php/lib/function.mtvar.php
	'You used a [_1] tag without a valid name attribute.' => 'Vous avez utilis un tag [_1] sans un attribut de nom valide',
	'\'[_1]\' is not a valid function for a hash.' => '\'[_1]\' n\'est pas une fonction valide pour un hash',
	'\'[_1]\' is not a valid function for an array.' => '\'[_1]\' n\'est pas une fonction valide pour un tableau',
	'[_1] [_2] [_3] is illegal.' => '[_1] [_2] [_3] est illgal.',

## php/lib/function.mtwidgetmanager.php
	'Error: widgetset [_1] is empty.' => 'Erreur: le groupe de widget [_1] est vide.',
	'Error compiling widgetset [_1]' => 'Erreur de compilation du groupe de widget [_1]',

## php/lib/thumbnail_lib.php
	'GD support has not been available. Please install GD support.' => 'Le support GP n\'est pas disponible. Veuillez installer le support GD.',

## php/lib/function.mtcommentauthor.php
	'Anonymous' => 'Anonyme',

## php/lib/archive_lib.php
	'Page' => 'Page',
	'Individual' => 'Individuel',
	'Yearly' => 'Annuelles',
	'Monthly' => 'Mensuelles',
	'Daily' => 'Journalires',
	'Weekly' => 'Hebdomadaires',
	'Author' => 'Par auteurs',
	'(Display Name not set)' => '(Nom pas spcifi)',
	'Author Yearly' => 'Par auteurs et annes',
	'Author Monthly' => 'Par auteurs et mois',
	'Author Daily' => 'Par auteurs et jours',
	'Author Weekly' => 'Par auteurs et semaines',
	'Category Yearly' => 'Par catgories et annes',
	'Category Monthly' => 'Par catgories et mois',
	'Category Daily' => 'Par catgories et jours',
	'Category Weekly' => 'Par catgories et semaines',

## php/lib/block.mtsethashvar.php

## php/lib/block.mtif.php

## php/lib/function.mtremotesigninlink.php
	'TypeKey authentication is not enabled in this blog.  MTRemoteSignInLink can\'t be used.' => 'L\'authentification TypeKey n\'est pas active sur ce blog.  MTRemoteSignInLink ne peut tre utilis.',

## php/lib/block.mtauthorhaspage.php
	'No author available' => 'Il n\'a pas d\'auteurs disponibles',

## php/lib/block.mtauthorhasentry.php

## php/lib/function.mtproductname.php
	'[_1] [_2]' => '[_1] [_2]',

## php/lib/captcha_lib.php
	'Captcha' => 'Captcha',
	'Type the characters you see in the picture above.' => 'Saisissez les caractres que vous voyez dans l\'image ci-dessus.',

## php/lib/function.mtcommentauthorlink.php

## php/lib/MTUtil.php
	'userpic-[_1]-%wx%h%x' => 'userpic-[_1]-%wx%h%x',

## php/lib/function.mtsetvar.php
	'\'[_1]\' is not a hash.' => '\'[_1]\' n\'est pas un hash',
	'Invalid index.' => 'Index invalide',
	'\'[_1]\' is not an array.' => '\'[_1]\' n\'est pas un tableau',
	'\'[_1]\' is not a valid function.' => '\'[_1]\' n\'est pas une fonction valide',

## php/lib/block.mtassets.php
	'sort_by="score" must be used in combination with namespace.' => 'sort_by="score" doit tre utilis en combinaison avec l\'espace de nom.',

## php/lib/block.mtsetvarblock.php

## php/lib/block.mtentries.php

## php/lib/function.mtauthordisplayname.php

## php/lib/function.mtcommentreplytolink.php
	'Reply' => 'Rpondre',

## php/lib/function.mtentryclasslabel.php
	'page' => 'Page',
	'entry' => 'note',
	'Entry' => 'Note',

## php/mt.php.pre
	'Page not found - [_1]' => 'Page non trouve - [_1]',

## default_templates/comment_response.mtml
	'Confirmation...' => 'Confirmation...',
	'Your comment has been submitted!' => 'Votre commentaire a t envoy !',
	'Thank you for commenting.' => 'Merci de votre commentaire.',
	'Your comment has been received and held for approval by the blog owner.' => 'Votre commentaire a t reu et est en attente de validation par le propritaire de ce blog.',
	'Comment Submission Error' => 'Erreur d\'envoi du commentaire',
	'Your comment submission failed for the following reasons: [_1]' => 'La soumission de votre commentaire a chou pour la raison suivante : [_1]',
	'HTML Head' => 'En-tte HTML',
	'Banner Header' => 'Bloc de l\'En-tte',
	'Return to the <a href="[_1]">original entry</a>.' => 'Retourner  la <a href="[_1]">note originale</a>.',
	'Sidebar' => 'Colonne latrale',
	'Banner Footer' => 'Bloc du Pied de page',

## default_templates/notify-entry.mtml
	'A new [lc,_3] entitled \'[_1]\' has been published to [_2].' => 'Une nouvelle [lc,_3] intitule \'[_1]\' a t publie sur [_2].',
	'View entry:' => 'Voir la note :',
	'View page:' => 'Voir la page :',
	'[_1] Title: [_2]' => 'Titre du [_1] : [_2]',
	'Publish Date: [_1]' => 'Date de publication : [_1]',
	'Message from Sender:' => 'Message de l\'expditeur :',
	'You are receiving this email either because you have elected to receive notifications about new content on [_1], or the author of the post thought you would be interested. If you no longer wish to receive these emails, please contact the following person:' => 'Vous recevez cet email car vous avez demand  recevoir les notifications de nouveau contenu sur [_1], ou l\'auteur de la note a pens que vous seriez intress. Si vous ne souhaitez plus recevoir ces emails, merci de contacter la personne suivante:',

## default_templates/main_index.mtml
	'Entry Summary' => 'Rsum de la note',
	'Archives' => 'Archives',

## default_templates/monthly_archive_dropdown.mtml
	'Select a Month...' => 'Slectionnez un Mois...',

## default_templates/page.mtml
	'Trackbacks' => 'Trackbacks',
	'Comments' => 'Commentaires',

## default_templates/entry_summary.mtml
	'By [_1] on [_2]' => 'Par [_1] le [_2]',
	'1 Comment' => '1 Commentaire',
	'# Comments' => '# Commentaires',
	'No Comments' => 'Aucun Commentaire',
	'1 TrackBack' => '1 Trackback',
	'# TrackBacks' => '# Trackbacks',
	'No TrackBacks' => 'Aucun Trackback',
	'Tags' => 'Tags',
	'Continue reading <a href="[_1]" rel="bookmark">[_2]</a>.' => 'Lire la suite de <a href="[_1]" rel="bookmark">[_2]</a>.',

## default_templates/category_archive_list.mtml
	'Categories' => 'Catgories',
	'[_1] ([_2])' => '[_1] ([_2])',

## default_templates/recent_comments.mtml
	'Recent Comments' => 'Commentaires rcents',
	'<strong>[_1]:</strong> [_2] <a href="[_3]" title="full comment on: [_4]">read more</a>' => '<strong>[_1] :</strong> [_2] <a href="[_3]" title="commentaire complet sur : [_4]">lire la suite</a>',

## default_templates/new-ping.mtml
	'An unapproved TrackBack has been posted on your blog [_1], for entry #[_2] ([_3]). You need to approve this TrackBack before it will appear on your site.' => 'Un Trackback non-approuv a t dpos sur votre blog [_1], pour la note #[_2] ([_3]). Vous devez approuver ce Trackback pour qu\'il apparaisse sur votre site.',
	'An unapproved TrackBack has been posted on your blog [_1], for category #[_2], ([_3]). You need to approve this TrackBack before it will appear on your site.' => 'Un Trackback non-approuv a t dpos sur votre blog [_1], pour la catgorie #[_2] ([_3]). Vous devez approuver ce Trackback pour qu\'il apparaisse sur votre site.',
	'A new TrackBack has been posted on your blog [_1], on entry #[_2] ([_3]).' => 'Un nouveau TrackBack a t dpos sur votre blog [_1], pour la note #[_2] ([_3]).',
	'A new TrackBack has been posted on your blog [_1], on category #[_2] ([_3]).' => 'Un nouveau TrackBack a t dpos sur votre blog [_1], pour la catgorie #[_2] ([_3]).',
	'Excerpt' => 'Extrait',
	'URL' => 'URL',
	'Title' => 'Titre',
	'Blog' => 'Blog',
	'IP address' => 'Adresse IP',
	'Approve TrackBack' => 'Approuver le Trackback',
	'View TrackBack' => 'Voir le Trackback',
	'Report TrackBack as spam' => 'Notifier le Trackback comme spam',
	'Edit TrackBack' => 'diter les Trackbacks',

## default_templates/current_author_monthly_archive_list.mtml
	'[_1]: Monthly Archives' => '[_1]: Archives Mensuelles',

## default_templates/main_index_widgets_group.mtml
	'This is a custom set of widgets that are conditioned to only appear on the homepage (or "main_index"). More info: [_1]' => 'Ceci est un groupe de wigets personnalis qui est conditionn pour n\'apparatre que sur la page d\'accueil (ou "main_index"). Plus d\'infos : [_1]',
	'Recent Entries' => 'Notes rcentes',
	'Recent Assets' => 'lments rcents',
	'Tag Cloud' => 'Nuage de tags',

## default_templates/commenter_notify.mtml
	'This email is to notify you that a new user has successfully registered on the blog \'[_1]\'. Listed below you will find some useful information about this new user.' => 'Un nouvel utilisateur s\'est enregistr sur le blog \'[_1]\'. Vous trouverez ci-dessous quelques informations utiles  propos de ce nouvel utilisateur.',
	'New User Information:' => 'Informations concernant ce nouvel utilisateur :',
	'Username: [_1]' => 'Identifiant : [_1]',
	'Full Name: [_1]' => 'Nom complet : [_1]',
	'Email: [_1]' => 'Email : [_1]',
	'To view or edit this user, please click on or cut and paste the following URL into a web browser:' => 'Pour voir ou modifier cet utilisateur, merci de cliquer ou copier-coller l\'adresse suivante dans votre navigateur web:',

## default_templates/footer-email.mtml
	'Powered by Movable Type [_1]' => 'Powered by Movable Type [_1]',

## default_templates/verify-subscribe.mtml
	'Thanks for subscribing to notifications about updates to [_1]. Follow the link below to confirm your subscription:' => 'Merci d\'avoir pour votre inscription aux mises  jours [_1]. Cliquez sur le lien ci-dessous pour confirmer cette inscription :',
	'If the link is not clickable, just copy and paste it into your browser.' => 'Si le lien n\'est pas cliquable, faites simplement un copier-coller dans votre navigateur.',

## default_templates/archive_widgets_group.mtml
	'This is a custom set of widgets that are conditioned to serve different content based upon what type of archive it is included. More info: [_1]' => 'Ceci est un groupe de widgets personnalis qui est conditionn pour afficher un contenu diffrent bas sur le type d\'archives qui est inclue. Plus d\'infos : [_1]',
	'Current Category Monthly Archives' => 'Archives Mensuelles de la Catgorie Courante',
	'Category Archives' => 'Archives par Catgories',
	'Monthly Archives' => 'Archives mensuelles',

## default_templates/technorati_search.mtml
	'Technorati' => 'Technorati',
	'<a href=\'http://www.technorati.com/\'>Technorati</a> search' => 'Recherche <a href=\'http://www.technorati.com/\'>Technorati</a> ',
	'this blog' => 'ce blog',
	'all blogs' => 'tous les blogs',
	'Search' => 'Rechercher',
	'Blogs that link here' => 'Blogs pointant ici',

## default_templates/syndication.mtml
	'Subscribe to feed' => 'S\'abonner au flux',
	'Subscribe to this blog\'s feed' => 'S\'abonner au flux de ce blog',
	'Subscribe to a feed of all future entries tagged &ldquo;[_1]&ldquo;' => 'S\'abonner au flux de toutes les futurs notes taggues &ldquo;[_1]&ldquo;',
	'Subscribe to a feed of all future entries matching &ldquo;[_1]&ldquo;' => 'S\'abonner au flux de toutes les futurs notes contenant &ldquo;[_1]&ldquo;',
	'Feed of results tagged &ldquo;[_1]&ldquo;' => 'Flux des rsultats taggs &ldquo;[_1]&ldquo;',
	'Feed of results matching &ldquo;[_1]&ldquo;' => 'Flux des rsultats pour &ldquo;[_1]&ldquo;',

## default_templates/date_based_author_archives.mtml
	'Author Yearly Archives' => 'Archives Annuelles par Auteurs',
	'Author Monthly Archives' => 'Archives par auteurs et mois',
	'Author Weekly Archives' => 'Archives Hebdomadaires par Auteurs',
	'Author Daily Archives' => 'Archives Quotidiennes par Auteurs',

## default_templates/category_entry_listing.mtml
	'[_1] Archives' => 'Archives [_1]',
	'Recently in <em>[_1]</em> Category' => 'Rcemment dans la catgorie <em>[_1]</em>',
	'Main Index' => 'Index principal',

## default_templates/comment_throttle.mtml
	'If this was a mistake, you can unblock the IP address and allow the visitor to add it again by logging in to your Movable Type installation, going to Blog Config - IP Banning, and deleting the IP address [_1] from the list of banned addresses.' => 'Si c\'tait une erreur, vous pouvez dbloquer l\'adresse IP et autoriser le visiteur  nouveau en vous identifiant dans Movable Type, dans Configuration du Blog - Blocage IP, et en effaant l\'adresse IP [_1] de la liste des adresses bannies.',
	'A visitor to your blog [_1] has automatically been banned by adding more than the allowed number of comments in the last [_2] seconds.' => 'Un visiteur de votre blog [_1] a t automatiquement banni aprs avoir publi une quantit de commentaires suprieure  la limite tablie au cours des [_2] secondes.',
	'This has been done to prevent a malicious script from overwhelming your weblog with comments. The banned IP address is' => 'Cette opration est destine  empcher la publication automatise de commentaires par des scripts. L\'adresse IP bannie est',

## default_templates/current_category_monthly_archive_list.mtml
	'[_1]' => '[_1]',

## default_templates/monthly_archive_list.mtml
	'[_1] <a href="[_2]">Archives</a>' => '<a href="[_2]">Archives</a> [_1]',

## default_templates/new-comment.mtml
	'An unapproved comment has been posted on your blog [_1], for entry #[_2] ([_3]). You need to approve this comment before it will appear on your site.' => 'Un commentaire non approuv a t envoy sur votre blog [_1], pour la note #[_2] ([_3]). Vous devez l\'approuver pour qu\'il apparaisse sur votre blog.',
	'A new comment has been posted on your blog [_1], on entry #[_2] ([_3]).' => 'Un nouveau commentaire a t publi sur votre blog [_1], au sujet de la note [_2] ([_3]). ',
	'Commenter name: [_1]' => 'Nom de l\'auteur de commentaires',
	'Commenter email address: [_1]' => 'Adresse email de l\'auteur de commentaires :  [_1]',
	'Commenter URL: [_1]' => 'URL de l\'auteur de commentaires : [_1]',
	'Commenter IP address: [_1]' => 'Adresse IP de l\'auteur de commentaires : [_1]',
	'Approve comment:' => 'Accepter le commentaire :',
	'View comment:' => 'Voir le commentaire :',
	'Edit comment:' => 'diter le commentaire :',
	'Report comment as spam:' => 'Marquer le commentaire comme tant du spam :',

## default_templates/signin.mtml
	'Sign In' => 'Connexion',
	'You are signed in as ' => 'Vous tes identifi en tant que ',
	'sign out' => 'dconnexion',
	'You do not have permission to sign in to this blog.' => 'Vous n\'avez pas l\'autorisation de vous identifier sur ce blog.',

## default_templates/about_this_page.mtml
	'About this Entry' => ' propos de cette note',
	'About this Archive' => ' propos de cette archive',
	'About Archives' => ' propos des archives',
	'This page contains links to all the archived content.' => 'Cette page contient des liens vers toutes les archives.',
	'This page contains a single entry by [_1] published on <em>[_2]</em>.' => 'Cette page contient une unique note de [_1] publie le <em>[_2]</em>.',
	'<a href="[_1]">[_2]</a> was the previous entry in this blog.' => '<a href="[_1]">[_2]</a> est la note prcdente de ce blog.',
	'<a href="[_1]">[_2]</a> is the next entry in this blog.' => '<a href="[_1]">[_2]</a> est la note suivante de ce blog.',
	'This page is an archive of entries in the <strong>[_1]</strong> category from <strong>[_2]</strong>.' => 'Cette page est une archive des notes dans la catgorie <strong>[_1]</strong> de <strong>[_2]</strong>.',
	'<a href="[_1]">[_2]</a> is the previous archive.' => '<a href="[_1]">[_2]</a> est l\'archive prcdente.',
	'<a href="[_1]">[_2]</a> is the next archive.' => '<a href="[_1]">[_2]</a> est l\'archive suivante.',
	'This page is an archive of recent entries in the <strong>[_1]</strong> category.' => 'Cette page est une archive des notes rcentes dans la catgorie <strong>[_1]</strong>.',
	'<a href="[_1]">[_2]</a> is the previous category.' => '<a href="[_1]">[_2]</a> est la catgorie prcdente.',
	'<a href="[_1]">[_2]</a> is the next category.' => '<a href="[_1]">[_2]</a> est la catgorie suivante.',
	'This page is an archive of recent entries written by <strong>[_1]</strong> in <strong>[_2]</strong>.' => 'Cette page est une archive des notes rcentes crites par <strong>[_1]</strong> dans <strong>[_2]</strong>.',
	'This page is an archive of recent entries written by <strong>[_1]</strong>.' => 'Cette page est une archive des notes rcentes crites par <strong>[_1]</strong>.',
	'This page is an archive of entries from <strong>[_2]</strong> listed from newest to oldest.' => 'Cette page est une archive des notes de <strong>[_2]</strong> listes de la plus rcente  la plus ancienne.',
	'Find recent content on the <a href="[_1]">main index</a>.' => 'Retrouvez le contenu rcent sur <a href="[_1]">l\'index principal</a>.',
	'Find recent content on the <a href="[_1]">main index</a> or look in the <a href="[_2]">archives</a> to find all content.' => 'Retrouvez le contenu rcent sur <a href="[_1]">l\'index principal</a> ou allez dans les <a href="[_2]">archives</a> pour retrouver tout le contenu.',

## default_templates/pages_list.mtml
	'Pages' => 'Pages',

## default_templates/entry.mtml

## default_templates/recover-password.mtml
	'_USAGE_FORGOT_PASSWORD_1' => 'Vous avez demand  rcuprer votre mot de passe Movable Type. Votre mot de passe a t chang au niveau du systme ; le nouveau mot de passe est le suivant:',
	'_USAGE_FORGOT_PASSWORD_2' => 'Ce nouveau mot de passe devrait vous permettre d\'ouvrir une session Movable Type via l\'URL ci-dessous. Vous pourrez changer ce mot de passe une fois la session ouverte.',
	'Mail Footer' => 'Pied des mails',

## default_templates/trackbacks.mtml
	'TrackBack URL: [_1]' => 'URL de Trackback : [_1]',
	'<a href="[_1]">[_2]</a> from [_3] on <a href="[_4]">[_5]</a>' => '<a href="[_1]">[_2]</a> depuis [_3] sur <a href="[_4]">[_5]</a>',
	'[_1] <a href="[_2]">Read More</a>' => '[_1] <a href="[_2]">Lire la suite</a>',

## default_templates/javascript.mtml
	'moments ago' => 'il y a quelques instants',
	'[quant,_1,hour,hours] ago' => 'il y a [quant,_1,heure,heures]',
	'[quant,_1,minute,minutes] ago' => 'il y a [quant,_1,minute,minutes]',
	'[quant,_1,day,days] ago' => 'il y a [quant,_1,jour,jours]',
	'Edit' => 'Editer',
	'Your session has expired. Please sign in again to comment.' => 'Votre session a expir. Veuillez vous identifier  nouveau pour commenter.',
	'Signing in...' => 'Identification ...',
	'You do not have permission to comment on this blog. ([_1]sign out[_2])' => 'Vous n\'avez pas la permission de commenter sur ce blog. ([_1]dconnexion[_2])',
	'Thanks for signing in, __NAME__. ([_1]sign out[_2])' => 'Merci de vous tre identifi(e) en tant que __NAME__. ([_1]fermer la session[_2])',
	'[_1]Sign in[_2] to comment.' => '[_1]Identifiez-vous[_2] pour commenter.',
	'[_1]Sign in[_2] to comment, or comment anonymously.' => '[_1]Identifiez-vous[_2] pour commenter, ou laissez un commentaire anonyme.',
	'Replying to <a href="[_1]" onclick="[_2]">comment from [_3]</a>' => 'En rponse au <a href="[_1]" onclick="[_2]">commentaire de [_3]</a>',

## default_templates/archive_index.mtml
	'Author Archives' => 'Archives par auteurs',
	'Category Monthly Archives' => 'Archives par catgories et mois',

## default_templates/recent_entries.mtml

## default_templates/calendar.mtml
	'Monthly calendar with links to daily posts' => 'Calendrier mensuel avec des liens vers les notes du jour',
	'Sunday' => 'Dimanche',
	'Sun' => 'Dim',
	'Monday' => 'Lundi',
	'Mon' => 'Lun',
	'Tuesday' => 'Mar',
	'Tue' => 'Mar',
	'Wednesday' => 'Mercredi',
	'Wed' => 'Mer',
	'Thursday' => 'Jeudi',
	'Thu' => 'Jeu',
	'Friday' => 'Vendredi',
	'Fri' => 'Ven',
	'Saturday' => 'Samedi',
	'Sat' => 'Sam',

## default_templates/sidebar.mtml
	'2-column layout - Sidebar' => 'Mise en page  2 colonnes - Barre latrale',
	'3-column layout - Primary Sidebar' => 'Mise en page  3 colonnes - Premire barre latrale',
	'3-column layout - Secondary Sidebar' => 'Mise en page  3 colonnes - Seconde barre latrale',

## default_templates/openid.mtml
	'[_1] accepted here' => '[_1] est accept',
	'http://www.sixapart.com/labs/openid/' => 'http://www.sixapart.com/labs/openid/',
	'Learn more about OpenID' => 'Apprenez-en plus  propos d\'OpenID',

## default_templates/creative_commons.mtml
	'This blog is licensed under a <a href="[_1]">Creative Commons License</a>.' => 'Ce blog possde une licence <a href="[_1]">Creative Commons</a>.',

## default_templates/banner_footer.mtml
	'_POWERED_BY' => 'Powered by <a href="http://www.movabletype.org/"><$MTProductName$></a>',

## default_templates/comments.mtml
	'[_1] replied to <a href="[_2]">comment from [_3]</a>' => '[_1] en rponse au <a href="[_2]">commentaire de [_3]</a>',
	'Leave a comment' => 'Laisser un commentaire',
	'Name' => 'Nom',
	'Email Address' => 'Adresse e-mail',
	'Remember personal info?' => 'Mmoriser mes infos personnelles ?',
	'(You may use HTML tags for style)' => '(Vous pouvez utiliser des balises HTML pour le style)',
	'Preview' => 'Aperu',
	'Submit' => 'Envoyer',

## default_templates/monthly_entry_listing.mtml

## default_templates/search_results.mtml
	'Search Results' => 'Rsultats de recherche',
	'Results matching &ldquo;[_1]&rdquo;' => 'Rsultats pour &ldquo;[_1]&rdquo;',
	'Results tagged &ldquo;[_1]&rdquo;' => 'Rsultats tagus &ldquo;[_1]&rdquo;',
	'Previous' => 'Prcdent',
	'Next' => 'Suivant',
	'No results found for &ldquo;[_1]&rdquo;.' => 'Aucun rsultat pour &ldquo;[_1]&rdquo;.',
	'Instructions' => 'Instructions',
	'By default, this search engine looks for all words in any order. To search for an exact phrase, enclose the phrase in quotes:' => 'Par dfaut, ce moteur va rechercher tous les mots, quelque soit leur ordre. Pour lancer une recherche sur une phrase exacte, insrez la phrase entre des apostrophes : ',
	'movable type' => 'movable type',
	'The search engine also supports AND, OR, and NOT keywords to specify boolean expressions:' => 'Le moteur de recherche supporte aussi les mot-cls AND, OR, NOT pour spcifier des expressions boolennes :',
	'personal OR publishing' => 'personnel OR publication',
	'publishing NOT personal' => 'publication NOT personnel',

## default_templates/dynamic_error.mtml
	'Page Not Found' => 'Page Non Trouve',

## default_templates/comment_preview.mtml
	'Previewing your Comment' => 'Aperu de votre commentaire',
	'Replying to comment from [_1]' => 'En rponse au commentaire de [_1]',
	'Cancel' => 'Annuler',

## default_templates/powered_by.mtml
	'_MTCOM_URL' => 'http://www.movabletype.com/',

## default_templates/date_based_category_archives.mtml
	'Category Yearly Archives' => 'Archives Annuelles par Catgories',
	'Category Weekly Archives' => 'Archives Hebdomadaires par Catgories',
	'Category Daily Archives' => 'Archives Quotidiennes par Catgories',

## default_templates/author_archive_list.mtml
	'Authors' => 'Auteurs',

## default_templates/tag_cloud.mtml

## default_templates/recent_assets.mtml

## default_templates/search.mtml
	'Case sensitive' => 'Sensible  la casse',
	'Regex search' => 'Expression rationnelle',

## default_templates/commenter_confirm.mtml
	'Thank you registering for an account to comment on [_1].' => 'Merci de vous tre enregistr pour commenter sur [_1].',
	'For your own security and to prevent fraud, we ask that you please confirm your account and email address before continuing. Once confirmed you will immediately be allowed to comment on [_1].' => 'Pour votre propre scurit et pour viter les fraudes, nous vous demandons de confirmer votre compte et votre adresse email avant de continuer. Vous pourrez ensuite immdiatement commenter sur [_1].',
	'To confirm your account, please click on or cut and paste the following URL into a web browser:' => 'Pour confirmer votre compte, cliquez ou copiez-collez l\'adresse suivante dans un navigateur web:',
	'If you did not make this request, or you don\'t want to register for an account to comment on [_1], then no further action is required.' => 'Si vous n\'tes pas  l\'origine de cette demande, ou si vous ne souhaitez pas vous enregistrer pour commenter sur [_1], alors aucune action n\'est ncessaire.',
	'Thank you very much for your understanding.' => 'Merci beaucoup pour votre comprhension.',
	'Sincerely,' => 'Cordialement,',

## lib/MT/Asset/Image.pm
	'Images' => 'Images',
	'Actual Dimensions' => 'Dimensions relles',
	'[_1] x [_2] pixels' => '[_1] x [_2] pixels',
	'Error cropping image: [_1]' => 'Erreur de rognage de l\'image: [_1]',
	'Error scaling image: [_1]' => 'Erreur lors du redimentionement de l\'image: [_1]',
	'Error converting image: [_1]' => 'Erreur pendant la conversion de l\'image: [_1]',
	'Error creating thumbnail file: [_1]' => 'Erreur lors de la cration de la vignette: [_1]',
	'%f-thumb-%wx%h%x' => '%f-thumb-%wx%h%x',
	'Can\'t load image #[_1]' => 'Impossible de charger l\'image #[_1]',
	'View image' => 'Voir l\'image',
	'Permission denied setting image defaults for blog #[_1]' => 'Autorisation interdite de configurer les paramtres par dfaut des images pour le blog #[_1]',
	'Thumbnail image for [_1]' => 'Miniature de l\'image pour [_1]',
	'Invalid basename \'[_1]\'' => 'Nom de base invalide \'[_1]\'',
	'Error writing to \'[_1]\': [_2]' => 'Erreur \'[_1]\' lors de l\'criture de : [_2]',
	'Popup Page for [_1]' => 'Fentre popup pour [_1]',

## lib/MT/Asset/Video.pm
	'Videos' => 'Vidos',

## lib/MT/Asset/Audio.pm

## lib/MT/Bootstrap.pm
	'Got an error: [_1]' => 'Erreur de type : [_1]',

## lib/MT/Page.pm
	'Folder' => 'Rpertoire',
	'Load of blog failed: [_1]' => 'chec lors du chargement du blog : [_1]',

## lib/MT/BasicAuthor.pm
	'authors' => 'auteurs',

## lib/MT/Placement.pm
	'Category Placement' => 'Gestion des catgories',

## lib/MT/TaskMgr.pm
	'Unable to secure lock for executing system tasks. Make sure your TempDir location ([_1]) is writable.' => 'Impossible d\'assurer le verrouillage pour l\'excution de tches systme. Vrifiez que la zone TempDir ([_1]) est ouverte en criture.',
	'Error during task \'[_1]\': [_2]' => 'Erreur pendant la tche \'[_1]\' : [_2]',
	'Scheduled Tasks Update' => 'Mise  jour des tches planifies',
	'The following tasks were run:' => 'Les tches suivantes ont t excutes :',

## lib/MT/Asset.pm
	'Asset' => 'lment',
	'Assets' => 'lments',
	'Description' => 'Description',
	'Location' => 'Adresse',

## lib/MT/Category.pm
	'Category' => 'Catgorie',
	'Categories must exist within the same blog' => 'Les catgories doivent exister au sein du mme blog ',
	'Category loop detected' => 'Boucle de catgorie dtecte',

## lib/MT/Notification.pm
	'Contact' => 'Contact',
	'Contacts' => 'Contacts',

## lib/MT/Session.pm
	'Session' => 'Session',

## lib/MT/Image.pm
	'Perl module Image::Size is required to determine width and height of uploaded images.' => 'Le module Perl Image::Size est requis pour dterminer la largeur et la hauteur des images tlcharges.',
	'File size exceeds maximum allowed: [_1] > [_2]' => 'La taille du fichier dpasse le maximum autoris: [_1] > [_2]',
	'Can\'t load Image::Magick: [_1]' => 'Impossible de charger Image::Magick : [_1]',
	'Reading file \'[_1]\' failed: [_2]' => 'La lecture du fichier \'[_1]\' a chou : [_2]',
	'Reading image failed: [_1]' => 'chec lors de la lecture de l\'image : [_1]',
	'Scaling to [_1]x[_2] failed: [_3]' => 'La mise  l\'chelle vers [_1]x[_2] a chou : [_3]',
	'Cropping a [_1]x[_1] square at [_2],[_3] failed: [_4]' => 'Rognage d\'un carr [_1]x[_1]  [_2],[_3] chou: [_4]',
	'Converting image to [_1] failed: [_2]' => 'Conversion de l\'image vers [_1] a chou: [_2]',
	'Can\'t load IPC::Run: [_1]' => 'Impossible de charger IPC::Run : [_1]',
	'Unsupported image file type: [_1]' => 'Type de fichier image non support: [_1]',
	'Cropping to [_1]x[_1] failed: [_2]' => 'Rognage vers [_1]x[_1] chou: [_2]',
	'Converting to [_1] failed: [_2]' => 'Conversion vers [_1] a chou: [_2]',
	'You do not have a valid path to the NetPBM tools on your machine.' => 'Votre chemin d\'accs vers les outils NetPBM n\'est pas valide sur votre machine.',
	'Can\'t load GD: [_1]' => 'Impossible de charger GD: [_1]',

## lib/MT/Trackback.pm
	'TrackBack' => 'Trackback',
	'TrackBacks' => 'Trackbacks',

## lib/MT/Util/Archive/Tgz.pm
	'Type must be tgz.' => 'Le type doit tre tgz.',
	'Could not read from filehandle.' => 'Impossible de lire le fichier.',
	'File [_1] is not a tgz file.' => 'Le fichier [_1] n\'est pas un fichier tgz.',
	'File [_1] exists; could not overwrite.' => 'Le fichier [_1] existe; impossible de l\'craser.',
	'Can\'t extract from the object' => 'Impossible d\'extraire l\'objet',
	'Can\'t write to the object' => 'Impossible d\'crire l\'objet',
	'Both data and file name must be specified.' => 'Les donnes et le fichier doivent tre spcifis.',

## lib/MT/Util/Archive/Zip.pm
	'Type must be zip' => 'Le type doit tre zip',
	'File [_1] is not a zip file.' => 'Le fichier [_1] n\'est pas un fichier zip.',

## lib/MT/Util/Archive.pm
	'Type must be specified' => 'Le type doit tre spcifi',
	'Registry could not be loaded' => 'Le registre n\'a pu tre charg',

## lib/MT/Util/Captcha.pm
	'Movable Type default CAPTCHA provider requires Image::Magick.' => 'Le fournisseur de CAPTCHA par dfaut de Movable Type ncessite Image::Magick.',
	'You need to configure CaptchaSourceImageBase.' => 'Vous devez configurer CaptchaSourceImagebase.',
	'Image creation failed.' => 'Cration de l\'image choue.',
	'Image error: [_1]' => 'Erreur image : [_1]',

## lib/MT/Upgrade.pm
	'Comment Posted' => 'Commentaire envoy',
	'Your comment has been posted!' => 'Votre commentaire a t envoy !',
	'Comment Pending' => 'Commentaires en attente',
	'Your comment submission failed for the following reasons:' => 'L\'envoi de votre commentaire a chou pour les raisons suivantes :',
	'[_1]: [_2]' => '[_1]: [_2]',
	'Moving metadata storage for categories...' => 'Dplacement du stockage des mtadonnes pour les catgories en cours...',
	'Upgrading metadata storage for [_1]' => 'Mise  jour du stockage des mtadonnes pour [_1]',
	'Migrating Nofollow plugin settings...' => 'Migration des paramtres du plugin Nofollow...',
	'Updating system search template records...' => 'Mise  jour des donnes du gabarit de recherche du systme...',
	'Custom ([_1])' => '([_1]) personnalis ',
	'This role was generated by Movable Type upon upgrade.' => 'Ce rle a t gnr par Movable Type lors d\'une mise  jour.',
	'Migrating permission records to new structure...' => 'Migration des donnes d\'autorisation vers une nouvelle structure...',
	'Migrating role records to new structure...' => 'Migration des donnes de rle vers la nouvelle structure...',
	'Migrating system level permissions to new structure...' => 'Migration des autorisations pour tout le systme vers la nouvelle structure...',
	'Invalid upgrade function: [_1].' => 'Fonction de mise  jour invalide : [_1].',
	'Error loading class [_1].' => 'Erreur en chargeant la classe [_1].',
	'Creating initial blog and user records...' => 'Cration des donnes initiales du blog et de l\'utilisateur...',
	'Error saving record: [_1].' => 'Erreur de l\'enregistrement des informations : [_1].',
	'First Blog' => 'Premier blog',
	'I just finished installing Movable Type [_1]!' => 'Je viens d\'installer Movable Type [_1]!',
	'Welcome to my new blog powered by Movable Type. This is the first post on my blog and was created for me automatically when I finished the installation process. But that is ok, because I will soon be creating posts of my own!' => 'Bienvenue sur mon nouveau blog anim par Movable Type. Ceci est la premire note de mon blog. Elle a t cre automatiquement lorsque j\'ai termin mon installation. Mais je vais maintenant crer mes propres articles!',
	'Movable Type also created a comment for me as well so that I could see what a comment will look like on my blog once people start submitting comments on all the posts I will write.' => 'Movable Type a aussi cr un commentaire automatiquement pour me permettre de voir  quoi cela ressemblera lorsque mes lecteurs commenteront mes notes.',
	'Blog Administrator' => 'Administrateur du blog',
	'Can administer the blog.' => 'Peut administrer le blog.',
	'Editor' => 'diteur',
	'Can upload files, edit all entries/categories/tags on a blog and publish the blog.' => 'Peut tlcharger des fichiers, diter les notes/catgories/tags sur un blog donn et le republier.',
	'Can create entries, edit their own, upload files and publish.' => 'Peut crer des notes, modifier ses notes, envoyer des fichiers et publier.',
	'Designer' => 'Designer',
	'Can edit, manage and publish blog templates.' => 'Peut diter, grer et republier les templates des blogs.',
	'Webmaster' => 'Webmaster',
	'Can manage pages and publish blog templates.' => 'Peut grer les pages et republier les templates des blogs.',
	'Contributor' => 'Contributeur',
	'Can create entries, edit their own and comment.' => 'Peut crer des notes, modifier ses notes et commenter.',
	'Moderator' => 'Modrateur',
	'Can comment and manage feedback.' => 'Peut commenter et grer les commentaires.',
	'Commenter' => 'Auteur du commentaire',
	'Can comment.' => 'Peut commenter.',
	'Removing Dynamic Site Bootstrapper index template...' => 'Suppression du gabarit index Dynamic Site Bootstrapper',
	'Creating new template: \'[_1]\'.' => 'Cration d\'un nouveau gabarit: \'[_1]\'.',
	'Mapping templates to blog archive types...' => 'Mapping des gabarits vers les archives des blogs...',
	'Renaming PHP plugin file names...' => 'Renommage des noms de fichier des plugins php...',
	'Error renaming PHP files. Please check the Activity Log.' => 'Erreur pendant le renommage des fichiers PHP. Merci de vrifier le journal (logs).',
	'Cannot rename in [_1]: [_2].' => 'Impossible de renommer dans [_1]: [_2].',
	'Removing unnecessary indexes...' => 'Suppression des index non ncessaires...',
	'Upgrading table for [_1] records...' => 'Mise  jour des tables pour [_1] les enregistrements...',
	'Upgrading database from version [_1].' => 'Mise  jour de la Base de donnes de la version [_1].',
	'Database has been upgraded to version [_1].' => 'La base de donnes a t mise  jour version [_1].',
	'User \'[_1]\' upgraded database to version [_2]' => 'L\'utilisateur \'[_1]\' a mis  jour la base de donnes avec la version [_2]',
	'Plugin \'[_1]\' upgraded successfully to version [_2] (schema version [_3]).' => 'Plugin \'[_1]\' mis  jour avec succs  la version [_2] (schma version [_3]).',
	'User \'[_1]\' upgraded plugin \'[_2]\' to version [_3] (schema version [_4]).' => 'Utilisateur \'[_1]\' a mis  jour le plugin \'[_2]\' vers la version [_3] (schma version [_4]).',
	'Plugin \'[_1]\' installed successfully.' => 'Le Plugin \'[_1]\' a t install correctement.',
	'User \'[_1]\' installed plugin \'[_2]\', version [_3] (schema version [_4]).' => 'Utilisateur \'[_1]\' a install le plugin \'[_2]\', version [_3] (schma version [_4]).',
	'Setting your permissions to administrator.' => 'Paramtre des autorisations pour l\'administrateur.',
	'Comment Response' => 'Rponse au commentaire',
	'Creating configuration record.' => 'Cration des infos de configuration.',
	'Creating template maps...' => 'Cration des tables de correspondances de gabarits...',
	'Mapping template ID [_1] to [_2] ([_3]).' => 'Lien du gabarit [_1] vers [_2] ([_3]).',
	'Mapping template ID [_1] to [_2].' => 'Lien du gabarit [_1] vers [_2].',
	'Error loading class: [_1].' => 'Erreur de chargement de classe : [_1].',
	'Error saving [_1] record # [_3]: [_2]... [_4].' => 'Erreur de sauvegarde [_1] enregistrement # [_3]: [_2]... [_4]',
	'Creating entry category placements...' => 'Cration des placements des catgories des notes...',
	'Updating category placements...' => 'Modification des placements de catgories...',
	'Assigning comment/moderation settings...' => 'Mise en place des paramtres commentaire/modration ...',
	'Setting blog basename limits...' => 'Spcification des limites des noms de bases du blog...',
	'Setting default blog file extension...' => 'Ajout de l\'extension de fichier par dfaut du blog...',
	'Updating comment status flags...' => 'Modification des statuts des commentaires...',
	'Updating commenter records...' => 'Modification des donnes des auteurs de commentaires...',
	'Assigning blog administration permissions...' => 'Ajout des autorisations d\'administration du blog...',
	'Setting blog allow pings status...' => 'Mise en place du statut d\'autorisation des pings...',
	'Updating blog comment email requirements...' => 'Mise  jour des prrequis des emails pour les commentaires du blog...',
	'Assigning entry basenames for old entries...' => 'Ajout des racines des notes pour les anciennes notes...',
	'Updating user web services passwords...' => 'Mise  jour des mots de passe des services web d\'utilisateur...',
	'Updating blog old archive link status...' => 'Modification de l\'ancien statut d\'archive du blog...',
	'Updating entry week numbers...' => 'Mise  jour des numros des semaines de la note...',
	'Updating user permissions for editing tags...' => 'Modification des autorisations des utilisateurs pour modifier les balises...',
	'Setting new entry defaults for blogs...' => 'Rglage des valeurs par dfaut des nouvelles notes pour les blogs...',
	'Migrating any "tag" categories to new tags...' => 'Migration des catgories de "tag" vers de nouveaux tags...',
	'Assigning custom dynamic template settings...' => 'Attribution des paramtres spcifiques de gabarits dynamique...',
	'Assigning user types...' => 'Attribution des types d\'utilisateurs...',
	'Assigning category parent fields...' => 'Attribution des champs parents de la catgorie...',
	'Assigning template build dynamic settings...' => 'Attribution des paramtres de construction dynamique du gabarit...',
	'Assigning visible status for comments...' => 'Attribution du statut visible pour les commentaires...',
	'Assigning junk status for comments...' => 'Attribution du statut spam pour les commentaires...',
	'Assigning visible status for TrackBacks...' => 'Attribution du statut visible des trackbacks...',
	'Assigning junk status for TrackBacks...' => 'Attribution du statut spam pour les trackbacks...',
	'Assigning basename for categories...' => 'Attribution de racines aux catgories...',
	'Assigning user status...' => 'Attribution du statut utilisateur...',
	'Migrating permissions to roles...' => 'Migration des autorisations vers les rles...',
	'Populating authored and published dates for entries...' => 'Mise en place des dates de cration et de publication des notes...',
	'Updating widget template records...' => 'Mise  jour des donnes du gabarit de widget...',
	'Classifying category records...' => 'Classement des donnes des catgories...',
	'Classifying entry records...' => 'Classement des donnes des notes...',
	'Merging comment system templates...' => 'Assemblage des gabarits du systme de commentaire...',
	'Populating default file template for templatemaps...' => 'Mise en place du fichier gabarit par dfaut pour les tables de correspondances de gabarits...',
	'Removing unused template maps...' => 'Suppression des tables de correspondances de gabarits non-utiliss...',
	'Assigning user authentication type...' => 'Attribution du type d\'authentification utilisateur...',
	'Adding new feature widget to dashboard...' => 'Ajout du nouveau widget au tableau de bord...',
	'Moving OpenID usernames to external_id fields...' => 'Dplacement des identifiants OpenID vers les champs external_id...',
	'Assigning blog template set...' => 'Attribution du groupe de gabarits de blogs...',
	'Assigning blog page layout...' => 'Attribution de la mise en page du blog...',
	'Assigning author basename...' => 'Attribution du nom de base de l\'auteur...',
	'Assigning entry comment and TrackBack counts...' => 'Attribution des nombres de commentaires et trackbacks...',
	'Assigning embedded flag to asset placements...' => 'Attribution des drapeaux embarqus vers la gestion d\'lments...',
	'Updating template build types...' => 'Mise  jour des types de construction de gabarits...',
	'Replacing file formats to use CategoryLabel tag...' => 'Remplacement des formats de fichiers pour utiliser le tag CategoryLabel...',
	'Assigning all permissions to blog administrator...' => 'Attribution de toutes les permissions  l\'administrateur du blog...',
	'Recover permissions of system administrators...' => 'Rcupration des permissions des administrateurs systme...',

## lib/MT/Core.pm
	'System Administrator' => 'Administrateur Systme',
	'Create Blogs' => 'Crer des blogs',
	'Manage Plugins' => 'Grer les plugins',
	'Manage Templates' => 'Grer les gabarits',
	'View System Activity Log' => 'Afficher le journal (logs) du systme',
	'Configure Blog' => 'Configurer le blog',
	'Set Publishing Paths' => 'Rgler les chemins de publication',
	'Manage Categories' => 'Grer les catgories',
	'Manage Tags' => 'Grer les tags',
	'Manage Address Book' => 'Gestion de l\'annuaire',
	'View Activity Log' => 'Afficher le journal (logs)',
	'Create Entries' => 'Cration d\'une note',
	'Publish Entries' => 'Publier les notes',
	'Send Notifications' => 'Envoyer des notifications',
	'Edit All Entries' => 'diter toutes les entres',
	'Manage Pages' => 'Grer les pages',
	'Publish Blog' => 'Publier le Blog',
	'Upload File' => 'Tlcharger un fichier',
	'Save Image Defaults' => 'Enregistrer les paramtres d\'images par dfaut',
	'Manage Assets' => 'Grer les lements',
	'Post Comments' => 'Commentaires de la note',
	'Manage Feedback' => 'Grer les retours',
	'Error creating performance logs directory, [_1]. Please either change the permissions to make it writable or specify an alternate using the PerformanceLoggingPath configuration directive: [_2]' => 'Erreur dans la cration du rpertoire pour les logs de performance, [_1]. Vous pouvez soit changer ses permissions pour qu\'il soit accessible en criture, soit utiliser la directive de configuration PerformanceLoggingPath: [_2]',
	'Error creating performance logs: PerformanceLoggingPath setting must be a directory path, not a file: [_1]' => 'Erreur dans la cration de logs de performance : PerformanceLoggingPath doit tre un chemin de rpertoire et non un fichier : [_1]',
	'Error creating performance logs: PerformanceLoggingPath directory exists but is not writeable: [_1]' => 'Erreur dans la cration de logs de performance : PerformanceLoggingPath existe mais n\'est pas accessible   l\'criture : [_1]',
	'MySQL Database' => 'Base de donnes MySQL',
	'PostgreSQL Database' => 'Base de donnes PostgreSQL',
	'SQLite Database' => 'Base de donnes SQLite',
	'SQLite Database (v2)' => 'Base de donnes SQLite (v2)',
	'Convert Line Breaks' => 'Conversion retours ligne',
	'Rich Text' => 'Texte Enrichi',
	'Movable Type Default' => 'Valeur par Dfaut Movable Type',
	'weblogs.com' => 'weblogs.com',
	'technorati.com' => 'technorati.com',
	'google.com' => 'google.com',
	'Classic Blog' => 'Blog classique',
	'Publishes content.' => 'Publication de contenu.',
	'Synchronizes content to other server(s).' => 'Synchronise le contenu vers d\'autres serveurs.',
	'zip' => 'zip',
	'tar.gz' => 'tar.gz',
	'Entries List' => 'Liste des notes',
	'Blog URL' => 'URL du blog',
	'Blog ID' => 'ID du blog',
	'Blog Name' => 'Nom du blog',
	'Entry Body' => 'Corps de la note',
	'Entry Excerpt' => 'Extrait de la note',
	'Entry Link' => 'Lien de la note',
	'Entry Extended Text' => 'Texte tendu de la note',
	'Entry Title' => 'Titre de la note',
	'If Block' => 'Bloc If',
	'If/Else Block' => 'Bloc If/Else',
	'Include Template Module' => 'Inclure un module de gabarit',
	'Include Template File' => 'Inclure un fichier de gabarit',
	'Get Variable' => 'Rcuprer la variable',
	'Set Variable' => 'Spcifier la variable',
	'Set Variable Block' => 'Spcifier le bloc de variable',
	'Widget Set' => 'Groupe de widgets',
	'Publish Scheduled Entries' => 'Publier les notes planifies',
	'Junk Folder Expiration' => 'Expiration du rpertoire de spam',
	'Remove Temporary Files' => 'Supprimer les fichiers temporaires',
	'Remove Expired User Sessions' => 'Supprimer les sessions utilisateur expires',
	'Remove Expired Search Caches' => 'Supprimer les caches des recherches expires',

## lib/MT/ArchiveType/AuthorMonthly.pm
	'AUTHOR-MONTHLY_ADV' => 'par auteurs et semaines',
	'author/author-display-name/yyyy/mm/index.html' => 'auteur/auteur-nom-affichage/aaaa/mm/index.html',
	'author/author_display_name/yyyy/mm/index.html' => 'auteur/auteur_nom_affichage/aaaa/mm/index.html',

## lib/MT/ArchiveType/Yearly.pm
	'YEARLY_ADV' => 'annuelles',
	'yyyy/index.html' => 'aaaa/index.html',

## lib/MT/ArchiveType/Page.pm
	'PAGE_ADV' => 'par pages',
	'folder-path/page-basename.html' => 'chemin-repertoire/nomdebase-page.html',
	'folder-path/page-basename/index.html' => 'chemin-repertoire/nomdebase-page/index.html',
	'folder_path/page_basename.html' => 'chemin_repertoire/nomdebase_page.html',
	'folder_path/page_basename/index.html' => 'chemin_repertoire/nomdebase_page/index.html',

## lib/MT/ArchiveType/Category.pm
	'CATEGORY_ADV' => 'par catgories',
	'category/sub-category/index.html' => 'categorie/sous-categorie/index.html',
	'category/sub_category/index.html' => 'categorie/sous_categorie/index.html',

## lib/MT/ArchiveType/CategoryMonthly.pm
	'CATEGORY-MONTHLY_ADV' => 'par catgories et mois',
	'category/sub-category/yyyy/mm/index.html' => 'categorie/sous-categorie/aaaa/mm/index.html',
	'category/sub_category/yyyy/mm/index.html' => 'categorie/sous_categorie/aaaa/mm/index.html',

## lib/MT/ArchiveType/AuthorWeekly.pm
	'AUTHOR-WEEKLY_ADV' => 'par auteurs et annes',
	'author/author-display-name/yyyy/mm/day-week/index.html' => 'auteur/auteur-nom-affichage/aaaa/mm/jour-semaine/index.html',
	'author/author_display_name/yyyy/mm/day-week/index.html' => 'auteur/auteur_nom_affichage/aaaa/mm/jour-semaine/index.html',

## lib/MT/ArchiveType/AuthorDaily.pm
	'AUTHOR-DAILY_ADV' => 'par auteurs et jours',
	'author/author-display-name/yyyy/mm/dd/index.html' => 'auteur/afficher-nom-auteur/aaaa/mm/jj/index.html',
	'author/author_display_name/yyyy/mm/dd/index.html' => 'auteur/afficher_nom_auteur/aaaa/mm/jj/index.html',

## lib/MT/ArchiveType/Individual.pm
	'INDIVIDUAL_ADV' => 'par notes',
	'yyyy/mm/entry-basename.html' => 'aaaa/mm/nomdebase-note.html',
	'yyyy/mm/entry_basename.html' => 'aaaa/mm/nomdebase_note.html',
	'yyyy/mm/entry-basename/index.html' => 'aaaa/mm/nomdebase-note/index.html',
	'yyyy/mm/entry_basename/index.html' => 'aaaa/mm/nomdebase_note/index.html',
	'yyyy/mm/dd/entry-basename.html' => 'aaaa/mm/jj/nomdebase-note.html',
	'yyyy/mm/dd/entry_basename.html' => 'aaaa/mm/jj/nomdebase_note.html',
	'yyyy/mm/dd/entry-basename/index.html' => 'aaaa/mm/jj/nomdebase-note/index.html',
	'yyyy/mm/dd/entry_basename/index.html' => 'aaaa/mm/jj/nomdebase_note/index.html',
	'category/sub-category/entry-basename.html' => 'categorie/sous-categorie/nomdebase-note.html',
	'category/sub-category/entry-basename/index.html' => 'categorie/sous-categorie/nomdebase-note/index.html',
	'category/sub_category/entry_basename.html' => 'categorie/sous_categorie/nomdebase_note.html',
	'category/sub_category/entry_basename/index.html' => 'categorie/sous_categorie/nomdebase_note/index.html',

## lib/MT/ArchiveType/CategoryWeekly.pm
	'CATEGORY-WEEKLY_ADV' => 'par catgories et semaines',
	'category/sub-category/yyyy/mm/day-week/index.html' => 'categorie/sous-categorie/aaaa/mm/jour-semaine/index.html',
	'category/sub_category/yyyy/mm/day-week/index.html' => 'categorie/sous_categorie/aaaa/mm/jour-semaine/index.html',

## lib/MT/ArchiveType/AuthorYearly.pm
	'AUTHOR-YEARLY_ADV' => 'par auteurs et annes',
	'author/author-display-name/yyyy/index.html' => 'auteur/auteur-nom-affichage/aaaa/index.html',
	'author/author_display_name/yyyy/index.html' => 'auteur/auteur_nom_affichage/aaaa/index.html',

## lib/MT/ArchiveType/Monthly.pm
	'MONTHLY_ADV' => 'mensuelles',
	'yyyy/mm/index.html' => 'aaaa/mm/index.html',

## lib/MT/ArchiveType/CategoryDaily.pm
	'CATEGORY-DAILY_ADV' => 'par catgories et jours',
	'category/sub-category/yyyy/mm/dd/index.html' => 'categorie/sous-categorie/aaaa/mm/jj/index.html',
	'category/sub_category/yyyy/mm/dd/index.html' => 'categorie/sous_categorie/aaa/mm/jj/index.html',

## lib/MT/ArchiveType/Weekly.pm
	'WEEKLY_ADV' => 'hebdomadaires',
	'yyyy/mm/day-week/index.html' => 'aaaa/mm/jour-semaine/index.html',

## lib/MT/ArchiveType/Author.pm
	'AUTHOR_ADV' => 'par auteurs',
	'author/author-display-name/index.html' => 'auteur/auteur-nom-affichage/index.html',
	'author/author_display_name/index.html' => 'auteur/auteur_nom_affichage/index.html',

## lib/MT/ArchiveType/Daily.pm
	'DAILY_ADV' => 'journalires',
	'yyyy/mm/dd/index.html' => 'aaaa/mm/jj/index.html',

## lib/MT/ArchiveType/CategoryYearly.pm
	'CATEGORY-YEARLY_ADV' => 'par catgories et annes',
	'category/sub-category/yyyy/index.html' => 'categorie/sous-categorie/aaaa/index.html',
	'category/sub_category/yyyy/index.html' => 'categorie/sous_categorie/aaaa/index.html',

## lib/MT/ObjectTag.pm
	'Tag Placement' => 'Gestion des tags',
	'Tag Placements' => 'Gestions des tags',

## lib/MT/Author.pm
	'User' => 'Utilisateur',
	'Users' => 'Utilisateurs',
	'The approval could not be committed: [_1]' => 'L\'approbation ne peut tre ralise : [_1]',

## lib/MT/ObjectAsset.pm
	'Asset Placement' => 'Gestion des objets',

## lib/MT/XMLRPC.pm
	'No WeblogsPingURL defined in the configuration file' => 'Pas de WeblogsPingURL dfini dans le fichier de configuration',
	'No MTPingURL defined in the configuration file' => 'Pas de MTPingURL dfini dans le fichier de configuration',
	'Can\'t load blog #[_1].' => 'Impossible de charger le blog #[_1].',
	'HTTP error: [_1]' => 'Erreur HTTP: [_1]',
	'Ping error: [_1]' => 'Erreur Ping: [_1]',

## lib/MT/Association.pm
	'Association' => 'Association',
	'Associations' => 'Associations',
	'association' => 'association',
	'associations' => 'associations',

## lib/MT/ConfigMgr.pm
	'Alias for [_1] is looping in the configuration.' => 'L alias pour [_1] fait une boucle dans la configuration ',
	'Error opening file \'[_1]\': [_2]' => 'Erreur lors de l\'ouverture du fichier \'[_1]\': [_2]',
	'Config directive [_1] without value at [_2] line [_3]' => 'Directive de Config  [_1] sans valeur sur [_2] ligne [_3]',
	'No such config variable \'[_1]\'' => 'Pas de variable de Config de ce type \'[_1]\'',

## lib/MT/BackupRestore.pm
	'Backing up [_1] records:' => 'Sauvegarde des enregistrements [_1]:',
	'[_1] records backed up...' => '[_1] enregistrements sauvegards...',
	'[_1] records backed up.' => '[_1] enregistrements sauvegards.',
	'There were no [_1] records to be backed up.' => 'Il n\'y a pas d\'enregistrements [_1]  sauvegarder.',
	'Can\'t open directory \'[_1]\': [_2]' => 'Impossible d\'ouvrir le rpertoire \'[_1]\' : [_2]',
	'No manifest file could be found in your import directory [_1].' => 'Aucun fichier manifest n\'a t trouv dans votre rpertoire d\'import [_1].',
	'Can\'t open [_1].' => 'Impossible d\'ouvrir [_1].',
	'Manifest file [_1] was not a valid Movable Type backup manifest file.' => 'Le fichier manifest [_1] n\'est pas un fichier manifest de sauvegarde Movable Type.',
	'Manifest file: [_1]' => 'Fichier manifest : [_1]',
	'Path was not found for the file ([_1]).' => 'Le chemin n\'a pas t trouv pour le fichier ([_1]).',
	'[_1] is not writable.' => '[_1] non ditable.',
	'Error making path \'[_1]\': [_2]' => 'Erreur dans le chemin \'[_1]\' : [_2]',
	'Copying [_1] to [_2]...' => 'Copie de [_1] vers [_2]...',
	'Failed: ' => 'chec: ',
	'Done.' => 'Termin.',
	'Restoring asset associations ... ( [_1] )' => 'Restauration les associations d\'lments ... ([_1])',
	'Restoring asset associations in entry ... ( [_1] )' => 'Restauration des associations d\'lments dans la note ... ([_1])',
	'Restoring asset associations in page ... ( [_1] )' => 'Restauration des associations d\'lments dans la page... ([_1])',
	'Restoring url of the assets ( [_1] )...' => 'Restauration de l\'url de l\'lment ([_1]) ...',
	'Restoring url of the assets in entry ( [_1] )...' => 'Restauration de l\'url de l\'lment dans la note ([_1]) ...',
	'Restoring url of the assets in page ( [_1] )...' => 'Restauration de l\'url de l\'lment dans la page ([_1]) ...',
	'ID for the file was not set.' => 'L\'ID pour le fichier n\'a pas t spcifi.',
	'The file ([_1]) was not restored.' => 'Le fichier ([_1]) n\'a pas t restaur.',
	'Changing path for the file \'[_1]\' (ID:[_2])...' => 'Changement du chemin du fichier \'[_1]\' (ID:[_2])...',
	'failed' => 'chec',
	'ok' => 'ok',

## lib/MT/TemplateMap.pm
	'Archive Mapping' => 'Table de correspondance des archives',
	'Archive Mappings' => 'Tables de correspondance des archives',

## lib/MT/Plugin/JunkFilter.pm
	'[_1]: [_2][_3] from rule [_4][_5]' => '[_1]: [_2][_3] de la rgle [_4][_5]',
	'[_1]: [_2][_3] from test [_4]' => '[_1]: [_2][_3] du test [_4]',

## lib/MT/Auth/TypeKey.pm
	'Sign in requires a secure signature.' => 'L\'identification ncessite une signature scurise.',
	'The sign-in validation failed.' => 'La validation de l\'enregistrement a chou.',
	'This weblog requires commenters to pass an email address. If you\'d like to do so you may log in again, and give the authentication service permission to pass your email address.' => 'Les auteurs de commentaires de ce blog doivent donner une adresse email. Si vous souhaitez le faire il faut vous enregistrer  nouveau et donner l\'autorisation au systme d\'identification de rcuprer votre adresse email',
	'Couldn\'t save the session' => 'Impossible de sauvegarder la session',
	'Couldn\'t get public key from url provided' => 'Impossible d\'avoir une clef publique',
	'No public key could be found to validate registration.' => 'Aucune cl publique n\'a t trouve pour valider l\'inscription.',
	'TypeKey signature verif\'n returned [_1] in [_2] seconds verifying [_3] with [_4]' => 'La vrification de la signature Typekey retourne [_1] dans [_2] secondes en vrifiant [_3] avec [_4]',
	'The TypeKey signature is out of date ([_1] seconds old). Ensure that your server\'s clock is correct' => 'La signature Typekey est prime depuis ([_1] secondes). Vrifier que votre serveur a une heure correcte',

## lib/MT/Auth/MT.pm
	'Passwords do not match.' => 'Les mots de passe ne sont pas identiques.',
	'Failed to verify current password.' => 'Erreur lors de la vrification du mot de passe.',
	'Password hint is required.' => 'L\'indice de mot de passe est requis.',

## lib/MT/Auth/OpenID.pm
	'Invalid request.' => 'Demande invalide.',
	'The address entered does not appear to be an OpenID' => 'L\'adresse entre ne semble pas tre une adresse OpenID',
	'The text entered does not appear to be a web address' => 'L\'adresse entre ne semble pas tre une adresse de type URL',
	'Unable to connect to [_1]: [_2]' => 'Impossible de se connecter  [_1] : [_2]',
	'Could not verify the OpenID provided: [_1]' => 'La vrification de l\'OpenID entr a chou : [_1]',

## lib/MT/Blog.pm
	'Blogs' => 'Blogs',
	'No default templates were found.' => 'Aucun gabarit par dfaut trouv.',
	'Cloned blog... new id is [_1].' => 'Le nouvel identifiant du blog clon est [_1]',
	'Cloning permissions for blog:' => 'Clonage des autorisations du blog:',
	'[_1] records processed...' => '[_1] enregistrements effectus...',
	'[_1] records processed.' => '[_1] enregistrements effectus.',
	'Cloning associations for blog:' => 'Clonage des associations du blog:',
	'Cloning entries and pages for blog...' => 'Clonage des notes et pages du blog en cours...',
	'Cloning categories for blog...' => 'Clonage des catgories du blog...',
	'Cloning entry placements for blog...' => 'Clonage des placements de notes du blog...',
	'Cloning comments for blog...' => 'Clonage des commentaires de blog...',
	'Cloning entry tags for blog...' => 'Clonage des tags de notes du blog...',
	'Cloning TrackBacks for blog...' => 'Clonage des trackbacks du blog...',
	'Cloning TrackBack pings for blog...' => 'Clonage des pings de trackback du blog...',
	'Cloning templates for blog...' => 'Clonage des gabarits du blog...',
	'Cloning template maps for blog...' => 'Clonage des tables de correspondances de gabarit du blog...',
	'blog' => 'Blog',
	'blogs' => 'Blogs',

## lib/MT/TheSchwartz/ExitStatus.pm
	'Job Exit Status' => 'Statut de fin de tche',

## lib/MT/TheSchwartz/FuncMap.pm
	'Job Function' => 'Fonction Tche',

## lib/MT/TheSchwartz/Error.pm
	'Job Error' => 'Erreur de tche',

## lib/MT/TheSchwartz/Job.pm
	'Job' => 'Tche',

## lib/MT/TBPing.pm
	'Load of blog \'[_1]\' failed: [_2]' => 'Le chargement du blog \'[_1]\' a chou : [_2]',

## lib/MT/Builder.pm
	'<[_1]> at line [_2] is unrecognized.' => '<[_1]>  la ligne [_2] n\'est pas reconnu.',
	'<[_1]> with no </[_1]> on line #' => '<[_1]> sans </[_1]>  la ligne #',
	'<[_1]> with no </[_1]> on line [_2].' => '<[_1]> sans </[_1]>  la ligne [_2].',
	'<[_1]> with no </[_1]> on line [_2]' => '<[_1]> sans </[_1]>  la ligne [_2]',
	'Error in <mt[_1]> tag: [_2]' => 'Erreur dans le tag <mt[_1]> : [_2]',
	'Unknown tag found: [_1]' => 'Un tag inconnu a t trouv : [_1]',

## lib/MT/ObjectDriver/Driver/DBD/SQLite.pm
	'Can\'t open \'[_1]\': [_2]' => 'Impossible d\'ouvrir \'[_1]\' : [_2]',

## lib/MT/CMS/AddressBook.pm
	'No permissions.' => 'Pas d\'autorisations.',
	'No entry ID provided' => 'Aucune ID de note fournie',
	'No such entry \'[_1]\'' => 'Aucune note du type \'[_1]\'',
	'No email address for user \'[_1]\'' => 'L\'utilisateur \'[_1]\' ne possde pas d\'adresse e-mail',
	'No valid recipients found for the entry notification.' => 'Aucun destinataire valide n\'a t trouv pour la notification de cette note.',
	'[_1] Update: [_2]' => '[_1] Mise  jour : [_2]',
	'Error sending mail ([_1]); try another MailTransfer setting?' => 'Erreur lors de l\'envoi de l\'e-mail ([_1]); Essayer avec d\'autres paramtres pour MailTransfer ?',
	'Please select a blog.' => 'Merci de slectionner un blog.',
	'Permission denied.' => 'Autorisation refuse.',
	'The value you entered was not a valid email address' => 'Vous devez saisir une adresse email valide',
	'The e-mail address you entered is already on the Notification List for this blog.' => 'L\'adresse email saisie est dj sur la liste de notification de ce blog.',
	'Subscriber \'[_1]\' (ID:[_2]) deleted from address book by \'[_3]\'' => 'Abonn \'[_1]\' (ID:[_2]) supprim du carnet d\'adresses par \'[_3]\'',

## lib/MT/CMS/Template.pm
	'index' => 'index',
	'archive' => 'archive',
	'module' => 'module',
	'widget' => 'widget',
	'email' => 'Adresse email',
	'system' => 'systme',
	'Templates' => 'Gabarits',
	'One or more errors were found in this template.' => 'Une erreur ou plus ont t trouves dans ce gabarit.',
	'Create template requires type' => 'La cration de gabarits ncessite un type',
	'Archive' => 'Archive',
	'Entry or Page' => 'Note ou Page',
	'New Template' => 'Nouveau gabarit',
	'Index Templates' => 'Gabarits d\'index',
	'Archive Templates' => 'Gabarits d\'archives',
	'Template Modules' => 'Modules de gabarits',
	'System Templates' => 'Gabarits systme',
	'Email Templates' => 'Gabarits email',
	'Template Backups' => 'Sauvegardes de gabarit',
	'Can\'t locate host template to preview module/widget.' => 'Impossible de localiser le gabarit du serveur pour prvisualiser de module/widget.',
	'Publish error: [_1]' => 'Erreur de publication: [_1]',
	'Unable to create preview file in this location: [_1]' => 'Impossible de crer le fichier de pr-visualisation  cet endroit : [_1]',
	'Lorem ipsum' => 'Lorem ipsum',
	'LOREM_IPSUM_TEXT' => 'LOREM_IPSUM_TEXT',
	'LORE_IPSUM_TEXT_MORE' => 'LORE_IPSUM_TEXT_MORE',
	'sample, entry, preview' => 'extrait, note, prvisualisation',
	'No permissions' => 'Aucun droit',
	'Populating blog with default templates failed: [_1]' => 'L\'activation sur le blog des gabarits par dfaut a chou : [_1]',
	'Setting up mappings failed: [_1]' => 'La mise en oeuvre des mappings a chou : [_1]',
	'Saving map failed: [_1]' => 'chec lors du rattachement: [_1]',
	'You should not be able to enter 0 as the time.' => 'Vous ne devriez pas pouvoir saisir 0 comme heure.',
	'You must select at least one event checkbox.' => 'Vous devez slectionner au moins une case  cocher vnement.',
	'Template \'[_1]\' (ID:[_2]) created by \'[_3]\'' => 'Gabarit \'[_1]\' (ID:[_2]) cr par \'[_3]\'',
	'Template \'[_1]\' (ID:[_2]) deleted by \'[_3]\'' => 'Gabarit \'[_1]\' (ID:[_2]) supprim par \'[_3]\'',
	'No Name' => 'Pas de Nom',
	'Orphaned' => 'Orphelin',
	'Global Templates' => 'Gabarits globaux',
	' (Backup from [_1])' => ' (Sauvegarde depuis [_1])',
	'Error creating new template: ' => 'Erreur pendant la cration du nouveau gabarit : ',
	'Skipping template \'[_1]\' since it appears to be a custom template.' => 'Saut du gabarit \'[_1]\' car c\'est un gabarit personnalis.',
	'Refreshing template <strong>[_3]</strong> with <a href="?__mode=view&amp;blog_id=[_1]&amp;_type=template&amp;id=[_2]">backup</a>' => 'Ractualiser les gabarits <strong>[_3]</strong> depuis <a href="?__mode=view&amp;blog_id=[_1]&amp;_type=template&amp;id=[_2]">la sauvegarde</a>',
	'Skipping template \'[_1]\' since it has not been changed.' => 'Saut du gabarit \'[_1]\' car il n\'a pas t modifi',
	'Copy of [_1]' => 'Copie de [_1]',
	'Permission denied: [_1]' => 'Autorisation refuse: [_1]',
	'Save failed: [_1]' => 'chec sauvegarde: [_1]',
	'Invalid ID [_1]' => 'ID invalide [_1]',
	'Saving object failed: [_1]' => 'chec lors de la sauvegarde de l\'objet : [_1]',
	'Load failed: [_1]' => 'chec de chargement : [_1]',
	'(no reason given)' => '(sans raison donne)',
	'Removing [_1] failed: [_2]' => 'Suppression [_1] choue: [_2]',
	'template' => 'gabarit',
	'Restoring widget set [_1]... ' => 'Restauration du set de widget [_1] en cours...',
	'Failed.' => 'Echec.',

## lib/MT/CMS/Search.pm
	'No [_1] were found that match the given criteria.' => 'Aucun [_1] n\'a t trouv correspondant aux critres fournis.',
	'Extended Entry' => 'Suite de la note',
	'Keywords' => 'Mots-cls',
	'Basename' => 'Nom de base',
	'Comment Text' => 'Texte du commentaire',
	'IP Address' => 'Adresse IP',
	'Source URL' => 'URL Source',
	'Page Body' => 'Corps de la page',
	'Extended Page' => 'Page tendue',
	'Template Name' => 'Nom du gabarit',
	'Text' => 'Texte',
	'Linked Filename' => 'Lien du fichier li',
	'Output Filename' => 'Nom du fichier de sortie',
	'Filename' => 'Nom de fichier',
	'Label' => 'Etiquette',
	'Log Message' => 'Message du journal',
	'Username' => 'Nom d\'utilisateur',
	'Display Name' => 'Nom  afficher',
	'Site URL' => 'URL du site',
	'Site Root' => 'Site Racine',
	'Search & Replace' => 'Rechercher et Remplacer',
	'Invalid date(s) specified for date range.' => 'Date(s) incorrecte(s) pour la slection de calendrier.',
	'Error in search expression: [_1]' => 'Erreur dans la recherche de l expression : [_1]',
	'Saving object failed: [_2]' => 'La sauvegarde des objets a chou : [_2]',

## lib/MT/CMS/Import.pm
	'Import/Export' => 'Importer/Exporter',
	'You do not have import permissions' => 'Vous n\'avez pas les droits d\'importation',
	'You do not have permission to create users' => 'Vous n\'avez pas l\'autorisation de crer des utilisateurs',
	'You need to provide a password if you are going to create new users for each user listed in your blog.' => 'Vous devez fournir un mot de passe si vous allez crer de nouveaux utilisateurs pour chaque utilisateur list dans votre blog.',
	'Importer type [_1] was not found.' => 'Type d\'importeur [_1] non trouv.',

## lib/MT/CMS/Folder.pm
	'The folder \'[_1]\' conflicts with another folder. Folders with the same parent must have unique basenames.' => 'Le rpertoire \'[_1]\' est en conflit avec un autre rpertoire. Les rpertoires qui ont le mme rpertoire parent doivent avoir un nom de base unique.',
	'Folder \'[_1]\' created by \'[_2]\'' => 'Rpertoire \'[_1]\' cr par \'[_2]\'',
	'The name \'[_1]\' is too long!' => 'Le nom \'[_1]\' est trop long.',
	'Folder \'[_1]\' (ID:[_2]) deleted by \'[_3]\'' => 'Rpertoire \'[_1]\' (ID:[_2]) supprim par \'[_3]\'',

## lib/MT/CMS/Tag.pm
	'Invalid type' => 'Type incorrect',
	'New name of the tag must be specified.' => 'Le nouveau nom de ce tag doit tre spcifi.',
	'No such tag' => 'Pas de tag de ce type',
	'Error saving entry: [_1]' => 'Erreur d\'enregistrement de la note: [_1]',
	'Error saving file: [_1]' => 'Erreur en sauvegardant le fichier: [_1]',
	'Tag \'[_1]\' (ID:[_2]) deleted by \'[_3]\'' => 'Tag \'[_1]\' (ID:[_2]) supprim par \'[_3]\'',
	'Entries' => 'Notes',

## lib/MT/CMS/Category.pm
	'Subfolder' => 'Sous-rpertoire',
	'Subcategory' => 'Sous-catgorie',
	'Saving [_1] failed: [_2]' => 'Enregistrement de [_1] a chou: [_2]',
	'The [_1] must be given a name!' => 'Le [_1] doit avoir un nom!',
	'Add a [_1]' => 'Ajouter un [_1]',
	'No label' => 'Pas d\'tiquette',
	'Category name cannot be blank.' => 'Le nom de la catgorie ne peut pas tre vide.',
	'The category name \'[_1]\' conflicts with another category. Top-level categories and sub-categories with the same parent must have unique names.' => 'Le nom de catgorie \'[_1]\' est en conflit avec une autre catgorie. Les catgories racines et les sous-catgories qui ont le mme parent doivent avoir des noms uniques.',
	'The category basename \'[_1]\' conflicts with another category. Top-level categories and sub-categories with the same parent must have unique basenames.' => 'Le nom de base de la catgorie \'[_1]\' est en conflit avec une autre catgorie. Les catgories racines et les sous-catgories qui ont le mme parent doivent avoir des noms de base uniques.',
	'Category \'[_1]\' created by \'[_2]\'' => 'Catgorie \'[_1]\' cre par \'[_2]\'',
	'Category \'[_1]\' (ID:[_2]) deleted by \'[_3]\'' => 'Catgorie \'[_1]\' (ID:[_2]) supprime par \'[_3]\'',
	'Saving category failed: [_1]' => 'chec lors de la sauvegarde des catgories : [_1]',

## lib/MT/CMS/TrackBack.pm
	'Junk TrackBacks' => 'Trackbacks spam',
	'TrackBacks where <strong>[_1]</strong> is &quot;[_2]&quot;.' => 'Trackbacks o <strong>[_1]</strong> est &quot;[_2]&quot;.',
	'TrackBack Activity Feed' => 'Flux d\'activit des trackbacks ',
	'(Unlabeled category)' => '(Catgorie sans description)',
	'Ping (ID:[_1]) from \'[_2]\' deleted by \'[_3]\' from category \'[_4]\'' => 'Ping (ID:[_1]) de \'[_2]\' supprim par \'[_3]\' de la catgorie \'[_4]\'',
	'(Untitled entry)' => '(Note sans titre)',
	'Ping (ID:[_1]) from \'[_2]\' deleted by \'[_3]\' from entry \'[_4]\'' => 'Ping (ID:[_1]) de \'[_2]\' supprim par \'[_3]\' de la note \'[_4]\'',
	'No Excerpt' => 'Pas d\'extrait',
	'No Title' => 'Pas de Titre',
	'Orphaned TrackBack' => 'Trackback orphelin',
	'category' => 'catgorie',

## lib/MT/CMS/User.pm
	'Create User' => 'Crer un utilisateur',
	'Can\'t load role #[_1].' => 'Impossible de charger le rle #[_1].',
	'Roles' => 'Rles',
	'Create Role' => 'Crer un rle',
	'(user deleted)' => '(utilisateur effac)',
	'*User deleted*' => '*Utilisateur supprim*',
	'(newly created user)' => '(nouveaux utilisateurs)',
	'User Associations' => 'Associations d\'utilisateur',
	'Role Users & Groups' => 'Rle Utilisateurs et Groupes',
	'(Custom)' => '(Personnalis)',
	'The user' => 'L\'utilisateur',
	'Role name cannot be blank.' => 'Le rle de peu pas tre laiss vierge.',
	'Another role already exists by that name.' => 'Un autre rle existe dj avec ce nom.',
	'You cannot define a role without permissions.' => 'Vous ne pouvez pas dfinir un rle sans autorisations.',
	'General Settings' => 'Paramtres gnraux',
	'Invalid ID given for personal blog clone source ID.' => 'ID invalide fourni pour l\'ID de la source de la duplication du blog personnel.',
	'If personal blog is set, the default site URL and root are required.' => 'Si le blog personnel est activ, l\'URL du site par dfaut et sa racine sont obligatoires.',
	'Select a entry author' => 'Slectionner l\'auteur de la note',
	'Selected author' => 'Auteur slectionn',
	'Type a username to filter the choices below.' => 'Tapez un nom d\'utilisateur pour affiner les choix ci-dessous.',
	'Entry author' => 'Auteur de la note',
	'Select a System Administrator' => 'Slectionner un administrateur systme',
	'Selected System Administrator' => 'Administrateur systme slectionn',
	'represents a user who will be created afterwards' => 'il s\'agit des nouveaux utilisateurs crs plus tard',
	'Select Blogs' => 'Slectionner des blogs',
	'Blogs Selected' => 'Blogs slectionns',
	'Search Blogs' => 'Rechercher des blogs',
	'Select Users' => 'Utilisateurs slectionns',
	'Users Selected' => 'Utilisateurs slectionns',
	'Search Users' => 'Rechercher des utilisateurs',
	'Select Roles' => 'Slectionnez des rles',
	'Role Name' => 'Nom du rle',
	'Roles Selected' => 'Rles slectionns',
	'' => '', # Translate - New
	'Grant Permissions' => 'Ajouter des autorisations',
	'You cannot delete your own association.' => 'Vous ne pouvez pas supprimer votre propre association.',
	'You cannot delete your own user record.' => 'Vous ne pouvez pas effacer vos propres donnes Utilisateur.',
	'You have no permission to delete the user [_1].' => 'Vous n\'avez pas l\'autorisation d\'effacer l\'utilisateur [_1].',
	'User requires username' => 'Un nom d\'utilisateur est ncessaire pour l\'utilisateur',
	'User requires display name' => 'Un nom d\'affichage est ncessaire pour l\'utilisateur',
	'A user with the same name already exists.' => 'Un utilisateur possdant ce nom existe dj.',
	'User requires password' => 'L\'utilisateur a besoin d\'un mot de passe',
	'User requires password recovery word/phrase' => 'L\'utilisateur a besoin d\'une phrase de rcupration de mot de passe',
	'Email Address is required for password recovery' => 'L\'adresse email est ncessaire pour rcuprer le mot de passe',
	'Website URL is invalid' => 'L\'URL du site web n\'est pas valide',
	'User \'[_1]\' (ID:[_2]) created by \'[_3]\'' => 'Utilisateur \'[_1]\' (ID:[_2]) cr par \'[_3]\'',
	'User \'[_1]\' (ID:[_2]) deleted by \'[_3]\'' => 'Utilisateur \'[_1]\' (ID:[_2]) supprim par \'[_3]\'',

## lib/MT/CMS/Asset.pm
	'Files' => 'Fichiers',
	'Can\'t load file #[_1].' => 'Impossible de charger le fichier #[_1].',
	'File \'[_1]\' uploaded by \'[_2]\'' => 'Fichier \'[_1]\' envoy par \'[_2]\'',
	'File \'[_1]\' (ID:[_2]) deleted by \'[_3]\'' => 'Fichier \'[_1]\' (ID:[_2]) supprim par \'[_3]\'',
	'All Assets' => 'Tous les lments',
	'Untitled' => 'Sans nom',
	'Archive Root' => 'Archive Racine',
	'Please select a file to upload.' => 'Merci de slectionner un fichier  envoyer.',
	'Invalid filename \'[_1]\'' => 'Nom de fichier invalide \'[_1]\'',
	'Please select an audio file to upload.' => 'Merci de slectionner un fichier audio  envoyer.',
	'Please select an image to upload.' => 'Merci de slectionner une image  envoyer.',
	'Please select a video to upload.' => 'Merci de slectionner une vido  envoyer.',
	'Before you can upload a file, you need to publish your blog.' => 'Avant de pouvoir envoyer un fichier, vous devez publier votre blog.',
	'Invalid extra path \'[_1]\'' => 'Chemin supplmentaire invalide \'[_1]\'',
	'Can\'t make path \'[_1]\': [_2]' => 'Impossible de crer le chemin \'[_1]\' : [_2]',
	'Invalid temp file name \'[_1]\'' => 'Nom de fichier temporaire invalide \'[_1]\'',
	'Error opening \'[_1]\': [_2]' => 'Erreur lors de l\'ouverture de \'[_1]\' : [_2]',
	'Error deleting \'[_1]\': [_2]' => 'Erreur lors de la suppression de \'[_1]\' : [_2]',
	'File with name \'[_1]\' already exists. (Install File::Temp if you\'d like to be able to overwrite existing uploaded files.)' => 'Le fichier dont le nom est \'[_1]\' existe dj. (Installez File::Temp si vous souhaitez pouvoir craser les fichiers dj chargs.)',
	'Error creating temporary file; please check your TempDir setting in your coniguration file (currently \'[_1]\') this location should be writable.' => 'Erreur lors de la cration du fichier temporaire; merci de vrifier votre rglage TempDir dans votre fichier de configuration (actuellement \'[_1]\') cet endroit doit tre accessible en criture.',
	'unassigned' => 'non assign',
	'File with name \'[_1]\' already exists; Tried to write to tempfile, but open failed: [_2]' => 'Le fichier avec le nom \'[_1]\' existe dj; Tentative d\'criture dans un fichier temporaire, mais l\'ouverture a chou : [_2]',
	'Could not create upload path \'[_1]\': [_2]' => 'Impossible de crer le rpertoire d\'upload \'[_1]\': [_2]',
	'Error writing upload to \'[_1]\': [_2]' => 'Erreur d\'criture lors de l\'envoi de \'[_1]\' : [_2]',
	'<' => '<',
	'/' => '/',

## lib/MT/CMS/Log.pm
	'All Feedback' => 'Tous les retours lecteurs',
	'Publishing' => 'Publication',
	'Activity Log' => 'Journal (logs)',
	'System Activity Feed' => 'Flux d\'activit du systme',
	'Activity log for blog \'[_1]\' (ID:[_2]) reset by \'[_3]\'' => 'Journal (logs) pour le blog \'[_1]\' (ID:[_2]) rinitialis par \'[_3]\'',
	'Activity log reset by \'[_1]\'' => 'Journal (logs) rinitialis par \'[_1]\'',

## lib/MT/CMS/Export.pm
	'You do not have export permissions' => 'Vous n\'avez pas les droits d\'exportation',

## lib/MT/CMS/Blog.pm
	'Publishing Settings' => 'Paramtres de publication',
	'Plugin Settings' => 'Paramtres des plugins',
	'Settings' => 'Paramtres',
	'New Blog' => 'Nouveau Blog',
	'Blog Activity Feed' => 'Flux Activit du Blog',
	'Go Back' => 'Retour',
	'Can\'t load entry #[_1].' => 'Impossible de charger la note #[_1].',
	'Can\'t load template #[_1].' => 'Impossible de charger le gabarit #[_1].',
	'index template \'[_1]\'' => 'gabarit d\'index \'[_1]\'',
	'[_1] \'[_2]\'' => '[_1] \'[_2]\'',
	'Publish Site' => 'Publier le site',
	'Invalid blog' => 'Blog incorrect',
	'Select Blog' => 'Slectionner un blog',
	'Selected Blog' => 'Blog slectionn',
	'Type a blog name to filter the choices below.' => 'Entrez le nom d\'un blog pour affiner les rsultats ci-dessous.',
	'Saving permissions failed: [_1]' => 'chec lors de la sauvegarde des Autorisations : [_1]',
	'Blog \'[_1]\' (ID:[_2]) created by \'[_3]\'' => 'Blog \'[_1]\' (ID:[_2]) cr par \'[_3]\'',
	'You did not specify a blog name.' => 'Vous n\'avez pas spcifi de nom pour le blog.',
	'Site URL must be an absolute URL.' => 'L\'URL du site doit tre une URL absolue.',
	'Archive URL must be an absolute URL.' => 'Les URLs d\'archive doivent tre des URLs absolues.',
	'You did not specify an Archive Root.' => 'Vous n\'avez pas spcifi une archive racine ',
	'Blog \'[_1]\' (ID:[_2]) deleted by \'[_3]\'' => 'Blog \'[_1]\' (ID:[_2]) effac par \'[_3]\'',
	'Saving blog failed: [_1]' => 'chec lors de la sauvegarde du blog : [_1]',
	'Error: Movable Type cannot write to the template cache directory. Please check the permissions for the directory called <code>[_1]</code> underneath your blog directory.' => 'Erreur: Movable Type ne peut pas crire dans le rpertoire de cache de gabarits. Merci de vrifier les autorisations du rpertoire <code>[_1]</code> situ dans le rpertoire du blog.',
	'Error: Movable Type was not able to create a directory to cache your dynamic templates. You should create a directory called <code>[_1]</code> underneath your blog directory.' => 'Erreur: Movable Type n\'a pas pu crer un rpertoire pour cacher vos gabarits dynamiques. Vous devez crer un rpertoire nomm <code>[_1]</code> dans le rpertoire de votre blog.',

## lib/MT/CMS/Dashboard.pm
	'Better, Stronger, Faster' => 'Meilleur, Plus robuste, Plus Rapide',
	'Movable Type has undergone a significant overhaul in all aspects of performance. Memory utilization has been reduced, publishing times have been increased significantly and search is now 100x faster!' => 'Movable Type a subi des changements majeurs concernant ses performances. L\'utilisation de la mmoire a t rduite, les temps de publication sont significativement rduits et la recherche est dsormais 100x plus rapide !', # Translate - New
	'Module Caching' => 'Cache des modules',
	'Template module and widget content can now be cached in the database to dramatically speed up publishing.' => 'Les gabarits de module et de widget peuvent dsormais tre cachs en base de donnes pour amliorer le temps de publication.', # Translate - New
	'Improved Template and Design Management' => 'Gestion du design et des gabarits amliore', # Translate - New
	'The template editing interface has been enhanced to make designers more efficient at updating their site\'s design. The default templates have also been dramatically simplified to make it easier for you to edit and create the site you want.' => 'L\'interface d\'dition des gabarits a t amliore pour permettre aux graphistes d\'tre plus efficace dans la mise  jour du design de leur site. Les gabarits par dfaut ont t grandement simplifis pour vous rendre plus simple l\'dition et la cration d\'un site sur mesure.', # Translate - New
	'Threaded Comments' => 'Commentaires en cascade',
	'Allow commenters on your blog to reply to each other increasing user engagement and creating more dynamic conversations.' => 'Permet  vos commentateurs de se rpondre entre eux pour un engagement accru et des conversations plus dynamiques.',

## lib/MT/CMS/Common.pm
	'Permisison denied.' => 'Autorisation refuse.',
	'The Template Name and Output File fields are required.' => 'Le nom du gabarit et les champs du fichier de sortie sont obligatoires.',
	'Invalid type [_1]' => 'Type invalide [_1]',
	'Invalid parameter' => 'Paramtre invalide',
	'Notification List' => 'Liste de notifications',
	'IP Banning' => 'Bannissement d\'adresses IP',
	'Removing tag failed: [_1]' => 'La suppression du tag a choue: [_1]',
	'You can\'t delete that category because it has sub-categories. Move or delete the sub-categories first if you want to delete this one.' => 'Vous ne pouvez pas effacer cette catgorie car elle contient des sous-catgories. Dplacez ou supprimez d\'abord les sous-catgories puis effacez cette catgorie.',
	'Loading MT::LDAP failed: [_1].' => 'chec de Chargement MT::LDAP[_1]',
	'System templates can not be deleted.' => 'Les gabarits crs par le Systme ne peuvent pas tre supprims.',

## lib/MT/CMS/BanList.pm
	'You did not enter an IP address to ban.' => 'Vous devez saisir une adresse IP  bannir.',
	'The IP you entered is already banned for this blog.' => 'L\'adresse IP saisie est dj bannie pour ce blog.',

## lib/MT/CMS/Plugin.pm
	'Plugin Set: [_1]' => 'ventail de plugins : [_1]',
	'Individual Plugins' => 'Plugins individuels',

## lib/MT/CMS/Tools.pm
	'Password Recovery' => 'Rcupration de mot de passe',
	'That action ([_1]) is apparently not implemented!' => 'Cette action ([_1]) n\'est visiblement pas implmente!',
	'Invalid password recovery attempt; can\'t recover password in this configuration' => 'Tentative de rcupration de mot de passe invalide; impossible de rcuprer le mot de passe dans cette configuration',
	'Invalid author_id' => 'auteur_id incorrect',
	'Backup' => 'Sauvegarder',
	'Backup & Restore' => 'Sauvegarder & Restaurer',
	'Temporary directory needs to be writable for backup to work correctly.  Please check TempDir configuration directive.' => 'Le rpertoire temporaire doit tre autoris en criture pour que la sauvegarde puisse fonctionner. Merci de vrifier la directive de configuration TempDir.',
	'Temporary directory needs to be writable for restore to work correctly.  Please check TempDir configuration directive.' => 'Le rpertoire temporaire doit tre autoris en criture pour que la restauration puisse fonctionner. Merci de vrifier la directive de configuration TempDir.',
	'[_1] is not a number.' => '[_1] n\'est pas un nombre.',
	'Copying file [_1] to [_2] failed: [_3]' => 'La copie du fichier [_1] vers [_2] a chou: [_3]',
	'Specified file was not found.' => 'Le fichier spcifi n\'a pas t trouv.',
	'[_1] successfully downloaded backup file ([_2])' => '[_1] a tlcharg avec succs le fichier de sauvegarde ([_2])',
	'Restore' => 'Restaurer',
	'MT::Asset#[_1]: ' => 'MT::Asset#[_1]: ',
	'Some of the actual files for assets could not be restored.' => 'Certains des fichiers des lments n\'ont pu tre restaurs.',
	'Please use xml, tar.gz, zip, or manifest as a file extension.' => 'Merci d\'utiliser xml, tar.gz, zip, ou manifest comme extension de fichier.',
	'Unknown file format' => 'Format de fichier inconnu',
	'Some objects were not restored because their parent objects were not restored.' => 'Certains objets n\'ont pas t restaurs car leurs objets parents n\'ont pas t restaurs.',
	'Detailed information is in the <a href=\'javascript:void(0)\' onclick=\'closeDialog(\"[_1]\")\'>activity log</a>.' => 'Des informations dtailles se trouvent dans le <a href=\'javascript:void(0)\' onclick=\'closeDialog(\"[_1]\")\'>journal (logs)</a>.',
	'[_1] has canceled the multiple files restore operation prematurely.' => '[_1] a annul prmaturment l\'opration de restauration de plusieurs fichiers.',
	'Changing Site Path for the blog \'[_1]\' (ID:[_2])...' => 'Changement du chemin du site pour le blog \'[_1]\' (ID:[_2])...',
	'Removing Site Path for the blog \'[_1]\' (ID:[_2])...' => 'Suppression du chemin du site pour le blog \'[_1]\' (ID:[_2])...',
	'Changing Archive Path for the blog \'[_1]\' (ID:[_2])...' => 'Changement du chemin d\'archive pour le blog \'[_1]\' (ID:[_2])...',
	'Removing Archive Path for the blog \'[_1]\' (ID:[_2])...' => 'Suppression du chemin d\'archive pour le blog \'[_1]\' (ID:[_2])...',
	'Changing file path for the asset \'[_1]\' (ID:[_2])...' => 'Changement de chemin de fichier pour l\'lment \'[_1]\' (ID:[_2])...',
	'Please upload [_1] in this page.' => 'Merci d\'envoyer [_1] dans cette page.',
	'File was not uploaded.' => 'Le fichier n\'a pas t envoy.',
	'Restoring a file failed: ' => 'chec lors de la restauration d\'un fichier : ',
	'Some of the files were not restored correctly.' => 'Certains fichiers n\'ont pas t restaurs correctement.',
	'Successfully restored objects to Movable Type system by user \'[_1]\'' => 'Restauration avec succs des objets dans Movable Type par utilisateur \'[_1]\'',
	'Can\'t recover password in this configuration' => 'Impossible de rcuprer le mot de passe dans cette configuration',
	'Invalid user name \'[_1]\' in password recovery attempt' => 'Nom d\'utilisateur invalide \'[_1]\' lors de la tentative de rcupration du mot de passe',
	'User name or password hint is incorrect.' => 'Identifiant ou indice du mot de passe incorrect.',
	'User has not set pasword hint; cannot recover password' => 'L\'utilisateur n\'a pas fourni d\'indice de mot de passe; impossible de rcuprer le mot de passe',
	'Invalid attempt to recover password (used hint \'[_1]\')' => 'Tentative invalide de rcupration du mot de passe (indice de \'utilisateur \'[_1]\')',
	'User does not have email address' => 'L\'utilisateur n\'a pas d\'adresse email',
	'Password was reset for user \'[_1]\' (user #[_2]). Password was sent to the following address: [_3]' => 'Le mot de passe a t rinitialis pour l\'utilisateur \'[_1]\' (utilisateur #[_2]). Le mot de passe a t envoy  l\'adresse suivante: [_3]',
	'Error sending mail ([_1]); please fix the problem, then try again to recover your password.' => 'Erreur d\'envoi du mail ([_1]); merci de corriger le problme, puis essayez  nouveau de rcuprer votre mot de passe.',
	'Some objects were not restored because their parent objects were not restored.  Detailed information is in the <a href="javascript:void(0);" onclick="closeDialog(\'[_1]\');">activity log</a>.' => 'Certains objets n\'ont pas t restaurs car leurs objets parents n\'ont pas t restaurs. Des informations dtailles se trouvent dans le <a href="javascript:void(0);" onclick="closeDialog(\'[_1]\');">journal d\'activit</a>.',
	'[_1] is not a directory.' => '[_1] n\'est pas un rpertoire.',
	'Error occured during restore process.' => 'Une erreur s\'est produite pendant la procdure de restauration.',
	'Some of files could not be restored.' => 'Certains fichiers n\'ont pu tre restaurs.',
	'Uploaded file was not a valid Movable Type backup manifest file.' => 'Le fichier envoy n\'tait pas un fichier de sauvegarde manifest Movable Type valide.',
	'Blog(s) (ID:[_1]) was/were successfully backed up by user \'[_2]\'' => 'Blog(s) (ID:[_1]) a/ont t sauvegard(s) avec succs par l\'utilisateur \'[_2]\'',
	'Movable Type system was successfully backed up by user \'[_1]\'' => 'Movable Type a t sauvegard avec succs par l\'utilisateur \'[_1]\'',
	'Some [_1] were not restored because their parent objects were not restored.' => 'Certains [_1] n\'ont pas t restaurs car leurs objets parents n\'ont pas t restaurs.',

## lib/MT/CMS/Entry.pm
	'(untitled)' => '(sans titre)',
	'New Entry' => 'Nouvelle note',
	'New Page' => 'Nouvelle Page',
	'None' => 'Aucune',
	'pages' => 'Pages',
	'Tag' => 'Tag',
	'Entry Status' => 'Statut par dfaut',
	'[_1] Feed' => 'Flux [_1]',
	'Can\'t load template.' => 'Impossible de charger le gabarit',
	'New [_1]' => 'Nouveau [_1]',
	'No such [_1].' => 'Pas de [_1].',
	'Same Basename has already been used. You should use an unique basename.' => 'Ce nom de base est dj utilis. Vous devriez choisir un nom de base unique.',
	'Your blog has not been configured with a site path and URL. You cannot publish entries until these are defined.' => 'Votre blog n\'a pas t configur avec un chemin de site et une URL. Vous ne pourrez pas publier de notes tant qu\'ils ne seront pas dfinis.',
	'Invalid date \'[_1]\'; authored on dates must be in the format YYYY-MM-DD HH:MM:SS.' => 'Date invalide \'[_1]\'; les dates doivent tre au format AAAA-MM-JJ HH:MM:SS.',
	'Invalid date \'[_1]\'; authored on dates should be real dates.' => 'Date invalide \'[_1]\'; les dates de publication doivent tre relles.',
	'[_1] \'[_2]\' (ID:[_3]) added by user \'[_4]\'' => '[_1] \'[_2]\' (ID:[_3]) ajout par utilisateur \'[_4]\'',
	'[_1] \'[_2]\' (ID:[_3]) edited and its status changed from [_4] to [_5] by user \'[_6]\'' => '[_1] \'[_2]\' (ID:[_3]) dit et son statut est pass de [_4] a [_5] par utilisateur \'[_6]\'',
	'[_1] \'[_2]\' (ID:[_3]) edited by user \'[_4]\'' => '[_1] \'[_2]\' (ID:[_3]) dit par utilisateur \'[_4]\'',
	'Saving placement failed: [_1]' => 'chec lors de la sauvegarde du placement : [_1]',
	'Saving entry \'[_1]\' failed: [_2]' => 'chec \'[_1]\' lors de la sauvegarde de la Note : [_2]',
	'Removing placement failed: [_1]' => 'chec lors de la suppression de l\'emplacement : [_1]',
	'Ping \'[_1]\' failed: [_2]' => 'Le ping \'[_1]\' n\'a pas fonctionn : [_2]',
	'(user deleted - ID:[_1])' => '(utilisateur supprim - ID:[_1])',
	'<a href="[_1]">QuickPost to [_2]</a> - Drag this link to your browser\'s toolbar then click it when you are on a site you want to blog about.' => '<a href="[_1]">QuickPost vers [_2]</a> - Glissez ce lien vers la barre d\'outils de votre navigateur et cliquez dessus  chaque fois que vous tes sur un site dont vous voulez parler dans votre blog.',
	'Entry \'[_1]\' (ID:[_2]) deleted by \'[_3]\'' => 'Note \'[_1]\' (ID:[_2]) supprime par \'[_3]\'',
	'Need a status to update entries' => 'Statut ncessaire pour mettre  jour les notes',
	'Need entries to update status' => 'Notes ncessaires pour mettre  jour le statut',
	'One of the entries ([_1]) did not actually exist' => 'Une des notes ([_1]) n\'existait pas',
	'[_1] \'[_2]\' (ID:[_3]) status changed from [_4] to [_5]' => '[_1] \'[_2]\' (ID:[_3]) statut chang de [_4]  [_5]',

## lib/MT/CMS/Comment.pm
	'Edit Comment' => 'diter les commentaires',
	'Orphaned comment' => 'Commentaire orphelin',
	'Comments Activity Feed' => 'Flux d\'activit des commentaires',
	'Commenters' => 'Auteurs de commentaires',
	'Authenticated Commenters' => 'Auteurs de commentaires authentifis',
	'No such commenter [_1].' => 'Pas de d\'auteur de commentaires [_1].',
	'User \'[_1]\' trusted commenter \'[_2]\'.' => 'L\'utilisateur \'[_1]\' a accord le statut Fiable  l\'auteur de commentaire \'[_2]\'.',
	'User \'[_1]\' banned commenter \'[_2]\'.' => 'L\'utilisateur \'[_1]\'  a banni l\'auteur de commentaire \'[_2]\'.',
	'User \'[_1]\' unbanned commenter \'[_2]\'.' => 'L\'utilisateur \'[_1]\'  a retir le statut Banni  l\'auteur de commentaire \'[_2]\'.',
	'User \'[_1]\' untrusted commenter \'[_2]\'.' => 'L\'utilisateur \'[_1]\'  a retir le statut Fiable  l\'auteur de commentaire \'[_2]\'.',
	'Feedback Settings' => 'Paramtres des Feedbacks',
	'Invalid request' => 'Demande incorrecte',
	'An error occurred: [_1]' => 'Une erreur s\'est produite: [_1]',
	'Parent comment id was not specified.' => 'id du commentaire parent non spcifi.',
	'Parent comment was not found.' => 'Commentaire parent non trouv.',
	'You can\'t reply to unapproved comment.' => 'Vous ne pouvez rpondre  un commentaire non approuv.',
	'Publish failed: [_1]' => 'chec de la publication : [_1]',
	'Comment (ID:[_1]) by \'[_2]\' deleted by \'[_3]\' from entry \'[_4]\'' => 'Commentaire (ID:[_1]) de \'[_2]\' supprim par \'[_3]\' de la note \'[_4]\'',
	'You don\'t have permission to approve this comment.' => 'Vous n\'avez pas l\'autorisation d\'approuver ce commentaire.',
	'Comment on missing entry!' => 'Commentaire sur une note manquante !',
	'You can\'t reply to unpublished comment.' => 'Vous ne pouvez pas rpondre  un commentaire non publi.',
	'Registered User' => 'Utilisateur enregistr',

## lib/MT/Compat/v3.pm
	'uses: [_1], should use: [_2]' => 'utilise: [_1], devrait utiliser: [_2]',
	'uses [_1]' => 'utilise [_1]',
	'No executable code' => 'Pas de code excutable',
	'Publish-option name must not contain special characters' => 'La personnalisation du nom de publication ne doit pas contenir de caractres spciaux',

## lib/MT/ObjectScore.pm
	'Object Score' => 'Score Objet',
	'Object Scores' => 'Scores Objet',

## lib/MT/FileMgr/Local.pm
	'Opening local file \'[_1]\' failed: [_2]' => 'L\'ouverture du fichier local \'[_1]\' a chou: [_2]',
	'Renaming \'[_1]\' to \'[_2]\' failed: [_3]' => 'Le renommage de \'[_1]\'  \'[_2]\' a chou : [_3]',
	'Deleting \'[_1]\' failed: [_2]' => 'La suppression de \'[_1]\' a chou : [_2]',

## lib/MT/FileMgr/FTP.pm
	'Creating path \'[_1]\' failed: [_2]' => 'Cration du chemin \'[_1]\' a choue : [_2]',

## lib/MT/FileMgr/DAV.pm
	'DAV connection failed: [_1]' => 'La connexion DAV a chou : [_1]',
	'DAV open failed: [_1]' => 'L\'ouverture DAV a choue : [_1]',
	'DAV get failed: [_1]' => 'La rcupration DAV a choue : [_1]',
	'DAV put failed: [_1]' => 'L\'envoi DAV a choue : [_1]',

## lib/MT/FileMgr/SFTP.pm
	'SFTP connection failed: [_1]' => 'La connexion SFTP a chou : [_1]',
	'SFTP get failed: [_1]' => 'La rcupration  SFTP a chou : [_1]',
	'SFTP put failed: [_1]' => 'L\'envoi  SFTP a chou : [_1]',

## lib/MT/BackupRestore/ManifestFileHandler.pm

## lib/MT/BackupRestore/BackupFileHandler.pm
	'Uploaded file was backed up from Movable Type but the different schema version ([_1]) from the one in this system ([_2]).  It is not safe to restore the file to this version of Movable Type.' => 'Le fichier tlcharg a t sauvegard depuis Movable Type mais la version du schma ([_1]) est diffrente de celle du systme ([_2]). Il n\'est pas conseill de restaurer le fichier vers cette version de Movable Type.',
	'[_1] is not a subject to be restored by Movable Type.' => '[_1] n\'est pas un sujet qui peut tre restaur par Movable Type.',
	'[_1] records restored.' => '[_1] enregistrements restaurs.',
	'Restoring [_1] records:' => 'Restauration de [_1] enregistrements:',
	'User with the same name as the name of the currently logged in ([_1]) found.  Skipped the record.' => 'Utilisateur avec le mme nom que l\'utilisateur actuellement connect ([_1]) trouv',
	'User with the same name \'[_1]\' found (ID:[_2]).  Restore replaced this user with the data backed up.' => 'Utilisateur avec le mme nom \'[_1]\' trouv (ID:[_2]). La restauration a remplac cet utilisateur par les donnes prsentes dans la sauvegardes.',
	'Tag \'[_1]\' exists in the system.' => 'Le tag \'[_1]\' existe dans le systme.',
	'[_1] records restored...' => '[_1] enregistrements restaurs...',

## lib/MT/Import.pm
	'Can\'t rewind' => 'Impossible de revenir en arrire',
	'No readable files could be found in your import directory [_1].' => 'Aucun fichier lisible n\'a t trouv dans le rpertoire d\'importation [_1].',
	'Importing entries from file \'[_1]\'' => 'Importation des notes du fichier \'[_1]\'',
	'Couldn\'t resolve import format [_1]' => 'Impossible de dtecter le format d\'import [_1]',
	'Movable Type' => 'Movable Type',
	'Another system (Movable Type format)' => 'Autre systme (format Movable Type)',

## lib/MT/IPBanList.pm
	'IP Ban' => 'Interdiction IP',
	'IP Bans' => 'Interdictions IP',

## lib/MT/Folder.pm
	'Folders' => 'Rpertoires',

## lib/MT/Tag.pm
	'Tag must have a valid name' => 'Le tag doit avoir un nom valide',
	'This tag is referenced by others.' => 'Ce tag est rfrenc par d\'autres.',

## lib/MT/App.pm
	'Invalid request: corrupt character data for character set [_1]' => 'Requte invalide : les donnes de ces caractres sont corrompues pour ce jeu de caractres [_1]', # Translate - New
	'First Weblog' => 'Premier Blog',
	'Error loading blog #[_1] for user provisioning. Check your NewUserTemplateBlogId setting.' => 'Erreur de chargement #[_1] concernant la cration Utilisateur. Veuillez vrifier vos paramtres NewUserTemplateBlogId.',
	'Error provisioning blog for new user \'[_1]\' using template blog #[_2].' => 'Erreur de cration du blog pour le nouvel utilisateur  \'[_1]\' utilisant le template #[_2].',
	'Error creating directory [_1] for blog #[_2].' => 'Erreur lors de la cration de la liste [_1] pour le blog #[_2].',
	'Error provisioning blog for new user \'[_1] (ID: [_2])\'.' => 'Erreur de cration du blog pour le nouvel utilisateur \'[_1] (ID: [_2])\'.',
	'Blog \'[_1] (ID: [_2])\' for user \'[_3] (ID: [_4])\' has been created.' => 'Le blog \'[_1] (ID: [_2])\' pour l\'utilisateur \'[_3] (ID: [_4])\' a t cr.',
	'Error assigning blog administration rights to user \'[_1] (ID: [_2])\' for blog \'[_3] (ID: [_4])\'. No suitable blog administrator role was found.' => 'Erreur d\'assignation des droits pour l\'utilisateur \'[_1] (ID: [_2])\' pour le blog \'[_3] (ID: [_4])\'. Aucun rle d\'administrateur adquat n\'a t trouv.',
	'The login could not be confirmed because of a database error ([_1])' => 'L\'identifiant ne peut pas tre confirm en raison d\'une erreur de base de donnes ([_1])',
	'Our apologies, but you do not have permission to access any blogs within this installation. If you feel you have reached this message in error, please contact your Movable Type system administrator.' => 'Dsol, mais vous n\'avez pas l\'authorisation d\'accder aux blogs de cette installation. Si vous pensez qu\'il s\'agit d\'une erreur, merci de contacter votre administrateur Movable Type.',
	'Invalid login.' => 'Identifiant invalide.',
	'Failed login attempt by unknown user \'[_1]\'' => 'chec de tentative d\'identification par utilisateur inconnu\'[_1]\'',
	'Failed login attempt by disabled user \'[_1]\'' => 'chec de tentative  d\'identification par utilisateur dsactiv \'[_1]\' ',
	'This account has been disabled. Please see your system administrator for access.' => 'Ce compte a t dsactiv. Merci de contacter votre administrateur systme.',
	'Failed login attempt by pending user \'[_1]\'' => 'Tentative d\'identification choue par l\'utilisateur en attente \'[_1]\'',
	'This account has been deleted. Please see your system administrator for access.' => 'Ce compte a t supprim. Merci de contacter votre administrateur systme.',
	'User cannot be created: [_1].' => 'L\'utilisateur n\'a pu tre cr: [_1].',
	'User \'[_1]\' has been created.' => 'L\'utilisateur \'[_1]\' a t cr ',
	'User \'[_1]\' (ID:[_2]) logged in successfully' => 'L\'utilisateur \'[_1]\' (ID:[_2]) s\'est identifi correctement',
	'Invalid login attempt from user \'[_1]\'' => 'Tentative d\'authentification invalide de l\'utilisateur \'[_1]\'',
	'User \'[_1]\' (ID:[_2]) logged out' => 'L\'utilisateur \'[_1]\' (ID:[_2]) s\'est dconnect',
	'User requires password.' => 'L\'utilisateur doit avoir un mot de passe.',
	'User requires password recovery word/phrase.' => 'L\'utilisateur doit avoir un indice de rcupration du mot de passe.',
	'URL is invalid.' => 'L\'URL n\'est pas valide.',
	'User requires username.' => 'L\'utilisateur doit avoir un nom d\'utilisateur.',
	'User requires display name.' => 'L\'utilisateur doit avoir un nom public.',
	'Email Address is invalid.' => 'L\'adresse email n\'est pas valide.',
	'Email Address is required for password recovery.' => 'Une adresse email est obligatoire pour rcuprer le mot de passe.',
	'Text entered was wrong.  Try again.' => 'Le texte saisi est erron.  Essayez  nouveau',
	'Something wrong happened when trying to process signup: [_1]' => 'Un problme s\'est produit en essayant de soumettre l\'inscription: [_1]',
	'New Comment Added to \'[_1]\'' => 'Nouveau commentaire ajout  \'[_1]\'',
	'System Email Address is not configured.' => 'Adresse Email du Systme non configure.',
	'Close' => 'Fermer',
	'The file you uploaded is too large.' => 'Le fichier tlcharg est trop lourd.',
	'Unknown action [_1]' => 'Action inconnue [_1]',
	'Warnings and Log Messages' => 'Mises en gardes et entres du Journal (logs)',
	'Removed [_1].' => '[_1] supprims.',

## lib/MT/Log.pm
	'Log message' => 'Message du journal',
	'Log messages' => 'Messages du journal',
	'Page # [_1] not found.' => 'Page # [_1] non trouve.',
	'Entry # [_1] not found.' => 'Note # [_1] non trouve.',
	'Comment # [_1] not found.' => 'Commentaire # [_1] non trouv.',
	'TrackBack # [_1] not found.' => 'Trackback # [_1] non trouv.',

## lib/MT/Template/Context.pm
	'The attribute exclude_blogs cannot take \'all\' for a value.' => 'L\'attribut exclude_blogs ne peut pas prendre \'all\' comme valeur.',
	'You used an \'[_1]\' tag outside of the context of a author; perhaps you mistakenly placed it outside of an \'MTAuthors\' container?' => 'Vous avez utilis un tag \'[_1]\' en dehors du contexte d\'un auteur; peut-tre l\'avez-vous plac par erreur en dehors du conteneur \'MTAuthors\' ?',
	'You used an \'[_1]\' tag outside of the context of an entry; perhaps you mistakenly placed it outside of an \'MTEntries\' container?' => 'Vous avez utilis une balise \'[_1]\' en dehors du contexte d\'une note; peut-tre l\'avez-vous plac par erreur en dehors du conteneur \'MTEntries\' ?',
	'You used an \'[_1]\' tag outside of the context of a comment; perhaps you mistakenly placed it outside of an \'MTComments\' container?' => 'Vous avez utilis une balise \'[_1]\' en dehors du contexte d\'un commentaire; peut-tre l\'avez-vous plac par erreur en dehors du conteneur \'MTComments\' ?',
	'You used an \'[_1]\' tag outside of the context of a ping; perhaps you mistakenly placed it outside of an \'MTPings\' container?' => 'Vous avez utilis une balise \'[_1]\' en dehors d\'un contexte de ping; peut-tre l\'avez-vous plac en dehors du conteneur \'MTPings\' ?',
	'You used an \'[_1]\' tag outside of the context of an asset; perhaps you mistakenly placed it outside of an \'MTAssets\' container?' => 'Vous avez utilis une balise \'[_1]\' en dehors du contexte d\'un lment; peut-tre l\'avez-vous plac par erreur en dehors d\'un conteneur \'MTAssets\' ?',
	'You used an \'[_1]\' tag outside of the context of an page; perhaps you mistakenly placed it outside of an \'MTPages\' container?' => 'Vous avez utilis une balise \'[_1]\' en dehors du contexte d\'une page; peut-tre l\'avez-vous plac par erreur en dehors d\'un conteneur \'MTPages\' ?',

## lib/MT/Template/ContextHandlers.pm
	'All About Me' => 'Tout Sur Moi',
	'Remove this widget' => 'Supprimer ce widget',
	'[_1]Publish[_2] your site to see these changes take effect.' => '[_1]Publiez[_2] votre site pour que ces changements soient appliqus.',
	'Actions' => 'Actions',
	'Warning' => 'Attention',
	'http://www.movabletype.org/documentation/appendices/tags/%t.html' => 'http://www.movabletype.org/documentation/appendices/tags/%t.html',
	'No [_1] could be found.' => 'Il n\'y a pas de [_1] trouvs.',
	'records' => 'enregistrements',
	'Invalid tag [_1] specified.' => 'Tag invalide [_1] spcifi.',
	'No template to include specified' => 'Aucun gabarit spcifi pour inclusion',
	'Recursion attempt on [_1]: [_2]' => 'Tentative de rcursion sur [_1]: [_2]',
	'Can\'t find included template [_1] \'[_2]\'' => 'Impossible de trouver le gabarit inclus [_1] \'[_2]\'',
	'Writing to \'[_1]\' failed: [_2]' => 'Ecriture sur\'[_1]\' a chou: [_2]',
	'Can\'t find blog for id \'[_1]' => 'Impossible de trouver un blog pour le ID\'[_1]',
	'Can\'t find included file \'[_1]\'' => 'Impossible de trouver le fichier inclus \'[_1]\'',
	'Error opening included file \'[_1]\': [_2]' => 'Erreur lors de l\'ouverture du fichier inclus \'[_1]\' : [_2]',
	'Recursion attempt on file: [_1]' => 'Tentative de rcursion sur le fichier: [_1]',
	'Unspecified archive template' => 'Gabarit d\'archive non spcifi',
	'Error in file template: [_1]' => 'Erreur dans fichier gabarit : [_1]',
	'Can\'t load template' => 'Impossible de charger le gabarit',
	'Can\'t find template \'[_1]\'' => 'Impossible de trouver le gabarit \'[_1]\'',
	'Can\'t find entry \'[_1]\'' => 'Impossible de trouver la note \'[_1]\'',
	'[_1] is not a hash.' => '[_1] n\'est pas un hash',
	'You have an error in your \'[_2]\' attribute: [_1]' => 'Vous avez une erreur dans votre attribut \'[_2]\' : [_1]',
	'You have an error in your \'tag\' attribute: [_1]' => 'Vous avez une erreur dans votre attribut \'tag\': [_1]',
	'No such user \'[_1]\'' => 'L\'utilisateur \'[_1]\' n\'existe pas',
	'You used <$MTEntryFlag$> without a flag.' => 'Vous utilisez <$MTEntryFlag$> sans drapeau.',
	'You used an [_1] tag for linking into \'[_2]\' archives, but that archive type is not published.' => 'Vous avez utilis un [_1] tag pour crer un lien vers \'[_2]\' archives, mais ce type d\'archive n\'est pas publi.',
	'Could not create atom id for entry [_1]' => 'Impossible de crer un ID Atom pour cette note [_1]',
	'To enable comment registration, you need to add a TypeKey token in your weblog config or user profile.' => 'Pour activer l\'enregistrement afin de commenter, vous devez ajouter une cl TypeKey dans le profil de votre blog ou celui de votre utilisateur.',
	'The MTCommentFields tag is no longer available; please include the [_1] template module instead.' => 'Le tag MTCommentFields n\'est plus disponible; merci d\'inclure le module de template [_1]  la place.',
	'Comment Form' => 'Formulaire de commentaire',
	'You used an [_1] tag without a date context set up.' => 'Vous utilisez un tag [_1] sans avoir configur la date.',
	'[_1] can be used only with Daily, Weekly, or Monthly archives.' => '[_1] est valide uniquement avec des archives quotidiennes, hebdomadaires ou mensuelles.',
	'Group iterator failed.' => 'Le rptateur de groupe a chou',
	'You used an [_1] tag outside of the proper context.' => 'Vous utilisez un tag [_1] en dehors de son contexte propre.',
	'Could not determine entry' => 'La note ne peut pas tre dtermine',
	'Invalid month format: must be YYYYMM' => 'Le format du mois est invalide : Il doit tre de la forme AAAAMM',
	'No such category \'[_1]\'' => 'La catgorie \'[_1]\' n\'existe pas',
	'[_1] cannot be used without publishing Category archive.' => '[_1] ne peut tre utilis sans la publication d\'archives par catgorie.',
	'<\$MTCategoryTrackbackLink\$> must be used in the context of a category, or with the \'category\' attribute to the tag.' => '<\$MTCategoryTrackbackLink\$> doit tre utilis dans le contexte d\'une catgorie, ou avec l\'attribut \'Catgorie\' dans le tag.',
	'You failed to specify the label attribute for the [_1] tag.' => 'Vous n\'avez pas spcifi l\'tiquette du tag [_1].',
	'[_1] used outside of [_2]' => '[_1] utilis en dehors de [_2]',
	'MT[_1] must be used in a [_2] context' => 'MT[_1] doit tre utilis dans le contexte [_2]',
	'Cannot find package [_1]: [_2]' => 'Impossible de trouver le package [_1]: [_2]',
	'Error sorting [_2]: [_1]' => 'Erreur en classant [_2]: [_1]',
	'You used an [_1] without a author context set up.' => 'Vous avez utilis un [_1] sans avoir configur de contexte d\'auteur.',
	'Can\'t load user.' => 'Impossible de charger l\'utilisateur.',
	'Division by zero.' => 'Division par zro.',
	'name is required.' => 'le nom est requis.',
	'Specified WidgetSet not found.' => 'WidgetSet spcifi introuvable.',
	'Can\'t find included template widget \'[_1]\'' => 'Impossible de trouver le gabarit de widget inclus \'[_1]\'',

## lib/MT/App/Search/Legacy.pm
	'You are currently performing a search. Please wait until your search is completed.' => 'Vous tes en train d\'effectuer une recherche. Merci d\'attendre que la recherche soit finie.',
	'Search failed. Invalid pattern given: [_1]' => 'chec de la recherche. Comportement non valide : [_1]',
	'Search failed: [_1]' => 'chec lors de la recherche : [_1]',
	'No alternate template is specified for the Template \'[_1]\'' => 'Pas de gabarit alternatif spcifi pour le gabarit \'[_1]\'',
	'Publishing results failed: [_1]' => 'chec de la publication des rsultats: [_1]',
	'Search: query for \'[_1]\'' => 'Recherche : requte pour \'[_1]\'',
	'Search: new comment search' => 'Recherche : recherche de nouveaux commentaires',

## lib/MT/App/Search/TagSearch.pm
	'TagSearch works with MT::App::Search.' => 'TagSearch fonctionne avec MT::App::Search.',

## lib/MT/App/NotifyList.pm
	'Please enter a valid email address.' => 'Veuillez entrer une adresse e-mail valide.',
	'Missing required parameter: blog_id. Please consult the user manual to configure notifications.' => 'Il manque un paramtre requis : blog_id. Veuillez consulter le manuel d\'utilisateur pour configurer les notifications.',
	'An invalid redirect parameter was provided. The weblog owner needs to specify a path that matches with the domain of the weblog.' => 'Vous avez fourni un paramtre de redirection non valide. Le propritaire du blog doit spcifier le chemin qui correspond au nom de domaine du blog.',
	'The email address \'[_1]\' is already in the notification list for this weblog.' => 'L\'adresse e-mail \'[_1]\' fait dj parti de la liste de notification pour ce blog.',
	'Please verify your email to subscribe' => 'Merci de vrifier votre email pour souscrire',
	'_NOTIFY_REQUIRE_CONFIRMATION' => 'Un email a t envoy  [_1]. Pour valider votre inscription, merci de cliquer sur le lien qui figure dans cet email. Il permettra de vrifier que votre adresse email est valable.',
	'The address [_1] was not subscribed.' => 'L\'adresse [_1] n\'a pas t souscrite.',
	'The address [_1] has been unsubscribed.' => 'L\'adresse [_1] a t supprime.',

## lib/MT/App/Comments.pm
	'Error assigning commenting rights to user \'[_1] (ID: [_2])\' for weblog \'[_3] (ID: [_4])\'. No suitable commenting role was found.' => 'Erreur en assignant les droits de commenter  l\'utilisateur \'[_1] (ID: [_2])\' pour le blog \'[_3] (ID: [_4])\'. Aucun rle de commentaire adquat n\'a t trouv.',
	'Invalid commenter login attempt from [_1] to blog [_2](ID: [_3]) which does not allow Movable Type native authentication.' => 'Tentative d\'identification choue pour l\'auteur de commentaires [_1] sur le blog [_2](ID: [_3]) qui n\'autorise pas l\'authentification native de Movable Type.',
	'Invalid login' => 'Login invalide',
	'Successfully authenticated but signing up is not allowed.  Please contact system administrator.' => 'Identification russie mais l\'enregistrement n\'est pas autoris. Merci de contacter votre administrateur systme.',
	'You need to sign up first.' => 'Vous devez vous enregistrer d\'abord.',
	'Login failed: permission denied for user \'[_1]\'' => 'Identification choue: autorisation interdite pour l\'utilisateur \'[_1]\'',
	'Login failed: password was wrong for user \'[_1]\'' => 'Identification choue: mot de passe incorrect pour l\'utilisateur \'[_1]\'',
	'Signing up is not allowed.' => 'Enregistrement non autorise.',
	'Movable Type Account Confirmation' => 'Confirmation de compte Movable Type',
	'Commenter \'[_1]\' (ID:[_2]) has been successfully registered.' => 'L\'auteur de commentaires \'[_1]\' (ID:[_2]) a t enregistr avec succs.',
	'Thanks for the confirmation.  Please sign in to comment.' => 'Merci pour la confirmation. Merci de vous identifier pour commenter.',
	'[_1] registered to the blog \'[_2]\'' => '[_1] est enregistr sur le blog \'[_2]\'',
	'No id' => 'pas d\'id',
	'No such comment' => 'Pas de commentaire de la sorte',
	'IP [_1] banned because comment rate exceeded 8 comments in [_2] seconds.' => 'l\'IP [_1] a t bannie car elle a envoy plus de 8 commentaires en  [_2] seconds.',
	'IP Banned Due to Excessive Comments' => 'IP bannie pour cause de commentaires excessifs',
	'No entry_id' => 'Pas de note_id',
	'No such entry \'[_1]\'.' => 'Aucune Note \'[_1]\'.',
	'_THROTTLED_COMMENT' => 'Dans le but de rduire les possibilits d\'abus, Nous avons activ une fonction obligeant les auteurs de commentaires  attendre quelques instants avant de publier un autre commentaire. Veuillez attendre quelques instants avant de publier un autre commentaire. Merci.',
	'Comments are not allowed on this entry.' => 'Les commentaires ne sont pas autoriss sur cette Note.',
	'Comment text is required.' => 'Le texte de commentaire est requis.',
	'Registration is required.' => 'L\'inscription est requise.',
	'Name and email address are required.' => 'Le nom et l\'e-mail sont requis.',
	'Invalid email address \'[_1]\'' => 'Adresse e-mail invalide \'[_1]\'',
	'Invalid URL \'[_1]\'' => 'URL invalide \'[_1]\'',
	'Comment save failed with [_1]' => 'La sauvegarde du commentaire a chou [_1]',
	'Comment on "[_1]" by [_2].' => 'Commentaire sur "[_1]" par [_2].',
	'Failed comment attempt by pending registrant \'[_1]\'' => 'Tentative de commentaire choue par utilisateur  \'[_1]\' en cours d\'inscription',
	'The sign-in attempt was not successful; please try again.' => 'La tentative d\'enregistrement a chou; veuillez essayer de nouveau.',
	'No entry was specified; perhaps there is a template problem?' => 'Aucune note n\'a t spcifie; peut-tre y a-t-il un problme de gabarit?',
	'Somehow, the entry you tried to comment on does not exist' => 'Il semble que la note que vous souhaitez commenter n\'existe pas',
	'Invalid entry ID provided' => 'ID de note fourni invalide',
	'All required fields must have valid values.' => 'Tous les champs obligatoires doivent avoir des valeurs valides.',
	'Commenter profile has successfully been updated.' => 'Le profil de l\'auteur de commentaires a t modifi avec succs.',
	'Commenter profile could not be updated: [_1]' => 'Le profil de l\'auteur de commentaires n\'a pu tre modifi: [_1]',

## lib/MT/App/Search.pm
	'Invalid type: [_1]' => 'Type invalide : [_1]',
	'Search: failed storing results in cache.  [_1] is not available: [_2]' => 'Recherche : chec sur stockage des rsultats en cache. [_1] n\'est pas disponible : [_2]',
	'Invalid format: [_1]' => 'Format invalide : [_1]',
	'Unsupported type: [_1]' => 'Type non support : [_1]',
	'Invalid query: [_1]' => 'Requte non valide : [_1]',
	'No search term was specified.' => 'Aucune entre de recherche spcifie.',
	'Invalid value: [_1]' => 'Valeur invalide : [_1]',
	'No column was specified to search for [_1].' => 'Aucune colonne spcifie  la recherche de [_1].',
	'The search you conducted has timed out.  Please simplify your query and try again.' => 'La recherche que vous avez effectu a expir. Merci de simplifier votre requte et ressayer.',

## lib/MT/App/Trackback.pm
	'Invalid entry ID \'[_1]\'' => 'ID de Note invalide \'[_1]\'',
	'You must define a Ping template in order to display pings.' => 'Vous devez dfinir un gabarit d\'affichage Ping pour les afficher.',
	'Trackback pings must use HTTP POST' => 'Les Pings trackback doivent utiliser HTTP POST',
	'Need a TrackBack ID (tb_id).' => 'Un ID de Trackback est requis (tb_id).',
	'Invalid TrackBack ID \'[_1]\'' => 'L\'ID de Trackback \'[_1]\' est invalide',
	'You are not allowed to send TrackBack pings.' => 'You n\'tes pas autoris  envoyer des pings trackback.',
	'You are pinging trackbacks too quickly. Please try again later.' => 'Vous pinguez les trackbacks trop rapidement. Merci d\'essayer plus tard.',
	'Need a Source URL (url).' => 'Une URL source est requise (url).',
	'This TrackBack item is disabled.' => 'Cet lment trackback est dsactiv.',
	'This TrackBack item is protected by a passphrase.' => 'Cet lment de trackback est protg par un mot de passe.',
	'TrackBack on "[_1]" from "[_2]".' => 'Trackback sur "[_1]" provenant de "[_2]".',
	'TrackBack on category \'[_1]\' (ID:[_2]).' => 'Trackback sur la catgorie \'[_1]\' (ID:[_2]).',
	'Can\'t create RSS feed \'[_1]\': ' => 'Impossible de crer le flux RSS \'[_1]\': ',
	'New TrackBack Ping to Entry [_1] ([_2])' => 'Nouveau trackback pour la note [_1] ([_2])',
	'New TrackBack Ping to Category [_1] ([_2])' => 'Nouveau trackback pour la catgorie [_1] ([_2])',

## lib/MT/App/Upgrader.pm
	'Failed to authenticate using given credentials: [_1].' => 'L\'authentification a chou en utilisant les informations communiques [_1].',
	'You failed to validate your password.' => 'chec lors de la validation du mot de passe.',
	'You failed to supply a password.' => 'Vous n\'avez pas donn de mot de passe.',
	'The e-mail address is required.' => 'L\'adresse email est requise.',
	'The path provided below is not writable.' => 'Le chemin ci-dessous n\'est pas ouvert en criture',
	'Invalid session.' => 'Session invalide.',
	'No permissions. Please contact your administrator for upgrading Movable Type.' => 'Pas d\'autorisation. Contactez votre administrateur systme Movable Type pour modifier vos privilges.',
	'Movable Type has been upgraded to version [_1].' => 'Movable Type a t mis  jour  la version [_1].',

## lib/MT/App/Wizard.pm
	'The [_1] database driver is required to use [_2].' => 'Le driver de base de donnes [_1] est obligatoire pour utiliser [_2].',
	'The [_1] driver is required to use [_2].' => 'Le driver [_1] est obligatoire pour utiliser [_2].',
	'An error occurred while attempting to connect to the database.  Check the settings and try again.' => 'Une erreur s\'est produite en essayant de se connecter  la base de donnes. Vrifiez les paramtres et essayez  nouveau.',
	'SMTP Server' => 'Serveur SMTP',
	'Sendmail' => 'Sendmail',
	'Test email from Movable Type Configuration Wizard' => 'Test email  partir de l\'Assistant de Configuration de Movable Type',
	'This is the test email sent by your new installation of Movable Type.' => 'Ceci est un email de test envoy par votre nouvelle installation Movable Type.',
	'This module is needed to encode special characters, but this feature can be turned off using the NoHTMLEntities option in mt-config.cgi.' => 'Ce module est ncessaire pour encoder les caractres spciaux, mais cette option peut tre dsactive en utilisant NoHTMLEntities dans mt-config.cgi.',
	'This module is needed if you wish to use the TrackBack system, the weblogs.com ping, or the MT Recently Updated ping.' => 'Ce module est ncessaire si vous souhaitez utiliser le systme de trackback, les pings weblogs.com, ou le ping Mises  jour rcentes MT.',
	'This module is needed if you wish to use the MT XML-RPC server implementation.' => 'Ce module est ncessaire si vous souhaitez utiliser l\'implmentation du serveur XML-RPC MT.',
	'This module is needed if you would like to be able to overwrite existing files when you upload.' => 'Ce module est ncessaire si vous voulez pouvoir craser les fichiers existants lorsque vous envoyez un nouveau fichier.',
	'List::Util is optional; It is needed if you want to use the Publish Queue feature.' => 'List:Util est optionnel; Il est ncessaire si vous souhaitez utiliser les possibilits de publications en mode file d\'attente',
	'Scalar::Util is optional; It is needed if you want to use the Publish Queue feature.' => 'Scalar::Util est optionnel; Il est ncessaire uniquement si vous souhaitez utiliser la fonction de file d\'attente de publication.',
	'This module is needed if you would like to be able to create thumbnails of uploaded images.' => 'Ce module est ncessaire si vous souhaitez pouvoir crer des vignettes pour les images envoyes.',
	'This module is required by certain MT plugins available from third parties.' => 'Ce module est ncessaire pour certains plugins MT disponibles auprs de partenaires.',
	'This module accelerates comment registration sign-ins.' => 'Ce module acclre les enregistrements des auteurs de commentaires.',
	'This module is needed to enable comment registration.' => 'Ce module est ncessaire pour activer l\'enregistrement des auteurs de commentaires.',
	'This module enables the use of the Atom API.' => 'Ce module active l\'utilisation de l\'API Atom.',
	'This module is required in order to archive files in backup/restore operation.' => 'Ce module est ncessaire pour archiver les fichiers lors des oprations de sauvegarde/restauration.',
	'This module is required in order to compress files in backup/restore operation.' => 'Ce module est ncessaire pour compresser les fichiers lors des oprations de sauvegarde et restauration.',
	'This module is required in order to decompress files in backup/restore operation.' => 'Ce module est ncessaire pour dcompresser les fichiers lors d\'une opration de sauvegarde/restauration.',
	'This module and its dependencies are required in order to restore from a backup.' => 'Ce module et ses dpendances sont ncessaires pour restaurer les fichiers  partir d\'une sauvegarde.',
	'This module and its dependencies are required in order to allow commenters to be authenticated by OpenID providers including Vox and LiveJournal.' => 'Ce module et ses dpendances sont obligatoires pour permettre aux auteurs de commentaires d\'tre authentifis par des fournisseurs OpenID comme Vox et LiveJournal.',
	'This module is required for sending mail via SMTP Server.' => 'Ce module est ncessaire pour envoyer des emails via un serveur SMTP.',
	'This module is used in test attribute of MTIf conditional tag.' => 'Ce module est utilis dans l\'attribut de test du tag conditionnel MTIf.',
	'This module is used by the Markdown text filter.' => 'Ce module est utilis par le filtre de texte Markdown',
	'This module is required in mt-search.cgi if you are running Movable Type on Perl older than Perl 5.8.' => 'Ce module est ncessaire pour mt-search.cgi si vous utilisez Movable Type sur une version de Perl suprieur  5.8.',
	'This module is required for file uploads (to determine the size of uploaded images in many different formats).' => 'Ce module est ncessaire pour les envois de fichiers (pour dterminer la taille des images dans diffrents formats).',
	'This module is required for cookie authentication.' => 'Ce module est ncessaire pour l\'authentification par cookies.',
	'DBI is required to store data in database.' => 'DBI est ncessaire pour enregistrer les donnes en base de donnes.',
	'CGI is required for all Movable Type application functionality.' => 'CGI est ncessaire pour toutes les fonctionnalits de l\'application Movable Type.',
	'File::Spec is required for path manipulation across operating systems.' => 'File::Spec est ncessaire pour manipuler les chemins de fichiers sur diffrents systmes d\'exploitation.',

## lib/MT/App/CMS.pm
	'_WARNING_PASSWORD_RESET_MULTI' => 'Vous tes sur le point de r-initialiser le mot de passe des utilisateurs slectionns. Les nouveaux mots de passe sont gnrs automatiquement et seront envoys directement aux utilisateurs par e-mail. tes-vous sr de vouloir continuer ?',
	'_WARNING_DELETE_USER_EUM' => 'Supprimer un utilisateur est une action dfinitive qui va rendre des notes orphelines. Si vous voulez retirer un utilisateur ou lui supprimer ses accs nous vous recommandons de dsactiver son compte. tes-vous sr(e) de vouloir supprimer cet utilisateur ? Attention, il pourra se crer un nouvel accs s\'il existe encore dans le rpertoire externe',
	'_WARNING_DELETE_USER' => 'Supprimer un utilisateur est une action dfinitive qui va rendre des notes orphelines. Si vous souhaitez retirer un utilisateur ou lui supprimer ses accs nous vous recommandons de dsactiver son compte. tes-vous sr(e) de vouloir supprimer cet utilisateur ?',
	'_WARNING_REFRESH_TEMPLATES_FOR_BLOGS' => 'Cette action rtablira les gabarits par dfaut pour le(s) blog(s) slectionn(s). Etes-vous sr de vouloir rafrachir les gabarits de ce(s) blog(s) ?', # Translate - New
	'Published [_1]' => '[_1] publies',
	'Unpublished [_1]' => '[_1] non-publies',
	'Scheduled [_1]' => '[_1] programmes',
	'My [_1]' => 'Mes [_1]',
	'[_1] with comments in the last 7 days' => '[_1] avec des commentaires dans les 7 derniers jours',
	'[_1] posted between [_2] and [_3]' => '[_1] postes entre le [_2] et le [_3]',
	'[_1] posted since [_2]' => '[_1] postes depuis [_2]',
	'[_1] posted on or before [_2]' => '[_1] postes le ou avant le [_2]',
	'All comments by [_1] \'[_2]\'' => 'Tous les commentaires par [_1] \'[_2]\'',
	'All comments for [_1] \'[_2]\'' => 'Tous les commentaires pour [_1] \'[_2]\'',
	'Comments posted between [_1] and [_2]' => 'Commentaires posts entre [_1] et [_2]',
	'Comments posted since [_1]' => 'Commentaires dposs depuis [_1]',
	'Comments posted on or before [_1]' => 'Commentaires posts le ou avant le [_1]',
	'You are not authorized to log in to this blog.' => 'Vous n\'tes pas autoris  vous connecter sur ce blog.',
	'No such blog [_1]' => 'Aucun blog ne porte le nom [_1]',
	'Edit Template' => 'Modifier un gabarit',
	'Unknown object type [_1]' => 'Objet de type [_1] inconnu',
	'Error during publishing: [_1]' => 'Erreur pendant la publication : [_1]',
	'This is You' => 'C\'est vous',
	'Handy Shortcuts' => 'Raccourcis pratiques',
	'Movable Type News' => 'Actualits Movable Type',
	'Blog Stats' => 'Statistiques du blog',
	'Refresh Blog Templates' => 'Mettre  jour les gabarits du blog',
	'Refresh Global Templates' => 'Mettre  jour les gabarits globaux',
	'Use Publishing Profile' => 'Utiliser un Profil de Publication',
	'Unpublish Entries' => 'Annuler publication',
	'Add Tags...' => 'Ajouter des tags...',
	'Tags to add to selected entries' => 'Tags  ajouter aux notes slectionnes',
	'Remove Tags...' => 'Enlever les tags...',
	'Tags to remove from selected entries' => 'Tags  enlever des notes slectionnes',
	'Batch Edit Entries' => 'Modifier des notes par lot',
	'Publish Pages' => 'Publier les pages',
	'Unpublish Pages' => 'Dpublier les pages',
	'Tags to add to selected pages' => 'Tags  ajouter aux pages slectionnes',
	'Tags to remove from selected pages' => 'Tags  supprimer des pages slectionnes',
	'Batch Edit Pages' => 'Modifier les pages en masse',
	'Tags to add to selected assets' => 'Tags  ajouter aux lments slectionns',
	'Tags to remove from selected assets' => 'Tags  supprimer les lments slectionns',
	'Unpublish TrackBack(s)' => 'Annuler la publication de ce (ou ces) trackbacks(s)',
	'Unpublish Comment(s)' => 'Annuler la publication de ce (ou ces) commentaire(s)',
	'Trust Commenter(s)' => 'Donner le statut fiable  cet auteur de commentaires',
	'Untrust Commenter(s)' => 'Retirer le statut fiable  cet auteur de commentaires',
	'Ban Commenter(s)' => 'Bannir cet auteur de commentaires',
	'Unban Commenter(s)' => 'Lever le bannissement cet auteur de commentaires',
	'Recover Password(s)' => 'Rcuprer le(s) mot(s) de passe',
	'Delete' => 'Supprimer',
	'Refresh Template(s)' => 'Actualiser le(s) Gabarit(s)',
	'Publish Template(s)' => 'Publier le(s) Gabarit(s)',
	'Clone Template(s)' => 'Cloner le(s) Gabarit(s)',
	'Non-spam TrackBacks' => 'Trackbacks marqus comme n\'tant pas du spam',
	'TrackBacks on my entries' => 'Trackbacks sur mes entres',
	'Published TrackBacks' => 'Trackbacks publis',
	'Unpublished TrackBacks' => 'Tracbacks non publis',
	'TrackBacks marked as Spam' => 'Trackbacks marqus comme spam',
	'All TrackBacks in the last 7 days' => 'Tous les trackbacks des 7 derniers jours',
	'Non-spam Comments' => 'Commentaires marqus comme n\'tant pas du spam',
	'Comments on my entries' => 'Commentaires sur mes notes',
	'Pending comments' => 'Commentaires en attente',
	'Spam Comments' => 'Commentaires marqus comme tant du spam',
	'Published comments' => 'Commentaires publis.',
	'Comments in the last 7 days' => 'Commentaires des 7 derniers jours',
	'E-mail Templates' => 'Gabarits des emails',
	'Tags with entries' => 'Tags avec les notes',
	'Tags with pages' => 'Tags avec les pages',
	'Tags with assets' => 'Tags avec les lments',
	'Enabled Users' => 'Utilisateurs activs',
	'Disabled Users' => 'Utilisateurs dsactivs',
	'Pending Users' => 'Utilisateurs en attente',
	'Create' => 'Crer',
	'Manage' => 'Grer',
	'Design' => 'Design',
	'Preferences' => 'Prfrences',
	'Tools' => 'Outils',
	'Address Book' => 'Carnet d\'adresses',
	'Widgets' => 'Widgets',
	'General' => 'Gnral',
	'Feedback' => 'Feedback',
	'Comment' => 'Commentaire',
	'Registration' => 'Enregistrement',
	'Spam' => 'Spam',
	'Web Services' => 'Services Web',
	'Plugins' => 'Plugins',
	'Import' => 'Importer',
	'Export' => 'Exporter',
	'System Information' => 'Informations systme',
	'System Overview' => 'Vue d\'ensemble',

## lib/MT/App/Viewer.pm
	'Loading blog with ID [_1] failed' => 'chec lors du chargement du blog ayant pour ID [_1] ',
	'Template publishing failed: [_1]' => 'chec lors de la publication du gabarit : [_1]',
	'Invalid date spec' => 'Spcifications de dates invalides',
	'Can\'t load templatemap' => 'Impossible de charger la table de correspondance des gabarits',
	'Can\'t load template [_1]' => 'Impossible de charger le gabarit [_1]',
	'Archive publishing failed: [_1]' => 'chec lors de la publication de l\'archive : [_1]',
	'Invalid entry ID [_1]' => ' ID de la note invalide : [_1]',
	'Entry [_1] is not published' => 'La note [_1] n\'est pas publie',
	'Invalid category ID \'[_1]\'' => 'ID de catgorie invalide : \'[_1]\'',

## lib/MT/App/ActivityFeeds.pm
	'Error loading [_1]: [_2]' => 'Erreur lors du chargement chargement [_1] : [_2]',
	'An error occurred while generating the activity feed: [_1].' => 'Une erreur est survenue lors de la gnration du flux d\'activit : [_1].',
	'[_1] Weblog TrackBacks' => 'Trackbacks du blog [_1] ',
	'All Weblog TrackBacks' => 'Tous les trackbacks du blog',
	'[_1] Weblog Comments' => 'Commentaires du blog [_1] ',
	'All Weblog Comments' => 'Tous les commentaires du blog',
	'[_1] Weblog Entries' => 'Notes du blog [_1] ',
	'All Weblog Entries' => 'Toutes les notes du blog ',
	'[_1] Weblog Activity' => 'Activit du blog [_1] ',
	'All Weblog Activity' => 'Toutes l\'activit du blog',
	'Movable Type System Activity' => 'Activit du systme Movable Type',
	'Movable Type Debug Activity' => 'Activit de dbogage Movable Type',
	'[_1] Weblog Pages' => 'Pages du blog [_1]',
	'All Weblog Pages' => 'Toutes les pages du blog',

## lib/MT/AtomServer.pm
	'[_1]: Entries' => '[_1]: Notes',
	'PreSave failed [_1]' => 'chec lors du pr-enregistrement [_1]',
	'User \'[_1]\' (user #[_2]) added [lc,_4] #[_3]' => 'L\'Utilisateur \'[_1]\' (utilisateur #[_2]) a ajout [lc,_4] #[_3]',
	'User \'[_1]\' (user #[_2]) edited [lc,_4] #[_3]' => 'L\'Utilisateur \'[_1]\' (L\'Utilisateur #[_2]) a dit [lc,_4] #[_3]',

## lib/MT/PluginData.pm
	'Plugin Data' => 'Donnes Plugin',

## lib/MT/Plugin.pm
	'Publish' => 'Publier',
	'My Text Format' => 'Format de mon texte.',

## lib/MT/Entry.pm
	'Draft' => 'Brouillon',
	'Review' => 'Vrification',
	'Future' => 'Futur',

## lib/MT/Role.pm
	'Role' => 'Rle',

## lib/MT/Config.pm
	'Configuration' => 'Configuration',

## lib/MT/ImportExport.pm
	'No Blog' => 'Pas de Blog',
	'Need either ImportAs or ParentAuthor' => 'ImportAs ou ParentAuthor sont ncessaires',
	'Creating new user (\'[_1]\')...' => 'Cration d\'un nouvel utilisateur (\'[_1]\')...',
	'Saving user failed: [_1]' => 'chec lors de la sauvegarde de l\'utilisateur : [_1]',
	'Assigning permissions for new user...' => 'Mise en place des autorisations pour le nouvel utilisateur...',
	'Saving permission failed: [_1]' => 'chec lors de la sauvegarde des droits des utilisateurs : [_1]',
	'Creating new category (\'[_1]\')...' => 'Cration d\'une nouvelle catgorie (\'[_1]\')...',
	'Invalid status value \'[_1]\'' => 'Valeur du statut invalide \'[_1]\'',
	'Invalid allow pings value \'[_1]\'' => 'Valeur du ping invalide\'[_1]\'',
	'Can\'t find existing entry with timestamp \'[_1]\'... skipping comments, and moving on to next entry.' => 'Impossible de trouver une note avec la date \'[_1]\'... abandon de ces commentaires, et passage  la note suivante.',
	'Importing into existing entry [_1] (\'[_2]\')' => 'Importation dans la note existante [_1] (\'[_2]\')',
	'Saving entry (\'[_1]\')...' => 'Enregistrement de la note (\'[_1]\')...',
	'ok (ID [_1])' => 'ok (ID [_1])',
	'Saving entry failed: [_1]' => 'chec lors de la sauvegarde de la Note: [_1]',
	'Creating new comment (from \'[_1]\')...' => 'Cration d\'un nouveau commentaire (de \'[_1]\')...',
	'Saving comment failed: [_1]' => 'chec lors de la sauvegarde du commentaire : [_1]',
	'Entry has no MT::Trackback object!' => 'La note n\'a pas d\'objet MT::Trackback !',
	'Creating new ping (\'[_1]\')...' => 'Cration d\'un nouveau ping (\'[_1]\')...',
	'Saving ping failed: [_1]' => 'chec lors de la sauvegarde du ping : [_1]',
	'Export failed on entry \'[_1]\': [_2]' => 'chec lors de l\'exportation sur la Note \'[_1]\' : [_2]',
	'Invalid date format \'[_1]\'; must be \'MM/DD/YYYY HH:MM:SS AM|PM\' (AM|PM is optional)' => 'Format de date invalide \'[_1]\'; doit tre \'MM/DD/YYYY HH:MM:SS AM|PM\' (AM|PM est optionnel)',

## lib/MT/Template.pm
	'Template' => 'gabarit',
	'File not found: [_1]' => 'Fichier non trouv : [_1]',
	'Error reading file \'[_1]\': [_2]' => 'Erreur  la lecture du fichier \'[_1]\': [_2]',
	'Publish error in template \'[_1]\': [_2]' => 'Erreur de publication dans le gabarit \'[_1]\': [_2]',
	'Template with the same name already exists in this blog.' => 'Un gabarit avec le mme nom existe dj dans ce blog.',
	'You cannot use a [_1] extension for a linked file.' => 'Vous ne pouvez pas utiliser l\'extension [_1] pour un fichier joint.',
	'Opening linked file \'[_1]\' failed: [_2]' => 'L\'ouverture du fichier li \'[_1]\' a chou : [_2] ',
	'Index' => 'Index',
	'Category Archive' => 'Archive de catgorie',
	'Comment Listing' => 'Liste des commentaires',
	'Ping Listing' => 'Liste des pings',
	'Comment Preview' => 'Pr visualisation du commentaire',
	'Comment Error' => 'Erreur de commentaire',
	'Dynamic Error' => 'Erreur dynamique',
	'Uploaded Image' => 'Image charge',
	'Module' => 'Module',
	'Widget' => 'Widget',

## lib/MT/JunkFilter.pm
	'Action: Junked (score below threshold)' => 'Action : Indsirable (score ci-dessous)',
	'Action: Published (default action)' => 'Action : Publi (action par dfaut)',
	'Junk Filter [_1] died with: [_2]' => 'Filtre indsirable [_1] mort avec : [_2]',
	'Unnamed Junk Filter' => 'Filtre indsirable sans nom',
	'Composite score: [_1]' => 'Score composite : [_1]',

## lib/MT/Util.pm
	'moments from now' => 'maintenant',
	'[quant,_1,hour,hours] from now' => 'dans [quant,_1,heure,heures]',
	'[quant,_1,minute,minutes] from now' => 'dans [quant,_1,minute,minutes]',
	'[quant,_1,day,days] from now' => 'dans [quant,_1,jour,jours]',
	'less than 1 minute from now' => 'moins d\'une minute  partir de maintenant',
	'less than 1 minute ago' => 'il y a moins d\'une minute',
	'[quant,_1,hour,hours], [quant,_2,minute,minutes] from now' => 'dans [quant,_1,heure,heures], [quant,_2,minute,minutes]',
	'[quant,_1,hour,hours], [quant,_2,minute,minutes] ago' => 'il y a [quant,_1,heure,heures], [quant,_2,minute,minutes]',
	'[quant,_1,day,days], [quant,_2,hour,hours] from now' => 'dans [quant,_1,jour,jours], [quant,_2,heure,heures]',
	'[quant,_1,day,days], [quant,_2,hour,hours] ago' => 'il y a [quant,_1,jour,jours], [quant,_2,heure,heures]',
	'[quant,_1,second,seconds] from now' => 'dans [quant,_1,seconde,secondes]',
	'[quant,_1,second,seconds]' => '[quant,_1,seconde,secondes]',
	'[quant,_1,minute,minutes], [quant,_2,second,seconds] from now' => 'dans [quant,_1,minute,minutes], [quant,_2,seconde,secondes]',
	'[quant,_1,minute,minutes], [quant,_2,second,seconds]' => '[quant,_1,minute,minutes], [quant,_2,seconde,secondes]',
	'[quant,_1,minute,minutes]' => '[quant,_1,minute,minutes]',
	'[quant,_1,hour,hours], [quant,_2,minute,minutes]' => '[quant,_1,heure,heures], [quant,_2,minute,minutes]',
	'[quant,_1,hour,hours]' => '[quant,_1,heure,heures]',
	'[quant,_1,day,days], [quant,_2,hour,hours]' => '[quant,_1,jour,jours], [quant,_2,heure,heures]',
	'[quant,_1,day,days]' => '[quant,_1,jour,jours]',

## lib/MT/Mail.pm
	'Unknown MailTransfer method \'[_1]\'' => 'Mthode de transfert de mail inconnu \'[_1]\'',
	'Sending mail via SMTP requires that your server have Mail::Sendmail installed: [_1]' => 'Pour envoyer des mails via SMTP, votre serveur doit avoir Mail::Sendmail install: [_1]',
	'Error sending mail: [_1]' => 'Erreur lors de l\'envoi du mail : [_1]',
	'You do not have a valid path to sendmail on your machine. Perhaps you should try using SMTP?' => 'Vous n\'avez pas un chemin valide vers sendmail sur votre machine. Peut-tre devriez-vous essayer en utilisant SMTP?',
	'Exec of sendmail failed: [_1]' => 'chec lors de l\'excution de sendmail : [_1]',

## lib/MT/Worker/Publish.pm
	'-- set complete ([quant,_1,file,files] in [_2] seconds)' => '-- configuration termine ([quant,_1,fichier,fichiers] dans [_2] secondes)',

## lib/MT/Worker/Sync.pm
	'Synchrnizing Files Done' => 'Synchronisation des fichiers effectue',
	'Done syncing files to [_1] ([_2])' => 'Synchronisation des fichiers de [_1] ([_2]) termine',

## lib/MT/Auth.pm
	'Bad AuthenticationModule config \'[_1]\': [_2]' => 'Mauvaise configuration du module d\'authentification \'[_1]\': [_2]',
	'Bad AuthenticationModule config' => 'Mauvaise configuration du module d\'authentification',

## lib/MT/WeblogPublisher.pm
	'Archive type \'[_1]\' is not a chosen archive type' => 'Le Type d\'archive\'[_1]\' n\'est pas un type d\'archive slectionn',
	'Parameter \'[_1]\' is required' => 'Le paramtre \'[_1]\' est requis',
	'You did not set your blog publishing path' => 'Vous n\'avez pas spcifi le chemin de publication de votre blog',
	'The same archive file exists. You should change the basename or the archive path. ([_1])' => 'Le mme fichier d\'archive existe dj. Vous devez changer le nom de base ou le chemin de l\'archive ([_1])',
	'An error occurred publishing [_1] \'[_2]\': [_3]' => 'Une erreur s\'est produite lors de la publication [_1] \'[_2]\': [_3]',
	'An error occurred publishing date-based archive \'[_1]\': [_2]' => 'Une erreur s\'est produite en publiant l\'archive par dates \'[_1]\': [_2]',
	'Renaming tempfile \'[_1]\' failed: [_2]' => 'Le renommage de tempfile \'[_1]\' a chou: [_2]',
	'Template \'[_1]\' does not have an Output File.' => 'Le gabarit \'[_1]\' n\'a pas de fichier de sortie.',
	'An error occurred while publishing scheduled entries: [_1]' => 'Une erreur s\'est produite en publiant les notes planifies: [_1]',

## lib/MT/Permission.pm
	'Permission' => 'Autorisation',
	'Permissions' => 'Autorisations',

## lib/MT/Scorable.pm
	'Object must be saved first.' => 'L\'objet doit tre d\'abord sauvegard.',
	'Already scored for this object.' => 'Cet objet a dj t not',
	'Could not set score to the object \'[_1]\'(ID: [_2])' => 'Impossible de stocker le score de l\'objet \'[_1]\'(ID: [_2])',

## lib/MT/XMLRPCServer.pm
	'Invalid timestamp format' => 'Format de date invalide',
	'No web services password assigned.  Please see your user profile to set it.' => 'Aucun mot de passe associ aux services web. Merci de vrifier votre profil utilisateur pour le dfinir.',
	'Requested permalink \'[_1]\' is not available for this page' => 'Le lien permanent requis  \'[_1]\' n\'est pas disponible pour cette page',
	'Saving folder failed: [_1]' => 'Echec lors de la sauvegarde du rpertoire : [_1]',
	'No blog_id' => 'Pas de blog_id',
	'Invalid blog ID \'[_1]\'' => 'ID du blog invalide \'[_1]\'',
	'Value for \'mt_[_1]\' must be either 0 or 1 (was \'[_2]\')' => 'Valeur pour \'mt_[_1]\' doit tre 1 ou 0 (tait \'[_2]\')',
	'Not privileged to edit entry' => 'Non dtenteur des droits d\'dition de notes',
	'Entry \'[_1]\' ([lc,_5] #[_2]) deleted by \'[_3]\' (user #[_4]) from xml-rpc' => 'La note \'[_1]\' ([lc,_5] #[_2]) a t supprime par \'[_3]\' (utilisateur #[_4]) depuis xml-rpc',
	'Not privileged to get entry' => 'Non dtenteur des droits de possession de notes',
	'Not privileged to set entry categories' => 'Non dtenteur des droits d\'affectation des catgories d\'une note',
	'Not privileged to upload files' => 'Non dtenteur des droits de tlchargement de fichiers',
	'No filename provided' => 'Aucun nom de fichier',
	'Error writing uploaded file: [_1]' => 'Erreur lors de l\'criture du fichier tlcharg : [_1]',
	'Template methods are not implemented, due to differences between the Blogger API and the Movable Type API.' => 'Les mthodes de gabarit ne sont pas implmentes en raison d\'une diffrence entre l\'API Blogger et l\'API Movable Type.',

## lib/MT/Component.pm
	'Loading template \'[_1]\' failed: [_2]' => 'chec lors du chargement du gabarit \'[_1]\': [_2]',

## lib/MT/Comment.pm
	'Load of entry \'[_1]\' failed: [_2]' => 'Le chargement de la note \'[_1]\' a chou : [_2]',

## lib/MT/DefaultTemplates.pm
	'Archive Index' => 'Index d\'archive',
	'Stylesheet' => 'Feuille de style',
	'JavaScript' => 'JavaScript',
	'Feed - Recent Entries' => 'Flux - Notes Rcentes',
	'RSD' => 'RSD',
	'Monthly Entry Listing' => 'Liste des notes mensuelle',
	'Category Entry Listing' => 'Liste des notes catgorises',
	'Displays error, pending or confirmation message for comments.' => 'Affiche les erreurs et les messages de modration pour les commentaires.',
	'Displays preview of comment.' => 'Affiche la prvisualisation du commentaire.',
	'Displays errors for dynamically published templates.' => 'Affiche les erreurs pour les modles publis dynamiquement.',
	'Popup Image' => 'Image dans une fentre popup',
	'Displays image when user clicks a popup-linked image.' => 'Affiche l\'image quand l\'utilisateur clique sur une image pop-up.',
	'Displays results of a search.' => 'Affiche les rsultats d\'une recherche.',
	'About This Page' => ' propos de cette page',
	'Archive Widgets Group' => 'Archive du groupe des Widgets',
	'Current Author Monthly Archives' => 'Archives Mensuelles de l\'Auteur Courant',
	'Calendar' => 'Calendrier',
	'Creative Commons' => 'Creative Commons',
	'Home Page Widgets Group' => 'Page d\'accueil du groupe des Widgets',
	'Monthly Archives Dropdown' => 'Liste droulante des Archives Mensuelles',
	'Page Listing' => 'Liste des Pages',
	'Powered By' => 'Anim Par',
	'Syndication' => 'Syndication',
	'Technorati Search' => 'Recherche Technorati',
	'Date-Based Author Archives' => 'Archives des Auteurs par Dates',
	'Date-Based Category Archives' => 'Archives des Catgories par Dates',
	'OpenID Accepted' => 'OpenID Accept',
	'Comment throttle' => 'Limitation des commentaires',
	'Commenter Confirm' => 'Confirmation du commentateur',
	'Commenter Notify' => 'Notification du commentateur',
	'New Comment' => 'Nouveau commentaire',
	'New Ping' => 'Nouveau ping',
	'Entry Notify' => 'Notification de note',
	'Subscribe Verify' => 'Vrification d\'inscription',

## lib/MT.pm.pre
	'Powered by [_1]' => 'Powered by [_1]',
	'Version [_1]' => 'Version [_1]',
	'http://www.sixapart.com/movabletype/' => 'http://www.movabletype.com/',
	'OpenID URL' => 'URL OpenID',
	'Sign in using your OpenID identity.' => 'Identifiez-vous avec votre identit OpenID.',
	'OpenID is an open and decentralized single sign-on identity system.' => 'OpenID est un systme de gestion d\'identit ouvert et dcentralis pour s\'identifiant une seule fois seulement.',
	'Sign in' => 'Identification',
	'Learn more about OpenID.' => 'En savoir plus sur OpenID.',
	'Your LiveJournal Username' => 'Votre identifiant LiveJournal',
	'Sign in using your Vox blog URL' => 'Identifiez-vous en utilisant votre URL Vox',
	'Learn more about LiveJournal.' => 'En savoir plus sur LiveJournal.',
	'Your Vox Blog URL' => 'L\'URL de votre blog Vox',
	'Learn more about Vox.' => 'En savoir plus sur Vox.',
	'TypeKey is a free, open system providing you a central identity for posting comments on weblogs and logging into other websites. You can register for free.' => 'TypeKey est un systme gratuit et ouvert qui fournit une identit centralise pour poster des commentaires sur les blogs et vous identifier sur d\'autres sites web. Vous pouvez crer un compte gratuitement.',
	'Sign in or register with TypeKey.' => 'Identifiez-vous ou enregistrez-vous avec TypeKey.',
	'Hello, world' => 'Bonjour,',
	'Hello, [_1]' => 'Bonjour, [_1]',
	'Message: [_1]' => 'Message: [_1]',
	'If present, 3rd argument to add_callback must be an object of type MT::Component or MT::Plugin' => 'Si prsent, le 3me argument de add_callback doit tre un objet de type MT::Component ou MT:Plugin',
	'4th argument to add_callback must be a CODE reference.' => '4me argument de add_callback doit tre une rfrence de CODE.',
	'Two plugins are in conflict' => 'Deux plugins sont en conflit',
	'Invalid priority level [_1] at add_callback' => 'Niveau de priorit invalide [_1] dans add_callback',
	'Unnamed plugin' => 'Plugin sans nom',
	'[_1] died with: [_2]' => '[_1] mort avec: [_2]',
	'Bad ObjectDriver config' => 'Mauvaise config ObjectDriver',
	'Bad CGIPath config' => 'Mauvaise config CGIPath',
	'Missing configuration file. Maybe you forgot to move mt-config.cgi-original to mt-config.cgi?' => 'Fichier de configuration manquant. Avez-vous oubli de dplacer mt-config.cgi-original vers mt-config.cgi?',
	'Plugin error: [_1] [_2]' => 'Erreur de Plugin: [_1] [_2]',
	'Loading template \'[_1]\' failed.' => 'Le chargement du template \'[_1]\' a chou.',
	'__PORTAL_URL__' => '__PORTAL_URL__',
	'http://www.movabletype.org/documentation/' => 'http://www.movabletype.org/documentation/',
	'OpenID' => 'OpenID',
	'LiveJournal' => 'LiveJournal',
	'Vox' => 'Vox',
	'TypeKey' => 'TypeKey',
	'Movable Type default' => 'Valeur par dfaut Movable Type',

## mt-static/mt.js
	'delete' => 'supprimer',
	'remove' => 'retirer',
	'enable' => 'activer',
	'disable' => 'dsactiver',
	'You did not select any [_1] to [_2].' => 'Vous n\'avez pas slectionn de [_1]  [_2].',
	'Are you sure you want to [_2] this [_1]?' => 'tes-vous sr(e) de vouloir [_2] : [_1]?',
	'Are you sure you want to [_3] the [_1] selected [_2]?' => 'tes-vous sr(e) de vouloir [_3] les [_1] [_2] slectionn(e)s?',
	'Are you certain you want to remove this role? By doing so you will be taking away the permissions currently assigned to any users and groups associated with this role.' => 'tes-vous sr(e) de vouloir supprimer ce rle. En faisant cela vous allez supprimer les autorisations de tous les utilisateurs et groupes associs  ce rle.',
	'Are you certain you want to remove these [_1] roles? By doing so you will be taking away the permissions currently assigned to any users and groups associated with these roles.' => 'tes-vous sr(e) de vouloir supprimer les rles [_1] ? Avec cette actions vous allez supprimer les autorisations associes  tous les utilisateurs et groupes lis  ce rle.',
	'You did not select any [_1] [_2].' => 'Vous n\'avez pas slectionn de [_1] [_2].',
	'You can only act upon a minimum of [_1] [_2].' => 'Vous ne pouvez agir que sur un minimum de [_1] [_2].',
	'You can only act upon a maximum of [_1] [_2].' => 'Vous ne pouvez agir que sur un maximum de [_1] [_2].',
	'You must select an action.' => 'Vous devez slectionner une action.',
	'to mark as spam' => 'pour classer comme spam',
	'to remove spam status' => 'pour retirer le statut de spam',
	'Enter email address:' => 'Saisissez l\'adresse email :',
	'Enter URL:' => 'Saisissez l\'URL :',
	'The tag \'[_2]\' already exists. Are you sure you want to merge \'[_1]\' with \'[_2]\'?' => 'Le tag \'[_2]\' existe dj. tes-vous sr(e) de vouloir fusionner \'[_1]\' avec \'[_2]\'?',
	'The tag \'[_2]\' already exists. Are you sure you want to merge \'[_1]\' with \'[_2]\' across all weblogs?' => 'Le tag \'[_2]\' existe dj. tes-vous sr(e) de vouloir fusionner \'[_1]\' avec \'[_2]\' sur tous les blogs?',
	'Loading...' => 'Chargement...',
	'[_1] &ndash; [_2] of [_3]' => '[_1] &ndash; [_2] de [_3]',
	'[_1] &ndash; [_2]' => '[_1] &ndash; [_2]',

## mt-static/js/dialog.js
	'(None)' => '(Aucun)',

## mt-static/js/assetdetail.js
	'No Preview Available' => 'Pas de pr-visualisation possible',
	'View uploaded file' => 'Voir le fichier envoy',

## search_templates/comments.tmpl
	'Search for new comments from:' => 'Recherche de nouveaux commentaires depuis :',
	'the beginning' => 'le dbut',
	'one week back' => 'une semaine',
	'two weeks back' => 'deux semaines',
	'one month back' => 'un mois',
	'two months back' => 'deux mois',
	'three months back' => 'trois mois',
	'four months back' => 'quatre mois',
	'five months back' => 'cinq mois',
	'six months back' => 'six mois',
	'one year back' => 'un an',
	'Find new comments' => 'Voir les nouveaux commentaires',
	'Posted in [_1] on [_2]' => 'Publi dans [_1] le [_2]',
	'No results found' => 'Aucun rsultat n\'a t trouv',
	'No new comments were found in the specified interval.' => 'Aucun nouveau commentaire n\'a t trouv dans la priode spcifie.',
	'Select the time interval that you\'d like to search in, then click \'Find new comments\'' => 'Slectionner l\'intervalle de temps dsir pour la recherche, puis cliquez sur \'Voir les nouveaux commentaires\'',

## search_templates/default.tmpl
	'SEARCH FEED AUTODISCOVERY LINK PUBLISHED ONLY WHEN A SEARCH HAS BEEN EXECUTED' => 'LE LIEN DU FLUX DE LA RECHERCHE AUTOMATISE EST PUBLI UNIQUEMENT APRES L\'EXCUTION D\'UNE RECHERCHE.',
	'Blog Search Results' => 'Rsultats de la recherche',
	'Blog search' => 'Recherche de Blog',
	'STRAIGHT SEARCHES GET THE SEARCH QUERY FORM' => 'LES RECHERCHES SIMPLES ONT LE FORMULAIRE DE RECHERCHES',
	'Search this site' => 'Rechercher sur ce site',
	'Match case' => 'Respecter la casse',
	'SEARCH RESULTS DISPLAY' => 'AFFICHAGE DES RESULTATS DE LA RECHERCHE',
	'Matching entries from [_1]' => 'Notes correspondant  [_1]',
	'Entries from [_1] tagged with \'[_2]\'' => 'Notes  partir de [_1] tagues avec \'[_2]\'',
	'Posted <MTIfNonEmpty tag="EntryAuthorDisplayName">by [_1] </MTIfNonEmpty>on [_2]' => 'Post <MTIfNonEmpty tag="EntryAuthorDisplayName">par [_1] </MTIfNonEmpty>le [_2]',
	'Showing the first [_1] results.' => 'Afficher les premiers [_1] resultats.',
	'NO RESULTS FOUND MESSAGE' => 'MESSAGE AUCUN RSULTAT',
	'Entries matching \'[_1]\'' => 'Notes correspondant  \'[_1]\'',
	'Entries tagged with \'[_1]\'' => 'Notes tagues avec \'[_1]\'',
	'No pages were found containing \'[_1]\'.' => 'Aucune page trouve contenant \'[_1]\'.',
	'By default, this search engine looks for all words in any order. To search for an exact phrase, enclose the phrase in quotes' => 'Par dfaut, ce moteur de recherche analyse l\'ensemble des mots sans se proccuper de leur ordre. Pour lancer une recherche sur une phrase exacte, insrez-la entre guillemets.',
	'The search engine also supports AND, OR, and NOT keywords to specify boolean expressions' => 'Le moteur de recherche admet aussi AND, OR et NOT mais pas des mots clefs pour spcifier des expressions particulires',
	'END OF ALPHA SEARCH RESULTS DIV' => 'FIN DE LA RECHERCHE ALPHA RESULTATS DIV',
	'BEGINNING OF BETA SIDEBAR FOR DISPLAY OF SEARCH INFORMATION' => 'DEBUT DE LA COLONNE BETA POUR AFFICHAGE DES INFOS DE RECHERCHE',
	'SET VARIABLES FOR SEARCH vs TAG information' => 'DEFINIT LES VARIABLES DE RECHERCHE vs informations TAGS',
	'If you use an RSS reader, you can subscribe to a feed of all future entries tagged \'[_1]\'.' => 'Si vous utilisez un lecteur de flux RSS, vous pouvez souscrire au flux de toutes notes futures dont le tag sera \'[_1]\'.',
	'If you use an RSS reader, you can subscribe to a feed of all future entries matching \'[_1]\'.' => 'Si vous utilisez un lecteur de flux RSS, vous pouvez souscrire au flux des futures notes contenant le mot \'[_1]\'.',
	'SEARCH/TAG FEED SUBSCRIPTION INFORMATION' => 'RECHERCHE/INFORMATION D\'ABONNEMENT AU FLUX',
	'Feed Subscription' => 'Abonnement au flux',
	'http://www.sixapart.com/about/feeds' => 'http://www.sixapart.com/about/feeds',
	'What is this?' => 'De quoi s\'agit-il?',
	'TAG LISTING FOR TAG SEARCH ONLY' => 'LISTE DES TAGS UNIQUEMENT POUR LA RECHERCHE DE TAG',
	'Other Tags' => 'Autres tags',
	'END OF PAGE BODY' => 'FIN DU CORPS DE LA PAGE',
	'END OF CONTAINER' => 'FIN DU CONTENU',

## search_templates/results_feed_rss2.tmpl
	'Search Results for [_1]' => 'Rsultats de la recherche sur [_1]',

## search_templates/results_feed.tmpl

## tmpl/wizard/optional.tmpl
	'Mail Configuration' => 'Configuration Mail',
	'Your mail configuration is complete.' => 'Votre configuration email est complte.',
	'Check your email to confirm receipt of a test email from Movable Type and then proceed to the next step.' => 'Vrifiez votre adresse email pour confirmer la rception d\'un email de test de Movable Type et ensuite passez  l\'tape suivante.',
	'Back' => 'Retour',
	'Continue' => 'Continuer',
	'Show current mail settings' => 'Montrer les paramtres d\'email actuels',
	'Periodically Movable Type will send email to inform users of new comments as well as other other events. For these emails to be sent properly, you must instruct Movable Type how to send email.' => 'Movable Type va envoyer priodiquement des emails afin d\'informer les utilisateurs des nouveaux commentaires et autres vnements. Pour que ces emails puissent tre envoys correctement, veuillez spcifier la mthode que Movable Type va utiliser.',
	'An error occurred while attempting to send mail: ' => 'Une erreur s\'est produite en essayant d\'envoyer un email: ',
	'Send email via:' => 'Envoyer email via :',
	'Select One...' => 'Slectionner un...',
	'sendmail Path' => 'Chemin sendmail',
	'The physical file path for your sendmail binary.' => 'Le chemin du fichier physique de votre binaire sendmail.',
	'Outbound Mail Server (SMTP)' => 'Serveur email sortant (SMTP)',
	'Address of your SMTP Server.' => 'Adresse de votre serveur SMTP.',
	'Mail address for test sending' => 'Adresse email pour envoi d\'un test',
	'Send Test Email' => 'Envoyer un email de test',

## tmpl/wizard/complete.tmpl
	'Configuration File' => 'Fichier de configuration',
	'The [_1] configuration file can\'t be located.' => 'Le fichier de configuration [_1] n\'a pas pu tre trouv',
	'Please use the configuration text below to create a file named \'mt-config.cgi\' in the root directory of [_1] (the same directory in which mt.cgi is found).' => 'Crez un fichier nomm dans le rpertoire racine de [_1] (le mme qui contient mt.cgi) ayant pour contenu le texte de configuration ci-dessous.',
	'The wizard was unable to save the [_1] configuration file.' => 'L\'assistant n\'a pas pu enregistrer le fichier de configuration [_1]',
	'Confirm your [_1] home directory (the directory that contains mt.cgi) is writable by your web server and then click \'Retry\'.' => 'Vrifiez que votre rpertoire [_1] (celui qui contient mt.cgi) est ouvert en criture pour votre serveur web et cliquez sur Recommencer',
	'Congratulations! You\'ve successfully configured [_1].' => 'Flicitations ! Vous avez configur [_1] avec succs.',
	'Your configuration settings have been written to the following file:' => 'Vos paramtres de configuration ont t crits dans le fichier suivant:',
	'To reconfigure the settings, click the \'Back\' button below.' => 'Pour reconfigurer vos paramtres, cliquez sur le bouton \'Retour\' ci-dessous. Sinon, cliquez sur Continuer.',
	'Show the mt-config.cgi file generated by the wizard' => 'Afficher le fichier mt-config.cgi gnr par l\'assistant',
	'The mt-config.cgi file has been created manually.' => 'Le fichier mt-config.cgi a t cr manuellement.',
	'Retry' => 'Recommencer',

## tmpl/wizard/cfg_dir.tmpl
	'Temporary Directory Configuration' => 'Configuration du rpertoire temporaire',
	'You should configure you temporary directory settings.' => 'Vous devriez configurer les paramtres de votre rpertoire temporaire.',
	'Your TempDir has been successfully configured. Click \'Continue\' below to continue configuration.' => 'Votre Tempdir a t correctement configur. Cliquez sur \'Continuer\' ci-dessous pour continuer la configuration.',
	'[_1] could not be found.' => '[_1] introuvable.',
	'TempDir is required.' => 'TempDir est requis.',
	'TempDir' => 'TempDir',
	'The physical path for temporary directory.' => 'Chemin physique pour le rpertoire temporaire.',
	'Test' => 'Test',

## tmpl/wizard/start.tmpl
	'Welcome to Movable Type' => 'Bienvenue dans Movable Type',
	'Configuration File Exists' => 'Le fichier de configuration existe',
	'A configuration (mt-config.cgi) file already exists, <a href="[_1]">sign in</a> to Movable Type.' => 'Un fichier de configuration (mt-config.cgi) existe dj, <a href="[_1]">identifiez-vous</a> dans Movable Type.',
	'To create a new configuration file using the Wizard, remove the current configuration file and then refresh this page' => 'Pour crer un nouveau fichier de configuration avec l\'assistant, supprimez le fichier de configuration actuel puis rechargez cette page',
	'Movable Type requires that you enable JavaScript in your browser. Please enable it and refresh this page to proceed.' => 'Pour utiliser Movable Type, vous devez activer les JavaScript sur votre navigateur. Merci de les activer et de relancer le navigateur pour commencer.',
	'This wizard will help you configure the basic settings needed to run Movable Type.' => 'Vous allez maintenant, grce  cet assistant de configuration, mettre en place les paramtres de base afin d\'assurer le fonctionnement de Movable Type.',
	'<strong>Error: \'[_1]\' could not be found.</strong>  Please move your static files to the directory first or correct the setting if it is incorrect.' => '<strong>Erreur: \'[_1]\' n\'a pas pu tre trouv(e).</strong>  Veuillez dplacer vos fichiers statiques vers le rpertoire premier ou mettre  jour les paramtres si ncessaire.',
	'Configure Static Web Path' => 'Configurer le chemin web statique',
	'Movable Type ships with directory named [_1] which contains a number of important files such as images, javascript files and stylesheets.' => 'Movable Type est fourni avec un rpertoire nomm [_1] contenant un nombre important de fichiers comme des images, fichiers javascripts et feuilles de style.',
	'The [_1] directory is in the main Movable Type directory which this wizard script resides, but due to your web server\'s configuration, the [_1] directory is not accessible in this location and must be moved to a web-accessible location (e.g., your web document root directory).' => 'Le rpertoire [_1] est le rpertoire principal de Movable Type contenant les scripts de cet assistant, mais  cause de la configuration de votre serveur web, le rpertoire [_1] n\'est pas accessible  cette adresse et doit tre dplac vers un serveur web (par exemple, le rpertoire document  la racine). ',
	'This directory has either been renamed or moved to a location outside of the Movable Type directory.' => 'Ce rpertoire a t renomm ou dplac en dehors du rpertoire Movable Type.',
	'Once the [_1] directory is in a web-accessible location, specify the location below.' => 'Dplacez ou crez un lien symbolique du rpertoire [_1] dans un endroit accessible depuis le web et spcifiez le chemin web statique dans le champs ci-dessous.',
	'This URL path can be in the form of [_1] or simply [_2]' => 'Ce chemin d\'URL peut tre de la forme [_1] ou simplement [_2]',
	'This path must be in the form of [_1]' => 'Ce chemin doit tre de la forme [_1]',
	'Static web path' => 'Chemin web statique',
	'Static file path' => 'Chemin fichier statique',
	'Begin' => 'Commencer',

## tmpl/wizard/packages.tmpl
	'Requirements Check' => 'Vrifications des lments ncessaires',
	'The following Perl modules are required in order to make a database connection.  Movable Type requires a database in order to store your blog\'s data.  Please install one of the packages listed here in order to proceed.  When you are ready, click the \'Retry\' button.' => 'Les modules Perl suivants sont ncessaires pour raliser une connexion  une base de donnes.  Movable Type ncessite une base de donnes pour stocker les donnes de votre blog.  Merci d\'installer un des packages lists ici avant de continuer.  quand vous tes prt, cliquez sur le bouton \'Ressayer\'.',
	'All required Perl modules were found.' => 'Tous les modules Perl obligatoires ont t trouvs.',
	'You are ready to proceed with the installation of Movable Type.' => 'Vous tes prt  procder  l\'installation de Movable Type.',
	'Some optional Perl modules could not be found. <a href="javascript:void(0)" onclick="[_1]">Display list of optional modules</a>' => 'Certains modules Perl optionnels ne peuvent tre trouvs. <a href="javascript:void(0)" onclick="[_1]">Afficher la liste des modules optionnels</a>',
	'One or more Perl modules required by Movable Type could not be found.' => 'Un ou plusieurs modules Perl ncessaires pour Movable Type n\'ont pu tre trouvs.',
	'The following Perl modules are required for Movable Type to run properly. Once you have met these requirements, click the \'Retry\' button to re-test for these packages.' => 'Les modules Perl suivants sont ncessaires au bon fonctionnement de Movable Type. Ds que vous disposez de ces lments, cliquez sur le bouton \'Recommencer\' pour vrifier ces lments..',
	'Some optional Perl modules could not be found. You may continue without installing these optional Perl modules. They may be installed at any time if they are needed. Click \'Retry\' to test for the modules again.' => 'Certains modules Perl optionnels n\'ont pu tre trouvs. Vous pouvez continuer sans installer ces modules Perl. Ils peuvent tre installs n\'importe quand si besoin. Cliquez \'Ressayer\' pour tester  nouveau ces modules.',
	'Missing Database Modules' => 'Modules de base de donnes manquants',
	'Missing Optional Modules' => 'Modules optionnels manquants',
	'Missing Required Modules' => 'Modules ncessaires absents',
	'Minimal version requirement: [_1]' => 'Version minimale ncessaire : [_1]',
	'Learn more about installing Perl modules.' => 'Plus d\'informations sur l\'installation de modules Perl.',
	'Your server has all of the required modules installed; you do not need to perform any additional module installations.' => 'Votre serveur possde tous les modules ncessaires; vous n\'avez pas  procder  des installations complmentaires de modules',

## tmpl/wizard/configure.tmpl
	'Database Configuration' => 'Configuration de la Base de Donnes',
	'You must set your Database Path.' => 'Vous devez dfinir le Chemin de Base de Donnes.',
	'You must set your Database Name.' => 'Vous devez dfinir un Nom de Base de donnes.',
	'You must set your Username.' => 'Vous devez dfinir votre nom d\'utilisateur.',
	'You must set your Database Server.' => 'Vous devez dfinir votre serveur de Base de donnes.',
	'Your database configuration is complete.' => 'Votre configuration de base de donnes est termine.',
	'You may proceed to the next step.' => 'Vous pouvez passer  l\'tape suivante.',
	'Please enter the parameters necessary for connecting to your database.' => 'Merci de saisir les paramtres ncessaires pour se connecter  votre base de donnes.',
	'Show Current Settings' => 'Montrer les paramtres actuels',
	'Database Type' => 'Type de base de donnes',
	'http://www.movabletype.org/documentation/[_1]' => 'http://www.movabletype.org/documentation/[_1]',
	'Is your preferred database not listed? View the <a href="[_1]" target="_blank">Movable Type System Check</a> see if additional modules are necessary.' => 'Votre base de donnes prfre n\'est pas liste ? Regardez <a href="[_1]" target="_blank">Movable Type System Check</a> pour voir s\'il y a des modules additionnels ncessaires pour permettre son utilisation.',
	'Once installed, <a href="javascript:void(0)" onclick="[_1]">click here to refresh this screen</a>.' => 'Une fois install, <a href="javascript:void(0)" onclick="[_1]">cliquez ici pour ractualiser cette page</a>.',
	'Read more: <a href="[_1]" target="_blank">Setting Up Your Database</a>' => 'Apprenez-en plus : <a href="[_1]" target="_blank">Configurez votre base de donnes</a>',
	'Database Path' => 'Chemin de la Base de Donnes',
	'The physical file path for your SQLite database. ' => 'Le chemin du fichier physique de votre base de donnes SQLite. ',
	'A default location of \'./db/mt.db\' will store the database file underneath your Movable Type directory.' => 'Un endroit par dfaut \'./db/mt.db\' stockera le fichier de base de donnes dans votre rpertoire Movable Type.',
	'Database Server' => 'Serveur de Base de donnes',
	'This is usually \'localhost\'.' => 'C\'est gnralement \'localhost\'.',
	'Database Name' => 'Nom de la Base de donnes',
	'The name of your SQL database (this database must already exist).' => 'Le nom de votre Base de donnes SQL (cette base de donnes doit tre dj prsente).',
	'The username to login to your SQL database.' => 'Le nom d\'utilisateur pour accder  la Base de donnes SQL.',
	'Password' => 'Mot de passe',
	'The password to login to your SQL database.' => 'Le mot de passe pour accder  la Base de donnes SQL.',
	'Show Advanced Configuration Options' => 'Montrer les options avances de configuration',
	'Database Port' => 'Port de la Base de donnes',
	'This can usually be left blank.' => 'Peut tre laiss vierge.',
	'Database Socket' => 'Socket de la Base de donnes',
	'Publish Charset' => 'Publier le  Charset',
	'MS SQL Server driver must use either Shift_JIS or ISO-8859-1.  MS SQL Server driver does not support UTF-8 or any other character set.' => 'Le driver  Serveur MS SQL doit utiliser Shift_JIS ou ISO-8859-1.  Le driver serveur MS SQL ne supporte pas UTF-8 ou tout autre jeu de caractres.',
	'Test Connection' => 'Test de Connexion',

## tmpl/wizard/blog.tmpl
	'Setup Your First Blog' => 'Configurer votre premier blog',
	'In order to properly publish your blog, you must provide Movable Type with your blog\'s URL and the path on the filesystem where its files should be published.' => 'Pour pouvoir publier correctement votre blog, vous devez fournir  Movable Type l\'URL du blog et le chemin sur le disque o les fichiers doivent tre publis.',
	'My First Blog' => 'Mon Premier Blog',
	'Publishing Path' => 'Chemin de publication',
	'Your \'Publishing Path\' is the path on your web server\'s file system where Movable Type will publish all the files for your blog. Your web server must have write access to this directory.' => 'Votre \'Chemin de publication\' est le chemin sur le disque de votre serveur web o Movable Type va publier tous les fichiers de votre blog. Votre serveur web doit avoir un accs en criture  ce rpertoire.',

## tmpl/cms/edit_template.tmpl
	'Edit Widget' => 'Editer le Widget',
	'Create Widget' => 'Crer un Widget',
	'Create Template' => 'Crer le gabarit',
	'A saved version of this [_1] was auto-saved [_3]. <a href="[_2]">Recover auto-saved content</a>' => 'Une version de sauvegarde de [_1] a t automatiquement sauvegarde [_3]. <a href="[_2]">Rcuprer le contenu sauvegard</a>',
	'You have successfully recovered your saved [_1].' => 'Vous avez rcupr avec succs votre [_1] sauvegarde.',
	'An error occurred while trying to recover your saved [_1].' => 'Une erreur s\'est produite en essayant de rcuprer votre [_1] sauvegarde.',
	'Your template changes have been saved.' => 'Les modifications apportes ont t enregistres.',
	'<a href="[_1]" class="rebuild-link">Publish</a> this template.' => '<a href="[_1]" class="rebuild-link">Publier</a> ce gabarit.',
	'Your [_1] has been published.' => 'Votre [_1] a t publie.',
	'Useful Links' => 'Liens utiles',
	'List [_1] templates' => 'Lister des gabarits de type [_1]',
	'List all templates' => 'Lister tous les gabarits',
	'_external_link_target' => '_blank',
	'View Published Template' => 'Voir le gabarit publi',
	'Included Templates' => 'Gabarits inclus',
	'create' => 'crer',
	'Template Tag Docs' => 'Docs des tags de gabarits',
	'Unrecognized Tags' => 'Tags non reconnus',
	'Save (s)' => 'Enregistrer (s)',
	'Save' => 'Enregistrer',
	'Save and Publish this template (r)' => 'Enregistrer et publier ce gabarit (r)',
	'Save &amp; Publish' => 'Enregistrer &amp; publier',
	'You have unsaved changes to this template that will be lost.' => 'Certains de vos changements n\'ont pas t enregistrs : ils seront perdus.',
	'You must set the Template Name.' => 'Vous devez mettre un nom de gabarit.',
	'You must set the template Output File.' => 'Vous devez configurer le fichier de sortie du gabarit.',
	'Processing request...' => 'Requte en cours d\'excution...',
	'Error occurred while updating archive maps.' => 'Une erreur s\'est produite en mettant  jour les archive maps.',
	'Archive map has been successfully updated.' => 'L\'archive map a t modifie avec succs.',
	'Are you sure you want to remove this template map?' => 'tes-vous sr de vouloir supprimer cette table de correspondance de gabarit ?',
	'Module Body' => 'Corps du module',
	'Template Body' => 'Corps du gabarit',
	'Syntax Highlight On' => 'Coloriage de la syntaxe activ',
	'Syntax Highlight Off' => 'Coloriage de la syntaxe dsactiv',
	'Insert...' => 'Insertion...',
	'Template Options' => 'Options de gabarit',
	'Output file: <strong>[_1]</strong>' => 'Fichier de sortie : <strong>[_1]</strong>',
	'Enabled Mappings: [_1]' => 'Tables de correspondances activs : [_1]',
	'Output File' => 'Fichier de sortie',
	'Template Type' => 'Type de gabarit',
	'Custom Index Template' => 'Gabarit d\'index personnalis',
	'Link to File' => 'Lien vers le fichier',
	'Learn more about <a href="http://www.movabletype.org/documentation/administrator/publishing/settings.html" target="_blank">publishing settings</a>' => 'Apprennez en plus  propos des <a href="http://www.movabletype.org/documentation/administrator/publishing/settings.html" target="_blank">paramtres de publication</a>',
	'Create Archive Mapping' => 'Crer une nouvelle table de correspondance des archives',
	'Type' => 'Type',
	'Add' => 'Ajouter',
	'Statically (default)' => 'Statique (dfaut)',
	'Via Publish Queue' => 'Via une Publication en Mode File d\'Attente',
	'On a schedule' => 'Planifi',
	': every ' => ': chaque ',
	'minutes' => 'minutes',
	'hours' => 'heures',
	'days' => 'jours',
	'Dynamically' => 'Dynamique',
	'Manually' => 'Manuellement',
	'Do Not Publish' => 'Ne Pas Publier',
	'Server Side Include' => 'Server Side Include',
	'Process as <strong>[_1]</strong> include' => 'Traiter comme inclusion de <strong>[_1]</strong>',
	'Include cache path' => 'Inclure le chemin du cache',
	'Disabled (<a href="[_1]">change publishing settings</a>)' => 'Dsactiv (<a href="[_1]">changer les paramtres de publication</a>)',
	'No caching' => 'Pas de cache',
	'Expire after' => 'Expire aprs',
	'Expire upon creation or modification of:' => 'Expire lors de la cration ou modification de :',
	'Auto-saving...' => 'Sauvegarde automatique...',
	'Last auto-save at [_1]:[_2]:[_3]' => 'Dernire sauvegarde automatique  [_1]:[_2]:[_3]',

## tmpl/cms/edit_role.tmpl
	'Edit Role' => 'Modifier le rle',
	'Your changes have been saved.' => 'Les modifications ont t enregistres.',
	'List Roles' => 'Lister les rles',
	'[quant,_1,User,Users] with this role' => '[quant,_1,Utilisateur,Utilisateurs] avec ce rle',
	'You have changed the privileges for this role. This will alter what it is that the users associated with this role will be able to do. If you prefer, you can save this role with a different name.  Otherwise, be aware of any changes to users with this role.' => 'Vous avez chang les privilges pour ce rle. Cela va modifier ce que les utilisateurs associs  ce rle ont la possibilit de faire. Si vous prfrez, vous pouvez sauvegarder ce rle avec un nom diffrent.',
	'Role Details' => 'Dtails du rle',
	'Created by' => 'Cr par',
	'System' => 'Systme',
	'Privileges' => 'Privilges',
	'Check All' => 'Slectionner tout',
	'Uncheck All' => 'Dslectionner tout',
	'Administration' => 'Administration',
	'Authoring and Publishing' => 'Auteurs et Publication',
	'Designing' => 'Designer',
	'Commenting' => 'Commenter',
	'Duplicate Roles' => 'Dupliquer les rles',
	'These roles have the same privileges as this role' => 'Ces rles ont les mme privilges que ce rle',
	'Save changes to this role (s)' => 'Enregistrer les modifications de ce rle (s)',
	'Save Changes' => 'Enregistrer les modifications',

## tmpl/cms/cfg_system_general.tmpl
	'System: General Settings' => 'Paramtres gnraux',
	'Your settings have been saved.' => 'Vos paramtres ont t enregistrs.',
	'System Email' => 'Email systme',
	'The email address used in the From: header of each email sent from the system.  The address is used in password recovery, commenter registration, comment, trackback notification and a few other minor events.' => 'Cette adresse email sera utilise dans l\'en-tte From: des emails envoys par le systme. L\'adresse est utilise dans la rcupration des mots de passe, l\'enregistrement d\'auteurs de commentaires, les notifications de commentaires, trackbacks, ainsi que certains autres vnements mineurs.',
	'Save changes to these settings (s)' => 'Enregistrer les modifications de ces paramtres (s)',

## tmpl/cms/cfg_plugin.tmpl
	'System Plugin Settings' => 'Paramtres du systme de plugins',
	'Useful links' => 'Liens utiles',
	'http://plugins.movabletype.org/' => 'http://plugins.movabletype.org/',
	'Find Plugins' => 'Trouver des plugins',
	'Plugin System' => 'Systme de plugins',
	'Manually enable or disable plugin-system functionality. Re-enabling plugin-system functionality, will return all plugins to their original state.' => 'Activer ou dsactiver la prise en charge des plugins manuellement. La ractivation de cette prise en charge rendra  tous les plugins leur tat original',
	'Disable plugin functionality' => 'Dsactiver la prise en charge des plugins',
	'Disable Plugins' => 'Dsactiver les plugins',
	'Enable plugin functionality' => 'Activer la prise en charge des plugins',
	'Enable Plugins' => 'Activer les plugins',
	'Your plugin settings have been saved.' => 'Les paramtres de votre plugin ont t enregistrs.',
	'Your plugin settings have been reset.' => 'Les paramtres de votre plugin on t rinitialiss.',
	'Your plugins have been reconfigured. Since you\'re running mod_perl, you will need to restart your web server for these changes to take effect.' => 'Vos plugins ont t reconfigurs. Si vous tes sous mod_perl vous devez redmarrer votre serveur web pour la prise en compte de ces changements.',
	'Your plugins have been reconfigured.' => 'Votre plugin a t reconfigur.',
	'Are you sure you want to reset the settings for this plugin?' => 'tes-vous sr de vouloir r-initialiser les paramtres pour ce plugin ?',
	'Are you sure you want to disable plugin functionality?' => 'tes-vous sr de vouloir dsactiver la prise en charge des plugins ?',
	'Disable this plugin?' => 'Dsactiver ce plugin ?',
	'Are you sure you want to enable plugin functionality? (This will re-enable any plugins that were not individually disabled.)' => 'tes-vous sr de vouloir activer les plugins ? (Cela r-activera tous les plugins qui n\'ont pas t dsactivs manuellement)',
	'Enable this plugin?' => 'Activer ce plugin ?',
	'Failed to Load' => 'Erreur de chargement',
	'(Disable)' => '(Dsactiver)',
	'Enabled' => 'Activ',
	'Disabled' => 'Dsactiv',
	'(Enable)' => '(Activer)',
	'Settings for [_1]' => 'Paramtres pour [_1]',
	'This plugin has not been upgraded to support Movable Type [_1]. As such, it may not be 100% functional. Furthermore, it will require an upgrade once you have upgraded to the next Movable Type major release (when available).' => 'Ce plugin n\'a pas t mis  jour pour supporter Movable Type [_1]. Ainsi, il n\'est peut-tre pas fonctionnel  100%. De plus, il ncessitera une mise  jour ds que vous aurez mis  jour Movable Type  la prochaine version majeure (quand elle sera disponible).',
	'Plugin error:' => 'Erreur plugin :',
	'Info' => 'Info',
	'Resources' => 'Ressources',
	'Run [_1]' => 'Lancer [_1]',
	'Documentation for [_1]' => 'Documentation pour [_1]',
	'Documentation' => 'Documentation',
	'More about [_1]' => 'En savoir plus sur [_1]',
	'Plugin Home' => 'Accueil Plugin',
	'Author of [_1]' => 'Auteur de [_1]',
	'Tags:' => 'Tags:',
	'Tag Attributes:' => 'Attributs de tag:',
	'Text Filters' => 'Filtres de texte',
	'Junk Filters:' => 'Filtres de spam:',
	'Reset to Defaults' => 'R-initialiser (retour aux paramtres par dfaut)',
	'No plugins with blog-level configuration settings are installed.' => 'Aucun plugin avec une configuration au niveau du blog n\'est install.',
	'No plugins with configuration settings are installed.' => 'Aucun plugin avec une configuration n\'est install',

## tmpl/cms/list_blog.tmpl
	'You have successfully deleted the blogs from the Movable Type system.' => 'Le blog a t correctement supprim du systme Movable Type.',
	'You have successfully refreshed your templates.' => 'Vous avez ractualis avec succs vos gabarits.',
	'You can not refresh templates: [_1]' => 'Vous ne pouvez pas ractualiser le(s) gabarit(s) : [_1]',
	'Create Blog' => 'Crer un blog',

## tmpl/cms/cfg_trackbacks.tmpl
	'TrackBack Settings' => 'Paramtres des trackbacks',
	'Your TrackBack preferences have been saved.' => 'Vos prfrences de trackback ont t sauvegardes.',
	'Note: TrackBacks are currently disabled at the system level.' => 'Note: Les trackbacks sont actuellement dsactivs au niveau systme.',
	'Accept TrackBacks' => 'Accepter les trackbacks',
	'If enabled, TrackBacks will be accepted from any source.' => 'Si activ, les trackbacks seront accepts quelle que soit la source.',
	'TrackBack Policy' => 'Rgles pour les trackbacks',
	'Moderation' => 'Modration',
	'Hold all TrackBacks for approval before they\'re published.' => 'Retenir les trackbacks pour approbation avant publication.',
	'Apply \'nofollow\' to URLs' => 'Appliquer \'nofollow\' aux URLs',
	'This preference affects both comments and TrackBacks.' => 'Cette prfrence affecte les commentaires et les trackbacks.',
	'If enabled, all URLs in comments and TrackBacks will be assigned a \'nofollow\' link relation.' => 'Si activ, toutes les URLs dans les commentaires et les trackbacks seront affectes d\'un attribut de lien \'nofollow\'.',
	'E-mail Notification' => 'Notification par email',
	'Specify when Movable Type should notify you of new TrackBacks if at all.' => 'Spcifier quand Movable Type doit vous notifier les nouveaux trackbacks.',
	'On' => 'Active',
	'Only when attention is required' => 'Uniquement quand l\'attention est requise',
	'Off' => 'Dsactive',
	'TrackBack Options' => 'Options de trackback',
	'TrackBack Auto-Discovery' => 'Activer la dcouverte automatique des trackbacks',
	'If you turn on auto-discovery, when you write a new entry, any external links will be extracted and the appropriate sites automatically sent TrackBacks.' => 'Si vous activez la dcouverte automatique, quand vous crivez une nouvelle note, tous les liens externes seront extraits et les sites correspondants recevront un trackback.',
	'Enable External TrackBack Auto-Discovery' => 'Pour les notes extrieures au blog',
	'Setting Notice' => 'Paramtre des informations',
	'Note: The above option may be affected since outbound pings are constrained system-wide.' => 'Attention : L\'option ci-dessous peut tre affecte si les pings sortant sont limits dans le systme.',
	'Setting Ignored' => 'Paramtre ignor',
	'Note: The above option is currently ignored since outbound pings are disabled system-wide.' => 'Attention: l\'option ci-dessus est ignore si les pings sortants sont dsactivs dans le systme',
	'Enable Internal TrackBack Auto-Discovery' => 'Pour les notes intrieures au blog',

## tmpl/cms/dashboard.tmpl
	'Dashboard' => 'Tableau de bord',
	'Select a Widget...' => 'Slectionner un widget...',
	'Your Dashboard has been updated.' => 'Votre tableau de bord a t mis  jour.',
	'You have attempted to use a feature that you do not have permission to access. If you believe you are seeing this message in error contact your system administrator.' => 'Vous avez essay d\'accder  une fonctionnalit  laquelle vous n\'avez pas le droit. Si vous pensez que cette erreur n\'est pas normale contactez votre administrateur systme.',
	'The directory you have configured for uploading userpics is not writable. In order to enable users to upload userpics, please make the following directory writable by your web server: [_1]' => 'Le rpertoire que vous avez configur pour l\'envoi de fichiers utilisateur n\'est pas accessible en criture. Afin de rendre ce tlchargement possible  vos utilisateurs, merci de rendre le rpertoire suivant accessible en criture : [_1]',
	'Your dashboard is empty!' => 'Votre tableau de bord est vide !',

## tmpl/cms/edit_commenter.tmpl
	'Commenter Details' => 'Dtails sur l\'auteur de commentaires',
	'The commenter has been trusted.' => 'L\'auteur de commentaires est fiable.',
	'The commenter has been banned.' => 'L\'auteur de commentaires a t banni.',
	'Comments from [_1]' => 'Commentaires de [_1]',
	'commenter' => 'l\'auteur de commentaires',
	'commenters' => 'Auteurs de commentaire',
	'to act upon' => 'pour agir sur',
	'Trust user (t)' => 'Donner le statut fiable  cet utilisateur (t)',
	'Trust' => 'Fiable',
	'Untrust user (t)' => 'Donner le statut non fiable  cet utilisateur (t)',
	'Untrust' => 'Non Fiable',
	'Ban user (b)' => 'Donner le statut banni  cet utilisateur (t)',
	'Ban' => 'Bannir',
	'Unban user (b)' => 'Donner le statut non banni  cet utilisateur (t)',
	'Unban' => 'Non banni',
	'The Name of the commenter' => 'Le nom de l\'auteur de commentaires',
	'View all comments with this name' => 'Afficher tous les commentaires associs  ce nom',
	'Identity' => 'Identit',
	'The Identity of the commenter' => 'L\'identit de l\'auteur de commentaires',
	'Email' => 'Adresse email',
	'The Email of the commenter' => 'L\'adresse email de l\'auteur de commentaires',
	'Withheld' => 'Retenu',
	'View all comments with this email address' => 'Afficher tous les commentaires associs  cette adresse email',
	'The URL of the commenter' => 'URL de l\'auteur de commentaires',
	'View all comments with this URL address' => 'Afficher tous les commentaires associs  cette URL',
	'Status' => 'Statut',
	'The trusted status of the commenter' => 'Le statut de confiance de cet auteur de commentaires',
	'Trusted' => 'Fiable',
	'Banned' => 'Banni',
	'Authenticated' => 'Authentifi',
	'View all commenters' => 'Voir tous les commentaires',

## tmpl/cms/edit_widget.tmpl
	'Edit Widget Set' => 'Modifier le groupe de widgets',
	'Create Widget Set' => 'Crer un groupe de widgets',
	'Please use a unique name for this widget set.' => 'Merci d\'utiliser un nom unique pour ce groupe de widgets.',
	'Set Name' => 'Nom du groupe',
	'Drag and drop the widgets you want into the Installed column.' => 'Glissez-dposez les widgets que vous voulez dans la colonne de gauche.',
	'Installed Widgets' => 'Widgets installs',
	'edit' => 'Editer',
	'Available Widgets' => 'Widgets disponibles',
	'Save changes to this widget set (s)' => 'Enregistrer les modifications de ce groupe de widgets',

## tmpl/cms/list_entry.tmpl
	'Manage Entries' => 'Grer les notes',
	'Entries Feed' => 'Flux des Notes',
	'Pages Feed' => 'Flux des Pages',
	'The entry has been deleted from the database.' => 'Cette note a t supprime de la base de donnes.',
	'The page has been deleted from the database.' => 'Cette page a t supprime de la base de donnes.',
	'Quickfilters' => 'Filtres rapides',
	'[_1] (Disabled)' => '[_1] (Dsactiv)',
	'Set Web Services Password' => 'Dfinir un mot de passe pour les services Web',
	'Showing only: [_1]' => 'Montrer seulement : [_1]',
	'Remove filter' => 'Supprimer le filtre',
	'All [_1]' => 'Tous(tes) les [_1]',
	'change' => 'modifier',
	'[_1] where [_2] is [_3]' => '[_1] o [_2] est [_3]',
	'Show only entries where' => 'Afficher seulement les notes o',
	'Show only pages where' => 'Afficher seulement les pages o',
	'status' => 'le statut',
	'user' => 'utilisateur',
	'tag (exact match)' => 'le tag (exact)',
	'tag (fuzzy match)' => 'le tag (fuzzy match)',
	'asset' => 'lment',
	'is' => 'est',
	'published' => 'publi',
	'unpublished' => 'non publi',
	'scheduled' => 'programm',
	'Select A User:' => 'Slectionner un utilisateur',
	'User Search...' => 'Recherche utilisateur...',
	'Recent Users...' => 'Utilisateurs rcents...',
	'Filter' => 'Filtre',

## tmpl/cms/include/import_start.tmpl
	'Importing...' => 'Importation...',
	'Importing entries into blog' => 'Importation de notes dans le blog',
	'Importing entries as user \'[_1]\'' => 'Importation des notes en tant qu\'utilisateur \'[_1]\'',
	'Creating new users for each user found in the blog' => 'Cration de nouveaux utilisateur correspondant  chaque utilisateur trouv dans le blog',

## tmpl/cms/include/copyright.tmpl
	'Copyright &copy; 2001-[_1] Six Apart. All Rights Reserved.' => 'Copyright &copy; 2001-[_1] Six Apart. Tous droits rservs.',

## tmpl/cms/include/comment_table.tmpl
	'comment' => 'commentaire',
	'comments' => 'commentaires',
	'to publish' => 'pour publier',
	'Publish selected comments (a)' => 'Publier les commentaires slectionns (a)',
	'Delete selected comments (x)' => 'Supprimer les commentaires slectionns (x)',
	'Report selected comments as Spam (j)' => 'Marquer les commentaires slectionns comme tant du spam (j)',
	'Report selected comments as Not Spam and Publish (j)' => 'Marquer les commentaires slectionns comme n\'tant pas du spam et les publier (j)',
	'Not Spam' => 'Non-spam',
	'Are you sure you want to remove all comments reported as spam?' => 'tes-vous sr(e) de vouloir supprimer tous les commentaires notifis comme spam ?',
	'Delete all comments reported as Spam' => 'Supprimer tous les commentaires marqus comme tant du spam',
	'Empty' => 'Vide',
	'Ban This IP' => 'Bannir cette adresse IP',
	'Entry/Page' => 'Note/Page',
	'Date' => 'Date',
	'IP' => 'IP',
	'Only show published comments' => 'N\'afficher que les commentaires publis',
	'Published' => 'Publi',
	'Only show pending comments' => 'N\'afficher que les commentaires en attente',
	'Pending' => 'En attente',
	'Edit this comment' => 'Editer ce commentaire',
	'([quant,_1,reply,replies])' => '([quant,_1,rponse,rponses])',
	'Blocked' => 'Bloqus',
	'Edit this [_1] commenter' => 'Modifier l\'auteur de commentaires de cette [_1]',
	'Search for comments by this commenter' => 'Chercher les commentaires de cet auteur de commentaires',
	'View this entry' => 'Voir cette note',
	'View this page' => 'Voir cette page',
	'Search for all comments from this IP address' => 'Rechercher tous les commentaires associs  cette adresse IP',

## tmpl/cms/include/feed_link.tmpl
	'Activity Feed' => 'Flux d\'activit',

## tmpl/cms/include/member_table.tmpl
	'users' => 'utilisateurs',
	'Are you sure you want to remove the selected user from this blog?' => 'tes-vous sr(e) de vouloir retirer l\'utilisateur slectionn de ce blog ?',
	'Are you sure you want to remove the [_1] selected users from this blog?' => 'tes-vous sr(e) de vouloir retirer les [_1] utilisateurs slectionns de ce blog ?',
	'Remove selected user(s) (r)' => 'Retirer l\'(es) utilisateur(s) slectionn(s) (r)',
	'Remove' => 'Retirer',
	'_USER_ENABLED' => 'Utilisateur activ',
	'Trusted commenter' => 'Auteur de commentaires fiable',
	'Link' => 'Lien',
	'Remove this role' => 'Retirer ce rle',

## tmpl/cms/include/asset_table.tmpl
	'assets' => 'lments',
	'Delete selected assets (x)' => 'Effacer les contenus slectionns (x)',
	'Size' => 'Taille',
	'Created By' => 'Cr par',
	'Created On' => 'Cr le',
	'View' => 'Voir',
	'Asset Missing' => 'lment manquant',
	'No thumbnail image' => 'Pas de miniature',
	'[_1] is missing' => '[_1] est manquant',

## tmpl/cms/include/overview-left-nav.tmpl
	'List Weblogs' => 'Liste des Blogs',
	'Weblogs' => 'Blogs',
	'List Users and Groups' => 'Lister les Utilisateurs et les Groupes',
	'Users &amp; Groups' => 'Utilisateurs &amp; Groupes',
	'List Associations and Roles' => 'Lister les associations et les rles',
	'List Plugins' => 'Liste des Plugins',
	'Aggregate' => 'Multi-Blogs',
	'List Entries' => 'Afficher les notes',
	'List uploaded files' => 'Lister les fichiers envoys',
	'List Tags' => 'Liste de tags',
	'List Comments' => 'Afficher les commentaires',
	'List TrackBacks' => 'Lister les trackbacks',
	'Configure' => 'Configurer',
	'Edit System Settings' => 'Editer les Paramtres Systme',
	'Utilities' => 'Utilitaires',
	'Search &amp; Replace' => 'Chercher &amp; Remplacer',
	'_SEARCH_SIDEBAR' => 'Rechercher',
	'Show Activity Log' => 'Afficher le journal (logs)',

## tmpl/cms/include/comment_detail.tmpl

## tmpl/cms/include/cfg_content_nav.tmpl

## tmpl/cms/include/pagination.tmpl

## tmpl/cms/include/log_table.tmpl
	'No log records could be found.' => 'Aucune donne du journal n\'a t trouve.',
	'_LOG_TABLE_BY' => 'Utilisateur',
	'IP: [_1]' => 'IP : [_1]',

## tmpl/cms/include/backup_end.tmpl
	'All of the data has been backed up successfully!' => 'Toutes les donnes ont t sauvegardes avec succs!',
	'Download This File' => 'Tlcharger ce fichier',
	'_BACKUP_TEMPDIR_WARNING' => '_BACKUP_TEMPDIR_WARNING',
	'_BACKUP_DOWNLOAD_MESSAGE' => '_BACKUP_DOWNLOAD_MESSAGE',
	'An error occurred during the backup process: [_1]' => 'Une erreur est survenue pendant la sauvegarde: [_1]',

## tmpl/cms/include/author_table.tmpl
	'_USER_DISABLED' => 'Utilisateur dsactiv',

## tmpl/cms/include/ping_table.tmpl
	'Publish selected [_1] (p)' => 'Publier le(s) [_1] slectionn(s) (p)',
	'Delete selected [_1] (x)' => 'Supprimer le(s) [_1] slectionn(s) (x)',
	'Report selected [_1] as Spam (j)' => 'Marquer le(s) [_1] slectionn(s) comme tant du spam (j)',
	'Report selected [_1] as Not Spam and Publish (j)' => 'Marquer le(s) [_1] slectionn(s) comme n\'tant pas du spam et les publier (j)',
	'Are you sure you want to remove all TrackBacks reported as spam?' => 'tes-vous sr de vouloir supprimer tous les trackbacks notifis comme spam?',
	'Deletes all [_1] reported as Spam' => 'Supprimer tous les [_1] marqus comme tant du spam',
	'From' => 'De',
	'Target' => 'Cible',
	'Only show published TrackBacks' => 'Afficher uniquement les trackbacks publis',
	'Only show pending TrackBacks' => 'Afficher uniquement les trackbacks en attente',
	'Edit this TrackBack' => 'Modifier ce trackback',
	'Go to the source entry of this TrackBack' => 'Aller  la note  l\'origine de ce trackback',
	'View the [_1] for this TrackBack' => 'Voir [_1] pour ce trackback',

## tmpl/cms/include/footer.tmpl
	'This is a beta version of Movable Type and is not recommended for production use.' => 'Ceci est une version beta de Movable Type et n\'est pas recommand pour une utilisation en production.',
	'http://www.movabletype.org' => 'http://www.movabletype.org',
	'MovableType.org' => 'MovableType.org',
	'http://wiki.movabletype.org/' => 'http://wiki.movabletype.org/',
	'Wiki' => 'Wiki',
	'http://www.movabletype.com/support/' => 'http://www.movabletype.com/support/',
	'Support' => 'Support',
	'http://www.movabletype.org/feedback.html' => 'http://www.movabletype.org/feedback.html',
	'Send us Feedback' => 'Faites nous part de vos retours',
	'<a href="[_1]"><mt:var name="mt_product_name"></a> version [_2]' => '<a href="[_1]"><mt:var name="mt_product_name"></a> version [_2]',
	'with' => 'avec',

## tmpl/cms/include/notification_table.tmpl
	'Date Added' => 'Ajout(e)',
	'Click to edit contact' => 'Cliquer pour modifier le contact',
	'Save changes' => 'Enregistrer les modifications',

## tmpl/cms/include/itemset_action_widget.tmpl
	'More actions...' => 'Plus d\'actions...',
	'Plugin Actions' => 'Actions du plugin',
	'Go' => 'OK',

## tmpl/cms/include/tools_content_nav.tmpl

## tmpl/cms/include/commenter_table.tmpl
	'Last Commented' => 'Dernier comment',
	'Only show trusted commenters' => 'Afficher uniquement les auteurs de commentaires fiable',
	'Only show banned commenters' => 'Afficher uniquement les auteurs de commentaires bannis',
	'Only show neutral commenters' => 'Afficher uniquement les auteurs de commentaires neutres',
	'Edit this commenter' => 'Editer cet auteur de commentaires',
	'View this commenter&rsquo;s profile' => 'Voir le profil de cet auteur de commentaires',

## tmpl/cms/include/entry_table.tmpl
	'Save these entries (s)' => 'Enregistrer les notes slectionnes (s)',
	'Republish selected entries (r)' => 'Republier les notes slectionnes (r)',
	'Delete selected entries (x)' => 'Supprimer les notes slectionnes (x)',
	'Save these pages (s)' => 'Enregistrer les pages slectionnes (s)',
	'Republish selected pages (r)' => 'Republier les pages slectionnes (r)',
	'Delete selected pages (x)' => 'Supprimer les pages slectionnes (x)',
	'to republish' => 'pour republier',
	'Last Modified' => 'Dernire modification',
	'Created' => 'Cr',
	'Unpublished (Draft)' => 'Non publi (Brouillon)',
	'Unpublished (Review)' => 'Non publi (Vrification)',
	'Scheduled' => 'Planifi',
	'Only show unpublished entries' => 'Afficher uniquement les notes non publies',
	'Only show unpublished pages' => 'Afficher uniquement les pages non publies',
	'Only show published entries' => 'Afficher uniquement les notes publies',
	'Only show published pages' => 'Afficher uniquement les pages publies',
	'Only show entries for review' => 'Afficher uniquement les notes  vrifier',
	'Only show pages for review' => 'Afficher uniquement les pages  vrifier',
	'Only show scheduled entries' => 'Afficher uniquement les notes planifies',
	'Only show scheduled pages' => 'Afficher uniquement les pages planifies',
	'Edit Entry' => 'diter une note',
	'Edit Page' => 'diter une page',
	'View entry' => 'Afficher une note',
	'View page' => 'Afficher une page',
	'No entries could be found. <a href="[_1]">Create an entry</a> now.' => 'Aucune note n\'a t trouve. <a href="[_1]">Crer une note</a> maintenant.',
	'No page could be found. <a href="[_1]">Create a page</a> now.' => 'Aucune page n\'a t trouve. <a href="[_1]">Crer une page</a> maintenant.',

## tmpl/cms/include/login_mt.tmpl

## tmpl/cms/include/calendar.tmpl
	'_LOCALE_WEEK_START' => '1',
	'S|M|T|W|T|F|S' => 'L|M|M|J|V|S|D',
	'January' => 'Janvier',
	'Febuary' => 'Fvrier',
	'March' => 'Mars',
	'April' => 'Avril',
	'May' => 'Mai',
	'June' => 'Juin',
	'July' => 'Juillet',
	'August' => 'Aot',
	'September' => 'Septembre',
	'October' => 'Octobre',
	'November' => 'Novembre',
	'December' => 'Dcembre',
	'Jan' => 'Jan',
	'Feb' => 'Fv',
	'Mar' => 'Mar',
	'Apr' => 'Avr',
	'_SHORT_MAY' => 'Mai',
	'Jun' => 'Juin',
	'Jul' => 'Juil',
	'Aug' => 'Ao',
	'Sep' => 'Sep',
	'Oct' => 'Oct',
	'Nov' => 'Nov',
	'Dec' => 'Dc',
	'OK' => 'OK',
	'[_1:calMonth] [_2:calYear]' => '[_1:calMonth] [_2:calYear]',

## tmpl/cms/include/list_associations/page_title.tmpl
	'Permissions for [_1]' => 'Autorisations pour [_1]',
	'Permissions: System-wide' => 'Autorisations : configuration globale',
	'Users for [_1]' => 'Utilisateurs pour [_1]',

## tmpl/cms/include/anonymous_comment.tmpl
	'Anonymous Comments' => 'Commentaires anonymes',
	'Require E-mail Address for Anonymous Comments' => 'Ncessite une adresse email pour les commentaires anonymes',
	'If enabled, visitors must provide a valid e-mail address when commenting.' => 'Si activ, le visiteur doit donner une adresse email valide pour commenter.',

## tmpl/cms/include/cfg_system_content_nav.tmpl

## tmpl/cms/include/category_selector.tmpl
	'Add sub category' => 'Ajouter une sous-catgorie',
	'Add new' => 'Crer',

## tmpl/cms/include/backup_start.tmpl
	'Backing up Movable Type' => 'Sauvegarder Movable Type',

## tmpl/cms/include/display_options.tmpl
	'Display Options' => 'Options d\'affichage',
	'_DISPLAY_OPTIONS_SHOW' => 'Afficher',
	'[quant,_1,row,rows]' => '[quant,_1,ligne,lignes]',
	'Compact' => 'Compacte',
	'Expanded' => 'Etendue',
	'Action Bar' => 'Barre d\'action',
	'Top' => 'En haut',
	'Both' => 'En haut et en bas',
	'Bottom' => 'En bas',
	'Date Format' => 'Format date',
	'Relative' => 'Relative',
	'Full' => 'Entire',
	'Save display options' => 'Enregistrer les options d\'affichage',
	'Close display options' => 'Fermer les options d\'affichage',

## tmpl/cms/include/chromeless_footer.tmpl
	'<a href="[_1]">Movable Type</a> version [_2]' => '<a href="[_1]">Movable Type</a> version [_2]',

## tmpl/cms/include/template_table.tmpl
	'Create Archive Template:' => 'Crer un gabarit d\'archives',
	'Entry Listing' => 'Liste des notes',
	'Create template module' => 'Crer un module de gabarit',
	'Create index template' => 'Crer un gabarit index',
	'templates' => 'gabarits',
	'Publish selected templates (a)' => 'Publier les gabarits slectionns (a)',
	'Archive Path' => 'Chemin d\'archive',
	'Cached' => 'Cach',
	'Linked Template' => 'Gabarit li',
	'-' => '-',
	'Manual' => 'Manuellement',
	'Dynamic' => 'Dynamique',
	'Publish Queue' => 'Publication en mode File d\'Attente',
	'Static' => 'Statique',
	'Yes' => 'Oui',
	'No' => 'Non',

## tmpl/cms/include/asset_upload.tmpl
	'Before you can upload a file, you need to publish your blog. [_1]Configure your blog\'s publishing paths[_2] and rebuild your blog.' => 'Avant de pouvoir envoyer un fichier, vous devez publier votre blog. [_1]Configurez les chemins de publication de votre blog[_2] et republiez votre blog.',
	'Your system or blog administrator needs to publish the blog before you can upload files. Please contact your system or blog administrator.' => 'L\'administrateur du systme ou du blog doit publier le blog avant que vous puissiez envoyer des fichiers.',
	'Close (x)' => 'Fermer (x)',
	'Select File to Upload' => 'Slectionnez le fichier  envoyer',
	'_USAGE_UPLOAD' => 'Vous pouvez tlcharger le fichier ci-dessus dans le chemin local de votre site <a href="javascript:alert(\'[_1]\')">(?)</a> ou dans le chemin des archives de votre site <a href="javascript:alert(\'[_2]\')">(?)</a>. Vous pouvez galement tlcharger le fichier dans un rpertoire compris dans les rpertoires mentionns ci-dessus, en spcifiant le chemin dans les champs de droite (<i>images</i>, par exemple). Les rpertoires qui n\'existent pas encore seront crs.',
	'Upload Destination' => 'Destination du fichier',
	'Choose Folder' => 'Choisir le Dossier',
	'Upload (s)' => 'Envoyer (s)',
	'Upload' => 'Envoyer',
	'Back (b)' => 'Retour (b)',
	'Cancel (x)' => 'Annuler (x)',

## tmpl/cms/include/listing_panel.tmpl
	'Step [_1] of [_2]' => 'tape  [_1] sur [_2]',
	'Reset' => 'Mettre  jour',
	'Go to [_1]' => 'Aller  [_1]',
	'Sorry, there were no results for your search. Please try searching again.' => 'Dsol, aucun rsultat trouv pour cette recherche. Merci d\'essayer  nouveau.',
	'Sorry, there is no data for this object set.' => 'Dsol, mais il n\'y a pas de donnes pour cet ensemble d\'objets.',
	'Confirm (s)' => 'Confirmer (s)',
	'Confirm' => 'Confirmer',
	'Continue (s)' => 'Continuer (s)(',

## tmpl/cms/include/header.tmpl
	'Help' => 'Aide',
	'Hi [_1],' => 'Bonjour [_1],',
	'Logout' => 'Dconnexion',
	'Select another blog...' => 'Slectionnez un autre blog...',
	'Create a new blog' => 'Crer un nouveau blog',
	'Write Entry' => 'Ecrire une note',
	'Blog Dashboard' => 'Tableau de bord du Blog',
	'View Site' => 'Voir le site',
	'Search (q)' => 'Recherche (q)',

## tmpl/cms/include/archetype_editor.tmpl
	'Decrease Text Size' => 'Diminuer la taille du texte',
	'Increase Text Size' => 'Augmenter la taille du texte',
	'Bold' => 'Gras',
	'Italic' => 'Italique',
	'Underline' => 'Soulign',
	'Strikethrough' => 'Ray',
	'Text Color' => 'Couleur du texte',
	'Email Link' => 'Lien email',
	'Begin Blockquote' => 'Commencer le texte en retrait',
	'End Blockquote' => 'Fin paragraphe en retrait ',
	'Bulleted List' => 'Liste  puces',
	'Numbered List' => 'Liste numrote',
	'Left Align Item' => 'Aligner  gauche',
	'Center Item' => 'Centrer l\'lment',
	'Right Align Item' => 'Aligner l\'lment  droite',
	'Left Align Text' => 'Aligner le texte  gauche',
	'Center Text' => 'Centrer le texte',
	'Right Align Text' => 'Aligner le texte  droite',
	'Insert Image' => 'Insrer une image',
	'Insert File' => 'Insrer un fichier',
	'WYSIWYG Mode' => 'Mode WYSIWYG',
	'HTML Mode' => 'Mode HTML',

## tmpl/cms/include/users_content_nav.tmpl
	'Profile' => 'Profil',
	'Details' => 'Dtails',

## tmpl/cms/include/blog_table.tmpl
	'Delete selected blogs (x)' => 'Effacer les blogs slectionns (x)',

## tmpl/cms/include/blog-left-nav.tmpl
	'Creating' => 'Crer',
	'Create Entry' => 'Crer une nouvelle note',
	'Community' => 'Communaut',
	'List Commenters' => 'Lister les auteurs de commentaires',
	'Edit Address Book' => 'Modifier le carnet d\'adresses',
	'List Users &amp; Groups' => 'Liste des utilisateurs &amp; Groupes',
	'List &amp; Edit Templates' => 'Lister &amp; Editer les gabarits',
	'Edit Categories' => 'Modifier les catgories',
	'Edit Tags' => 'Editer les tags',
	'Edit Weblog Configuration' => 'Modifier la configuration du blog',
	'Backup this weblog' => 'Sauvegarder ce blog',
	'Import &amp; Export Entries' => 'Importer &amp; Exporter les Notes',
	'Import / Export' => 'Importer / Exporter',
	'Rebuild Site' => 'Actualiser le site',

## tmpl/cms/include/archive_maps.tmpl
	'Path' => 'Chemin',
	'Custom...' => 'Personnalis...',

## tmpl/cms/include/import_end.tmpl
	'All data imported successfully!' => 'Toutes les donnes ont t importes avec succs !',
	'Make sure that you remove the files that you imported from the \'import\' folder, so that if/when you run the import process again, those files will not be re-imported.' => 'Assurez vous d\'avoir bien enlev les fichiers imports du rpertoire \'import\', pour viter une r-importation des mmes fichiers  l\'avenir .',
	'An error occurred during the import process: [_1]. Please check your import file.' => 'Une erreur s\'est produite pendant le processus: [_1]. Merci de vrifier vos fichiers import.',

## tmpl/cms/dialog/asset_replace.tmpl
	'A file named \'[_1]\' already exists. Do you want to overwrite this file?' => 'Un fichier nomm \'[_1]\' existe dj. Souhaitez-vous le remplacer ?',
	'Yes (s)' => 'Oui (s)',

## tmpl/cms/dialog/restore_end.tmpl
	'An error occurred during the restore process: [_1] Please check your restore file.' => 'Une erreur s\'est produite pendant la procdure de restauration: [_1] Merci de vrifier votre fichier de restauration.',
	'View Activity Log (v)' => 'Voir le journal (logs) (v)',
	'All data restored successfully!' => 'Toutes les donnes ont t restaures avec succs !',
	'Close (s)' => 'Fermer (s)',
	'Next Page' => 'Page suivante',
	'The page will redirect to a new page in 3 seconds. [_1]Stop the redirect.[_2]' => 'Cette page va tre redirige vers une nouvelle page dans 3 secondes. [_1]Arrter la redirection.[_2]',

## tmpl/cms/dialog/recover.tmpl
	'Your password has been changed, and the new password has been sent to your email address ([_1]).' => 'Votre mot de passe a t modifi et a t envoy  votre adresse e-mail([_1]).',
	'Sign in to Movable Type (s)' => 'Connectez-vous sur Movable Type (s)',
	'Sign in to Movable Type' => 'Connectez-vous sur Movable Type',
	'Password recovery word/phrase' => 'Indice de rcupration du mot de passe',
	'Recover (s)' => 'Rcuprer (s)',
	'Recover' => 'Rcuprer',
	'Go Back (x)' => 'Retour (x)',

## tmpl/cms/dialog/comment_reply.tmpl
	'Reply to comment' => 'Rpondre au commentaire',
	'On [_1], [_2] commented on [_3]' => 'Le [_1], [_2] a comment sur [_3]',
	'Preview of your comment' => 'Prvisualisation de votre commentaire',
	'Your reply:' => 'Votre rponse :',
	'Submit reply (s)' => 'Envoyer la rponse (s)',
	'Preview reply (v)' => 'Prvisualiser la rponse (v)',
	'Re-edit reply (r)' => 'Re-modifier la rponse (r)',
	'Re-edit' => 'Re-modifier',

## tmpl/cms/dialog/asset_list.tmpl
	'Insert Asset' => 'Insrer un lment',
	'Upload New File' => 'Envoyer un nouveau fichier',
	'Upload New Image' => 'Envoyer une nouvelle image',
	'Asset Name' => 'Nom de l\'lment',
	'View Asset' => 'Aperu de l\'lment',
	'Next (s)' => 'Suivant (s)',
	'Insert (s)' => 'Insrer (s)',
	'Insert' => 'Insrer',
	'No assets could be found.' => 'Aucun lment n\'a t trouv.',

## tmpl/cms/dialog/refresh_templates.tmpl
	'Refresh Template Set' => 'Ractualiser le Groupe de Gabarits',
	'Refresh [_1] template set' => 'Ractualiser le groupe de gabarits [_1]',
	'Refresh global templates' => 'Mettre  jour les gabarits gnraux', # Translate - Case
	'Updates current templates while retaining any user-created templates.' => 'Met  jour les gabarits courants tout en empchant la cration de gabarits par l\'utilisateur.', # Translate - New
	'Apply a new template set' => 'Appliquer un nouveau groupe de gabarits',
	'Deletes all existing templates and install the selected template set.' => 'Supprime tout les gabarits existants et installe le groupe de gabarits slectionn.',
	'Reset to factory defaults' => 'Remettre  zro les modifications',
	'Deletes all existing templates and installs factory default template set.' => 'Supprime tous les gabarits existants et installe les groupes de gabarits par dfaut ',
	'Make backups of existing templates first' => 'Faire d\'abord des sauvegardes des gabarits existants',
	'You have requested to <strong>refresh the current template set</strong>. This action will:' => 'Vous avez demand  <strong>ractualiser le groupe de gabarit actuel</strong>. Cette action va :',
	'You have requested to <strong>refresh the global templates</strong>. This action will:' => 'Vous avez demand  <strong>rafrachir les gabarits gnraux</strong>. Cette action va :', # Translate - New
	'make backups of your templates that can be accessed through your backup filter' => 'faire des copies de sauvegarde de vos gabarits qui pourront tre accessibles via votre filtre de sauvegarde', # Translate - New
	'potentially install new templates' => 'peut-tre installer de nouveaux gabarits',
	'overwrite some existing templates with new template code' => 'remplacer le code de certains gabarits par un nouveau code',
	'You have requested to <strong>apply a new template set</strong>. This action will:' => 'Vous avez demand d\'<strong>appliquer un nouveau groupe de gabarit</strong>. Cette action va :',
	'You have requested to <strong>reset to the default global templates</strong>. This action will:' => 'Vous avez demand  <strong>rtablir les gabarits gnraux par dfaut</strong>. Cette action va :', # Translate - New
	'delete all of the templates in your blog' => 'supprimer tous les gabarits de votre blog',
	'install new templates from the selected template set' => 'installer de nouveaux gabarits depuis le groupe de gabarits slectionn',
	'delete all of your global templates' => 'supprimer tous vos gabarits gnraux', # Translate - New
	'install new templates from the default global templates' => 'installer de nouveaux gabarits issus des gabarits gnraux par dfaut', # Translate - New
	'Are you sure you wish to continue?' => 'tes-vous sr de vouloir continuer ?',

## tmpl/cms/dialog/publishing_profile.tmpl
	'Publishing Profile' => 'Profil de publication',
	'Choose the profile that best matches the requirements for this blog.' => 'Choisir le profil qui correspond le mieux aux besoins de ce blog',
	'Static Publishing' => 'Publication statique',
	'Immediately publish all templates statically.' => 'Publier immdiatement tous les gabarits de manire statique.',
	'Background Publishing' => 'Publication en arrire-plan',
	'All templates published statically via Publish Que.' => 'Tous les gabarits sont publis en statique via une publication en mode file d\'attente',
	'High Priority Static Publishing' => 'Publication statique prioritaire',
	'Immediately publish Main Index template, Entry archives, and Page archives statically. Use Publish Queue to publish all other templates statically.' => 'Publier immdiatement les gabarits d\'index et d\'archives individuelles de notes et pages en statique. Utiliser une publication en mode file d\'attente pour tout le reste',
	'Dynamic Publishing' => 'Publication dynamique',
	'Publish all templates dynamically.' => 'Publier tous les gabarits en dynamique',
	'Dynamic Archives Only' => 'Archives dynamiques uniquement',
	'Publish all Archive templates dynamically. Immediately publish all other templates statically.' => 'Publier tous les gabarits d\'archives individuelles en dynamique. Publier immdiatement tout les autres gabarits en statique.',
	'This new publishing profile will update all of your templates.' => 'Ce nouveau profil de publication mettra  jour tous vos gabarits.',

## tmpl/cms/dialog/asset_upload.tmpl
	'You need to configure your blog.' => 'Vous devez configurer votre blog.',
	'Your blog has not been published.' => 'Votre blog n\'a pas t publi.',

## tmpl/cms/dialog/restore_upload.tmpl
	'Restore: Multiple Files' => 'Restauration : Plusieurs fichiers',
	'Canceling the process will create orphaned objects.  Are you sure you want to cancel the restore operation?' => 'L\'annulation de la procdure va crer des objets orphelins.  tes-vous sr de vouloir annuler l\'opration de restauration ?',
	'Please upload the file [_1]' => 'Merci d\'envoyer le fichier [_1]',

## tmpl/cms/dialog/entry_notify.tmpl
	'Send a Notification' => 'Envoyer une notification',
	'You must specify at least one recipient.' => 'Vos devez dfinir au moins un destinataire.',
	'Your blog\'s name, this entry\'s title and a link to view it will be sent in the notification.  Additionally, you can add a  message, include an excerpt of the entry and/or send the entire entry.' => 'Le nom de votre blog, le titre de cette note et un lien pour la voir seront envoys dans la notification. De plus, vous pouvez ajouter un message, inclure un extrait de la note et/ou envoyer la note entire.',
	'Recipients' => 'Destinataires',
	'Enter email addresses on separate lines, or comma separated.' => 'Saisissez les adresses email sur des lignes spares, ou spares par une virgule.',
	'All addresses from Address Book' => 'Toutes les adresses du carnet d\'adresses',
	'Optional Message' => 'Message optionnel',
	'Optional Content' => 'Contenu optionnel',
	'(Entry Body will be sent without any text formatting applied)' => '(Le corps de la note sera envoy sans mise en forme du texte)',
	'Send notification (s)' => 'Envoyer la notification (s)',
	'Send' => 'Envoyer',

## tmpl/cms/dialog/adjust_sitepath.tmpl
	'Confirm Publishing Configuration' => 'Confirmer la confirmation de publication',
	'URL is not valid.' => 'L\'URL n\'est pas valide.',
	'You can not have spaces in the URL.' => 'Vous ne pouvez pas avoir d\'espace dans l\'URL.',
	'You can not have spaces in the path.' => 'Vous ne pouvez pas avoir d\'espace dans le chemin.',
	'Path is not valid.' => 'Le chemin n\'est pas valide.',
	'Archive URL' => 'URL d\'archive',

## tmpl/cms/dialog/asset_options.tmpl
	'File Options' => 'Options fichier',
	'Create entry using this uploaded file' => 'Crer une note  l\'aide de ce fichier',
	'Create a new entry using this uploaded file.' => 'Crer une nouvelle note avec ce fichier envoy.',
	'Finish (s)' => 'Terminer (s)',
	'Finish' => 'Terminer',

## tmpl/cms/dialog/asset_options_image.tmpl
	'Display image in entry' => 'Afficher l\'image dans la note',
	'Alignment' => 'Alignement',
	'Left' => 'Gauche',
	'Center' => 'Centrer',
	'Right' => 'Droite',
	'Use thumbnail' => 'Utiliser une vignette',
	'width:' => 'largeur :',
	'pixels' => 'pixels',
	'Link image to full-size version in a popup window.' => 'Crer un lien vers l\'image originale dans une popup',
	'Remember these settings' => 'Se souvenir de ces paramtres',

## tmpl/cms/dialog/restore_start.tmpl
	'Restoring...' => 'Restauration...',

## tmpl/cms/dialog/create_association.tmpl
	'No roles exist in this installation. [_1]Create a role</a>' => 'Aucun rle n\'existe dans cette installation. [_1]Crer un rle</a>',
	'No groups exist in this installation. [_1]Create a group</a>' => 'Aucun groupe n\'existe dans cette installation. [_1]Crer un groupe</a>',
	'No users exist in this installation. [_1]Create a user</a>' => 'Aucun utilisateur n\'existe dans cette installation. [_1]Crer un utilisateur</a>',
	'No blogs exist in this installation. [_1]Create a blog</a>' => 'Aucun blog n\'existe dans cette installation. [_1]Crer un blog</a>',

## tmpl/cms/cfg_comments.tmpl
	'Comment Settings' => 'Paramtres des commentaires',
	'Your preferences have been saved.' => 'Vos prfrences ont t sauvegardes.',
	'Note: Commenting is currently disabled at the system level.' => 'Note : Les commentaires sont actuellement dsactivs au niveau systme.',
	'Comment authentication is not available because one of the needed modules, MIME::Base64 or LWP::UserAgent is not installed. Talk to your host about getting this module installed.' => 'L\'authetification de commentaire n\'est pas active car le module MIME::Base64 or LWP::UserAgent est absent. Contactez votre hbergeur pour l\'installation de ce module.',
	'Accept Comments' => 'Accepter les commentaires',
	'If enabled, comments will be accepted.' => 'Si activ, les commentaires seront accepts.',
	'Commenting Policy' => 'Rgles pour les commentaires',
	'Immediately approve comments from' => 'Approuver immdiatement les commentaires de',
	'Specify what should happen to comments after submission. Unapproved comments are held for moderation.' => 'Spcifiez ce qui doit se passer aprs la soumission de commentaires. Les commentaires non-approuvs sont retenus pour modration.',
	'No one' => 'Personne',
	'Trusted commenters only' => 'Auteurs de commentaires fiables uniquement',
	'Any authenticated commenters' => 'Tout auteur de commentaire authentifi',
	'Anyone' => 'Tout le monde',
	'Allow HTML' => 'Autoriser le HTML',
	'If enabled, users will be able to enter a limited set of HTML in their comments. If not, all HTML will be stripped out.' => 'Si activ, l\'auteur de commentaires pourra entrer du HTML de faon limite dans son commentaire. Sinon, le html ne sera pas pris en compte.',
	'Limit HTML Tags' => 'Limiter les balises HTML',
	'Specifies the list of HTML tags allowed by default when cleaning an HTML string (a comment, for example).' => 'Spcifie la liste des balises HTML autorises par dfaut lors du nettoyage d\'une chane HTML (un commentaire, par exemple).',
	'Use defaults' => 'Utiliser les valeurs par dfaut',
	'([_1])' => '([_1])',
	'Use my settings' => 'Utiliser mes paramtres',
	'Disable \'nofollow\' for trusted commenters' => 'dsactiver \'nofollow\' pour les auteurs de commentaires de confiance',
	'If enabled, the \'nofollow\' link relation will not be applied to any comments left by trusted commenters.' => 'Si activ, l\'attribut de lien \'nofollow\' ne sera appliqu  aucun commentaire dpos par un auteur de commentaires de confiance.',
	'Specify when Movable Type should notify you of new comments if at all.' => 'Spcifier quand Movable Type doit vous notifier les nouveaux commentaires.',
	'Comment Display Options' => 'Options d\'affichage des commentaires',
	'Comment Order' => 'Ordre des commentaires',
	'Select whether you want visitor comments displayed in ascending (oldest at top) or descending (newest at top) order.' => 'Slectionnez l\'ordre d\'affichage des commentaires publis par les visiteurs : croissant (les plus anciens en premier) ou dcroissant (les plus rcents en premier).',
	'Ascending' => 'Croissant',
	'Descending' => 'Dcroissant',
	'Auto-Link URLs' => 'Liaison automatique des URL',
	'If enabled, all non-linked URLs will be transformed into links to that URL.' => 'Si activ, toutes les urls non lies seront transformes en url actives.',
	'Text Formatting' => 'Mise en forme du texte',
	'Specifies the Text Formatting option to use for formatting visitor comments.' => 'Spcifie les options de mise en forme du texte des commentaires publis par les visiteurs.',
	'CAPTCHA Provider' => 'Fournisseur de CAPTCHA',
	'none' => 'Aucun fournisseur',
	'No CAPTCHA provider available' => 'Aucun fournisseur de CAPTCHA disponible',
	'No CAPTCHA provider is available in this system.  Please check to see if Image::Magick is installed, and CaptchaSourceImageBase directive points to captcha-source directory under mt-static/images.' => 'Aucun fournisseur de CAPTCHA n\'est disponible sur ce systme. Merci de vrifier si Image::Magick est install, et si la directive CaptchaSourceImageBase contient le rpertoire captcha-source dans mt-static/images.',
	'Use Comment Confirmation Page' => 'Utiliser la page de confirmation de commentaire',
	'Use comment confirmation page' => 'Utiliser la page de confirmation de commentaire',

## tmpl/cms/list_member.tmpl
	'Manage Users' => 'Grer les Utilisateurs',
	'Are you sure you want to remove this role?' => 'tes-vous sr(e) de vouloir supprimer ce rle?',
	'Add a user to this blog' => 'Ajouter un utilisateur  ce blog',
	'Show only users where' => 'Afficher uniquement les utilisateurs o',
	'role' => 'rle',
	'enabled' => 'activ',
	'disabled' => 'dsactiv',
	'pending' => 'en attente',

## tmpl/cms/backup.tmpl
	'What to backup' => 'Ce qu\'il faut sauvegarder',
	'This option will backup Users, Roles, Associations, Blogs, Entries, Categories, Templates and Tags.' => 'Cette option va sauvegarder les utilisateurs, rles, associations, blogs, notes, catgories, gabarits et tags.',
	'Everything' => 'Tout',
	'Choose blogs...' => 'Slectionner les blogs...',
	'Archive Format' => 'Format d\'archive',
	'The type of archive format to use.' => 'Le type de format d\'archive  utiliser.',
	'Don\'t compress' => 'Ne pas compresser',
	'Target File Size' => 'Limiter la taille du fichier cible',
	'Approximate file size per backup file.' => 'Taille de fichier approximative par fichier de sauvegarde.',
	'Don\'t Divide' => 'Pas de limitation',
	'Make Backup (b)' => 'Sauvegarder (b)',
	'Make Backup' => 'Sauvegarder',

## tmpl/cms/setup_initial_blog.tmpl
	'Create Your First Blog' => 'Crez votre premier blog',
	'The blog name is required.' => 'Le nom du blog est ncessaire.',
	'The blog URL is required.' => 'L\'url du blog est obligatoire.',
	'The publishing path is required.' => 'Le chemin de publication est ncessaire.',
	'The timezone is required.' => 'Le fuseau horaire est ncessaire.',
	'Template Set' => 'Ensemble de modles',
	'Select the templates you wish to use for this new blog.' => 'Slectionnez les modles que vous souhaitez utiliser pour ce nouveau blog.',
	'Timezone' => 'Fuseau horaire',
	'Select your timezone from the pulldown menu.' => 'Veuillez slectionner votre fuseau horaire dans la liste.',
	'Time zone not selected' => 'Vous n\'avez pas slectionn de fuseau horaire',
	'UTC+13 (New Zealand Daylight Savings Time)' => 'UTC+13 (Nouvelle-Zlande)',
	'UTC+12 (International Date Line East)' => 'UTC+12 (ligne internationale de changement de date)',
	'UTC+11' => 'UTC+11',
	'UTC+10 (East Australian Time)' => 'UTC+10 (Australie Est)',
	'UTC+9.5 (Central Australian Time)' => 'UTC+9,5 (Australie Centre)',
	'UTC+9 (Japan Time)' => 'UTC+9 (Japon)',
	'UTC+8 (China Coast Time)' => 'UTC+8 (Chine littorale)',
	'UTC+7 (West Australian Time)' => 'UTC+7 (Australie Ouest)',
	'UTC+6.5 (North Sumatra)' => 'UTC+6,5 (Sumatra Nord)',
	'UTC+6 (Russian Federation Zone 5)' => 'UTC+6 (Fdration russe, zone 5)',
	'UTC+5.5 (Indian)' => 'UTC+5.5 (Inde)',
	'UTC+5 (Russian Federation Zone 4)' => 'UTC+5 (Fdration russe, zone 4)',
	'UTC+4 (Russian Federation Zone 3)' => 'UTC+4 (Fdration russe, zone 3)',
	'UTC+3.5 (Iran)' => 'UTC+3,5 (Iran)',
	'UTC+3 (Baghdad Time/Moscow Time)' => 'UTC+3 (Bagdad/Moscou)',
	'UTC+2 (Eastern Europe Time)' => 'UTC+2 (Europe de l\'Est)',
	'UTC+1 (Central European Time)' => 'UTC+1 (Europe centrale)',
	'UTC+0 (Universal Time Coordinated)' => 'UTC+0 (Temps universel coordonn)',
	'UTC-1 (West Africa Time)' => 'UTC-1 (Afrique de l\'Ouest)',
	'UTC-2 (Azores Time)' => 'UTC-2 (Aores)',
	'UTC-3 (Atlantic Time)' => 'UTC-3 (Atlantique)',
	'UTC-3.5 (Newfoundland)' => 'UTC-3,5 (Terre-Neuve)',
	'UTC-4 (Atlantic Time)' => 'UTC-4 (Atlantique)',
	'UTC-5 (Eastern Time)' => 'UTC-5 (Etats-Unis, heure de l\'Est)',
	'UTC-6 (Central Time)' => 'UTC-6 (Etats-Unis, heure centrale)',
	'UTC-7 (Mountain Time)' => 'UTC-7 (Etats-Unis, heure des rocheuses)',
	'UTC-8 (Pacific Time)' => 'UTC-8 (Etats-Unis, heure du Pacifique)',
	'UTC-9 (Alaskan Time)' => 'UTC-9 (Alaska)',
	'UTC-10 (Aleutians-Hawaii Time)' => 'UTC-10 (Hawaii)',
	'UTC-11 (Nome Time)' => 'UTC-11 (Nome)',
	'Finish install (s)' => 'Terminer l\'installation',
	'Finish install' => 'Finir l\'installation',
	'Back (x)' => 'Retour',

## tmpl/cms/edit_entry.tmpl
	'Create Page' => 'Crer une Page',
	'Add folder' => 'Ajouter un rpertoire',
	'Add folder name' => 'Ajouter un nom de rpertoire',
	'Add new folder parent' => 'Ajouter un nouveau rpertoire parent',
	'Save this page (s)' => 'Enregistrer cette page (s)',
	'Preview this page (v)' => 'Prvisualiser cette page (v)',
	'Delete this page (x)' => 'Supprimer cette page (x)',
	'View Page' => 'Afficher une Page',
	'Add category' => 'Ajouter une catgorie',
	'Add category name' => 'Ajouter un nom de catgorie',
	'Add new category parent' => 'Ajouter une nouvelle catgorie parente',
	'Save this entry (s)' => 'Enregistrer cette note (s)',
	'Preview this entry (v)' => 'Prvisualiser cette note (v)',
	'Delete this entry (x)' => 'Supprimer cette note (x)',
	'View Entry' => 'Afficher la note',
	'A saved version of this entry was auto-saved [_2]. <a href="[_1]">Recover auto-saved content</a>' => 'Une version enregistre de cette note a t sauvergarde automatiquement [_2]. <a href="[_1]">Rcuprer le contenu sauvegard automatiquement</a>',
	'A saved version of this page was auto-saved [_2]. <a href="[_1]">Recover auto-saved content</a>' => 'Une version enregistre de cette page a t sauvergarde automatiquement [_2]. <a href="[_1]">Rcuprer le contenu sauvegard automatiquement</a>',
	'This entry has been saved.' => 'Cette note a t enregistre',
	'This page has been saved.' => 'Cette page a t enregistre',
	'One or more errors occurred when sending update pings or TrackBacks.' => 'Erreur lors de l\'envoi des pings ou des trackbacks.',
	'_USAGE_VIEW_LOG' => 'L\'erreur est enregistre dans le <a href="[_1]">journal (logs)</a>.',
	'Your customization preferences have been saved, and are visible in the form below.' => 'Vos prfrences ont t enregistres et sont affiches dans le formulaire ci-dessous.',
	'Your changes to the comment have been saved.' => 'Les modifications apportes aux commentaires ont t enregistres.',
	'Your notification has been sent.' => 'Votre notification a t envoye.',
	'You have successfully recovered your saved entry.' => 'Vous avez rcupr le contenu sauvegard de votre note avec succs.',
	'You have successfully recovered your saved page.' => 'Vous avez rcupr le contenu sauvegard de votre page avec succs.',
	'An error occurred while trying to recover your saved entry.' => 'Une erreur est survenue lors de la tentative de rcupration de la note enregistre.',
	'An error occurred while trying to recover your saved page.' => 'Une erreur est survenue lors de la tentative de rcupration de la page enregistre.',
	'You have successfully deleted the checked comment(s).' => 'Les commentaires slectionns ont t supprims.',
	'You have successfully deleted the checked TrackBack(s).' => 'Le(s) trackback(s) slectionn(s) ont t correctement supprim(s).',
	'Change Folder' => 'Modifier le Dossier',
	'Stats' => 'Stats',
	'Share' => 'Partager',
	'<a href="[_2]">[quant,_1,comment,comments]</a>' => '<a href="[_2]">[quant,_1,commentaire,commentaires]</a>',
	'<a href="[_2]">[quant,_1,trackback,trackbacks]</a>' => '<a href="[_2]">[quant,_1,trackback,trackbacks]</a>',
	'Unpublished' => 'Non publi',
	'You must configure this blog before you can publish this entry.' => 'Vous devez configurer ce blog avant de publier cette note.',
	'You must configure this blog before you can publish this page.' => 'Vous devez configurer ce blog avant de publier cette page.',
	'[_1] - Created by [_2]' => '[_1] - a t cr par [_2]',
	'[_1] - Published by [_2]' => '[_1] - a t publi par [_2]',
	'[_1] - Edited by [_2]' => '[_1] - a t dit par [_2]',
	'Publish On' => 'Publi le',
	'Publish Date' => 'Date de publication',
	'Select entry date' => 'Choisir la date de la note',
	'Unlock this entry&rsquo;s output filename for editing' => 'Dverrouiller le nom de fichier de la note pour le modifier',
	'Warning: If you set the basename manually, it may conflict with another entry.' => 'ATTENTION : Editer le nom de base manuellement peut crer des conflits avec d\'autres notes.',
	'Warning: Changing this entry\'s basename may break inbound links.' => 'ATTENTION : Changer le nom de base de cette note peut casser des liens entrants.',
	'close' => 'fermer',
	'Accept' => 'Accepter',
	'View Previously Sent TrackBacks' => 'Afficher les trackbacks envoys prcdemment',
	'Outbound TrackBack URLs' => 'URLs trackbacks sortants',
	'You have unsaved changes to this entry that will be lost.' => 'Certains de vos changements dans cette note n\'ont pas t enregistrs : ils seront perdus.',
	'You have unsaved changes to this page that will be lost.' => 'Certains de vos changements dans cette page n\'ont pas t enregistrs : ils seront perdus.',
	'Enter the link address:' => 'Saisissez l\'adresse du lien :',
	'Enter the text to link to:' => 'Saisissez le texte du lien :',
	'Your entry screen preferences have been saved.' => 'Vos prfrences d\'dition ont t enregistres.',
	'Your entry screen preferences have been saved. Please refresh the page to reorder the custom fields.' => 'Vos prfrences d\'dition ont t enregistres. Merci de recharger la page pour rordonner les champs personnaliss.',
	'Are you sure you want to use the Rich Text editor?' => 'tes-vous sr de vouloir utiliser l\'diteur de texte enrichi ?',
	'Make primary' => 'Rendre principal',
	'Fields' => 'Champs',
	'Body' => 'Corps',
	'Reset display options' => 'R-initialiser les options d\'affichage',
	'Reset display options to blog defaults' => 'R-initialiser les options d\'affichage avec les valeurs par dfaut du blog',
	'Reset defaults' => 'R-initialiser les valeurs par dfaut',
	'Extended' => 'Etendu',
	'Format:' => 'Format :',
	'(comma-delimited list)' => '(liste dlimite par virgule)',
	'(space-delimited list)' => '(liste dlimite par espace)',
	'(delimited by \'[_1]\')' => '(dlimite par \'[_1]\')',
	'Use <a href="http://blogit.typepad.com/">Blog It</a> to post to Movable Type from social networks like Facebook.' => 'Utiliser <a href="http://blogit.typepad.com/">Blog It</a> pour publier sur Movable Type depuis des rseaux sociaux comme Facebook.',
	'None selected' => 'Aucune slectionne',

## tmpl/cms/refresh_results.tmpl
	'Template Refresh' => 'Ractualiser les gabarits',
	'No templates were selected to process.' => 'Aucun gabarit slectionn pour cette action.',
	'Return to templates' => 'Retourner aux gabarits',

## tmpl/cms/view_log.tmpl
	'The activity log has been reset.' => 'Le journal (logs) a t rinitialis.',
	'All times are displayed in GMT[_1].' => 'Toutes les heures sont affiches en GMT[_1].',
	'All times are displayed in GMT.' => 'Toutes les heures sont affiches en GMT.',
	'Show only errors' => 'Montrer uniquement les erreurs',
	'System Activity Log' => 'Journal (logs)',
	'Filtered' => 'Filtrs',
	'Filtered Activity Feed' => 'Flux d\'activit filtr',
	'Download Filtered Log (CSV)' => 'Tlcharger le journal filtr (CSV)',
	'Download Log (CSV)' => 'Tlcharger le journal (CSV)',
	'Clear Activity Log' => 'Effacer le journal (logs)',
	'Are you sure you want to reset the activity log?' => 'tes-vous sr(e) de vouloir r-initialiser le journal (logs) ?',
	'Showing all log records' => 'Affichage de toutes les donnes du journal',
	'Showing log records where' => 'Affichage des donnes du journal o',
	'Show log records where' => 'Afficher les donnes du journal o',
	'level' => 'le statut',
	'classification' => 'classification',
	'Security' => 'Scurit',
	'Error' => 'Erreur',
	'Information' => 'Information',
	'Debug' => 'Debug',
	'Security or error' => 'Scurit ou erreur',
	'Security/error/warning' => 'Scurit/erreur/mise en garde',
	'Not debug' => 'Pas dbugu',
	'Debug/error' => 'Debug/erreur',

## tmpl/cms/edit_category.tmpl
	'Edit Category' => 'Editer les catgories',
	'Your category changes have been made.' => 'Les modifications apportes ont t enregistres.',
	'Manage entries in this category' => 'Grer les notes dans cette catgorie',
	'You must specify a label for the category.' => 'Vous devez spcifier un titre pour cette catgorie.',
	'_CATEGORY_BASENAME' => 'Nom de base',
	'This is the basename assigned to your category.' => 'Ceci est le nom de base assign  votre catgorie.',
	'Unlock this category&rsquo;s output filename for editing' => 'Dverrouiller le nom de fichier de cette catgorie pour le modifier',
	'Warning: Changing this category\'s basename may break inbound links.' => 'Attention: changer le nom de la catgorie risque de casser des liens entrants.',
	'Inbound TrackBacks' => 'Trackbacks entrants',
	'Accept Trackbacks' => 'Accepter trackbacks',
	'If enabled, TrackBacks will be accepted for this category from any source.' => 'Si activ, les trackbacks seront accepts pour cette catgorie quelle que soit la source.',
	'View TrackBacks' => 'Voir les trackbacks',
	'TrackBack URL for this category' => 'URL trackback pour cette catgorie',
	'_USAGE_CATEGORY_PING_URL' => 'Il s\'agit de l\'URL utilise par vos lecteurs pour envoyer des trackbacks aux notes de votre blog. Si vous souhaitez permettre l\'envoi d\'un trackback  tous vos lecteurs, publiez cette URL. Si vous prfrez rserver l\'envoi d\'un trackback  seulement certaines personnes, communiquez cette URL de manire prive. Enfin, si vous souhaitez inclure la liste des trackbacks entrant dans l\'index de votre gabarit, consultez la documentation Movable Type.',
	'Passphrase Protection' => 'Protection Passphrase',
	'Optional' => 'Optionnels',
	'Outbound TrackBacks' => 'Trackbacks sortants',
	'Trackback URLs' => 'URLs de trackback',
	'Enter the URL(s) of the websites that you would like to send a TrackBack to each time you create an entry in this category. (Separate URLs with a carriage return.)' => 'Saisir les URLs des sites web auxquels vous souhaitez envoyer un trackback chaque fois que vous crez une note dans cette catgorie. (Sparez les URLs avec un retour chariot.)',
	'Save changes to this category (s)' => 'Enregistrer les modifications de cette catgorie (s)',

## tmpl/cms/cfg_spam.tmpl
	'Spam Settings' => 'Paramtres du spam',
	'Your spam preferences have been saved.' => 'Vos prfrences de spam ont t sauvegardes.',
	'Auto-Delete Spam' => 'Effacer automatiquement le spam',
	'If enabled, feedback reported as spam will be automatically erased after a number of days.' => 'Si activ, les commentaires notifis comme spam seront automatiquement effacs aprs un certain nombre de jours.',
	'Delete Spam After' => 'Effacer le spam aprs',
	'When an item has been reported as spam for this many days, it is automatically deleted.' => 'Quand un lment a t notifi comme spam depuis tant de jours, il est automatiquement effac.',
	'Spam Score Threshold' => 'Niveau de filtrage du spam',
	'Comments and TrackBacks receive a spam score between -10 (complete spam) and +10 (not spam). Feedback with a score which is lower than the threshold shown above will be reported as spam.' => 'Les commentaires et les trackbacks reoivent un score de spam entre -10 (spam assur) et +10 (non spam). Un commentaire avec un score qui est plus faible que le seuil ci-dessus sera notifi comme spam.',
	'Less Aggressive' => 'Moins agressif',
	'Decrease' => 'Baisser',
	'Increase' => 'Augmenter',
	'More Aggressive' => 'Plus agressif',

## tmpl/cms/list_notification.tmpl
	'You have added [_1] to your address book.' => 'Vous avez ajout [_1]  votre carnet d\'adresses.',
	'You have successfully deleted the selected contacts from your address book.' => 'Vous avez supprim avec succs les contacts slectionns de votre carnet d\'adresses.',
	'Download Address Book (CSV)' => 'Tlcharger le carnet d\'adresses (CSV)',
	'contact' => 'contact',
	'contacts' => 'contacts',
	'Create Contact' => 'Crer un contact',
	'Website URL' => 'URL du site',
	'Add Contact' => 'Ajouter un contact',

## tmpl/cms/edit_folder.tmpl
	'Edit Folder' => 'Modifier le rpertoire',
	'Your folder changes have been made.' => 'Vos modifications du rpertoire ont t faites.',
	'Manage Folders' => 'Grer les Rpertoires',
	'Manage pages in this folder' => 'Grer les pages de ce dossier',
	'You must specify a label for the folder.' => 'Vous devez spcifier un nom pour le rpertoire.',
	'Save changes to this folder (s)' => 'Enregistrer les modifications de ce rpertoire (s)',

## tmpl/cms/export.tmpl
	'You must select a blog to export.' => 'Vous devez slectionner un blog  exporter.',
	'_USAGE_EXPORT_1' => 'L\'exportation vous permet de sauvegarder le contenu de votre blog dans un fichier. Vous pourrez par la suite procder  l\'importation de ce fichier si vous souhaitez restaurer vos notes ou transfrer vos notes d\'un blog  un autre.',
	'Blog to Export' => 'Blog  exporter',
	'Select a blog for exporting.' => 'Slectionnez un blog  exporter.',
	'Change blog' => 'Changer de blog',
	'Select blog' => 'Slectionner le blog',
	'Export Blog (s)' => 'Exporter le blog (s)',
	'Export Blog' => 'Exporter le blog',

## tmpl/cms/edit_comment.tmpl
	'The comment has been approved.' => 'Ce commentaire a t approuv.',
	'Save changes to this comment (s)' => 'Enregistrer les modifications de ce commentaire (s)',
	'Delete this comment (x)' => 'Supprimer ce commentaire (x)',
	'Previous Comment' => 'Commentaire prcdent',
	'Next Comment' => 'Commentaire suivant',
	'Manage Comments' => 'Grer les commentaires',
	'View entry comment was left on' => 'Voir la note sur laquelle ce commentaire a t dpos',
	'Reply to this comment' => 'Rpondre  ce commentaire',
	'Update the status of this comment' => 'Mettre  jour le statut de ce commentaire',
	'Approved' => 'Approuv',
	'Unapproved' => 'Non-approuv',
	'Reported as Spam' => 'Notifi comme spam',
	'View all comments with this status' => 'Voir tous les commentaires avec ce statut',
	'Spam Details' => 'Dtails du spam',
	'Total Feedback Rating: [_1]' => 'Note globale de Feedback: [_1]',
	'Score' => 'Score',
	'Results' => 'Rsultats',
	'The name of the person who posted the comment' => 'Le nom de la personne qui a post le commentaire',
	'(Trusted)' => '(Fiable)',
	'Ban Commenter' => 'Bannir l\'auteur de commentaires',
	'Untrust Commenter' => 'Considrer l\'auteur de commentaires comme pas sr',
	'(Banned)' => '(Banni)',
	'Trust Commenter' => 'Considrer l\'auteur de commentaires comme sr',
	'Unban Commenter' => 'Lever le bannissement de l\'auteur de commentaires',
	'View all comments by this commenter' => 'Afficher tous les commentaires de cet auteur de commentaires',
	'Email address of commenter' => 'Adresse email de l\'auteur de commentaires',
	'None given' => 'Non fourni',
	'URL of commenter' => 'URL de l\'auteur de commentaires',
	'View all comments with this URL' => 'Afficher tous les commentaires associs  cette URL',
	'[_1] this comment was made on' => '[_1] ce commentaire a t post',
	'[_1] no longer exists' => '[_1] n\'existe plus',
	'View all comments on this [_1]' => 'Voir tous les commentaires sur cette [_1]',
	'Date this comment was made' => 'Date du commentaire',
	'View all comments created on this day' => 'Voir tous les commentaires crs ce jour',
	'IP Address of the commenter' => 'Adresse IP de l\'auteur de commentaires',
	'View all comments from this IP address' => 'Afficher tous les commentaires associs  cette adresse IP',
	'Fulltext of the comment entry' => 'Texte complet de ce commentaire',
	'Responses to this comment' => 'Rponses  ce commentaire',

## tmpl/cms/edit_author.tmpl
	'Edit Profile' => 'Editer le Profil',
	'This profile has been updated.' => 'Ce profil a t mis  jour.',
	'A new password has been generated and sent to the email address [_1].' => 'Un nouveau mot de passe a t cr et envoy  l\'adresse [_1].',
	'Your Web services password is currently' => 'Votre mot de passe est actuellement',
	'_WARNING_PASSWORD_RESET_SINGLE' => '_WARNING_PASSWORD_RESET_SINGLE',
	'Error occurred while removing userpic.' => 'Une erreur est survenue lors du retrait de l\'avatar.',
	'_USER_STATUS_CAPTION' => 'Statut',
	'Status of user in the system. Disabling a user removes their access to the system but preserves their content and history.' => 'Statut de l\'utilisateur dans le systme. En dsactivant un utilisateur, vous supprimez son accs au systme mais ne dtruisez pas ses contenus et son historique ',
	'_USER_PENDING' => 'Utilisateur en attente',
	'The username used to login.' => 'L\'identifiant utilis pour s\'identifier.',
	'External user ID' => 'ID utilisateur externe',
	'The name used when published.' => 'Le nom utilis lors de la publication.',
	'The email address associated with this user.' => 'L\'adresse email associe avec cet utilisateur.',
	'The URL of the site associated with this user. eg. http://www.movabletype.com/' => 'L\'URL du site associ  cet utilisateur. Exemple: http://www.movabletype.com/',
	'Userpic' => 'Image de l\'utilisateur',
	'The image associated with this user.' => 'L\'image associe  cet utilisateur.',
	'Select Userpic' => 'Slectionner l\'image de l\'utilisateur',
	'Remove Userpic' => 'Supprimer l\'image de l\'utilisateur',
	'Change Password' => 'Changer de Mot de passe',
	'Current Password' => 'Mot de passe actuel',
	'Existing password required to create a new password.' => 'Mot de passe actuel ncessaire pour crer un nouveau mot de passe.',
	'Initial Password' => 'Mot de passe *',
	'Enter preferred password.' => 'Saisissez le mot de passe prfr.',
	'New Password' => 'Nouveau mot de passe',
	'Enter the new password.' => 'Saisissez le nouveau mot de passe.',
	'Confirm Password' => 'Mot de passe (confirmation) *',
	'Repeat the password for confirmation.' => 'Rptez votre mot de passe pour confirmer.',
	'This word or phrase will be required to recover a forgotten password.' => 'Ce mot ou cette phrase sera ncessaire pour rcuprer un mot de passe oubli.',
	'Language' => 'Langue',
	'Preferred language of this user.' => 'Langue prfre de cet utilisateur.',
	'Text Format' => 'Format du texte',
	'Preferred text format option.' => 'Option de format de texte prfr.',
	'(Use Blog Default)' => '(Utiliser la valeur par dfaut du blog)',
	'Tag Delimiter' => 'Dlimiteur de tags',
	'Preferred method of separating tags.' => 'Mthode prfre pour sparer les tags.',
	'Comma' => 'Virgule',
	'Space' => 'Espace',
	'Web Services Password' => 'Mot de passe Services Web',
	'For use by Activity feeds and with XML-RPC and Atom-enabled clients.' => 'Pour utilisation par les flux d\'activit et avec les clients XML-RPC ou ATOM.',
	'Reveal' => 'Rvler',
	'System Permissions' => 'Autorisations systme',
	'Options' => 'Options',
	'Create personal blog for user' => 'Crer le blog personnel de l\'utilisateur',
	'Create User (s)' => 'Crer l\'Utilisateur (s)',
	'Save changes to this author (s)' => 'Enregistrer les modifications de cet auteur (s)',
	'_USAGE_PASSWORD_RESET' => 'Ci-dessous, vous pouvez r-initialiser le mot de passe pour cet utilisateur. Si vous faites cela un mot de passe gnr alatoirement sera cr et envoy par e-mail  : [_1].',
	'Initiate Password Recovery' => 'Rcuprer le mot de passe',

## tmpl/cms/list_ping.tmpl
	'Manage Trackbacks' => 'Grer les Trackbacks',
	'The selected TrackBack(s) has been approved.' => 'Les trackbacks slectionns ont t approuvs.',
	'All TrackBacks reported as spam have been removed.' => 'Tous les trackbacks notifis comme spam ont t supprims.',
	'The selected TrackBack(s) has been unapproved.' => 'Les trackbacks suivants ont t dsapprouvs.',
	'The selected TrackBack(s) has been reported as spam.' => 'Les trackbacks slectionns ont t notifis comme spam.',
	'The selected TrackBack(s) has been recovered from spam.' => 'Les trackbacks slectionns ont t rcuprs du spam.',
	'The selected TrackBack(s) has been deleted from the database.' => 'Le(s) trackback(s) slectionn(s) ont t supprim(s) de la base de donnes.',
	'No TrackBacks appeared to be spam.' => 'Aucun trackback ne semble tre du spam.',
	'Show only [_1] where' => 'Afficher seulement : [_1] o',
	'approved' => 'Approuv',
	'unapproved' => 'non-approuv',

## tmpl/cms/list_banlist.tmpl
	'IP Banning Settings' => 'Paramtres des IP bannies',
	'IP addresses' => 'Adresses IP',
	'Delete selected IP Address (x)' => 'Effacer les adresses IP slectionnes (x)',
	'You have added [_1] to your list of banned IP addresses.' => 'L\'adresse [_1] a t ajoute  la liste des adresses IP bannies.',
	'You have successfully deleted the selected IP addresses from the list.' => 'L\'adresse IP slectionne a t supprime de la liste.',
	'Ban IP Address' => 'Bannir l\'adresse IP',
	'Date Banned' => 'Bannie le :',

## tmpl/cms/error.tmpl
	'An error occurred' => 'Une erreur s\'est produite',

## tmpl/cms/list_role.tmpl
	'Roles: System-wide' => 'Rles : configuration globale',
	'You have successfully deleted the role(s).' => 'Vous avez supprim avec succs le(s) rle(s).',
	'roles' => 'rles',
	'Members' => 'Membres',
	'Role Is Active' => 'Le rle est actif',
	'Role Not Being Used' => 'Le rle n\'est pas utilis',

## tmpl/cms/widget/new_version.tmpl
	'What\'s new in Movable Type [_1]' => 'Quoi de neuf dans Movable Type [_1]',
	'Congratulations, you have successfully installed Movable Type [_1]. Listed below is an overview of the new features found in this release.' => 'Flicitations, vous avez install Movable Type [_1] avec succs. Voici, entre autres, une vue d\'ensemble des nouveauts apportes par cette nouvelle version.',

## tmpl/cms/widget/new_user.tmpl
	'Welcome to Movable Type, the world\'s most powerful blogging, publishing and social media platform. To help you get started we have provided you with links to some of the more common tasks new users like to perform:' => 'Bienvenue dans Movable Type, la plateforme de blogs, de publication et de mdia social la plus puissante au monde. Afin de vous aider  dmarrer avec Movable Type, nous vous proposons quelques liens vers les tches les plus courantes que les nouveaux utilisateurs souhaitent raliser :',
	'Write your first post' => 'crivez votre premire note',
	'What would a blog be without content? Start your Movable Type experience by creating your very first post.' => 'Que serait un blog sans contenu ? Dbutez votre exprience Movable Type en crant votre toute premire note.',
	'Design your blog' => 'Choisissez l\'habillage de votre blog',
	'Customize the look and feel of your blog quickly by selecting a design from one of our professionally designed themes.' => 'Personnalisez votre blog en slectionnant un habillage cr par des professionnels.',
	'Explore what\'s new in Movable Type 4' => 'Dcouvrez ce qui est nouveau dans Movable Type 4',
	'Whether you\'re new to Movable Type or using it for the first time, learn more about what this tool can do for you.' => 'Que vous dcouvriez Movable Type ou que vous l\'utilisiez pour la premire fois, dcouvrez ce que cet outil peut faire pour vous.',

## tmpl/cms/widget/mt_news.tmpl
	'News' => 'Actualit',
	'MT News' => 'Actualit Movable Type',
	'Learning MT' => 'Apprendre Movable Type',
	'Hacking MT' => 'Coder pour Movable Type',
	'Pronet' => 'Pronet',
	'No Movable Type news available.' => 'Aucune actualit Movable Type n\'est disponible.',
	'No Learning Movable Type news available.' => 'Pas d\'actualit Apprendre Movable Type disponible.',

## tmpl/cms/widget/this_is_you.tmpl
	'This is you' => 'C\'est vous',
	'Your <a href="[_1]">last entry</a> was [_2] in <a href="[_3]">[_4]</a>.' => 'Votre <a href="[_1]">dernire note</a> a t [_2] dans <a href="[_3]">[_4]</a>.',
	'You have <a href="[_1]">[quant,_2,draft,drafts]</a>.' => 'Vous avez <a href="[_1]">[quant,_2,brouillon,brouillons]</a>.',
	'You\'ve written <a href="[_1]">[quant,_2,entry,entries]</a> with <a href="[_3]">[quant,_4,comment,comments]</a>.' => 'Vous avez crit <a href="[_1]">[quant,_2,note,notes]</a> avec <a href="[_3]">[quant,_4,commentaire,commentaires]</a>.',
	'You\'ve written <a href="[_1]">[quant,_2,entry,entries]</a>.' => 'Vous avez crit <a href="[_1]">[quant,_2,note,notes]</a>.',
	'Edit your profile' => 'Modifier votre profil',

## tmpl/cms/widget/blog_stats_recent_entries.tmpl
	'[quant,_1,entry,entries] tagged &ldquo;[_2]&rdquo;' => '[quant,_1,note,notes] avec le tag &ldquo;[_2]&rdquo;',
	'...' => '...',
	'Posted by [_1] [_2] in [_3]' => 'Poste par [_1] [_2] dans [_3]',
	'Posted by [_1] [_2]' => 'Poste par [_1] [_2]',
	'Tagged: [_1]' => 'avec le tag : [_1]',
	'View all entries tagged &ldquo;[_1]&rdquo;' => 'Voir toutes les notes avec le tag &ldquo;[_1]&rdquo;',
	'No entries available.' => 'Aucune note disponible.',

## tmpl/cms/widget/blog_stats_tag_cloud.tmpl

## tmpl/cms/widget/custom_message.tmpl
	'Welcome to [_1].' => 'Bienvenue sur [_1].',
	'You can manage your blog by selecting an option from the menu located to the left of this message.' => 'Vous pouvez grer votre blog en slectionnant une option dans le menu situ  gauche de ce message.',
	'If you need assistance, try:' => 'Si vous avez besoin d\'aide, vous pouvez consulter :',
	'Movable Type User Manual' => 'Mode d\'emploi de Movable Type',
	'http://www.sixapart.com/movabletype/support' => 'http://www.sixapart.com/movabletype/support',
	'Movable Type Technical Support' => 'Support Technique Movable Type',
	'Movable Type Community Forums' => 'Forums de la communaut Movable Type ',
	'Save Changes (s)' => 'Sauvegarder les modifications',
	'Change this message.' => 'Changer ce message.',
	'Edit this message.' => 'Modifier ce message.',

## tmpl/cms/widget/mt_shortcuts.tmpl
	'Import Content' => 'Importer du contenu',
	'Blog Preferences' => 'Prfrences du blog',

## tmpl/cms/widget/new_install.tmpl
	'Thank you for installing Movable Type' => 'Merci d\'avoir install Movable Type',
	'Congratulations on installing Movable Type, the world\'s most powerful blogging, publishing and social media platform. To help you get started we have provided you with links to some of the more common tasks new users like to perform:' => 'Flicitations, vous avez install avec succs Movable Type, la plateforme de blogs, de publication et de mdia social la plus puissante au monde. Afin de vous aider  dmarrer avec Movable Type, nous vous proposons quelques liens vers les tches les plus courantes que les nouveaux utilisateurs souhaitent raliser :',
	'Add more users to your blog' => 'Ajouter plus d\'utilisateurs  votre blog',
	'Start building your network of blogs and your community now. Invite users to join your blog and promote them to authors.' => 'Commencez  crer votre rseau de blogs et votre communaut ds maintenant. Invitez des utilisateurs  joindre votre blog et donnez-leur le statut d\'auteurs.',

## tmpl/cms/widget/blog_stats.tmpl
	'Error retrieving recent entries.' => 'Erreur en rcuprant les notes rcentes.',
	'Loading recent entries...' => 'Chargement des notes rcentes...',
	'Jan.' => 'Jan.',
	'Feb.' => 'Fv.',
	'July.' => 'Juil.',
	'Aug.' => 'Aot',
	'Sept.' => 'Sept.',
	'Oct.' => 'Oct.',
	'Nov.' => 'Nov.',
	'Dec.' => 'Dc.',
	'Movable Type was unable to locate your \'mt-static\' directory. Please configure the \'StaticFilePath\' configuration setting in your mt-config.cgi file, and create a writable \'support\' directory underneath your \'mt-static\' directory.' => 'Movable Type n\'a pas pu localiser votre rpertoire \'mt-static\'. Merci de configurer la variable de configuration \'StaticFilePath\' dans votre fichier mt-config.cgi, et crez un rpertoire \'support\' accessible en criture dans le rpertoire \'mt-static\'.',
	'Movable Type was unable to write to its \'support\' directory. Please create a directory at this location: [_1], and assign permissions that will allow the web server write access to it.' => 'Movable Type n\'a pas pu crire dans son rpertoire \'support\'. Merci de crer un rpertoire  cet endroit : [_1], et de lui ajouter des droits qui permettent au serveur web d\'crire dedans.',
	'[_1] [_2] - [_3] [_4]' => '[_1] [_2] - [_3] [_4]',
	'You have <a href=\'[_3]\'>[quant,_1,comment,comments] from [_2]</a>' => 'Vous avez <a href=\'[_3]\'>[quant,_1,commentaire,commentaires] de [_2]</a>',
	'You have <a href=\'[_3]\'>[quant,_1,entry,entries] from [_2]</a>' => 'Vous avez <a href=\'[_3]\'>[quant,_1,note,notes] de [_2]</a>',

## tmpl/cms/widget/blog_stats_entry.tmpl
	'Most Recent Entries' => 'Notes rcentes',
	'View all entries' => 'Voir toutes les notes',

## tmpl/cms/widget/blog_stats_comment.tmpl
	'Most Recent Comments' => 'Commentaires rcents',
	'[_1] [_2], [_3] on [_4]' => '[_1] [_2], [_3] sur [_4]',
	'View all comments' => 'Voir tous les commentaires',
	'No comments available.' => 'Aucune commentaire disponible.',

## tmpl/cms/preview_template_strip.tmpl
	'You are previewing the template named &ldquo;[_1]&rdquo;' => 'Vous prvisualisez le module nomm &ldquo;[_1]&rdquo;',
	'(Publish time: [_1] seconds)' => 'Temps de publication : [_1] secondes',
	'Save this template (s)' => 'Sauvegarder ce gabarit (s)',
	'Save this template' => 'Sauvegarder ce gabarit',
	'Re-Edit this template (e)' => 'R-diter ce gabarit (e)',
	'Re-Edit this template' => 'R-diter ce gabarit',

## tmpl/cms/cfg_web_services.tmpl
	'Web Services Settings' => 'Paramtres des services Web',
	'Your blog preferences have been saved.' => 'Les prfrences de votre blog ont t enregistres.',
	'Six Apart Services' => 'Services Six Apart',
	'Your TypeKey token is used to access Six Apart services like its free Authentication service.' => 'Votre code TypeKey est utilis pour accder aux services de Six Apart et notamment son service d\'authentification gratuit.',
	'TypeKey is enabled.' => 'TypeKey est activ.',
	'TypeKey token:' => 'Code TypeKey',
	'Clear TypeKey Token' => 'Effacer le code TypeKey',
	'Please click the Save Changes button below to disable authentication.' => 'Cliquez sur le bouton Enregistrer ci-dessous pour DESACTIVER l\'authentification.',
	'TypeKey is not enabled.' => 'TypeKey n\'est pas activ.',
	'or' => 'ou',
	'Obtain TypeKey token' => 'Obtenir le code TypeKey',
	'Please click the Save Changes button below to enable TypeKey.' => 'Merci de cliquer sur le bouton Enregistrer les modifications ci-dessous pour activer TypeKey.',
	'External Notifications' => 'Notifications externes',
	'Notify of blog updates' => 'Pinguer les sites :',
	'When this blog is updated, Movable Type will automatically notify the selected sites.' => 'Quand ce blog est mis  jour, Movable Type notifiera automatiquement les sites suivants.',
	'Note: This option is currently ignored since outbound notification pings are disabled system-wide.' => 'Remarque : cette option est actuellement ignore car les pings de notification sortants sont dsactivs pour tout le systme.',
	'Others:' => 'Autres :',
	'(Separate URLs with a carriage return.)' => '(Sparer les URLs avec un retour chariot.)',
	'Recently Updated Key' => 'Cl rcemment mise  jour',
	'If you have received a recently updated key (by virtue of your purchase), enter it here.' => 'Si vous avez reu une mise  jour de la clef, saisissez-la ici.',

## tmpl/cms/list_comment.tmpl
	'The selected comment(s) has been approved.' => 'Les commentaires suivants ont t approuvs.',
	'All comments reported as spam have been removed.' => 'Tous les commentaires notifis comme spam ont t supprims.',
	'The selected comment(s) has been unapproved.' => 'Les commentaires slectionns ont t approuvs.',
	'The selected comment(s) has been reported as spam.' => 'Les commentaires slectionns ont t notifis comme spam.',
	'The selected comment(s) has been recovered from spam.' => 'Les commentaires suivants ont t rcuprs du spam.',
	'The selected comment(s) has been deleted from the database.' => 'Les commentaires slectionns ont t supprims de la base de donnes.',
	'One or more comments you selected were submitted by an unauthenticated commenter. These commenters cannot be Banned or Trusted.' => 'Un ou plusieurs commentaires slectionns ont t crits par un auteur de commentaires non authentifi. Ces auteurs de commentaires ne peuvent pas tre bannis ou valids.',
	'No comments appeared to be spam.' => 'Aucun commentaire ne semble tre du spam.',
	'[_1] on entries created within the last [_2] days' => '[_1] sur les notes cres dans les [_2] derniers jours',
	'[_1] on entries created more than [_2] days ago' => '[_1] sur les notes cres il y a plus de [_2] jours',
	'spam' => 'Spam',

## tmpl/cms/list_tag.tmpl
	'Your tag changes and additions have been made.' => 'Votre changement de tag et les complments ont t faits.',
	'You have successfully deleted the selected tags.' => 'Vous avez effac correctement les tags slectionns.',
	'tag' => 'tag',
	'tags' => 'tags',
	'Specify new name of the tag.' => 'Spcifier le nouveau nom du tag',
	'Tag Name' => 'Nom du tag',
	'Click to edit tag name' => 'Cliquez pour modifier le nom du tag',
	'Rename [_1]' => 'Renommer',
	'Rename' => 'Changer le nom',
	'Show all [_1] with this tag' => 'Montrer toutes les [_1] avec ce tag',
	'[quant,_1,_2,_3]' => '[quant,_1,_2,_3]',
	'[quant,_1,entry,entries]' => '[quant,_1,note,notes]',
	'The tag \'[_2]\' already exists. Are you sure you want to merge \'[_1]\' with \'[_2]\' across all blogs?' => 'Le tag \'[_2]\' existe dj. tes-vous sr de vouloir fusionner \'[_1]\' et \'[_2]\' sur tous les blogs ?',
	'An error occurred while testing for the new tag name.' => 'Une erreur est survenue en testant la nouvelle balise.',

## tmpl/cms/list_template.tmpl
	'Blog Templates' => 'Gabarits du blog',
	'Show All' => 'Tout afficher',
	'Blog Publishing Settings' => 'Paramtres de publication du blog',
	'You have successfully deleted the checked template(s).' => 'Les gabarits slectionns ont t supprims.',
	'Your templates have been published.' => 'Vos gabarits ont bien t publis.',
	'Selected template(s) has been copied.' => 'Le(s) gabarit(s) slectionn(s) a (ont) t copi(s).',

## tmpl/cms/install.tmpl
	'Create Your Account' => 'Crez votre compte',
	'The initial account name is required.' => 'Le nom initial du compte est ncessaire.',
	'The display name is required.' => 'Le nom d\'affichage est requis.',
	'Password recovery word/phrase is required.' => 'La phrase de rcupration de mot de passe est requise.',
	'The version of Perl installed on your server ([_1]) is lower than the minimum supported version ([_2]).' => 'La version Perl installe sur votre serveur ([_1]) es antrieure  la version minimale ncessaire ([_2]).',
	'While Movable Type may run, it is an <strong>untested and unsupported environment</strong>.  We strongly recommend upgrading to at least Perl [_1].' => 'Mme si Movable Type semble fonctionner normalement, l\'application s\'excute <strong>dans un environnement non test et non support</strong>.  Nous vous recommandons fortement d\'installer une version de Perl suprieure ou gale  [_1].',
	'Do you want to proceed with the installation anyway?' => 'Souhaitez-vous tout de mme poursuivre l\'installation ?',
	'View MT-Check (x)' => 'Voir MT-Check (x)',
	'Before you can begin blogging, you must create an administrator account for your system. When you are done, Movable Type will then initialize your database.' => 'Avant de pouvoir commencer  bloguer, vous devez crer un compte administrateur pour votre systme. Une fois cela fait, Movable Type initialisera ensuite votre base de donnes.',
	'To proceed, you must authenticate properly with your LDAP server.' => 'Pour poursuivre, vous devez vous authentifier correctement auprs de votre serveur LDAP.',
	'The name used by this user to login.' => 'Le nom utilis par cet utilisateur pour s\'enregistrer.',
	'The user&rsquo;s email address.' => 'Adresse email de l\'utilisateur',
	'The user&rsquo;s preferred language.' => 'Langue prfre de l\'utilisateur.',
	'Select a password for your account.' => 'Slectionnez un Mot de Passe pour votre compte.',
	'Password Confirm' => 'Mot de passe (confirmation)',
	'This word or phrase will be required to recover your password if you forget it.' => 'Ce mot ou cette expression vous seront ncessaires pour retrouver votre mot de passe. Ne les oubliez pas.',
	'Your LDAP username.' => 'Votre nom d\'utilisateur LDAP.',
	'Enter your LDAP password.' => 'Saisissez votre mot de passe LDAP.',

## tmpl/cms/popup/rebuild_confirm.tmpl
	'Publish [_1]' => 'Publier [_1]',
	'Publish <em>[_1]</em>' => 'Publier <em>[_1]</em>',
	'_REBUILD_PUBLISH' => 'Publier',
	'All Files' => 'Tous les fichiers',
	'Index Template: [_1]' => 'Gabarit d\'index: [_1]',
	'Only Indexes' => 'Uniquement les Index',
	'Only [_1] Archives' => 'Uniquement les archives [_1]',
	'Publish (s)' => 'Publier',

## tmpl/cms/popup/pinged_urls.tmpl
	'Successful Trackbacks' => 'Trackbacks russis',
	'Failed Trackbacks' => 'Trackbacks chous',
	'To retry, include these TrackBacks in the Outbound TrackBack URLs list for your entry.' => 'Pour r-essayer, incluez ces trackbacks dans la liste des URLs de trackbacks sortants pour cette note.',

## tmpl/cms/popup/rebuilt.tmpl
	'Success' => 'Succs',
	'The files for [_1] have been published.' => 'Les fichiers pour [_1] ont t publis.',
	'Your [_1] archives have been published.' => 'Vos archives [_1]  ont t publies.',
	'Your [_1] templates have been published.' => 'Vos gabarites [_1] ont t publies.',
	'Publish time: [_1].' => 'Temps de publication : [_1].',
	'View your site.' => 'Voir votre site.',
	'View this page.' => 'Voir cette page.',
	'Publish Again (s)' => 'Publier  nouveau',
	'Publish Again' => 'Publier  nouveau',

## tmpl/cms/list_author.tmpl
	'Users: System-wide' => 'Utilisateurs : configuration globale',
	'You have successfully disabled the selected user(s).' => 'Vous avez dsactiv avec succs les utilisateurs slectionns.',
	'You have successfully enabled the selected user(s).' => 'Vous avez activ avec succs les utilisateurs slectionns.',
	'You have successfully deleted the user(s) from the Movable Type system.' => 'Vous avez supprim avec succs les utilisateurs dans le systme.',
	'The deleted user(s) still exist in the external directory. As such, they will still be able to login to Movable Type Enterprise.' => 'Les utilisateurs effacs existent encore dans le rpertoire externe. En consquence ils pourront encore s\'identifier dans Movable Type Entreprise',
	'You have successfully synchronized users\' information with the external directory.' => 'Vous avez synchronis avec succs les informations des utilisateurs avec le rpertoire externe.',
	'Some ([_1]) of the selected user(s) could not be re-enabled because they were no longer found in the external directory.' => 'Certains des utilisateurs slectionns ([_1])ne peuvent pas tre r-activs car ils ne sont pas dans le rpertoire externe.',
	'An error occured during synchronization.  See the <a href=\'[_1]\'>activity log</a> for detailed information.' => 'Une erreur s\'est produite durant la synchronisation.  Consultez le <a href=\'[_1]\'>journal (logs)</a> pour plus d\'informations.',
	'Enable selected users (e)' => 'Activer les utilisateurs slectionns (e)',
	'_USER_ENABLE' => 'Activer',
	'_NO_SUPERUSER_DISABLE' => 'Puisque vous tes administrateur du systme Movable Type, vous ne pouvez vous dsactiver vous-mme.',
	'Disable selected users (d)' => 'Dsactiver les utilisateurs slectionns (d)',
	'_USER_DISABLE' => 'Dsactiver',
	'Showing All Users' => 'Afficher tous les utilisateurs',

## tmpl/cms/cfg_system_feedback.tmpl
	'System: Feedback Settings' => 'Paramtres des feedbacks',
	'Your feedback preferences have been saved.' => 'Vos prfrences feedback sont enregistres.',
	'Feedback: Master Switch' => 'Feedback: paramtres globaux (agit sur tous les blogs)',
	'This will override all individual blog settings.' => 'Cela va craser les paramtres de tous les blogs individuels',
	'Disable comments for all blogs' => 'Dsactiver les commentaires sur tous les blogs',
	'Disable TrackBacks for all blogs' => 'Dsactiver les trackbacks sur tous les blogs',
	'Outbound Notifications' => 'Notifications sortantes',
	'Notification pings' => 'Pings de notification',
	'This feature allows you to disable sending notification pings when a new entry is created.' => 'Cette fonctionnalit vous permet de dsactiver l\'envoi de pings de notification quand une nouvelle note est cre.',
	'Disable notification pings for all blogs' => 'Dsactiver les pings de notification pour tous les blogs',
	'Limit outbound TrackBacks and TrackBack auto-discovery for the purposes of keeping your installation private.' => 'Limitez les trackbacks sortants et les trackbacks d\'autorecherche afin de conserver le caractre priv de votre installation. ',
	'Allow to any site' => 'Autoriser sur tous les sites',
	'(No outbound TrackBacks)' => '(Pas de trackbacks sortants)',
	'Only allow to blogs on this installation' => 'Autoriser uniquement vers les blogs de cette installation.',
	'Only allow the sites on the following domains:' => 'Autoriser uniquement sur les domaines suivants:',

## tmpl/cms/restore_end.tmpl
	'Make sure that you remove the files that you restored from the \'import\' folder, so that if/when you run the restore process again, those files will not be re-restored.' => 'Assurez-vous d\'avoir supprim les fichiers que vous avez restaurs dans le rpertoire \'import\', ainsi, si vous restaurez  nouveau d\'autres fichiers plus tard, les fichiers actuels ne seront pas restaurs une seconde fois.',
	'An error occurred during the restore process: [_1] Please check activity log for more details.' => 'Une erreur s\'est produite pendant la procdure de restauration : [_1] Merci de vous reporter au journal (logs) pour plus de dtails.',

## tmpl/cms/list_asset.tmpl
	'You have successfully deleted the asset(s).' => 'Vous avez effac les contenus.',
	'Show only assets where' => 'Afficher seulement les lments o',
	'type' => 'Type',

## tmpl/cms/import.tmpl
	'You must select a blog to import.' => 'Vous devez slectionner un blog  importer.',
	'Transfer weblog entries into Movable Type from other Movable Type installations or even other blogging tools or export your entries to create a backup or copy.' => 'Transfrer les notes dans Movable Type depuis une autre installation Movable Type ou  partir d\'un autre outil de publication de blogs afin de crer une sauvegarde ou une copie.',
	'Import data into' => 'Importer les donnes dans',
	'Select a blog to import.' => 'Slectionner un blog  importer.',
	'Importing from' => 'Importation  partir de',
	'Ownership of imported entries' => 'Propritaire des notes importes',
	'Import as me' => 'Importer en me considrant comme auteur',
	'Preserve original user' => 'Prserver l\'utilisateur initial',
	'If you choose to preserve the ownership of the imported entries and any of those users must be created in this installation, you must define a default password for those new accounts.' => 'Si vous choisissez de garder l\'auteur original de chaque note importe, ils doivent tre crs dans votre installation et vous devez dfinir un mot de passe par dfaut pour ces nouveaux comptes.',
	'Default password for new users:' => 'Mot de passe par dfaut pour un nouvel utilisateur:',
	'You will be assigned the user of all imported entries.  If you wish the original user to keep ownership, you must contact your MT system administrator to perform the import so that new users can be created if necessary.' => 'Vous serez dsign comme auteur/utilisateur pour toutes les notes importes. Si vous voulez que l\'auteur initial en conserve la proprit, vous devez contacter votre administrateur MT pour qu\'il fasse l\'importation et le cas chant qu\'il cre un nouvel utilisateur.',
	'Upload import file (optional)' => 'Envoyer le fichier d\'import (optionnel)',
	'If your import file is located on your computer, you can upload it here.  Otherwise, Movable Type will automatically look in the \'import\' folder of your Movable Type directory.' => 'Si votre fichier d\'import est situ sur votre ordinateur, vous pouvez l\'envoyer ici.  Sinon, Movable Type va automatiquement chercher dans le rpertoire \'import\' de votre rpertoire Movable Type.',
	'More options' => 'Plus d\'options',
	'Import File Encoding' => 'Encodage du fichier d\'import',
	'By default, Movable Type will attempt to automatically detect the character encoding of your import file.  However, if you experience difficulties, you can set it explicitly.' => 'Par dfaut, Movable Type va essayer de dtecter automatiquement l\'encodage des caractres de vos fichiers imports.  Cependant, si vous rencontrez des difficults, vous pouvez le paramtrer de manire explicite',
	'<mt:var name="display_name" escape="html">' => '<mt:var name="display_name" escape="html">', # Translate - New
	'Default category for entries (optional)' => 'Catgorie par dfaut pour les notes (optionnel)',
	'You can specify a default category for imported entries which have none assigned.' => 'Vous pouvez spcifier une catgorie par dfaut pour les notes importes qui n\'ont pas t assignes.',
	'Select a category' => 'Slectionnez une catgorie',
	'Import Entries (s)' => 'Importer les notes (s)',
	'Import Entries' => 'Importer des notes',

## tmpl/cms/upgrade_runner.tmpl
	'Initializing database...' => 'Initialisation de la base de donnes...',
	'Upgrading database...' => 'Mise  jour de la base de donnes...',
	'Installation complete!' => 'Installation termine !',
	'Upgrade complete!' => 'Mise  jour termine !',
	'Starting installation...' => 'Dbut de l\'installation...',
	'Starting upgrade...' => 'Dbut de la mise  jour...',
	'Error during installation:' => 'Erreur lors de l\'installation :',
	'Error during upgrade:' => 'Erreur lors de la mise  jour :',
	'Return to Movable Type (s)' => 'Retour vers Movable Type',
	'Return to Movable Type' => 'Retourner  Movable Type',
	'Your database is already current.' => 'Votre base de donnes est dj actualise.',

## tmpl/cms/list_widget.tmpl
	'Widget Sets' => 'Groupes de widgets',
	'Delete selected Widget Sets (x)' => 'Effacer les groupes de widgets slectionns (x)',
	'Helpful Tips' => 'Astuces',
	'To add a widget set to your templates, use the following syntax:' => 'Pour ajouter un groupe de widgets  vos gabarits, utilisez la syntaxe suivante :',
	'<strong>&lt;$MTWidgetSet name=&quot;Name of the Widget Set&quot;$&gt;</strong>' => '<strong>&lt;$MTWidgetSet name=&quot;Nom du groupe de widgets&quot;$&gt;</strong>',
	'Your changes to the widget set have been saved.' => 'Les modifications apportes au widget ont t enregistres.',
	'You have successfully deleted the selected widget set(s) from your blog.' => 'Vous avez supprim de votre blog les groupes de widgets slectionns.',
	'No Widget Sets could be found.' => 'Aucun groupe de widgets n\'a t trouv',
	'Create widget template' => 'Crer un gabarit de widget',
	'Widget Template' => 'Gabarit de Widget',
	'Widget Templates' => 'Gabarits de Widget',

## tmpl/cms/restore.tmpl
	'Restore from a Backup' => 'Restaurer  partir d\'une sauvegarde',
	'Perl module XML::SAX and/or its dependencies are missing - Movable Type can not restore the system without it.' => 'Le module Perl XML::SAX et/ou ses dpendances sont manquantes - Movable Type ne peut restaurer le systme sans lui.',
	'Backup file' => 'Fichier de sauvegarde',
	'If your backup file is located on your computer, you can upload it here.  Otherwise, Movable Type will automatically look in the \'import\' folder of your Movable Type directory.' => 'Si votre fichier de sauvegarde est situ sur votre ordinateur, vous pouvez l\'envoyer ici.  Autrement, Movable Type cherchera automatiquement dans le rpertoire \'import\' de votre rpertoire Movable Type.',
	'Check this and files backed up from newer versions can be restored to this system.  NOTE: Ignoring Schema Version can damage Movable Type permanently.' => 'Cochez ceci et les fichiers sauvegards  partir d\'une version plus rcente pourront tre restaurs dans ce systme. NOTE : Ignorer la version du schma peut endommager Movable Type de manire permanente.',
	'Ignore schema version conflicts' => 'Ignorer les conflits de version de schma',
	'Check this and existing global templates will be overwritten from the backup file.' => 'Cochez ceci et les gabarits globaux existants seront crass par ceux de la sauvegarde.',
	'Overwrite global templates.' => 'Ecraser les gabarits globaux.',
	'Restore (r)' => 'Restaurer (r)',

## tmpl/cms/system_check.tmpl
	'User Counts' => 'Statistiques utilisateurs',
	'Number of users in this system.' => 'Nombre d\'utilisateurs enregistrs',
	'Total Users' => 'Utilisateurs au total',
	'Active Users' => 'Utilisateurs actifs',
	'Users who have logged in within 90 days are considered <strong>active</strong> in Movable Type license agreement.' => 'Les utilisateurs qui se sont connects dans les 90 derniers jours sont considrs comme <strong>actifs</strong> dans les accords de licence Movable Type',
	'Movable Type could not find the script named \'mt-check.cgi\'. To resolve this issue, please ensure that the mt-check.cgi script exists and/or the CheckScript configuration parameter references it properly.' => 'Movable Type n\'a pu trouver le script nomm \'mt-check.cgi\'. Pour rsoudre ce problme, assurez-vous que le script mt-check.cgi script existe et/ou que la configuration des paramtres de MTCheckScript le rfrence convenablement.',

## tmpl/cms/restore_start.tmpl
	'Restoring Movable Type' => 'Restauration de Movable Type',

## tmpl/cms/cfg_archives.tmpl
	'Error: Movable Type was not able to create a directory for publishing your blog. If you create this directory yourself, assign sufficient permissions that allow Movable Type to create files within it.' => 'Erreur : Movable Type n\'a pas t capable de crer un rpertoire pour publier votre blog. Si vous crez ce rpertoire vous-mme, assignez-lui des autorisations suffisantes pour que Movable Type puisse crer des fichiers dedans.',
	'Your blog\'s archive configuration has been saved.' => 'La configuration des archives de votre blog a t sauvegarde.',
	'You have successfully added a new archive-template association.' => 'L\'association gabarit/archive a russi.',
	'You may need to update your \'Master Archive Index\' template to account for your new archive configuration.' => 'Vous aurez peut-tre besoin de mettre  jour votre gabarit \'Index principal des archives\' pour activer la nouvelle configuration de vos archives.',
	'The selected archive-template associations have been deleted.' => 'Les associations gabarit/archive slectionnes ont t supprimes.',
	'Warning: one or more of your templates is set to publish dynamically using PHP, however your server side include method may not be compatible with dynamic publishing.' => 'Attention : au moins un de vos gabarits est marqu pour publication dynamique via PHP, cependant votre mthode d\'inclusion ct serveur peut ne pas tre compatible avec une publication dynamique.',
	'You must set your Local Site Path.' => 'Vous devez configurer le chemin local de votre site.',
	'You must set a valid Site URL.' => 'Vous devez spcifier une URL valide.',
	'You must set a valid Local Site Path.' => 'Vous devez spcifier un chemin local d\'accs valide.',
	'Publishing Paths' => 'Chemins de publication',
	'The URL of your website. Do not include a filename (i.e. exclude index.html). Example: http://www.example.com/blog/' => 'L\'URL de votre site web. Ne mettez pas un nom de fichier (par exemple excluez index.html). Exemple : http://www.exemple.com/blog/',
	'Unlock this blog&rsquo;s site URL for editing' => 'Dverrouillez l\'URL du site de ce blog pour le modifier',
	'Warning: Changing the site URL can result in breaking all the links in your blog.' => 'Attention : Modifier l\'URL du site peut rompre tous les liens de votre blog.',
	'The path where your index files will be published. An absolute path (starting with \'/\') is preferred, but you can also use a path relative to the Movable Type directory. Example: /home/melody/public_html/blog' => 'Il s\'agit du chemin o vos fichiers d\'index seront publis. Un chemin absolu (commenant par \'/\') est prfrable, mais vous pouvez utiliser un chemin relatif au rpertoire de Movable Type. Exemple : /home/melody/public_html/blog',
	'Unlock this blog&rsquo;s site path for editing' => 'Dverrouiller le chemin du site de ce blog pour le modifier',
	'Note: Changing your site root requires a complete publish of your site.' => 'Remarque : La modification de la racine de votre site ncessite une publication complte de votre site.',
	'Advanced Archive Publishing' => 'Publication avance des archives',
	'Select this option only if you need to publish your archives outside of your Site Root.' => 'Slectionnez cette option si vous avez besoin de publier vos archives en dehors de la racine du Site.',
	'Publish archives outside of Site Root' => 'Publier les archives en dehors de la racine du site',
	'Enter the URL of the archives section of your website. Example: http://archives.example.com/' => 'Saisissez l\'URL de la section des archives de votre site web. Exemple: http://archives.exemple.com/',
	'Unlock this blog&rsquo;s archive url for editing' => 'Dverrouillez l\'url de l\'archive du blog pour la modifier',
	'Warning: Changing the archive URL can result in breaking all the links in your blog.' => 'Attention : Si vous modifiez l\'URL d\'archive vous pouvez casser tous les liens dans votre blog.',
	'Enter the path where your archive files will be published. Example: /home/melody/public_html/archives' => 'Saisissez le chemin o vos fichiers archives seront publis. Exemple : /home/melody/public_html/archives',
	'Warning: Changing the archive path can result in breaking all the links in your blog.' => 'Attention : Changer le chemin d\'archive peut casser tous les liens de votre blog.',
	'Asynchronous Job Queue' => 'File d\'attente asynchrone',
	'Use Publishing Queue' => 'Utiliser la publication en mode File d\'attente',
	'Requires the use of a cron job to publish pages in the background.' => 'Requiert l\'utilisation d\'un cron job pour publier en tche de fond.',
	'Use background publishing queue for publishing static pages for this blog' => 'Utiliser la publication en mode File d\'attente pour publier les pages statiques de ce blog',
	'Dynamic Publishing Options' => 'Options de publication dynamique',
	'Enable dynamic cache' => 'Activer le cache dynamique',
	'Enable conditional retrieval' => 'Activer la rcupration conditionnelle',
	'Archive Options' => 'Options d\'archive',
	'File Extension' => 'Extension de fichier',
	'Enter the archive file extension. This can take the form of \'html\', \'shtml\', \'php\', etc. Note: Do not enter the leading period (\'.\').' => 'Entrez l\'extension du fichier d\'archive. Elle peut tre au choix \'html\', \'shtml\', \'php\', etc. NB: Ne pas indiquer la priode (\'.\').',
	'Preferred Archive' => 'Archive prfre',
	'Used for creating links to an archived entry (permalink). Select from the archive types used in this blogs archive templates.' => 'Utilis pour crer des liens vers une note archive (lien permanent). Slectionner parmi les types d\'archives utiliss dans les gabarits d\'archives du blog.',
	'No archives are active' => 'Aucune archive n\'est active',
	'Module Options' => 'Options de module',
	'Enable template module caching' => 'Activer le cache des modules de gabarit',
	'Server Side Includes' => 'Service Side Includes',
	'None (disabled)' => 'Aucun (dsactiv)',
	'PHP Includes' => 'Inclusions PHP',
	'Apache Server-Side Includes' => 'Inclusions Apache Server-Side',
	'Active Server Page Includes' => 'Inclusions Active Server Page',
	'Java Server Page Includes' => 'Inclusions Java Server Page',

## tmpl/cms/rebuilding.tmpl
	'Publishing...' => 'Publication...',
	'Publishing [_1]...' => 'Publication [_1]...',
	'Publishing [_1] [_2]...' => 'Publication [_1] [_2]...',
	'Publishing [_1] dynamic links...' => 'Publication des liens dynamiques [_1]...',
	'Publishing [_1] archives...' => 'Publication des archives [_1]...',
	'Publishing [_1] templates...' => 'Publication des gabarits [_1]...',

## tmpl/cms/edit_asset.tmpl
	'Edit Asset' => 'diter les lments',
	'Your asset changes have been made.' => 'Vos modifications de l\'lment ont bien t apportes.',
	'[_1] - Modified by [_2]' => '[_1] - modifi par [_2]',
	'Appears in...' => 'Apparat dans...',
	'Published on [_1]' => 'Publi sur [_1]',
	'Show all entries' => 'Afficher toutes les notes',
	'Show all pages' => 'Afficher toutes les pages',
	'This asset has not been used.' => 'Cet lment n\'est pas utilis.',
	'Related Assets' => 'lments lis',
	'You must specify a label for the asset.' => 'Vous devez spcifier un titre pour l\'lment.',
	'Embed Asset' => 'lment embarqu',
	'Save changes to this asset (s)' => 'Enregistrer les modifications de cet lment (s)',

## tmpl/cms/upgrade.tmpl
	'Time to Upgrade!' => 'Il est temps de mettre  jour !',
	'Upgrade Check' => 'Vrification des mises  jour',
	'Do you want to proceed with the upgrade anyway?' => 'Voulez-vous quand mme continuer la mise a jour ?',
	'A new version of Movable Type has been installed.  We\'ll need to complete a few tasks to update your database.' => 'Une nouvelle version de Movable Type a t installe. Nous avons besoin de faire quelques manipulations complmentaires pour mettre  jour votre base de donnes.',
	'Information about this upgrade can be found <a href=\'[_1]\' target=\'_blank\'>here</a>.' => 'Des informations  propos de cette mise  jour peuvent tre obtenue <a href=\'[_1]\' target=\'_blank\'>ici</a>.',
	'In addition, the following Movable Type components require upgrading or installation:' => 'De plus, les composants suivants de Movable Type ncessitent une mise  jour ou une installation :',
	'The following Movable Type components require upgrading or installation:' => 'Les composants suivants de Movable Type ncessitent une mise  jour ou une installation :',
	'Begin Upgrade' => 'Commencer la mise  jour',
	'Congratulations, you have successfully upgraded to Movable Type [_1].' => 'Flicitations, vous avez mis  jour Movable Type  la version [_1].',
	'Your Movable Type installation is already up to date.' => 'Vous disposez de la dernire version de Movable Type.',

## tmpl/cms/edit_blog.tmpl
	'Your blog configuration has been saved.' => 'La configuration de votre blog a t sauvegarde.',
	'You must set your Blog Name.' => 'Vous devez configurer le nom du blog.',
	'You did not select a timezone.' => 'Vous n\'avez pas slectionn de fuseau horaire.',
	'You must set your Site URL.' => 'Vous devez configurer l\'URL de votre site.',
	'Your Site URL is not valid.' => 'L\'adresse URL de votre site n\'est pas valide.',
	'You can not have spaces in your Site URL.' => 'Vous ne pouvez pas avoir d\'espaces dans l\'adresse URL de votre site.',
	'You can not have spaces in your Local Site Path.' => 'Vous ne pouvez pas avoir d\'espaces dans le chemin local de votre site.',
	'Your Local Site Path is not valid.' => 'Le chemin local de votre site n\'est pas valide.',
	'Blog Details' => 'Dtails du Blog',
	'Name your blog. The blog name can be changed at any time.' => 'Nommez votre blog. Le nom du blog peut tre chang  n\'importe quel moment.',
	'Enter the URL of your public website. Do not include a filename (i.e. exclude index.html). Example: http://www.example.com/weblog/' => 'Saisir l\'URL de votre site web public. N\'incluez pas un nom de fichier (comme index.html). Exemple : http://www.exemple.com/blog/',
	'Enter the path where your main index file will be located. An absolute path (starting with \'/\') is preferred, but you can also use a path relative to the Movable Type directory. Example: /home/melody/public_html/weblog' => 'Saisissez le chemin o votre fichier d\'index principal sera situ. Un chemin absolu (qui commence par \'/\') est prfr, mais vous pouvez aussi utiliser un chemin relatif au rpertoire Movable Type. Exemple : /home/melody/public_html/blog',
	'Create Blog (s)' => 'Crer le Blog (s)',

## tmpl/cms/pinging.tmpl
	'Trackback' => 'Trackback',
	'Pinging sites...' => 'Envoi de ping(s)...',

## tmpl/cms/cfg_prefs.tmpl
	'Blog Settings' => 'Paramtres du blog',
	'Enter a description for your blog.' => 'Saisissez une description pour votre blog.',
	'License' => 'Licence',
	'Your blog is currently licensed under:' => 'Votre blog est actuellement sous licence :',
	'Change license' => 'Changer licence',
	'Remove license' => 'Retirer licence',
	'Your blog does not have an explicit Creative Commons license.' => 'Votre blog n\'a pas de licence Creative Commons explicite.',
	'Select a license' => 'Slectionner une licence',

## tmpl/cms/list_association.tmpl
	'permission' => 'Autorisation',
	'permissions' => 'Autorisations',
	'Remove selected permissions (x)' => 'Retirer les autorisations slectionnes (x)',
	'Revoke Permission' => 'Retirer l\'autorisation',
	'[_1] <em>[_2]</em> is currently disabled.' => '[_1] <em>[_2]</em> est actuellement dsactiv.',
	'Grant Permission' => 'Ajouter une autorisation',
	'You can not create permissions for disabled users.' => 'Vous ne pouvez pas crer d\'autorisations pour les utilisateurs dsactivs',
	'Assign Role to User' => 'Ajouter le rle  l\'utilisateur',
	'Grant permission to a user' => 'Ajouter une autorisation  un utilisateur',
	'You have successfully revoked the given permission(s).' => 'Vous avez rvoqu avec succs les autorisations slectionnes.',
	'You have successfully granted the given permission(s).' => 'Vous avez attribu avec succs les autorisations slectionnes.',
	'No permissions could be found.' => 'Aucune autorisation n\'a pu tre trouve.',

## tmpl/cms/preview_entry.tmpl
	'Preview [_1]' => 'Pr-visualiser [_1]',
	'Re-Edit this [_1]' => 'Modifier  nouveau cette [_1]',
	'Re-Edit this [_1] (e)' => 'Modifier  nouveau cette [_1] (e)',
	'Save this [_1]' => 'Enregistrer cette [_1]',
	'Save this [_1] (s)' => 'Enregistrer cette [_1] (s)',
	'Cancel (c)' => 'Annuler (c)',

## tmpl/cms/list_folder.tmpl
	'Your folder changes and additions have been made.' => 'Vos modifications du rpertoire ont bien t apportes.',
	'You have successfully deleted the selected folder.' => 'Vous avez supprim avec succs le rpertoire slectionn',
	'Delete selected folders (x)' => 'Supprimer les rpertoires slectionns (x)',
	'Create top level folder' => 'Crer un rpertoire de premier niveau',
	'New Parent [_1]' => 'Nouveau [_1] parent',
	'Create Folder' => 'Crer un Rpertoire',
	'Top Level' => 'Niveau racine',
	'Create Subfolder' => 'Crer un Sous-rpertoire',
	'Move Folder' => 'Dplacer un Rpertoire',
	'Move' => 'Dplacer',
	'[quant,_1,page,pages]' => '[quant,_1,page,pages]',
	'No folders could be found.' => 'Aucun dossier n\'a pu tre trouv.',

## tmpl/cms/cfg_entry.tmpl
	'Entry Settings' => 'Paramtres des notes',
	'Display Settings' => 'Prfrences d\'affichage',
	'Entry Listing Default' => 'Listage des notes par dfaut',
	'Select the number of days of entries or the exact number of entries you would like displayed on your blog.' => 'Slectionner le nombre de jours de notes ou le nombre exact de notes que vous voulez afficher sur votre blog.',
	'Days' => 'Jours',
	'Entry Order' => 'Ordre des notes',
	'Select whether you want your entries displayed in ascending (oldest at top) or descending (newest at top) order.' => 'Choisissez si vous voulez afficher vos notes en ascendant (les plus anciennes en haut) ou descendant (les plus rcentes en haut).',
	'Excerpt Length' => 'Longueur de l\'extrait',
	'Enter the number of words that should appear in an auto-generated excerpt.' => 'Entrez le nombre de mot  afficher pour les extraits de notes.',
	'Date Language' => 'Langue de la date',
	'Select the language in which you would like dates on your blog displayed.' => 'Slectionnez la langue dans laquelle vous souhaitez afficher les dates sur votre blog.',
	'Czech' => 'Tchque',
	'Danish' => 'Danois',
	'Dutch' => 'Nerlandais',
	'English' => 'Anglais',
	'Estonian' => 'Estonien',
	'French' => 'Franais',
	'German' => 'Allemand',
	'Icelandic' => 'Islandais',
	'Italian' => 'Italien',
	'Japanese' => 'Japonais',
	'Norwegian' => 'Norvgien',
	'Polish' => 'Polonais',
	'Portuguese' => 'Portugais',
	'Slovak' => 'Slovaque',
	'Slovenian' => 'Slovne',
	'Spanish' => 'Espagnol',
	'Suomi' => 'Finlandais',
	'Swedish' => 'Sudois',
	'Basename Length' => 'Longueur du nom de base',
	'Specifies the default length of an auto-generated basename. The range for this setting is 15 to 250.' => 'Spcifier la longueur par dfaut du nom de base. peut tre comprise entre 15 et 250.',
	'New Entry Defaults' => 'Prfrences pour les nouvelles notes',
	'Specifies the default Entry Status when creating a new entry.' => 'Spcifie le statut de note par dfaut quand une nouvelle note est cre.',
	'Specifies the default Text Formatting option when creating a new entry.' => 'Spcifie l\'option par dfaut de mise en forme du texte des nouvelles notes.',
	'Specifies the default Accept Comments setting when creating a new entry.' => 'Spcifie l\'option par dfaut des commentaires accepts lors de la cration d\'une nouvelle note.',
	'Note: This option is currently ignored since comments are disabled either blog or system-wide.' => 'Remarque : Cette option est actuellement ignore car les commentaires sont dsactivs sur le blog ou sur tout le systme.',
	'Specifies the default Accept TrackBacks setting when creating a new entry.' => 'Spcifie l\'option par dfaut des trackbacks accepts lors de la cration d\'une nouvelle note.',
	'Note: This option is currently ignored since TrackBacks are disabled either blog or system-wide.' => 'Remarque : Cette option est actuellement ignore car les trackbacks sont dsactivs soit sur le blog, soit au niveau de tout le systme.',
	'Replace Word Chars' => 'Remplacer les caractres de Word',
	'Smart Replace' => 'Remplacer par',
	'Replace UTF-8 characters frequently used by word processors with their more common web equivalents.' => 'Remplacer les caractres UTF-8 utiliss frquemment par l\'diteur de texte par leur quivalent web le plus commun.',
	'No substitution' => 'Ne pas effectuer de remplacements',
	'Character entities (&amp#8221;, &amp#8220;, etc.)' => 'Entits de caractres (&amp#8221;, &amp#8220;, etc.)',
	'ASCII equivalents (&quot;, \', ..., -, --)' => 'Equivalents ASCII (&quot;, \', ..., -, --)',
	'Replace Fields' => 'Appliquer le remplacement des caractres dans les champs',
	'Extended entry' => 'Suite de la note',
	'Default Editor Fields' => 'Champs d\'dition par dfaut',
	'Editor Fields' => 'Champs d\'dition',
	'_USAGE_ENTRYPREFS' => 'La configuration des champs dtermine les champs de saisie qui apparatront dans les crans de cration et de modification des notes. Vous pouvez slectionner une configuration existante (basique ou avance), ou personnaliser vos crans en activant le bouton Personnalise, puis en slectionnant les champs que vous souhaitez voir apparatre.',
	'Action Bars' => 'Barres de tches',
	'Select the location of the entry editor&rsquo;s action bar.' => 'Slectionner l\'emplacement de la barre d\'action de l\'diteur de note.',

## tmpl/cms/login.tmpl
	'Your Movable Type session has ended.' => 'Votre session Movable Type a t ferme.',
	'Your Movable Type session has ended. If you wish to sign in again, you can do so below.' => 'Votre session Movable Type est termine. Si vous souhaitez vous identifier  nouveau, vous pouvez le faire ci-dessous.',
	'Your Movable Type session has ended. Please sign in again to continue this action.' => 'Votre session Movable Type est termine. Merci de vous identifier  nouveau pour continuer cette action.',
	'Forgot your password?' => 'Vous avez oubli votre mot de passe ?',
	'Sign In (s)' => 'Connexion (s)',

## tmpl/cms/cfg_system_users.tmpl
	'System: User Settings' => 'Paramtres des utilisateurs',
	'(No blog selected)' => '(Aucun blog slectionn)',
	'You must set a valid Default Site URL.' => 'Vous devez dfinir une URL par dfaut valide pour le site.',
	'You must set a valid Default Site Root.' => 'Vous devez dfinir une URL par dfaut valide pour la Racine du Site.',
	'(None selected)' => '(Aucune slection)',
	'User Registration' => 'Enregistrement utilisateur',
	'Allow Registration' => 'Autoriser les enregistrements',
	'Select a system administrator you wish to notify when commenters successfully registered themselves.' => 'Slectionnez un administrateur que vous souhaitez notifier quand les auteurs de commentaires s\'enregistrent avec succs.',
	'Allow commenters to register to Movable Type' => 'Autoriser les auteurs de commentaires  s\'enregistrer dans Movable Type',
	'Notify the following administrators upon registration:' => 'Notifier les administrateurs suivants lors de l\'enregistrement:',
	'Select Administrators' => 'Slectionner les administrateurs',
	'Clear' => 'Clair',
	'Note: System Email Address is not set. Emails will not be sent.' => 'Note: l\'adresse Email Systme n\'est pas paramtre.  Les emails ne seront pas envoys.',
	'New User Defaults' => 'Paramtres par dfaut pour les nouveaux utilisateurs',
	'Personal blog' => 'Blog personnel',
	'Check to have the system automatically create a new personal blog when a user is created in the system. The user will be granted a blog administrator role on the blog.' => 'Vrifier  ce que le systme cr automatiquement un nouveau blog personnel lorsqu\'un utilisateur est cr. L\'utilisateur sera verra alors octroyer un rle d\'administrateur sur ce blog',
	'Automatically create a new blog for each new user' => 'Crer automatiquement un nouveau blog pour chaque nouvel utilisateur',
	'Personal blog clone source' => 'Source du blog personnel  dupliquer',
	'Select a blog you wish to use as the source for new personal blogs. The new blog will be identical to the source except for the name, publishing paths and permissions.' => 'Slectionner le blog que vous souhaitez utiliser comme source pour les nouveau blogs personnels. Le nouveau blog sera ainsi identique  la source, except le nom, les chemins de publication et les autorisations.',
	'Default Site URL' => 'URL par dfaut du site',
	'Define the default site URL for new blogs. This URL will be appended with a unique identifier for the blog.' => 'Spcifie l\'URL par dfaut pour les nouveaux blogs. Cette URL sera complte avec un identifiant unique pour le blog',
	'Default Site Root' => 'Racine du site par dfaut',
	'Define the default site root for new blogs. This path will be appended with a unique identifier for the blog.' => 'Spcifie le chemin de publication par dfaut pour les nouveaux blogs. Ce chemin sera complt avec un identifiant unique pour le blog',
	'Default User Language' => 'Langue par dfaut',
	'Define the default language to apply to all new users.' => 'Dfinir la langue par dfaut  appliquer  chaque nouvel utilisateur',
	'Default Timezone' => 'Fuseau horaire par dfaut',
	'Default Tag Delimiter' => 'Dlimiteur de tags par dfaut',
	'Define the default delimiter for entering tags.' => 'Dfinir un dlimiteur par dfaut pour la saisie des tags.',

## tmpl/cms/list_category.tmpl
	'Your category changes and additions have been made.' => 'Vos modifications de la catgorie ont bien t apportes.',
	'You have successfully deleted the selected category.' => 'Vous avez supprim avec succs la catgorie slectionne',
	'categories' => 'Catgories',
	'Delete selected category (x)' => 'Supprimer la catgorie slectionne (x)',
	'Create top level category' => 'Crer une catgorie de premier niveau',
	'Create Category' => 'Crer une Catgorie',
	'Collapse' => 'Rduire',
	'Expand' => 'Dvelopper',
	'Create Subcategory' => 'Crer une Sous-catgorie',
	'Move Category' => 'Dplacer une Catgorie',
	'[quant,_1,TrackBack,TrackBacks]' => '[quant,_1,trackback,trackbacks]',
	'No categories could be found.' => 'Aucune catgorie n\'a pu tre trouve.',

## tmpl/cms/recover_password_result.tmpl
	'Recover Passwords' => 'Retrouver les mots de passe',
	'No users were selected to process.' => 'Aucun utilisateur slectionn pour l\'opration.',
	'Return' => 'Retour',

## tmpl/cms/cfg_registration.tmpl
	'Registration Settings' => 'Paramtres des enregistrements',
	'Allow registration for Movable Type.' => 'Autoriser les enregistrements pour Movable Type.',
	'Registration Not Enabled' => 'Enregistrement non activ',
	'Note: Registration is currently disabled at the system level.' => 'Remarque : L\'enregistrement est actuellement dsactiv pour tout le systme.',
	'Authentication Methods' => 'Mthode d\'authentification',
	'Note: You have selected to accept comments from authenticated commenters only but authentication is not enabled. In order to receive authenticated comments, you must enable authentication.' => 'Attention: vous avez slectionn d\'accepter uniquement les commentaires de les auteurs de commentaires identifis MAIS l\'authentification n\'est pas active. Vous devez l\'activer pour recevoir les commentaire  autoriser.',
	'Native' => 'Natif',
	'Require E-mail Address for Comments via TypeKey' => 'Oblige  saisir l\'adresse email pour les commentaires avec TypeKey',
	'If enabled, visitors must allow their TypeKey account to share e-mail address when commenting.' => 'Si activ, les visiteurs doivent autoriser leur compte TypeKey  partager leur adresse email lorsqu\'ils commentent.',
	'Setup TypeKey' => 'Installation TypeKey',
	'OpenID providers disabled' => 'Fournisseurs OpenID dsactivs',
	'Required module (Digest::SHA1) for OpenID commenter authentication is missing.' => 'Le module obligatoire (Digest::SHA1) pour l\'authentification des auteurs de commentaires avec OpenID est absent.',

## tmpl/cms/import_others.tmpl
	'Start title HTML (optional)' => 'HTML de dbut de titre (optionnel)',
	'End title HTML (optional)' => 'HTML de fin du titre (optionnel)',
	'If the software you are importing from does not have title field, you can use this setting to identify a title inside the body of the entry.' => 'Si le logiciel  partir duquel vous importez n\'a pas de champ Titre, vous pouvez utiliser ce paramtre pour identifier un titre dans le corps de votre note.',
	'Default entry status (optional)' => 'Statut des notes par dfaut (optionnel)',
	'If the software you are importing from does not specify an entry status in its export file, you can set this as the status to use when importing entries.' => 'Si le logiciel  partir duquel vous importez ne spcifie pas un statut pour les notes dans son fichier d\'export, vous pouvez utiliser ce statut-ci lors de l\'importation des notes.',
	'Select an entry status' => 'Slectionner un statut de note',

## tmpl/cms/search_replace.tmpl
	'You must select one or more item to replace.' => 'Vous devez slectionner un ou plusieurs objets  remplacer.',
	'Search Again' => 'Chercher encore',
	'Submit search (s)' => 'Soumettre la recherche (s)',
	'Replace' => 'Remplacer',
	'Replace Checked' => 'Remplacer les objets slectionns',
	'Case Sensitive' => 'Sensible  la casse',
	'Regex Match' => 'Expression Rationnelle',
	'Limited Fields' => 'Champs limits',
	'Date Range' => 'Priode (date)',
	'Reported as Spam?' => 'Notifi comme spam ?',
	'Search Fields:' => 'Rechercher les champs :',
	'_DATE_FROM' => 'Depuis le',
	'_DATE_TO' => 'jusqu\'au',
	'Successfully replaced [quant,_1,record,records].' => 'Remplacements effectus avec succs dans [quant,_1,enregistrement,enregistrements].',
	'Showing first [_1] results.' => 'Afficher d\'abord [_1] rsultats.',
	'Show all matches' => 'Afficher tous les rsultats',
	'[quant,_1,result,results] found' => '[quant,_1,rsultat trouv,rsultats trouvs]',

## tmpl/cms/preview_strip.tmpl
	'Save this entry' => 'Enregistrer cette note',
	'Re-Edit this entry' => 'Modifier  nouveau cette note',
	'Re-Edit this entry (e)' => 'Modifier  nouveau cette note (e)',
	'Save this page' => 'Enregistrer cette page',
	'Re-Edit this page' => 'Modifier  nouveau cette page',
	'Re-Edit this page (e)' => 'Modifier  nouveau cette page (e)',
	'You are previewing the entry titled &ldquo;[_1]&rdquo;' => 'Vous prvisualisez la note suivante : &ldquo;[_1]&rdquo;',
	'You are previewing the page titled &ldquo;[_1]&rdquo;' => 'Vous prvisualisez la page suivante : &ldquo;[_1]&rdquo;',

## tmpl/cms/edit_ping.tmpl
	'Edit Trackback' => 'diter les  Trackbacks',
	'The TrackBack has been approved.' => 'Le trackback a t approuv.',
	'List &amp; Edit TrackBacks' => 'Lister &amp; diter les trackbacks',
	'Save changes to this TrackBack (s)' => 'Enregistrer les modifications de ce Trackback (s)',
	'Delete this TrackBack (x)' => 'Supprimer ce Trackback (x)',
	'Update the status of this TrackBack' => 'Modifier le statut de ce trackback',
	'Junk' => 'Indsirable',
	'View all TrackBacks with this status' => 'Voir tous les trackbacks avec ce statut',
	'Source Site' => 'Site source',
	'Search for other TrackBacks from this site' => 'Rechercher d\'autres trackbacks de ce site',
	'Source Title' => 'Titre de la source',
	'Search for other TrackBacks with this title' => 'Rechercher d\'autres trackbacks avec ce titre',
	'Search for other TrackBacks with this status' => 'Rechercher d\'autres trackbacks avec ce statut',
	'Target Entry' => 'Note cible',
	'Entry no longer exists' => 'Cette note n\'existe plus',
	'No title' => 'Sans titre',
	'View all TrackBacks on this entry' => 'Voir tous les trackbacks pour cette note',
	'Target Category' => 'Catgorie cible',
	'Category no longer exists' => 'La catgorie n\'existe plus',
	'View all TrackBacks on this category' => 'Afficher tous les trackbacks des cette catgorie',
	'View all TrackBacks created on this day' => 'Voir tous les trackbacks crs ce jour',
	'View all TrackBacks from this IP address' => 'Afficher tous les trackbacks avec cette adresse IP',
	'TrackBack Text' => 'Texte du trackback',
	'Excerpt of the TrackBack entry' => 'Extrait de la note du trackback',

## tmpl/comment/error.tmpl
	'Go Back (s)' => 'Retour (s)',

## tmpl/comment/register.tmpl
	'Create an account' => 'Crer un compte',
	'Your email address.' => 'Votre adresse email.',
	'Your login name.' => 'Votre nom d\'utilisateur.',
	'The name appears on your comment.' => 'Le nom apparat dans votre commentaire.',
	'Select a password for yourself.' => 'Slectionnez un mot de passe pour vous.',
	'This word or phrase will be required to recover the password if you forget it.' => 'Ce mot ou cette expression vous seront demands pour retrouver le mot de passe si vous l\'oubliez.',
	'The URL of your website. (Optional)' => 'URL de votre site internet (en option)',
	'Register' => 'S\'enregistrer',

## tmpl/comment/signup.tmpl

## tmpl/comment/login.tmpl
	'Sign in to comment' => 'Identifiez-vous pour commenter',
	'Sign in using' => 'S\'identifier en utilisant',
	'Remember me?' => 'Mmoriser les informations de connexion ?',
	'Not a member?&nbsp;&nbsp;<a href="[_1]">Sign Up</a>!' => 'Pas encore membre?&nbsp;&nbsp;<a href="[_1]">Enregistrez-vous</a>!',

## tmpl/comment/profile.tmpl
	'Your Profile' => 'Votre profil',
	'Password recovery' => 'Rcupration de mot de passe',
	'Return to the <a href="[_1]">original page</a>.' => 'Retourner sur la <a href="[_1]">page originale</a>.',

## tmpl/comment/signup_thanks.tmpl
	'Thanks for signing up' => 'Merci de vous tre enregistr(e)',
	'Before you can leave a comment you must first complete the registration process by confirming your account. An email has been sent to [_1].' => 'Avant de pouvoir dposer un commentaire vous devez terminer la prodcure d\'enregistrement en confirmant votre compte.  Un email a t envoy  l\'adresse suivante : [_1].',
	'To complete the registration process you must first confirm your account. An email has been sent to [_1].' => 'Pour terminer la procdure d\'enregistrement vous devez confirmer votre compte. Un email a t envoy  [_1].',
	'To confirm and activate your account please check your inbox and click on the link found in the email we just sent you.' => 'Pour confirmer et activer votre compte merci de vrifier votre boite email et de cliquer sur le lien que nous venons de vous envoyer.',
	'Return to the original entry.' => 'Retour  la note originale.',
	'Return to the original page.' => 'Retour  la page originale.',

## tmpl/feeds/feed_comment.tmpl
	'Unpublish' => 'D-publier',
	'More like this' => 'Plus du mme genre',
	'From this blog' => 'De ce blog',
	'On this entry' => 'Sur cette note',
	'By commenter identity' => 'Par identit de l\'auteur de commentaires',
	'By commenter name' => 'Par nom de l\'auteur de commentaires',
	'By commenter email' => 'Par l\'e-mail de l\'auteur de commentaires',
	'By commenter URL' => 'Par URL de l\'auteur de commentaires',
	'On this day' => 'Pendant cette journe',

## tmpl/feeds/feed_entry.tmpl
	'From this author' => 'De cet auteur',

## tmpl/feeds/feed_page.tmpl

## tmpl/feeds/login.tmpl
	'Movable Type Activity Log' => 'Journal (logs) de Movable Type',
	'This link is invalid. Please resubscribe to your activity feed.' => 'Ce lien n\'est pas valide. Merci de souscrire  nouveau  votre flux d\'activit.',

## tmpl/feeds/error.tmpl

## tmpl/feeds/feed_ping.tmpl
	'Source blog' => 'Blog source',
	'By source blog' => 'Par le blog source',
	'By source title' => 'Par le titre de la source',
	'By source URL' => 'Par l\'URL de la source',

## tmpl/error.tmpl
	'Missing Configuration File' => 'Fichier de configuration manquant',
	'_ERROR_CONFIG_FILE' => 'Votre fichier configuration Movable type est absent ou ne peut pas tre lu correctement. Merci de consulter la base de connaissances',
	'Database Connection Error' => 'Erreur de connexion  la base de donnes',
	'_ERROR_DATABASE_CONNECTION' => 'Les paramtres de votre base de donnes sont soit invalides, absents ou ne peuvent pas tre lus correctement. Consultez la base de connaissances pour plus d\'informations.',
	'CGI Path Configuration Required' => 'Configuration de chemin CGI requise',
	'_ERROR_CGI_PATH' => 'Votre configuration de chemin CGI est invalide ou absente de vos fichiers de configuration Movable Type. Merci de consulter la base de connaissance',

## addons/Community.pack/lib/MT/App/Community.pm
	'No login form template defined' => 'Aucun formulaire d\'identification de dfini',
	'Before you can sign in, you must authenticate your email address. <a href="[_1]">Click here</a> to resend the verification email.' => 'Avant de pouvoir vous identifier, vous devez confirmer votre adresse email. <a href="[_1]">Cliquez ici</a> pour envoyer  nouveau l\'email de vrification.',
	'Your confirmation have expired. Please register again.' => 'Votre confirmation a expir. Merci de vous inscrire  nouveau.',
	'User \'[_1]\' (ID:[_2]) has been successfully registered.' => 'L\'utilisateur \'[_1]\' (ID:[_2]) a t enregistr avec succs.',
	'Thanks for the confirmation.  Please sign in.' => 'Merci pour la confirmation. Identifiez-vous.',
	'Login required' => 'Authentification obligatoire',
	'System template entry_response not found in blog: [_1]' => 'Gabarit systme entry_response introuvable dans le blog: [_1]',
	'Posting a new entry failed.' => 'Echec de saisie d\'une nouvelle note.',
	'New entry \'[_1]\' added to the blog \'[_2]\'' => 'Nouvelle note \'[_1]\' ajoute sur le blog \'[_2]\'',
	'Id or Username is required' => 'Id ou identifiant obligatoire',
	'Unknown user' => 'Utilisateur inconnu',
	'Cannot edit profile.' => 'Impossible de modifier le profil.',
	'Recent Entries from [_1]' => 'Notes rcentes de [_1]',
	'Responses to Comments from [_1]' => 'Rponses aux commentaires de [_1]',
	'Actions from [_1]' => 'Actions de [_1]',

## addons/Community.pack/lib/MT/Community/Tags.pm
	'You used an \'[_1]\' tag outside of the block of MTIfEntryRecommended; perhaps you mistakenly placed it outside of an \'MTIfEntryRecommended\' container?' => 'Vous avez utilis un tag \'[_1]\' en dehors d\'un bloc de MTIfEntryRecommended; Peut-tre l\'avez-vous plac par erreur en dehors d\'un conteneur \'MTIfEntryRecommended\' ?',
	'Click here to recommend' => 'Cliquer ici pour recommander',
	'Click here to follow' => 'Cliquer ici pour suivre',
	'Click here to leave' => 'Cliquer ici pour quitter',

## addons/Community.pack/lib/MT/Community/CMS.pm
	'Users followed by [_1]' => 'Utilisateurs suivis par [_1]',
	'Users following [_1]' => 'Utilisateurs qui suivent [_1]',
	'Following' => 'Suit',
	'Followers' => 'Suiveurs',
	'Welcome to the Movable Type Community Solution' => 'Bienvenue dans Movable Type Community Solution',
	'The Community Solution gives you to the tools to build a successful community with active, engaged conversations. Some key features to explore:' => 'Le Community Solution vous offre les outils pour construire avec succs une communaut active avec des conversations engages. Certaines fonctionnalits principales  explorer:',
	'Friends and Followers' => 'Amis et Suiveurs',
	'Allow registered members to maintain a list of friends across your community' => 'Permettez aux membres enregistrs de maintenir une liste d\'amis dans votre communaut',

## addons/Community.pack/php/function.mtentryrecommendvotelink.php

## addons/Community.pack/tmpl/widget/blog_stats_registration.mtml
	'Registrations' => 'Inscriptions',
	'Recent Registrations' => 'Inscriptions rcentes',
	'default userpic' => 'Image de l\'utilisateur par dfaut',
	'You have [quant,_1,registration,registrations] from [_2]' => 'Vous avez [quant,_1,cration de compte,crations de compte] sur [_2]',

## addons/Community.pack/tmpl/widget/most_popular_entries.mtml
	'Most Popular Entries' => 'Notes les plus populaires',
	'There are no popular entries.' => 'Il n\'y a pas de notes populaires.',

## addons/Community.pack/tmpl/widget/recent_submissions.mtml
	'Recent Submissions' => 'Soumissions rcentes',

## addons/Community.pack/tmpl/widget/recently_scored.mtml
	'Recently Scored' => 'Not rcemment',
	'There are no recently favorited entries.' => 'Il n\'y a pas de notes favorites rcentes.',

## addons/Community.pack/tmpl/cfg_community_prefs.tmpl
	'Community Settings' => 'Rglages de la communaut',
	'Anonymous Recommendation' => 'Recommandation anonyme',
	'Check to allow anonymous users (users not logged in) to recommend discussion.  IP address is recorded and used to identify each user.' => 'Cocher pour autoriser les utilisateurs anonymes (non identifis)  recommander une discussion. L\'adresse IP est enregistre et utilise pour identifier chaque utilisateur.',
	'Allow anonymous user to recommend' => 'Autoriser un utilisateur anonyme  recommander',
	'Save changes to blog (s)' => 'Sauvegarder les modifications du blog (s)',

## addons/Community.pack/config.yaml
	'Following Users' => 'Utilisateurs suiveurs',
	'Being Followed' => 'tre suivi',
	'Login Form' => 'Formulaire d\'identification',
	'Password Reset Form' => 'Formulaire de rinitialisation du mot de passe',
	'Registration Form' => 'Formulaire d\'enregistrement',
	'Registration Confirmation' => 'Confirmation d\'enregistrement',
	'Profile Error' => 'Erreur de profil',
	'Profile View' => 'Vue du profil',
	'Profile Edit Form' => 'Formulaire de modification du profil',
	'Profile Feed' => 'Flux du profil',
	'Form Field' => 'Champ de formulaire',
	'Status Message' => 'Message de statut',
	'Simple Header' => 'Tte de page simple',
	'Simple Footer' => 'Pied de page simple',
	'Navigation' => 'Navigation',
	'Header' => 'Entte',
	'Footer' => 'Pied',
	'GlobalJavaScript' => 'GlobalJavaScript',
	'Email verification' => 'Vrification email',
	'Registration notification' => 'Notification enregistrement',
	'New entry notification' => 'Notification de nouvelle note',
	'Community Blog' => 'Blog de la communaut',
	'Atom ' => 'Atom',
	'Entry Response' => 'Rponse  la note',
	'Displays error, pending or confirmation message when submitting an entry.' => 'Afficher les erreurs et les messages de confirmation quand une note est crite.',
	'Comment Detail' => 'Dtail du Commentaire',
	'Entry Detail' => 'Dtails de la note',
	'Entry Metadata' => 'Metadonnes de la note',
	'Page Detail' => 'Dtails de la page',
	'Entry Form' => 'Formulaire de note',
	'Content Navigation' => 'Navigation du contenu',
	'Activity Widgets' => 'Widgets d\'activit',
	'Archive Widgets' => 'Widgets d\'archive',
	'Community Forum' => 'Forum de la communaut',
	'Entry Feed' => 'Flux de la note',
	'Displays error, pending or confirmation message when submitting a entry.' => 'Affiche les messages d\'erreur, de validation et de confirmation quand une nouvelle note est cre.',
	'Popular Entry' => 'Note populaire',
	'Entry Table' => 'Tableau de note',
	'Content Header' => 'Entte du contenu',
	'Category Groups' => 'Groupes de catgorie',
	'Default Widgets' => 'Widgets par dfaut',

## addons/Community.pack/templates/global/login_form.mtml

## addons/Community.pack/templates/global/signin.mtml
	'You are signed in as <a href="[_1]">[_2]</a>' => 'Vous tes identifi(e) comme tant <a href="[_1]">[_2]</a>',
	'You are signed in as [_1]' => 'Vous tes identifi(e) comme tant [_1]',
	'Edit profile' => 'Editer le profil',
	'Sign out' => 'dconnexion',
	'Not a member? <a href="[_1]">Register</a>' => 'Pas encore membre? <a href="[_1]">Enregistrez-vous</a>',

## addons/Community.pack/templates/global/register_form.mtml
	'Sign up' => 'Enregistrez-vous',

## addons/Community.pack/templates/global/simple_footer.mtml

## addons/Community.pack/templates/global/profile_error.mtml
	'ERROR MSG HERE' => 'MSG ERREUR ICI',

## addons/Community.pack/templates/global/password_reset_form.mtml
	'Reset Password' => 'Initialiser le mot de passe',
	'Back to the original page' => 'Retour  la page initiale',

## addons/Community.pack/templates/global/new_entry_email.mtml
	'A new entry \'[_1]([_2])\' has been posted on your blog [_3].' => 'Une nouvelle note \'[_1]([_2])\' a t poste sur votre blog [_3].',
	'Author name: [_1]' => 'Nom de l\'auteur: [_1]',
	'Author nickname: [_1]' => 'Surnom de l\'auteur: [_1]',
	'Title: [_1]' => 'Titre: [_1]',
	'Edit entry:' => 'Modifier la note:',

## addons/Community.pack/templates/global/profile_edit_form.mtml
	'Go <a href="[_1]">back to the previous page</a> or <a href="[_2]">view your profile</a>.' => 'Retourner   <a href="[_1]">la page prcdente</a> ou <a href="[_2]">voir votre profil</a>.',
	'Upload New Userpic' => 'Charger une nouvelle photo utilisateur',

## addons/Community.pack/templates/global/profile_feed.mtml
	'Posted [_1] to [_2]' => 'A post [_1] sur [_2]',
	'Commented on [_1] in [_2]' => 'A comment sur [_1] dans [_2]',
	'Voted on [_1] in [_2]' => 'A vot sur [_1] dans [_2]',
	'[_1] voted on <a href="[_2]">[_3]</a> in [_4]' => '[_1] a vot sur <a href="[_2]">[_3]</a> dans [_4]',

## addons/Community.pack/templates/global/header.mtml
	'Blog Description' => 'Description du blog',

## addons/Community.pack/templates/global/navigation.mtml
	'Home' => 'Accueil',

## addons/Community.pack/templates/global/footer.mtml

## addons/Community.pack/templates/global/search.mtml

## addons/Community.pack/templates/global/profile_view.mtml
	'User Profile' => 'Profil de l\'utilisateur',
	'Recent Actions from [_1]' => 'Actions rcentes de [_1]',
	'You are following [_1].' => 'Vous suivez [_1]',
	'Unfollow' => 'Ne plus suivre',
	'Follow' => 'Suivre',
	'You are followed by [_1].' => 'Vous tes suivi par [_1].',
	'You are not followed by [_1].' => 'Vous n\'tes pas suivi par [_1].',
	'Website:' => 'Site Web:',
	'Recent Actions' => 'Actions rcentes',
	'Comment Threads' => 'Fils de discussion',
	'Commented on [_1]' => 'A comment sur [_1]',
	'Favorited [_1] on [_2]' => 'A mis comme favori [_1] dans [_2]',
	'No recent actions.' => 'Plus d\'actions rcentes.',
	'[_1] commented on ' => '[_1] a comment sur',
	'No responses to comments.' => 'Pas de rponse aux commentaires.',
	'Not following anyone' => 'Ne suit personne',
	'Not being followed' => 'N\'est pas suivi',

## addons/Community.pack/templates/global/email_verification_email.mtml
	'Thank you registering for an account to [_1].' => 'Merci de crer un compte sur [_1].',
	'For your own security and to prevent fraud, we ask that you please confirm your account and email address before continuing. Once confirmed you will immediately be allowed to sign in to [_1].' => 'Pour votre propre scurit et pour prvenir la fraude, nous vous demandons de confirmer votre compte et adresse email avant de continuer. Une fois confirms vous serez immdiatement autoris  vous identifier sur [_1].',
	'If you did not make this request, or you don\'t want to register for an account to [_1], then no further action is required.' => 'Si vous n\'avez pas fait cette demande, ou que vous ne souhaitez pas crer un compte sur [_1], alors aucune action n\'est ncessaire.',

## addons/Community.pack/templates/global/register_confirmation.mtml
	'Authentication Email Sent' => 'Email d\'authentification envoy',
	'Profile Created' => 'Profil cr',
	'<a href="[_1]">Return to the original page.</a>' => '<a href="[_1]">Retourner  la page initiale</a>',

## addons/Community.pack/templates/global/login_form_module.mtml
	'Logged in as <a href="[_1]">[_2]</a>' => 'Identifi comme <a href="[_1]">[_2]</a>',
	'Hello [_1]' => 'Bonjour [_1]',
	'Forgot Password' => 'Mot de passe oubli?',

## addons/Community.pack/templates/global/javascript.mtml
	'Vote' => 'Vote',
	'Votes' => 'Votes',

## addons/Community.pack/templates/global/register_notification_email.mtml

## addons/Community.pack/templates/blog/main_index_widgets_group.mtml

## addons/Community.pack/templates/blog/category_archive_list.mtml

## addons/Community.pack/templates/blog/main_index.mtml

## addons/Community.pack/templates/blog/page.mtml

## addons/Community.pack/templates/blog/comment_response.mtml

## addons/Community.pack/templates/blog/entry_summary.mtml

## addons/Community.pack/templates/blog/content_nav.mtml
	'Blog Home' => 'Accueil du blog',

## addons/Community.pack/templates/blog/archive_widgets_group.mtml

## addons/Community.pack/templates/blog/entry_response.mtml
	'Thank you for posting an entry.' => 'Merci d\'avoir post votre message.',
	'Entry Pending' => 'Message en attente',
	'Your entry has been received and held for approval by the blog owner.' => 'Votre message a t reu et est en attente d\'approbation par le propritaire du blog.',
	'Entry Posted' => 'Message post',
	'Your entry has been posted.' => 'Votre message a bien t post.',
	'Your entry has been received.' => 'Votre message a t reu.',
	'Return to the <a href="[_1]">blog\'s main index</a>.' => 'Retour  la <a href="[_1]">page principale du blog</a>.',

## addons/Community.pack/templates/blog/entry_detail.mtml

## addons/Community.pack/templates/blog/comment_detail.mtml

## addons/Community.pack/templates/blog/entry_form.mtml
	'In order to create an entry on this blog you must first register.' => 'Avant de crer une note sur ce blog, vous devez vous enregistrer.',
	'You don\'t have permission to post.' => 'Vous n\'avez pas la permission de poster.',
	'Sign in to create an entry.' => 'Identifiez-vous pour crer une note.',
	'Select Category...' => 'Slectionner la catgorie...',

## addons/Community.pack/templates/blog/entry_create.mtml

## addons/Community.pack/templates/blog/syndication.mtml

## addons/Community.pack/templates/blog/recent_comments.mtml
	'<a href="[_1]">[_2] commented on [_3]</a>: [_4]' => '<a href="[_1]">[_2] a comment sur [_3]</a> : [_4]',

## addons/Community.pack/templates/blog/comment_form.mtml

## addons/Community.pack/templates/blog/current_category_monthly_archive_list.mtml

## addons/Community.pack/templates/blog/pages_list.mtml

## addons/Community.pack/templates/blog/monthly_archive_list.mtml

## addons/Community.pack/templates/blog/entry_listing.mtml
	'Recently by <em>[_1]</em>' => 'Rcemment par <em>[_1]</em>',

## addons/Community.pack/templates/blog/about_this_page.mtml

## addons/Community.pack/templates/blog/tags.mtml

## addons/Community.pack/templates/blog/entry_metadata.mtml

## addons/Community.pack/templates/blog/entry.mtml

## addons/Community.pack/templates/blog/javascript.mtml

## addons/Community.pack/templates/blog/archive_index.mtml

## addons/Community.pack/templates/blog/trackbacks.mtml

## addons/Community.pack/templates/blog/recent_entries.mtml

## addons/Community.pack/templates/blog/sidebar.mtml

## addons/Community.pack/templates/blog/openid.mtml

## addons/Community.pack/templates/blog/categories.mtml

## addons/Community.pack/templates/blog/comments.mtml

## addons/Community.pack/templates/blog/search_results.mtml

## addons/Community.pack/templates/blog/dynamic_error.mtml

## addons/Community.pack/templates/blog/powered_by.mtml

## addons/Community.pack/templates/blog/tag_cloud.mtml

## addons/Community.pack/templates/blog/recent_assets.mtml

## addons/Community.pack/templates/blog/comment_preview.mtml
	'Comment on [_1]' => 'Commentaire sur [_1]',

## addons/Community.pack/templates/blog/search.mtml

## addons/Community.pack/templates/forum/entry_summary.mtml

## addons/Community.pack/templates/forum/main_index.mtml
	'Forum Home' => 'Accueil du forum',

## addons/Community.pack/templates/forum/page.mtml

## addons/Community.pack/templates/forum/entry_response.mtml
	'Thank you for posting a new topic to the forums.' => 'Merci d\'avoir cr un nouveau sujet dans le forum.',
	'Topic Pending' => 'Sujet en attente',
	'The topic you posted has been received and held for approval by the forum administrators.' => 'Le sujet que vous avez cr a bien t reu et il est en attente de validation par les administrateurs du forum.',
	'Topic Posted' => 'Sujet post',
	'The topic you posted has been received and published. Thank you for your submission.' => 'Le sujet que vous avez cr a bien t reu et publi. Merci.',
	'Return to the <a href="[_1]">forum\'s homepage</a>.' => 'Retour  la <a href="[_1]">page d\'accueil du forum</a>.',

## addons/Community.pack/templates/forum/content_nav.mtml
	'Start Topic' => 'Dbuter un sujet',

## addons/Community.pack/templates/forum/comment_response.mtml
	'Reply Submitted' => 'Rponse envoye',
	'Your reply has been accepted.' => 'Votre rponse a t accepte.',
	'Thank you for replying.' => 'Merci pour votre rponse.',
	'Your reply has been received and held for approval by the forum administrator.' => 'Votre rponse a bien t reue et est en attente d\'approbation par un administrateur du forum.',
	'Reply Submission Error' => 'Erreur lors de l\'envoi de la rponse',
	'Your reply submission failed for the following reasons: [_1]' => 'L\'envoi de la rponse a chou pour les raisons suivantes : [_1]',
	'Return to the <a href="[_1]">original topic</a>.' => 'Retour au <a href="[_1]">sujet d\'origine</a>.',

## addons/Community.pack/templates/forum/content_header.mtml

## addons/Community.pack/templates/forum/entry_detail.mtml

## addons/Community.pack/templates/forum/comment_detail.mtml
	'[_1] replied to <a href="[_2]">[_3]</a>' => '[_1] a rpondu  <a href="[_2]">[_3]</a>',

## addons/Community.pack/templates/forum/entry_create.mtml
	'Start a Topic' => 'Crer un nouveau sujet',

## addons/Community.pack/templates/forum/entry_form.mtml
	'Topic' => 'Sujet',
	'Select Forum...' => 'Slectionner un forum...',
	'Forum' => 'Forum',

## addons/Community.pack/templates/forum/syndication.mtml
	'All Forums' => 'Tous les forums',
	'[_1] Forum' => 'Forum [_1]',

## addons/Community.pack/templates/forum/comment_form.mtml
	'Add a Reply' => 'Ajouter une Rponse',

## addons/Community.pack/templates/forum/entry_listing.mtml

## addons/Community.pack/templates/forum/entry_metadata.mtml
	'1 Reply' => '1 Rponse',
	'# Replies' => '# Rponses',

## addons/Community.pack/templates/forum/entry.mtml

## addons/Community.pack/templates/forum/javascript.mtml
	'Thanks for signing in,' => 'Merci de vous tre identifi,',
	'. Now you can reply to this topic.' => '. Maintenant vous pouvez rpondre  ce sujet.',
	'You do not have permission to comment on this blog.' => 'Vous n\'avez pas la permission de commenter sur ce blog.',
	' to reply to this topic.' => ' pour rpondre  ce sujet.',
	' to reply to this topic,' => ' pour rpondre  ce sujet,',
	'or ' => 'ou ',
	'reply anonymously.' => 'rpondre anonymement.',

## addons/Community.pack/templates/forum/entry_table.mtml
	'Recent Topics' => 'Sujets rcents',
	'Replies' => 'Rponses',
	'Last Reply' => 'Dernire rponse',
	'Permalink to this Reply' => 'Lien permanent vers cette rponse',
	'By [_1]' => 'Par [_1]',
	'Closed' => 'Ferm',
	'Post the first topic in this forum.' => 'Crez le premier sujet de ce forum.',

## addons/Community.pack/templates/forum/archive_index.mtml

## addons/Community.pack/templates/forum/sidebar.mtml

## addons/Community.pack/templates/forum/category_groups.mtml
	'Forum Groups' => 'Groupes de forums',
	'Last Topic: [_1] by [_2] on [_3]' => 'Dernier sujet: [_1] par [_2] sur [_3]',
	'Be the first to <a href="[_1]">post a topic in this forum</a>' => 'Soyez le premier  <a href="[_1]">crer un sujet dans ce forum</a>',

## addons/Community.pack/templates/forum/openid.mtml

## addons/Community.pack/templates/forum/comments.mtml
	'No Replies' => 'Pas de Rponses',

## addons/Community.pack/templates/forum/search_results.mtml
	'Topics matching &ldquo;[_1]&rdquo;' => 'Sujets correspondants  &ldquo;[_1]&rdquo;',
	'Topics tagged &ldquo;[_1]&rdquo;' => 'Sujets taggus &ldquo;[_1]&rdquo;',
	'Topics' => 'Sujets',

## addons/Community.pack/templates/forum/dynamic_error.mtml

## addons/Community.pack/templates/forum/entry_popular.mtml
	'Popular topics' => 'Sujets populaires',

## addons/Community.pack/templates/forum/comment_preview.mtml
	'Reply to [_1]' => 'Rpondre  [_1]',
	'Previewing your Reply' => 'Prvisualiser votre rponse',

## addons/Commercial.pack/lib/MT/Commercial/Util.pm
	'About' => 'A propos de',
	'_PTS_REPLACE_THIS' => '<p><strong>Remplacez ce texte d\'exemple par vos propres informations.</strong></p>',
	'_PTS_SAMPLE_ABOUT' => '
<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. In nec tellus sed turpis varius sagittis. Nullam pulvinar. Fusce dapibus neque pellentesque nulla. Maecenas condimentum quam. Vestibulum pretium fringilla quam. Nam elementum. Suspendisse odio magna, aliquam vitae, vulputate et, dignissim at, pede. Integer pellentesque orci at nibh. Morbi ante.</p>

<p>Maecenas convallis mattis justo. Ut mauris sapien, consequat a, bibendum vitae, sagittis ac, nisi. Nulla et sapien. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos. Ut condimentum turpis ut elit. Quisque ultricies sollicitudin justo. Duis vitae magna nec risus pulvinar ultricies.</p>
',
	'_PTS_EDIT_LINK' => '
<!-- retirer ce lien aprs l\'dition -->
<p class="admin-edit-link">
<a href="#" onclick="location.href=adminurl + \'?__mode=view&_type=page&id=\' + page_id + \'&blog_id=\' + blog_id; return false">diter ce contenu</a>
</p>
',
	'_PTS_CONTACT' => 'Contacter',
	'_PTS_SAMPLE_CONTACT' => '
<p>Nous adorerions avoir de vos nouvelles. Envoyez un email  email (at) nomdedomaine.com</p>
',
	'Welcome to our new website!' => 'Bienvenue sur notre nouveau site !',
	'_PTS_SAMPLE_WELCOME' => '
<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. In nec tellus sed turpis varius sagittis. Nullam pulvinar. Fusce dapibus neque pellentesque nulla. Maecenas condimentum quam. Aliquam erat volutpat. Ut placerat porta nibh. Donec vitae nulla. Pellentesque nisi leo, pretium a, gravida quis, sollicitudin non, eros. Vestibulum pretium fringilla quam. Nam elementum. Suspendisse odio magna, aliquam vitae, vulputate et, dignissim at, pede. Integer pellentesque orci at nibh. Morbi ante.</p>

<p>Maecenas convallis mattis justo. Ut mauris sapien, consequat a, bibendum vitae, sagittis ac, nisi. Nulla et sapien. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos. Ut condimentum turpis ut elit. Quisque ultricies sollicitudin justo. Duis vitae magna nec risus pulvinar ultricies. Aliquam sagittis volutpat metus.</p>

<p>Sed enim. Integer hendrerit, arcu ac pretium nonummy, velit turpis faucibus risus, pulvinar egestas enim elit sed ante. Curabitur orci diam, placerat a, faucibus id, condimentum vitae, magna. Etiam enim massa, convallis quis, rutrum vitae, porta quis, turpis.</p>
',
	'New design launched using Movable Type' => 'Nouveau design lanc en utilisant Movable Type',
	'_PTS_SAMPLE_NEWDESIGN' => '
<p>Notre nouveau site internet est habill d\'un nouvel habillage grce  <a href="http://www.movabletype.com/">Movable Type</a> et les Groupes d\'Habillages Universels. Les Groupes d\'Habillages Universels rendent facile et accessible  n\'importe qui la mise en place et l\'animation d\'un site internet utilisant Movable Type. Et cela ne vous prendra que quelques instants#160;! Slectionnez-en un simplement pour votre nouveau site web et publiez. Voil#160;! Merci Movable Type#160;!</p> 
',
	'John Doe' => 'John Doe',
	'Great new site. I can\'t wait to try Movable Type. Congrats!' => 'Super nouveau site. Je suis impatient d\'essayer Movable Type. Flicitations !',

## addons/Commercial.pack/lib/CustomFields/App/CMS.pm
	'Show' => 'Afficher',
	'Date & Time' => 'Date & heure',
	'Date Only' => 'Date seulement',
	'Time Only' => 'Heure seulement',
	'Please enter all allowable options for this field as a comma delimited list' => 'Merci de saisir toutes les options autorises pour ce champ dans une liste dlimite par des virgules',
	'Custom Fields' => 'Champs personnaliss',
	'[_1] Fields' => '[_1] champs',
	'Edit Field' => 'Modifier le champ',
	'Invalid date \'[_1]\'; dates must be in the format YYYY-MM-DD HH:MM:SS.' => 'Date invalide \'[_1]\'; les dates doivent tre dans le format YYYY-MM-DD HH:MM:SS.',
	'Invalid date \'[_1]\'; dates should be real dates.' => 'Date invalide \'[_1]\'; les dates doivent tre de vraies dates.',
	'Please enter valid URL for the URL field: [_1]' => 'Merci de saisir une URL correcte pour le champ URL : [_1]',
	'Please enter some value for required \'[_1]\' field.' => 'Merci de saisir une valeur pour le champ obligatoire \'[_1]\'.',
	'Please ensure all required fields have been filled in.' => 'Merci de vrifier que tous les champs obligatoires ont t remplis.',
	'The template tag \'[_1]\' is an invalid tag name.' => 'Le tag de gabarit \'[_1]\' est un nom de tag invalide',
	'The template tag \'[_1]\' is already in use.' => 'Le tag de gabarit \'[_1]\' est dj utilis.',
	'The basename \'[_1]\' is already in use.' => 'Le nom de base \'[_1]\' est dj utilis.',
	'Customize the forms and fields for entries, pages, folders, categories, and users, storing exactly the information you need.' => 'Personnalisez les champs des notes, pages, rpertoires, catgories et auteurs pour stocker toutes les informations dont vous avez besoin.',
	' ' => ' ',
	'Single-Line Text' => 'Texte sur une ligne',
	'Multi-Line Text' => 'Texte multi-lignes',
	'Checkbox' => 'Case  cocher',
	'Date and Time' => 'Date et heure',
	'Drop Down Menu' => 'Menu droulant',
	'Radio Buttons' => 'Boutons radio',

## addons/Commercial.pack/lib/CustomFields/BackupRestore.pm
	'Restoring custom fields data stored in MT::PluginData...' => 'Restauration des donnes des champs personnaliss stockes dans MT:PluginData...',
	'Restoring asset associations found in custom fields ( [_1] ) ...' => 'Restauration des associations d\'lments trouvs dans les champs personnaliss ([_1]) ...',
	'Restoring url of the assets associated in custom fields ( [_1] )...' => 'Restauration des URLs des lments associs dans les champs personnaliss ([_1]) ...',

## addons/Commercial.pack/lib/CustomFields/Upgrade.pm
	'Moving metadata storage for pages...' => 'Dplacement de l\'emplacement des mtadonnes des pages en cours ...',

## addons/Commercial.pack/lib/CustomFields/Template/ContextHandlers.pm
	'Are you sure you have used a \'[_1]\' tag in the correct context? We could not find the [_2]' => 'Etes-vous sr d\'avoir utilis un tag \'[_1]\' dans le contexte appropri ? Impossible de trouver le [_2]',
	'You used an \'[_1]\' tag outside of the context of the correct content; ' => 'Vous avez utilis un tag \'[_1]\' en dehors du contexte du contenu correct; ',

## addons/Commercial.pack/lib/CustomFields/Util.pm
	'Failed to find [_1]::[_2]' => 'Impossible de trouver [_1]::[_2]',

## addons/Commercial.pack/lib/CustomFields/Field.pm
	'Field' => 'Champ',

## addons/Commercial.pack/config.yaml
	'Professional Website' => 'Sites web professionnels', # Translate - New
	'Themes that are compatible with the Professional Website template set.' => 'Thmes compatibles avec le jeu de gabarits Sites web professionnels', # Translate - New
	'Blog Index' => 'Index du Blog',
	'Blog Entry Listing' => 'Liste des Notes du Blog',
	'Header' => 'Entte',
	'Footer' => 'Pied',
	'Navigation' => 'Navigation',
	'Comment Detail' => 'Dtail du Commentaire',
	'Entry Detail' => 'Dtails de la note',
	'Entry Metadata' => 'Metadonnes de la note',
	'Page Detail' => 'Dtails de la page',
	'Powered By (Footer)' => 'Powered By (Pied de Page)',
	'Recent Entries Expanded' => 'Entres tendues rcentes',
	'Footer Links' => 'Liens de Pied de Page',
	'Blog Activity' => 'Activit du blog',
	'Blog Archives' => 'Archives du blog',
	'Main Sidebar' => 'Colonne latrale principale',

## addons/Commercial.pack/tmpl/reorder_fields.tmpl
	'Your field order has been saved. Please refresh this page to see the new order.' => 'L\'ordre des champs a t sauvegard. Merci de recharger cette page pour voir le nouvel ordre.',
	'Reorder Fields' => 'Rordonner les champs',
	'Save field order' => 'Enregistrer l\'ordre des champs',
	'Close field order widget' => 'Fermer le module de changement d\'ordre des champs',
	'open' => 'ouvrir',
	'click-down and drag to move this field' => 'gardez le clic maintenu et glissez le curseur pour dplacer ce champs',
	'click to %toggle% this box' => 'cliquez pour %toggle% cette bote',
	'use the arrow keys to move this box' => 'utilisez les touches flches de votre clavier pour dplacer cette bote',
	', or press the enter key to %toggle% it' => ', ou pressez la touche entre pour la %toggle%',

## addons/Commercial.pack/tmpl/date-picker.tmpl
	'Select date' => 'Slectionner la date',

## addons/Commercial.pack/tmpl/edit_field.tmpl
	'New Field' => 'Nouveau champ',
	'The selected fields(s) has been deleted from the database.' => 'Les champs slectionns ont t effacs de la base de donnes.',
	'Please ensure all required fields (highlighted) have been filled in.' => 'Merci de vrifier que tous les champs obligatoires ont t remplis.',
	'System Object' => 'Objet systme',
	'Select the system object this field is for' => 'Slectionner l\'objet systme auquel ce champ est rattach',
	'Select...' => 'Slectionnez...',
	'Required?' => 'Obligatoire?',
	'Should a value be chosen or entered into this field?' => 'Une valeur doit-elle tre choisie ou saisie dans ce champ?',
	'Default' => 'Dfaut',
	'You will need to first save this field in order to set a default value' => 'Vous devez d\'abord enregistrer ce champ pour pouvoir mettre une valeur par dfaut',
	'_CF_BASENAME' => 'Nom de base',
	'The basename is used for entering custom field data through a 3rd party client. It must be unique.' => 'Le nom de base est utilis pour entrer les donnes d\'un champs personnalis  travers un logiciel tiers. Il doit tre unique. ',
	'Unlock this for editing' => 'Dverrouiller pour modifier',
	'Warning: Changing this field\'s basename may require changes to existing templates.' => 'Attention : le changement de ce nom de base peut ncessiter des changements additionnels dans vos gabarits existants.',
	'Template Tag' => 'Tag du gabarit',
	'Create a custom template tag for this field.' => 'Crer un tag de gabarit personnalis pour ce champ.',
	'Example Template Code' => 'Code de gabarit exemple',
	'Save this field (s)' => 'Enregistrer ce champs (s)',
	'field' => 'champ',
	'fields' => 'Champs',
	'Delete this field (x)' => 'Supprimer ce champs (x)',

## addons/Commercial.pack/tmpl/asset-chooser.tmpl
	'Choose [_1]' => 'Choisir [_1]',
	'Remove [_1]' => 'Supprimer [_1]',

## addons/Commercial.pack/tmpl/list_field.tmpl
	'New [_1] Field' => 'Nouveau champ [_1]',
	'Delete selected fields (x)' => 'Effacer les champs slectionns (x)',
	'No fields could be found.' => 'Aucun champ n\'a t trouv.',
	'System-Wide' => 'sur tout le systme',

## addons/Commercial.pack/templates/professional/comment_response.mtml

## addons/Commercial.pack/templates/professional/notify-entry.mtml

## addons/Commercial.pack/templates/professional/blog_index.mtml

## addons/Commercial.pack/templates/professional/category_archive_list.mtml

## addons/Commercial.pack/templates/professional/main_index.mtml

## addons/Commercial.pack/templates/professional/page.mtml

## addons/Commercial.pack/templates/professional/entry_summary.mtml

## addons/Commercial.pack/templates/professional/recent_entries_expanded.mtml
	'By [_1] | Comments ([_2])' => 'Par [_1] | Commentaires ([_1])',

## addons/Commercial.pack/templates/professional/commenter_notify.mtml

## addons/Commercial.pack/templates/professional/verify-subscribe.mtml

## addons/Commercial.pack/templates/professional/footer-email.mtml

## addons/Commercial.pack/templates/professional/entry_detail.mtml

## addons/Commercial.pack/templates/professional/comment_detail.mtml

## addons/Commercial.pack/templates/professional/new-ping.mtml

## addons/Commercial.pack/templates/professional/comment_throttle.mtml

## addons/Commercial.pack/templates/professional/comment_form.mtml

## addons/Commercial.pack/templates/professional/recent_comments.mtml
	'<a href="[_1]">[_2] commented on [_3]</a>: [_4]' => '<a href="[_1]">[_2] a comment sur [_3]</a> : [_4]',

## addons/Commercial.pack/templates/professional/monthly_archive_list.mtml

## addons/Commercial.pack/templates/professional/signin.mtml

## addons/Commercial.pack/templates/professional/new-comment.mtml

## addons/Commercial.pack/templates/professional/entry_listing.mtml
	'Recently by <em>[_1]</em>' => 'Rcemment par <em>[_1]</em>',

## addons/Commercial.pack/templates/professional/footer.mtml

## addons/Commercial.pack/templates/professional/tags.mtml

## addons/Commercial.pack/templates/professional/navigation.mtml
	'Home' => 'Accueil',

## addons/Commercial.pack/templates/professional/entry_metadata.mtml

## addons/Commercial.pack/templates/professional/entry.mtml

## addons/Commercial.pack/templates/professional/recover-password.mtml

## addons/Commercial.pack/templates/professional/javascript.mtml

## addons/Commercial.pack/templates/professional/archive_index.mtml

## addons/Commercial.pack/templates/professional/trackbacks.mtml

## addons/Commercial.pack/templates/professional/sidebar.mtml

## addons/Commercial.pack/templates/professional/powered_by_footer.mtml

## addons/Commercial.pack/templates/professional/openid.mtml

## addons/Commercial.pack/templates/professional/categories.mtml

## addons/Commercial.pack/templates/professional/comments.mtml

## addons/Commercial.pack/templates/professional/search_results.mtml

## addons/Commercial.pack/templates/professional/header.mtml

## addons/Commercial.pack/templates/professional/dynamic_error.mtml

## addons/Commercial.pack/templates/professional/footer_links.mtml
	'Links' => 'Liens',

## addons/Commercial.pack/templates/professional/tag_cloud.mtml

## addons/Commercial.pack/templates/professional/recent_assets.mtml

## addons/Commercial.pack/templates/professional/comment_preview.mtml

## addons/Commercial.pack/templates/professional/search.mtml

## addons/Commercial.pack/templates/professional/commenter_confirm.mtml

## addons/Enterprise.pack/lib/MT/Enterprise/CMS.pm
	'Add [_1] to a blog' => 'Ajouter [_1]  un blog',
	'You can not create associations for disabled groups.' => 'Vous ne pouvez pas crer d\'association pour les groupes dsactivs.',
	'Assign Role to Group' => 'Ajouter le rle au groupe',
	'Add a group to this blog' => 'Ajouter un groupe  ce blog',
	'Grant permission to a group' => 'Ajouter une autorisation  un groupe',
	'Movable Type Enterprise has just attempted to disable your account during synchronization with the external directory. Some of the external user management settings must be wrong. Please correct your configuration before proceeding.' => 'Movable Type Enterprise vient de tenter de dsactiver votre compte pendant la synchronisation avec l\'annuaire externe. Certains des paramtres du systme de gestion externe des utilisateurs doivent tre errons. Merci de corriger avant de poursuivre.',
	'Group requires name' => 'Le groupe ncessite un nom.',
	'Invalid group' => 'Groupe invalide.',
	'Add Users to Group [_1]' => 'Ajouter les utilisateurs au groupe [_1]',
	'Users & Groups' => 'Utilisateurs et Groupes',
	'Group Members' => 'Membres du groupe',
	'Groups' => 'Groupes',
	'User Groups' => 'Groupes de l\'utilisateur',
	'Group load failed: [_1]' => 'Chargement du groupe chou: [_1]',
	'User load failed: [_1]' => 'Chargement de l\'utilisateur chou: [_1]',
	'User \'[_1]\' (ID:[_2]) removed from group \'[_3]\' (ID:[_4]) by \'[_5]\'' => 'Utilisateur \'[_1]\' (ID:[_2]) supprim du groupe \'[_3]\' (ID:[_4]) par \'[_5]\'',
	'User \'[_1]\' (ID:[_2]) was added to group \'[_3]\' (ID:[_4]) by \'[_5]\'' => 'Utilisateur \'[_1]\' (ID:[_2]) a t ajout au groupe \'[_3]\' (ID:[_4]) par \'[_5]\'',
	'Group Profile' => 'Profil du Groupe',
	'Author load failed: [_1]' => 'Chargement de l\'auteur chou: [_1]',
	'Invalid user' => 'Utilisateur invalide',
	'Assign User [_1] to Groups' => 'Assigner l\'utilisateur [_1] aux groupes.',
	'Select Groups' => 'Slectionner les groupes',
	'Group' => 'Groupe',
	'Groups Selected' => 'Groupes slectionns',
	'Type a group name to filter the choices below.' => 'Tapez un nom de groupe pour filtrer les choix ci-dessous.',
	'Group Name' => 'Nom du groupe',
	'Search Groups' => 'Rechercher des groupes',
	'Bulk import cannot be used under external user management.' => 'L\'import en masse ne peut tre utilis avec la gestion externe des utilisateurs.',
	'Bulk management' => 'Gestion en masse',
	'No record found in the file.  Make sure the file uses CRLF as the line ending character.' => 'Aucune entre n\'a t trouve dans le fichier. Assurez-vous que le fichier utilise CRLF comme caractre de fin de ligne.',
	'Registered [quant,_1,user,users], updated [quant,_2,user,users], deleted [quant,_3,user,users].' => 'Cration de [quant,_1,utilisateur,utilisateurs], modification de [quant,_2, utilisateur, utilisateurs], suppression de [quant,_3, utilisateur, utilisateurs.',
	'The group' => 'Le groupe',
	'User/Group' => 'Utilisateur/Groupe',
	'A user can\'t change his/her own username in this environment.' => 'Un utilisateur ne peut pas changer son nom d\'utilisateur dans cet environnement',
	'An error occurred when enabling this user.' => 'Une erreur s\'est produite pendant l\'activation de cet utilisateur.',

## addons/Enterprise.pack/lib/MT/Enterprise/Upgrade.pm
	'Fixing binary data for Microsoft SQL Server storage...' => 'Correction des donnes binaires pour le stockage Microsoft SQL Server...',

## addons/Enterprise.pack/lib/MT/Enterprise/BulkCreation.pm
	'Format error at line [_1]: [_2]' => 'Erreur de format  la ligne [_1]: [_2]',
	'Invalid command: [_1]' => 'Commande invalide: [_1]',
	'Invalid number of columns for [_1]' => 'Nombre de colonnes invalide pour [_1]',
	'Invalid user name: [_1]' => 'Identifiant invalide: [_1]',
	'Invalid display name: [_1]' => 'Nom d\'affichage invalide: [_1]',
	'Invalid email address: [_1]' => 'Adresse email invalide: [_1]',
	'Invalid language: [_1]' => 'Langue invalide: [_1]',
	'Invalid password: [_1]' => 'Mot de passe invalide: [_1]',
	'Invalid password recovery phrase: [_1]' => 'Phrase de rcupration de mot de passe invalide: [_1]',
	'Invalid weblog name: [_1]' => 'Nom de weblog invalide: [_1]',
	'Invalid weblog description: [_1]' => 'Description de weblog invalide: [_1]',
	'Invalid site url: [_1]' => 'URL du site invalide: [_1]',
	'Invalid site root: [_1]' => 'Racine du site invalide: [_1]',
	'Invalid timezone: [_1]' => 'Fuseau horaire invalide: [_1]',
	'Invalid new user name: [_1]' => 'Nouvel identifiant invalide: [_1]',
	'A user with the same name was found.  Register was not processed: [_1]' => 'Un utilisateur avec le mme nom a t trouv. L\'enregistrement n\'a pas t effectu: [_1]',
	'Blog for user \'[_1]\' can not be created.' => 'Le blog pour l\'utilisateur \'[_1]\' ne peut tre cr.',
	'Blog \'[_1]\' for user \'[_2]\' has been created.' => 'Le blog \'[_1]\' pour l\'utilisateur \'[_2]\' a t cr.',
	'Error assigning weblog administration rights to user \'[_1] (ID: [_2])\' for weblog \'[_3] (ID: [_4])\'. No suitable weblog administrator role was found.' => 'Erreur en tentant d\'assigner les droits d\'administration du blog  l\'utilisateur \'[_1] (ID: [_2])\' pour le weblog \'[_3] (ID: [_4])\'. Aucun rle d\'administrateur de weblog adquat n\'a t trouv.',
	'Permission granted to user \'[_1]\'' => 'Permission accorde  l\'utilisateur \'[_1]\'',
	'User \'[_1]\' already exists. Update was not processed: [_2]' => 'L\'utilisateur \'[_1]\' existe dj. La mise a jour n\'a pas eu lieu: [_2]',
	'User cannot be updated: [_1].' => 'Utilisateur ne peut tre mis  jour: [_1].',
	'User \'[_1]\' not found.  Update was not processed.' => 'L\'utilisateur \'[_1]\' n\'a pas t trouv. La mise  jour n\'a pas eu lieu.',
	'User \'[_1]\' has been updated.' => 'L\'utilisateur \'[_1]\' a t mis  jour.',
	'User \'[_1]\' was found, but delete was not processed' => 'L\'utilisateur \'[_1]\' a t trouv, mais la suppression n\'a pas eu lieu.',
	'User \'[_1]\' not found.  Delete was not processed.' => 'L\'utilisateur \'[_1]\' n\'a pas t trouv. La suppression n\'a pas eu lieu.',
	'User \'[_1]\' has been deleted.' => 'L\'utilisateur \'[_1]\' a t supprim.',

## addons/Enterprise.pack/lib/MT/Enterprise/Wizard.pm
	'PLAIN' => 'PLAIN',
	'CRAM-MD5' => 'CRAM-MD5',
	'Digest-MD5' => 'Digest-MD5',
	'Login' => 'Identifiant',
	'Found' => 'Trouv',
	'Not Found' => 'Non trouv',

## addons/Enterprise.pack/lib/MT/Auth/LDAP.pm
	'User [_1]([_2]) not found.' => 'Utilisateur [_1]([_2]) non trouv.',
	'User \'[_1]\' cannot be updated.' => 'Utilisateur \'[_1]\' ne peut tre mis  jour.',
	'User \'[_1]\' updated with LDAP login ID.' => 'Utilisateur \'[_1]\' mis  jour avec l\'ID de login LDAP.',
	'LDAP user [_1] not found.' => 'Utilisateur LDAP [_1] non trouv.',
	'User [_1] cannot be updated.' => 'Utilisateur [_1] ne peut tre mis  jour.',
	'Failed login attempt by user \'[_1]\' deleted from LDAP.' => 'Tentative de login choue par utilisateur \'[_1]\' supprim de LDAP.',
	'User \'[_1]\' updated with LDAP login name \'[_2]\'.' => 'Utilisateur \'[_1]\' mis  jour avec l\'identifiant LDAP \'[_2]\'.',
	"Failed login attempt by user \'[_1]\'. A user with that\nusername already exists in the system with a different UUID." => "Echec de la connexion pour l\'utilisateur\'[_1]\'. Un utilisateur avec cet
identifiant existe mais avec un UUID diffrent.",
	'User \'[_1]\' account is disabled.' => 'Le compte de l\'utilisateur \'[_1]\' est dsactiv.',
	'LDAP users synchronization interrupted.' => 'Synchronisation des utilisateurs LDAP interrompue.',
	'Loading MT::LDAP failed: [_1]' => 'Chargement de MT::LDAP chou: [_1]',
	'External user synchronization failed.' => 'Synchronisation utilisateur externe choue.',
	'An attempt to disable all system administrators in the system was made.  Synchronization of users was interrupted.' => 'Une tentative de dsactivation de tous les administrateurs systme a t ralise. La synchronisation des utilisateurs a t interrompue.',
	'The following users\' information were modified:' => 'Les informations suivantes des utilisateurs ont t modifies:',
	'The following users were disabled:' => 'Les utilisateurs suivants ont t dsactivs:',
	'LDAP users synchronized.' => 'Utilisateurs LDAP synchroniss.',
	'Synchronization of groups can not be performed without LDAPGroupIdAttribute and/or LDAPGroupNameAttribute is set.' => 'La synchronisation des groupes ne peut avoir lieu sans LDAPGroupIdAttribute et/ou LDAPGroupNameAttribute paramtr.',
	'LDAP groups synchronized with existing groups.' => 'Groupes LDAP synchroniss avec les groupes existants.',
	'The following groups\' information were modified:' => 'Les informations suivantes des groupes ont t modifies:',
	'No LDAP group was found using given filter.' => 'Aucun groupe LDAP n\'a t trouv avec le filtre fourni.',
	"Filter used to search for groups: [_1]\nSearch base: [_2]" => "Filtre utilis pour la recherche dans les groupes : [_1]
Base de recherche : [_2]",
	'(none)' => '(Aucun)',
	'The following groups were deleted:' => 'Les groupes suivants ont t effacs:',
	'Failed to create a new group: [_1]' => 'Impossible de crer un nouveau groupe: [_1]',
	'[_1] directive must be set to synchronize members of LDAP groups to Movable Type Enterprise.' => 'La directive [_1] doit tre configure pour synchroniser les membres des groupes LDAP avec Movable Type Enterprise.',
	'Members removed: ' => 'Membres supprims:',
	'Members added: ' => 'Membres ajouts:',
	'Memberships of the group \'[_2]\' (#[_3]) has been changed in synchronizing with external directory.' => 'Les membres du groupe \'[_2]\' (#[_3]) ont t chang en synchronisant avec l\'annuaire externe.',
	'LDAPUserGroupMemberAttribute must be set to enable synchronize members of groups.' => 'LDAPUserGroupMemberAttribute doit tre configur pour activer la synchronisation des membres des groupes.',

## addons/Enterprise.pack/lib/MT/ObjectDriver/Driver/DBD/UMSSQLServer.pm
	'This version of UMSSQLServer driver requires DBD::ODBC version 1.14.' => 'Cette version du driver UMSSQLServer ncessite DBD::ODBC version 1.14.',
	'This version of UMSSQLServer driver requires DBD::ODBC compiled with Unicode support.' => 'Cette version du driver UMSSQLServer ncessite DBD::ODBC compil avec le support de Unicode.',

## addons/Enterprise.pack/lib/MT/ObjectDriver/Driver/DBD/MSSQLServer.pm
	'PublishCharset [_1] is not supported in this version of MS SQL Server Driver.' => 'PublishCharset [_1] n\'est pas support dans cette version de driver MS SQL Server.',

## addons/Enterprise.pack/lib/MT/Group.pm

## addons/Enterprise.pack/lib/MT/LDAP.pm
	'Invalid LDAPAuthURL scheme: [_1].' => 'LDAPAuthURL invalide : [_1].',
	'Error connecting to LDAP server [_1]: [_2]' => 'Erreur de connection au serveur LDAP [_1]: [_2]',
	'User not found on LDAP: [_1]' => 'Utilisateur non trouv dans LDAP : [_1]',
	'Binding to LDAP server failed: [_1]' => 'Rattachement au serveur LDAP chou: [_1]',
	'More than one user with the same name found on LDAP: [_1]' => 'Plus d\'un utilisateur avec le mme nom trouv dans LDAP: [_1]',

## addons/Enterprise.pack/tmpl/dialog/select_groups.tmpl
	'You need to create some groups.' => 'Vous devez crer des groupes',
	'Before you can do this, you need to create some groups. <a href="javascript:void(0);" onclick="closeDialog(\'[_1]\');">Click here</a> to create a group.' => 'Avant de pouvoir faire ceci, vous devez crer des groupes. <a href="javascript:void(0);" onclick="closeDialog(\'[_1]\');">Cliquez ici</a> pour crer un groupe.',

## addons/Enterprise.pack/tmpl/include/list_associations/page_title.group.tmpl
	'Users &amp; Groups for [_1]' => 'Utilisateurs &amp; groupes pour [_1]',
	'Group Associations for [_1]' => 'Associations de groupe pour [_1]',

## addons/Enterprise.pack/tmpl/include/users_content_nav.tmpl

## addons/Enterprise.pack/tmpl/include/group_table.tmpl
	'group' => 'groupe',
	'groups' => 'Groupes',
	'Enable selected group (e)' => 'Activer le groupe slectionn (e)',
	'Disable selected group (d)' => 'Dsactiver le groupe slectionn (d)',
	'Remove selected group (d)' => 'Supprimer le groupe slectionn (d)',
	'Only show enabled groups' => 'Afficher uniquement les groupes activs',
	'Only show disabled groups' => 'Afficher uniquement les groupes dsactivs',

## addons/Enterprise.pack/tmpl/list_group.tmpl
	'[_1]: User&rsquo;s Groups' => '[_1]: Groupes de l\'utilisateur',
	'Groups: System Wide' => 'Groupes: Sur tout le systme',
	'You have successfully disabled the selected group(s).' => 'Vous avez dsactiv les groupes slectionns avec succs.',
	'You have successfully enabled the selected group(s).' => 'Vous avez activ les groupes slectionns avec succs.',
	'You have successfully deleted the groups from the Movable Type system.' => 'Vous avez supprim les groupes du systme Movable Type avec succs.',
	'You have successfully synchronized groups\' information with the external directory.' => 'Vous avez synchronis avec succs les informations des groupes avec le rpertoire externe.',
	'The user <em>[_1]</em> is currently disabled.' => 'L\'utilisateur <em>[_1]</em> est actuellement dsactiv',
	'You can not add disabled users to groups.' => 'Vous ne pouvez pas ajouter dans les groupes des utilisateurs dsactivs.',
	'Add [_1] to another group' => 'Ajouter [_1]  un autre groupe',
	'Create Group' => 'Crer un groupe',
	'You did not select any [_1] to remove.' => 'Vous n\'avez slectionn aucun [_1]  supprimer.',
	'Are you sure you want to remove this [_1]?' => 'Etes-vous sr de vouloir supprimer ce [_1]?',
	'Are you sure you want to remove the [_1] selected [_2]?' => 'Etes-vous sr de vouloir supprimer le [_1] slectionn [_2]?',
	'to remove' => ' supprimer',

## addons/Enterprise.pack/tmpl/create_author_bulk_end.tmpl
	'All users updated successfully!' => 'Tous les utilisateurs ont t mis  jour avec succs!',
	'An error occurred during the updating process. Please check your CSV file.' => 'Une erreur s\'est produite pendant la mise  jour. Merci de vrifier votre fichier CSV.',

## addons/Enterprise.pack/tmpl/author_bulk.tmpl
	'Manage Users in bulk' => 'Grer les utilisateurs en masse',
	'_USAGE_AUTHORS_2' => 'Vous pouvez crer, modifier et effacer des utilisateurs en masse en chargeant un fichier CSV contenant ces commandes et les donnes associes.',
	'Upload source file' => 'Charger le fichier source',
	'Specify the CSV-formatted source file for upload' => 'Spcifier le fichier source CSV  charger',
	'Source File Encoding' => 'Encodage du fichier source',
	'Upload (u)' => 'Charger (u)',

## addons/Enterprise.pack/tmpl/list_group_member.tmpl
	'[_1]: Group Members' => '[_1]: Membres du groupe',
	'<em>[_1]</em>: Group Members' => '<em>[_1]</em>: Membres du groupe',
	'You have successfully deleted the users.' => 'Vous avez supprim les utilisateurs avec succs.',
	'You have successfully added new users to this group.' => 'Vous avez ajout les nouveaux utilisateurs dans ce groupe avec succs.',
	'You have successfully synchronized users\' information with external directory.' => 'Vous avez synchronis avec succs les informations des utilisateurs avec l\'annuaire externe.',
	'Some ([_1]) of the selected users could not be re-enabled because they were no longer found in LDAP.' => 'Certains ([_1]) utilisateurs slectionns n\'ont pu tre ractivs car ils ne sont plus dans LDAP.',
	'You have successfully removed the users from this group.' => 'Vous avez retirs avec succs les utilisateurs de ce groupe.',
	'Group Disabled' => 'Groupe dsactiv',
	'You can not add users to a disabled group.' => 'Vous ne pouvez pas ajouter des utilisateurs  un groupe dsactiv.',
	'Add user to [_1]' => 'Ajouter utilisateur  [_1]',
	'member' => 'membre',
	'Show Enabled Members' => 'Afficher les membres actifs',
	'Show Disabled Members' => 'Afficher les membres dsactivs',
	'Show All Members' => 'Afficher tous les membres',
	'None.' => 'Aucun.',
	'(Showing all users.)' => '(Afficher tous les utilisateurs.)',
	'Showing only users whose [_1] is [_2].' => 'Afficher seulement les utilisateurs dont [_1] est [_2].',
	'Show' => 'Afficher',
	'all' => 'Toutes',
	'only' => 'seulement',
	'users where' => 'utilisateurs o',
	'No members in group' => 'Aucun membre dans ce groupe',
	'Only show enabled users' => 'Afficher seulement les utilisateurs actifs',
	'Only show disabled users' => 'Afficher seulement les utilisateurs dsactivs.',
	'Are you sure you want to remove this [_1] from this group?' => 'Etes-vous sr des vouloir supprimer ce [_1] de ce groupe?',
	'Are you sure you want to remove the [_1] selected [_2] from this group?' => 'Etes-vous sr des vouloir supprimer le [_1] slectionn [_2] de ce groupe?',

## addons/Enterprise.pack/tmpl/edit_group.tmpl
	'Edit Group' => 'Modifier le groupe',
	'Group profile has been updated.' => 'Le profil du groupe a t modifi.',
	'LDAP Group ID' => 'Group ID LDAP',
	'The LDAP directory ID for this group.' => 'L\'ID de l\'annuaire LDAP pour ce groupe.',
	'Status of group in the system. Disabling a group removes its members&rsquo; access to the system but preserves their content and history.' => 'Statut du groupe dans le systme. Dsactiver un groupe supprime l\'accs de ses membres au systme mais prserve leur contenu et historique.',
	'The name used for identifying this group.' => 'Le nom utilis pour identifier ce groupe.',
	'The display name for this group.' => 'Le nom d\'affichage de ce groupe.',
	'Enter a description for your group.' => 'Saisir une description pour votre groupe.',
	'Created on' => 'Cr le',
	'Save changes to this field (s)' => 'Sauvegarder les changements apports  ce champ (s)',

## addons/Enterprise.pack/tmpl/cfg_ldap.tmpl
	'Authentication Configuration' => 'Configuration de l\'identification',
	'You must set your Authentication URL.' => 'Vous devez configurer votre URL d\'identification.',
	'You must set your Group search base.' => 'Vous devez configurer votre base de recherche de groupes.',
	'You must set your UserID attribute.' => 'Vous devez configurer votre attribut UserID.',
	'You must set your email attribute.' => 'Vous devez configurer votre attribut email.',
	'You must set your user fullname attribute.' => 'Vous devez configurer votre attribut nom complet de l\'utilisateur.',
	'You must set your user member attribute.' => 'Vous devez configurer votre attribut de membre de l\'utilisateur.',
	'You must set your GroupID attribute.' => 'Vous devez configurer votre attribut GroupID.',
	'You must set your group name attribute.' => 'Vous devez configurer votre attribut nom de groupe.',
	'You must set your group fullname attribute.' => 'Vous devez configurer votre attribut nom complet du groupe.',
	'You must set your group member attribute.' => 'Vous devez configurer votre attribut member du groupe.',
	'You can configure your LDAP settings from here if you would like to use LDAP-based authentication.' => 'Vous devez configurer vos rglages LDAP ici si vous souhaitez utiliser l\'identification LDAP.',
	'Your configuration was successful.' => 'Votre configuration est correcte.',
	'Click \'Continue\' below to configure the External User Management settings.' => 'Cliquez sur \'Continuer\' ci-dessous pour configurer les rglages de la gestion externe des utilisateurs.',
	'Click \'Continue\' below to configure your LDAP attribute mappings.' => 'Cliquez sur \'Continuer\' ci-dessous pour configurer vos rattachements des attributs LDAP.',
	'Your LDAP configuration is complete.' => 'Votre configuration LDAP est termine.',
	'To finish with the configuration wizard, press \'Continue\' below.' => 'Pour finir l\'assistant de configuration, cliquez sur \'Continuer\' ci-dessous.',
	'An error occurred while attempting to connect to the LDAP server: ' => 'Une erreur s\'est produite en essayant de se connecter au serveur LDAP:',
	'Use LDAP' => 'Utiliser LDAP',
	'Authentication URL' => 'URL d\'identification',
	'The URL to access for LDAP authentication.' => 'L\'URL pour accder  l\'identification LDAP.',
	'Authentication DN' => 'Identificatiin DN',
	'An optional DN used to bind to the LDAP directory when searching for a user.' => 'Un DN optionnel utilis pour rattacher  l\'annuaire LDAP lors d\'une recherche d\'utilisateur.',
	'Authentication password' => 'Mot de passe de l\'identification',
	'Used for setting the password of the LDAP DN.' => 'Utilis pour rgler le mot de passe du DN LDAP.',
	'SASL Mechanism' => 'Mcanisme SASL',
	'The name of SASL Mechanism to use for both binding and authentication.' => 'Nom du mcanisme SASL  utiliser pour le rattachement et l\'identification.',
	'Test Username' => 'Identifiant de test',
	'Test Password' => 'Mot de passe de test',
	'Enable External User Management' => 'Activer les gestion externe des utilisateurs',
	'Synchronization Frequency' => 'Frquence de synchronisation',
	'Frequency of synchronization in minutes. (Default is 60 minutes)' => 'Frquence de synchronisation en minutes. (60 minutes par dfaut)',
	'15 Minutes' => '15 Minutes',
	'30 Minutes' => '30 Minutes',
	'60 Minutes' => '60 Minutes',
	'90 Minutes' => '90 Minutes',
	'Group search base attribute' => 'Attribut de base de recherche du groupe',
	'Group filter attribute' => 'Attribut de filtre du groupe',
	'Search Results (max 10 entries)' => 'Rsultats de recherche (maxi 10 entres)',
	'CN' => 'CN',
	'No groups were found with these settings.' => 'Aucun groupe n\'a t trouv avec ces rglages.',
	'Attribute mapping' => 'Rattachement d\'attribut',
	'LDAP Server' => 'Serveur LDAP',
	'Other' => 'Autre',
	'User ID attribute' => 'Attribut ID utilisateur',
	'Email Attribute' => 'Attribut email',
	'User fullname attribute' => 'Attribut nom complet utilisateur',
	'User member attribute' => 'Attribut membre utilisateur',
	'GroupID attribute' => 'Attribut GroupID',
	'Group name attribute' => 'Attribut nom du groupe',
	'Group fullname attribute' => 'Attribut nom complet du groupe',
	'Group member attribute' => 'Attribut membre du groupe',
	'Search result (max 10 entries)' => 'Rsultat de recherche (maxi 10 entres)',
	'Group Fullname' => 'Nom complet du groupe',
	'Group Member' => 'Membre du groupe',
	'No groups could be found.' => 'Aucun groupe n\'a t trouv.',
	'User Fullname' => 'Nom complet utilisateur',
	'No users could be found.' => 'Aucun utilisateur n\'a t trouv.',
	'Test connection to LDAP' => 'Tester la connection  LDAP',
	'Test search' => 'Tester la recherche',

## addons/Enterprise.pack/tmpl/create_author_bulk_start.tmpl
	'Bulk Author Import' => 'Importer les auteurs en masse',

## addons/Enterprise.pack/app-wizard.yaml
	'This module is required in order to use the LDAP Authentication.' => 'Ce module est ncessaire pour utiliser l\'identification LDAP.',
	'This module is required in order to use SSL/TLS connection with the LDAP Authentication.' => 'Ce module est ncessaire pour utiliser les connections SSL/TLS avec l\'identification LDAP.',

## addons/Enterprise.pack/app-cms.yaml
	'Are you sure you want to delete the selected group(s)?' => 'Etes-vous sr de vouloir effacer les groupes slectionns?',
	'Bulk Author Export' => 'Export auteurs en masse',
	'Synchronize Users' => 'Synchroniser les utilisateurs',
	'Synchronize Groups' => 'Synchroniser les groupes',

## addons/Enterprise.pack/config.yaml
	'Enterprise Pack' => 'Enterprise Pack',
	'Oracle Database' => 'Base de donnes Oracle',
	'Microsoft SQL Server Database' => 'Base de donnes Microsoft SQL Server',
	'Microsoft SQL Server Database (UTF-8 support)' => 'Base de donnes Microsoft SQL Server (support UTF-8)',
	'External Directory Synchronization' => 'Synchronization rpertoire externe',
	'Populating author\'s external ID to have lower case user name...' => 'Peuplement de l\'ID externe d\'auteur pour avoir des identifiants en minuscule...',

## plugins/Cloner/cloner.pl
	'Clones a blog and all of its contents.' => 'Dupliquer un blog et tout son contenu',
	'Cloning blog \'[_1]\'...' => 'Duplication du blog...',
	'Finished! You can <a href="javascript:void(0);" onclick="closeDialog(\'[_1]\');">return to the blog listing</a> or <a href="javascript:void(0);" onclick="closeDialog(\'[_2]\');">configure the Site root and URL of the new blog</a>.' => 'Termin ! Vous pouvez <a href="javascript:void(0);" onclick="closeDialog(\'[_1]\');">retourner  la liste des blogs</a> ou <a href="javascript:void(0);" onclick="closeDialog(\'[_2]\');">configurer la racine du site et l\'URL du nouveau blog</a>.',
	'No blog was selected to clone.' => 'Aucun blog n\'a t slectionn pour la duplication',
	'This action can only be run for a single blog at a time.' => 'Cette action ne peut tre excute que pour un blog  la fois',
	'Invalid blog_id' => 'Identifiant du blog non valide',
	'Clone Blog' => 'Dupliquer le blog',

## plugins/Markdown/SmartyPants.pl
	'Easily translates plain punctuation characters into \'smart\' typographic punctuation.' => 'Permet de convertir facilement des caractres de ponctuation basiques vers une ponctuation plus complexe (comme les guillemets, tirets, etc...)',

## plugins/Markdown/Markdown.pl
	'A plain-text-to-HTML formatting plugin.' => 'Un plugin de formatage plain-text vers HTML',
	'Markdown' => 'Markdown',
	'Markdown With SmartyPants' => 'Markdown avec SmartyPants',

## plugins/WXRImporter/lib/WXRImporter/Import.pm

## plugins/WXRImporter/lib/WXRImporter/WXRHandler.pm
	'File is not in WXR format.' => 'Le fichier n\'est pas dans le format WXR.',
	'Creating new tag (\'[_1]\')...' => 'Cration d\'un nouveau tag (\'[_1]\')...',
	'Saving tag failed: [_1]' => 'L\'enregistrement du tag a chou : [_1]',
	'Duplicate asset (\'[_1]\') found.  Skipping.' => 'L\'lment  (\'[_1]\') a t trouv en double. Abandon.',
	'Saving asset (\'[_1]\')...' => 'Enregistrement de l\'lment (\'[_1]\')...',
	' and asset will be tagged (\'[_1]\')...' => ' et l\'lment sera taggu (\'[_1]\')...',
	'Duplicate entry (\'[_1]\') found.  Skipping.' => 'La note  (\'[_1]\') a t trouve en double. Abandon.',
	'Saving page (\'[_1]\')...' => 'Enregistrement de la page (\'[_1]\')...',

## plugins/WXRImporter/tmpl/options.tmpl
	'Before you import WordPress posts to Movable Type, we recommend that you <a href=\'[_1]\'>configure your blog\'s publishing paths</a> first.' => 'Avant d\'importer des notes Wordpress dans Movable Type, nous vous recommandons d\'abord de <a href=\'[_1]\'>configurer les chemins de publication de votre blog</a>.',
	'Upload path for this WordPress blog' => 'Chemin d\'envoi pour ce blog WordPress',
	'Replace with' => 'Remplacer par',
	'Download attachments' => 'Tlcharger les fichiers attachs',
	'Requires the use of a cron job to download attachments from WordPress powered blog in the background.' => 'L\'utilisation d\'un cron job est requis pour tlcharger en arrire plan les fichiers attachs  un blog WordPress.',
	'Download attachments (images and files) from the imported WordPress powered blog.' => 'Tlcharger les fichiers attachs d\'un blog WordPress (images et autres documents).',

## plugins/WXRImporter/WXRImporter.pl
	'Import WordPress exported RSS into MT.' => 'Importer depuis WordPress exported RSS vers MT',
	'WordPress eXtended RSS (WXR)' => 'WordPress eXtended RSS (WXR)',
	'Download WP attachments via HTTP.' => 'Tlcharger tous les fichiers attachs  un blog WordPress par HTTP',

## plugins/TypePadAntiSpam/lib/MT/TypePadAntiSpam.pm
	'API key is a required parameter.' => 'La cl API est requise.',

## plugins/TypePadAntiSpam/tmpl/system.tmpl
	'API Key' => 'Cl API',
	'To enable this plugin, you\'ll need a free TypePad AntiSpam API key. You can <strong>get your free API key at [_1]antispam.typepad.com[_2]</strong>. Once you have your key, return to this page and enter it in the field below.' => 'Pour activer ce plugin, vous devez obtenir une cl API gratuite TypePad AntiSpam. Vous pouvez <strong>obtenir votre cl API gratuite sur [_1]antispam.typepad.com[_2]</strong>. Une fois votre cl obtenue, retournez sur cette page et entrez-l dans le champs ci-dessous.',
	'Service Host' => 'Hbergeur de service',
	'The default service host for TypePad AntiSpam is api.antispam.typepad.com. You should only change this if you are using a different service that is compatible with the TypePad AntiSpam API.' => 'L\'hbergeur de service par dfaut pour TypePad AntiSpam est api.antispam.typepad.com. Vous ne devriez changer cela uniquement si vous utilisez un autre service compatible avec l\'API TypePad AntiSpam.',

## plugins/TypePadAntiSpam/tmpl/config.tmpl
	'Junk Score Weight' => 'Niveau du filtrage',
	'Least Weight' => 'Moins agressif',
	'Most Weight' => 'Plus agressif',
	'Comments and TrackBacks receive a junk score between -10 (definitely spam) and +10 (definitely not spam). This setting allows you to control the weight of the TypePad AntiSpam rating relative to other filters you may have installed to help you filter comments and TrackBacks.' => 'Les commentaires et trackbakcs reoivent une note de spam entre - 10 (trs forte probabilit d\'tre du spam) et +10 (trs forte probabilit de n\'tre pas du spam). Ces paramtres vous permettent de contrler la pondration du filtre de TypePad AntiSpam vis--vis des autres filtres que vous pouvez avoir install pour vous aider  filtrer les commentaires et trackbacks.',

## plugins/TypePadAntiSpam/tmpl/stats_widget.tmpl
	'widget_label_width' => 'widget_label_width',
	'widget_totals_width' => 'widget_totals_width',
	'TypePad AntiSpam' => 'TypePad AntiSpam',
	'Spam Blocked' => 'Spam bloqu',
	'on this blog' => 'sur ce blog',
	'on this system' => 'sur ce systme',

## plugins/TypePadAntiSpam/TypePadAntiSpam.pl
	'TypePad AntiSpam is a free service from Six Apart that helps protect your blog from comment and TrackBack spam. The TypePad AntiSpam plugin will send every comment or TrackBack submitted to your blog to the service for evaluation, and Movable Type will filter items if TypePad AntiSpam determines it is spam. If you discover that TypePad AntiSpam incorrectly classifies an item, simply change its classification by marking it as "Spam" or "Not Spam" from the Manage Comments screen, and TypePad AntiSpam will learn from your actions. Over time the service will improve based on reports from its users, so take care when marking items as "Spam" or "Not Spam."' => 'TypePad AntiSpam est un service gratuit de Six Apart vous aidant  protger votre blog des commentaires et trackbacks de spam. Le plugin TypePad AntiSpam enverra chaque commentaire ou trackback reu sur votre blog au service pour un valuation et Movable Type filtrera les lments si TypePad AntiSpam considre ces lments comme tant du spam. Si vous dcouvrez un lment que TypePad AntiSpam a mal filtr, changez simplement sa classification en le marquant comme "Spam" ou "Non-spam" dans la page Grer les commentaires et TypePad AntiSpam apprendra de vos actions. Le service s\'amliorera au fur et  mesure des notifications de ses utilisateurs, usez donc d\'une attention particulire lorsque vous marquez un lment comme tant du "spam" ou "non-spam".',
	'So far, TypePad AntiSpam has blocked [quant,_1,message,messages] for this blog, and [quant,_2,message,messages] system-wide.' => 'Depuis le dbut, TypePad AntiSpam a bloqu [quant,_1,message,messages] sur ce blog et [quant,_2,message,messages] sur tout le systme.',
	'So far, TypePad AntiSpam has blocked [quant,_1,message,messages] system-wide.' => 'Depuis le dbut, TypePad AntiSpam a bloqu [quant,_1,message,messages] sur tout le systme.',
	'Failed to verify your TypePad AntiSpam API key: [_1]' => 'Erreur lors de la vrification de votre cl API TypePad AntiSpam : [_1]',
	'The TypePad AntiSpam API key provided is invalid.' => 'La cl API TypePad AntiSpam entre n\'est pas valide.',

## plugins/StyleCatcher/lib/StyleCatcher/CMS.pm
	'Your mt-static directory could not be found. Please configure \'StaticFilePath\' to continue.' => 'Le rpertoire mt-static n\'a pas pu tre trouv. Veuillez configurer le \'StaticFilePath\' pour continuer.',
	'Could not create [_1] folder - Check that your \'themes\' folder is webserver-writable.' => 'Impossible de crer le dossier [_1] - Vrifiez que votre dossier \'themes\' et en mode webserveur/criture.',
	'Error downloading image: [_1]' => 'Erreur en tlchargeant l\'image : [_1]',
	'Successfully applied new theme selection.' => 'Slection de nouveau Thme applique avec succs.',
	'Invalid URL: [_1]' => 'URL inaccessible : [_1]',

## plugins/StyleCatcher/tmpl/view.tmpl
	'Select a Style' => 'Habillages',
	'3-Columns, Wide, Thin, Thin' => '3-colonnes, large, fin, fin',
	'3-Columns, Thin, Wide, Thin' => '3-colonnes, fin, large, fin',
	'2-Columns, Thin, Wide' => '2-colonnes, fin, large',
	'2-Columns, Wide, Thin' => '2-colonnes, large, fin',
	'2-Columns, Wide, Medium' => '2-Colonnes, Large, Moyen',
	'2-Columns, Medium, Wide' => '2-colonnes, moyen, large',
	'None available' => 'Aucun disponible',
	'Applying...' => 'Appliquer...',
	'Apply Design' => 'Appliquer l\'habillage',
	'Error applying theme: ' => 'Erreur en appliquant l\'habillage:',
	'The selected theme has been applied, but as you have changed the layout, you will need to republish your blog to apply the new layout.' => 'L\'habillage slectionn a t appliqu. Vous devez republier votre blog afin d\'appliquer la nouvelle mise en page.',
	'The selected theme has been applied!' => 'L\'habillage slectionn a t appliqu!',
	'Error loading themes! -- [_1]' => 'Erreur lors du chargement des habillages ! -- [_1]',
	'Stylesheet or Repository URL' => 'URL de la feuille de style ou du rpertoire',
	'Stylesheet or Repository URL:' => 'URL de la feuille de style ou du rpertoire:',
	'Download Styles' => 'Tlcharger des habillages',
	'Current theme for your weblog' => 'Thme actuel de votre weblog',
	'Current Style' => 'Habillage actuel',
	'Locally saved themes' => 'Thmes enregistrs localement',
	'Saved Styles' => 'Habillages enregistrs',
	'Default Styles' => 'Habillages par dfaut',
	'Single themes from the web' => 'Thmes uniques venant du web',
	'More Styles' => 'Plus d\'habillages',
	'Selected Design' => 'Habillage slectionn',
	'Layout' => 'Mise en page',

## plugins/StyleCatcher/config.yaml
	'MT 4 Style Library' => 'Bibliothque MT4',
	'A collection of styles compatible with Movable Type 4 default templates.' => 'Une gamme de styles compatibles avec les gabarits MT4 par dfaut',
	'Styles' => 'Habillages',

## plugins/spamlookup/lib/spamlookup.pm
	'Failed to resolve IP address for source URL [_1]' => 'chec de la vrification de l\'adresse IP pour l\'URL source [_1]',
	'Moderating: Domain IP does not match ping IP for source URL [_1]; domain IP: [_2]; ping IP: [_3]' => 'Modration : l\IP du domaine ne correspond pas  l\'IP de ping pour l\'URL de la source [_1]; IP du domaine: [_2]; IP du ping: [_3]',
	'Domain IP does not match ping IP for source URL [_1]; domain IP: [_2]; ping IP: [_3]' => 'L\'IP du domaine ne correspond pas  l\'IP du ping pour l\'URL source [_1]; l\'IP du domaine: [_2]; IP du ping: [_3]',
	'No links are present in feedback' => 'Aucun lien n\'est prsent dans le message',
	'Number of links exceed junk limit ([_1])' => 'Le nombre de liens a dpass la limite de marquage comme spam ([_1])',
	'Number of links exceed moderation limit ([_1])' => 'Le nombre de liens a dpass la limite de modration ([_1])',
	'Link was previously published (comment id [_1]).' => 'Le lien a t publi prcdemment (id de commentaire [_1]).',
	'Link was previously published (TrackBack id [_1]).' => 'Le lien a t publi prcdemment (id de trackback [_1]).',
	'E-mail was previously published (comment id [_1]).' => 'L\'email a t publi prcdemment (id de commentaire [_1]).',
	'Word Filter match on \'[_1]\': \'[_2]\'.' => 'Le filtre de mot correspond sur \'[_1]\': \'[_2]\'.',
	'Moderating for Word Filter match on \'[_1]\': \'[_2]\'.' => 'Modration pour filtre de mot sur \'[_1]\': \'[_2]\'.',
	'domain \'[_1]\' found on service [_2]' => 'domaine \'[_1]\' trouv sur le service [_2]',
	'[_1] found on service [_2]' => '[_1] trouv sur le service [_2]',

## plugins/spamlookup/tmpl/lookup_config.tmpl
	'Lookups monitor the source IP addresses and hyperlinks of all incoming feedback. If a comment or TrackBack comes from a blacklisted IP address or contains a blacklisted domain, it can be held for moderation or scored as junk and placed into the blog\'s Junk folder. Additionally, advanced lookups on TrackBack source data can be performed.' => 'Lookups surveille les adresses IP sources et les liens hypertextes de tous les commentaires/trackbacks entrants. Si un commentaire ou un trackback provient d\'une adresse IP en liste noire ou contient un domaine banni, il peut tre retenu pour modration ou not comme spam et plac dans le rpertoire de spam. De plus, des vrifications avances sur les donnes sources des trackbacks peuvent tre raliss.',
	'IP Address Lookups' => 'Vrifier une adresse IP',
	'Moderate feedback from blacklisted IP addresses' => 'Modrer les commentaires/trackbacks des adresses IP en liste noire',
	'Junk feedback from blacklisted IP addresses' => 'Marquer comme spam les commentaires/trackbacks des adresses IP en liste noire',
	'Adjust scoring' => 'Ajuster la notation',
	'Score weight:' => 'Poids de la notation:',
	'Less' => 'Moins',
	'More' => 'Plus',
	'block' => 'bloquer',
	'IP Blacklist Services' => 'Services de liste noire d\'IP',
	'Domain Name Lookups' => 'Vrifier un nom de domaine',
	'Moderate feedback containing blacklisted domains' => 'Modrer le contenu des messages contenant des domaines en liste noire',
	'Junk feedback containing blacklisted domains' => 'Marquer comme spam les messages contenant les domaines en liste noire',
	'Domain Blacklist Services' => 'Services de liste noire de domaines',
	'Advanced TrackBack Lookups' => 'Vrifications avances des trackbacks',
	'Moderate TrackBacks from suspicious sources' => 'Modrer les trackbacks des sources suspectes',
	'Junk TrackBacks from suspicious sources' => 'Marquer comme spam les trackbacks des sources suspectes',
	'Lookup Whitelist' => 'Vrifier la liste blanche',
	'To prevent lookups for specific IP addresses or domains, list each on a line by itself.' => 'Pour ne pas effectuer de vrifications pour des noms de domaines ou addresses IP spcifiques, listez-les ligne par ligne.',

## plugins/spamlookup/tmpl/url_config.tmpl
	'Link filters monitor the number of hyperlinks in incoming feedback. Feedback with many links can be held for moderation or scored as junk. Conversely, feedback that does not contain links or only refers to previously published URLs can be positively rated. (Only enable this option if you are sure your site is already spam-free.)' => 'Les filtres de liens surveillent le nombre de liens hypertextes dans les messages entrants. Les messages avec beaucoup de liens peuvent tre retenus pour modration ou marqus comme spam. Inversement, les messages qui ne contiennent pas de liens ou lient seulement vers des URLs publies prcdemment peuvent tre nots positivement. (Activez cette option si vous tes sr que votre site est dj dpourvu de spam.)',
	'Link Limits' => 'Limite de liens',
	'Credit feedback rating when no hyperlinks are present' => 'Crditer la notation du message quand aucun lien hypertexte n\'est prsent',
	'Moderate when more than' => 'Modrer quand plus de',
	'link(s) are given' => 'liens sont prsents',
	'Junk when more than' => 'Marquer comme spam quand plus de',
	'Link Memory' => 'Mmorisation des liens',
	'Credit feedback rating when &quot;URL&quot; element of feedback has been published before' => 'Crditer la notation du message quand l\'lment &quot;URL&quot; du message a t publi prcdemment',
	'Only applied when no other links are present in message of feedback.' => 'Appliquer seulement quand aucun autre lien n\'est prsent quand le texte du message.',
	'Exclude URLs from comments published within last [_1] days.' => 'Exclure les URLs des commentaires publis dans les [_1] derniers jours.',
	'Email Memory' => 'Mmorisation des emails',
	'Credit feedback rating when previously published comments are found matching on the &quot;Email&quot; address' => 'Crditer la notation du message lorsque des commentaires publis prcdemment contenaient l\'adresse &quot;email&quot;',
	'Exclude Email addresses from comments published within last [_1] days.' => 'Exclure les adresses email des commentaires publis dans les [_1] derniers jours.',

## plugins/spamlookup/tmpl/word_config.tmpl
	'Incomming feedback can be monitored for specific keywords, domain names, and patterns. Matches can be held for moderation or scored as junk. Additionally, junk scores for these matches can be customized.' => 'Les messages entrant peuvent tre analyss  la recherche des mots-cls spcifiques, de noms de domaines, et de gabarits. Les messages correspondants peuvent tre maintenus pour modration ou marqus comme spam. De plus, les notes de spam pour ces messages peuvent tre personnaliss.',
	'Keywords to Moderate' => 'Mots-cls  modrer',
	'Keywords to Junk' => 'Mots-cls  marquer comme spam',

## plugins/spamlookup/spamlookup_words.pl
	'SpamLookup module for moderating and junking feedback using keyword filters.' => 'SpamLookup module pour modrer et marquer comme spam les messages en utilisant des filtres de mots-cls.',
	'SpamLookup Keyword Filter' => 'SpamLookup filtre de mots-cls',

## plugins/spamlookup/spamlookup.pl
	'SpamLookup module for using blacklist lookup services to filter feedback.' => 'Module SpamLookup pour utiliser les services de vrification de liste noire pour filtrer les commentaires.',
	'SpamLookup IP Lookup' => 'SpamLookup vrification des IP',
	'SpamLookup Domain Lookup' => 'SpamLookup vrification des domaines',
	'SpamLookup TrackBack Origin' => 'SpamLookup origine des trackbacks',
	'Despam Comments' => 'Commentaires non-spam',
	'Despam TrackBacks' => 'Trackbacks non-spam',
	'Despam' => 'Non-spam',

## plugins/spamlookup/spamlookup_urls.pl
	'SpamLookup - Link' => 'SpamLookup - Lien',
	'SpamLookup module for junking and moderating feedback based on link filters.' => 'SpamLookup module pour marquer comme spam et modrer les messages bas sur les filtres de liens.',
	'SpamLookup Link Filter' => 'SpamLookup filtre de lien',
	'SpamLookup Link Memory' => 'SpamLookup mmorisation des liens',
	'SpamLookup Email Memory' => 'SpamLookup mmorisation des emails',

## plugins/MultiBlog/lib/MultiBlog/Tags.pm
	'MTMultiBlog tags cannot be nested.' => 'Les balises MTMultiBlog ne peuvent pas tre imbriques.',
	'Unknown "mode" attribute value: [_1]. Valid values are "loop" and "context".' => 'Valeur de l\'attribut "mode" inconnue : [_1]. Les valeurs valides sont "loop" et "context".',

## plugins/MultiBlog/lib/MultiBlog.pm
	'The include_blogs, exclude_blogs, blog_ids and blog_id attributes cannot be used together.' => 'Les attributs include_blogs, exclude_blogs, blog_ids et blog_id ne peuvent pas tre utiliss ensemble.',
	'The attribute exclude_blogs cannot take "all" for a value.' => 'L\'attribut exclude_blogs ne peut pas prendre "all" pour valeur.',
	'The value of the blog_id attribute must be a single blog ID.' => 'La valeur de l\'attribut blog_id doit tre un ID de blog unique.',
	'The value for the include_blogs/exclude_blogs attributes must be one or more blog IDs, separated by commas.' => 'La valeur des attributs include_blogs/exclude_blogs doit tre un ou plusieurs IDs de blogs, spars par des virgules.',

## plugins/MultiBlog/tmpl/system_config.tmpl
	'Default system aggregation policy' => 'Rgle d\'agrgation du systme par dfaut',
	'Allow' => 'Autoriser',
	'Disallow' => 'Interdire',
	'Cross-blog aggregation will be allowed by default.  Individual blogs can be configured through the blog-level MultiBlog settings to restrict access to their content by other blogs.' => 'L\'agrgation inter-blog sera active par dfaut. Les blogs individuels peuvent tre configurs via les paramtres MultiBlog du blog en question, pour restreindre l\'accs  leur contenu par les autres blogs.',
	'Cross-blog aggregation will be disallowed by default.  Individual blogs can be configured through the blog-level MultiBlog settings to allow access to their content by other blogs.' => 'L\'agrgation inter-blog sera dsactive par dfaut. Les blogs individuels peuvent tre configurs via les paramtres MultiBlog du blog en question, pour autoriser l\'accs  leur contenu par les autres blogs.',

## plugins/MultiBlog/tmpl/blog_config.tmpl
	'When' => 'Quand',
	'Any Weblog' => 'Tous les blogs',
	'Weblog' => 'Blog',
	'Trigger' => 'Evnement',
	'Action' => 'Action',
	'Content Privacy' => 'Protection du contenu',
	'Specify whether other blogs in the installation may publish content from this blog. This setting takes precedence over the default system aggregation policy found in the system-level MultiBlog configuration.' => 'Indiquez si les autres blogs de cette installation peuvent publier du contenu de ce blog. Ce rglage prend le dessus sur la rgle d\'agrgation du systme par dfaut qui se trouve dans la configuration de MultiBlog pour tout le systme.',
	'Use system default' => 'Utiliser la rgle par dfaut du systme',
	'MTMultiBlog tag default arguments' => 'Arguments par dfaut de la balise MTMultiBlog',
	'Enables use of the MTMultiBlog tag without include_blogs/exclude_blogs attributes. Comma-separated BlogIDs or \'all\' (include_blogs only) are acceptable values.' => 'Autorise l\'utilisation de la balise MTMultiBlog sans les attributs include_blogs/exclude_blogs. Les valeurs correctes sont une liste de BlogIDs spars par des virgules, ou \'all\' (seulement pour include_blogs).',
	'Include blogs' => 'Inclure les blogs',
	'Exclude blogs' => 'Exclure les blogs',
	'Rebuild Triggers' => 'vnements de republication',
	'Create Rebuild Trigger' => 'Crer un vnement de republication ',
	'You have not defined any rebuild triggers.' => 'Vous n\'avez dfini aucun vnement de republication.',

## plugins/MultiBlog/tmpl/dialog_create_trigger.tmpl
	'Create MultiBlog Trigger' => 'Crer un vnement MultiBlog',

## plugins/MultiBlog/multiblog.pl
	'MultiBlog allows you to publish content from other blogs and define publishing rules and access controls between them.' => 'Multiblog vous permet de publier du contenu d\'autres blogs et de dfinir des rgles de publication et de droit d\'accs entre eux.',
	'MultiBlog' => 'MultiBlog',
	'Create Trigger' => 'Crer un nouvel vnement',
	'Weblog Name' => 'Nom du blog',
	'Search Weblogs' => 'Rechercher les blogs',
	'When this' => 'quand ce',
	'* All Weblogs' => '* Tous les blogs',
	'Select to apply this trigger to all weblogs' => 'Slectionner pour appliquer cet vnement  tous les blogs',
	'saves an entry' => 'sauvegarde une note',
	'publishes an entry' => 'publie une note',
	'publishes a comment' => 'publie un commentaire',
	'publishes a TrackBack' => 'publie un trackback',
	'rebuild indexes.' => 'reconstruire les index.',
	'rebuild indexes and send pings.' => 'reconstruire les index et envoyer les pings.',

## plugins/Textile/textile2.pl
	'A humane web text generator.' => 'Gnrateur de texte user-friendly',
	'Textile 2' => 'Textile 2',

## plugins/WidgetManager/WidgetManager.pl
	'Widget Manager version 1.1; This version of the plugin is to upgrade data from older version of Widget Manager that has been shipped with Movable Type to the Movable Type core schema.  No other features are included.  You can safely remove this plugin after installing/upgrading Movable Type.' => 'Widget Manager version 1.1; Cette version est destine  la mise  jour des donnes des versions plus anciennes de Widget Manager, dlivr avec Movable Type. Aucune autre fonction n\'est incluse. Vous pouvez supprimer ce plugin aprs avoir install/mis  jour Movable Type.',
	'Moving storage of Widget Manager [_1]...' => 'Changement de l\'emplacement du Widget Manager [_1]...',

## plugins/feeds-app-lite/lib/MT/Feeds/Lite.pm
	'An error occurred processing [_1]. The previous version of the feed was used. A HTTP status of [_2] was returned.' => 'Une erreur s\'est produite en traitant [_1]. La version prcdente du flux a t utilise. Un statut HTTP de [_2] a t retourn.',
	'An error occurred processing [_1]. A previous version of the feed was not available.A HTTP status of [_2] was returned.' => 'Une erreur s\'est produite en traitant [_1]. Une version prcdente du flux n\'est pas disponible. Un statut HTTP de [_2] a t renvoy.',

## plugins/feeds-app-lite/lib/MT/Feeds/Tags.pm
	'\'[_1]\' is a required argument of [_2]' => '\'[_1]\' est un argument ncessaire de [_2]',
	'MT[_1] was not used in the proper context.' => 'Le [_1] MT n\'a pas t utilis dans le bon contexte.',

## plugins/feeds-app-lite/tmpl/config.tmpl
	'Feeds.App Lite Widget Creator' => 'Crateur de widget de flux',
	'Configure feed widget settings' => 'Configurer les paramtres du widget de flux',
	'Enter a title for your widget.  This will also be displayed as the title of the feed when used on your published blog.' => 'Saisissez un titre pour votre widget. Il sera aussi utilis comme titre pour le flux qui sera utilis sur votre blog.',
	'[_1] Feed Widget' => 'Widget de flux [_1]',
	'Select the maximum number of entries to display.' => 'Slectionnez le nombre maximum de notes que vous voulez afficher.',
	'3' => '3',
	'5' => '5',
	'10' => '10',
	'All' => 'Toutes',

## plugins/feeds-app-lite/tmpl/msg.tmpl
	'No feeds could be discovered using [_1]' => 'Aucun flux n\'a pu tre trouv en utilisant [_1]',
	'An error occurred processing [_1]. Check <a href="javascript:void(0)" onclick="closeDialog(\'http://www.feedvalidator.org/check.cgi?url=[_2]\')">here</a> for more detail and please try again.' => 'Une erreur s\'est produite en traitant [_1]. Vrifiez <a href="javascript:void(0)" onclick="closeDialog(\'http://www.feedvalidator.org/check.cgi?url=[_2]\')">ici</a> pour plus de dtails et essayez  nouveau.',
	'A widget named <strong>[_1]</strong> has been created.' => 'Un widget nomm <strong>[_1]</strong> a t cr.',
	'You may now <a href="javascript:void(0)" onclick="closeDialog(\'[_2]\')">edit &ldquo;[_1]&rdquo;</a> or include the widget in your blog using <a href="javascript:void(0)" onclick="closeDialog(\'[_3]\')">WidgetManager</a> or the following MTInclude tag:' => 'Vous pouvez maintenant <a href="javascript:void(0)" onclick="closeDialog(\'[_2]\')">modifier &ldquo;[_1]&rdquo;</a> ou inclure le widget dans votre blog en utilisant <a href="javascript:void(0)" onclick="closeDialog(\'[_3]\')">WidgetManager</a> ou la balise MTInclude suivante :',
	'You may now <a href="javascript:void(0)" onclick="closeDialog(\'[_2]\')">edit &ldquo;[_1]&rdquo;</a> or include the widget in your blog using the following MTInclude tag:' => 'Vous pouvez maintenant <a href="javascript:void(0)" onclick="closeDialog(\'[_2]\')">modifier &ldquo;[_1]&rdquo;</a> ou inclure le widget dans votre blog en utilisant la balise  MTInclude suivante :',
	'Create Another' => 'En crer un autre',

## plugins/feeds-app-lite/tmpl/start.tmpl
	'You must enter a feed or site URL to proceed' => 'Vous devez saisir l\'URL d\'un flux ou d\'un site pour poursuivre',
	'Create a widget from a feed' => 'Crer un widget  partir d\'un flux',
	'Feed or Site URL' => 'URL du site ou du flux',
	'Enter the URL of a feed, or the URL of a site that has a feed.' => 'Saisissez l\'adresse d\'un flux ou l\'adresse d\'un site possdant un flux.',

## plugins/feeds-app-lite/tmpl/select.tmpl
	'Multiple feeds were found' => 'Plusieurs flux ont t trouvs',
	'Select the feed you wish to use. <em>Feeds.App Lite supports text-only RSS 1.0, 2.0 and Atom feeds.</em>' => 'Slectionnez le flux que vous voulez utiliser. <em>Feeds.App Lite supporte les flux texte uniquement en RSS 1.0, 2.0 et Atom.</em>',
	'URI' => 'URI',

## plugins/feeds-app-lite/mt-feeds.pl
	'Feeds.App Lite helps you republish feeds on your blogs. Want to do more with feeds in Movable Type?' => 'Feeds.App Lite vous permet de republier des flux sur vos blogs. Vous voulez en faire plus avec les flux de Movable Type?',
	'Upgrade to Feeds.App' => 'Mise  jour Feeds.App',
	'Create a Feed Widget' => 'Crer un widget  partir d\'un flux',

);

## New words: 190

1;
