#!/bin/sh
set -e
export TAR_OPTIONS='--owner root --group root --mode a+rX'
export GZIP_OPTIONS='-9n'
pwd=$(pwd)
dfsg_version="$1"
if [ -z "$dfsg_version" ]
then
    printf 'Usage: %s <version>\n' "$0"
    exit 1
fi
upstream_version="${dfsg_version%+dfsg*}"
cd "$(dirname "$0")/../"
tmpdir=$(mktemp -t -d get-orig-source.XXXXXX)
uscan --noconf --force-download --rename --download-version="$upstream_version" --destdir="$tmpdir"
cd "$tmpdir"
tar -xzf python-xmp-toolkit_*.orig.tar.gz
rm *.tar.gz
# Remove pre-built HTML documentation, as it contains some sourceless
# JavaScript code:
rm -rf python-xmp-toolkit-*/docs/
# Remove some useless cruft:
rm -rf python-xmp-toolkit-*/.[!.]*
mv python-xmp-toolkit-*/ "python-xmp-toolkit-${dfsg_version}.orig"
tar -czf "$pwd/python-xmp-toolkit_${dfsg_version}.orig.tar.gz" python-xmp-toolkit-*.orig/
cd ..
rm -Rf "$tmpdir"

# vim:ts=4 sw=4 et
