/*
 * Copyright (C) 1999-2001 Jonathan R. Hudson
 * Developed by Jonathan R. Hudson <jonathan@daria.co.uk>
 * Modified by Mario Motta <mmotta@guest.net>
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef  _vdk_in_channel_h_
#define  _vdk_in_channel_h_
#include <vdk/vdkobj.h>
#include <vdk/siglisthandle.h>

#define INPUT_SIGNAL (user_signal-1024)

/*! \class VDKInputChannel
 *  \brief This class allows you to monitor inputs from one or more
 *  file descriptors and define member function(s) to be called whenever
 *  some activity is detected on that file descriptor.
 *
 * More informations can be found into an appendix of VDK/VDKBuilder tutorial
 * Signals:
 * INPUT_SIGNAL
 * "input_signal"
 */
class VDKInputChannel: public VDKObject
{
  private:
    void SetSignal(VDKObject*, GdkInputCondition);
  protected:
    static void HandleIO(gpointer obj, gint source, GdkInputCondition condition);
    gint tag;
    int fd;
    GdkInputCondition condition;
    
public:
    /*!
      Constructor
      \param owner the form that owns the input channel
      \param fd file descriptor
      \param condition the condition that activates the fd.
     */
    VDKInputChannel (VDKForm* owner, int fd,  GdkInputCondition condition = GDK_INPUT_READ);
    /*!
      destructor
    */
    virtual ~VDKInputChannel();
    /*!
      Returns the file descriptor associated with the object
     */
    int getfd() {return fd;}
    /*!
      Returns the condition that caused the VDK signal to be fired.
     */
    int getcondition() {return condition;}

};
#endif
