/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import IceGrid.PropertySetDescriptor;
import IceGrid.ServerDescriptor;
import IceGrid.ServerInstanceDescriptor;
import IceGrid.ServiceDescriptor;
import IceGrid.ServiceInstanceDescriptor;
import IceGrid.TemplateDescriptor;
import IceGridGUI.Application.Communicator;
import IceGridGUI.Application.Editable;
import IceGridGUI.Application.Editor;
import IceGridGUI.Application.ListTreeNode;
import IceGridGUI.Application.Node;
import IceGridGUI.Application.PropertySet;
import IceGridGUI.Application.PropertySetParent;
import IceGridGUI.Application.Server;
import IceGridGUI.Application.ServerInstanceEditor;
import IceGridGUI.Application.TreeNode;
import IceGridGUI.Application.UpdateFailedException;
import IceGridGUI.ApplicationActions;
import IceGridGUI.Utils;
import IceGridGUI.XMLWriter;
import java.awt.Component;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class ServerInstance
extends ListTreeNode
implements Server,
PropertySetParent {
    private ServerInstanceDescriptor _descriptor;
    private final boolean _ephemeral;
    private boolean _isIceBox;
    private ServerInstanceEditor _editor;
    private Utils.Resolver _resolver;
    private static DefaultTreeCellRenderer _cellRenderer;
    private static Icon _serverIcon;
    private static Icon _iceboxServerIcon;
    private static JPopupMenu _popup;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static ServerInstanceDescriptor copyDescriptor(ServerInstanceDescriptor sid) {
        ServerInstanceDescriptor copy = (ServerInstanceDescriptor)sid.clone();
        copy.propertySet = PropertySet.copyDescriptor(copy.propertySet);
        return copy;
    }

    public boolean getAllowsChildren() {
        return this._isIceBox;
    }

    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[20];
        actions[13] = !this._ephemeral;
        Object clipboard = this.getCoordinator().getClipboard();
        if (clipboard != null && (clipboard instanceof ServerDescriptor || clipboard instanceof ServerInstanceDescriptor || this._isIceBox && clipboard instanceof PropertySetDescriptor)) {
            actions[14] = true;
        }
        actions[15] = true;
        if (!this._ephemeral) {
            actions[16] = true;
            actions[17] = true;
            if (this._isIceBox) {
                actions[3] = true;
            }
        }
        return actions;
    }

    public void copy() {
        this.getCoordinator().setClipboard(ServerInstance.copyDescriptor(this._descriptor));
        this.getCoordinator().getActionsForMenu().get(14).setEnabled(true);
    }

    public void paste() {
        Object descriptor;
        if (this._isIceBox && (descriptor = this.getCoordinator().getClipboard()) instanceof PropertySetDescriptor) {
            this.newPropertySet(PropertySet.copyDescriptor((PropertySetDescriptor)descriptor));
            return;
        }
        ((TreeNode)this._parent).paste();
    }

    public void newPropertySet() {
        this.newPropertySet(new PropertySetDescriptor(new String[0], new LinkedList()));
    }

    public JPopupMenu getPopupMenu() {
        if (this._isIceBox) {
            ApplicationActions actions = this.getCoordinator().getActionsForPopup();
            if (_popup == null) {
                _popup = new JPopupMenu();
                _popup.add(actions.get(3));
            }
            actions.setTarget(this);
            return _popup;
        }
        return null;
    }

    public Editor getEditor() {
        if (this._editor == null) {
            this._editor = (ServerInstanceEditor)this.getRoot().getEditor(ServerInstanceEditor.class, this);
        }
        this._editor.show(this);
        return this._editor;
    }

    protected Editor createEditor() {
        return new ServerInstanceEditor();
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            _serverIcon = Utils.getIcon("/icons/16x16/server_inactive.png");
            _iceboxServerIcon = Utils.getIcon("/icons/16x16/icebox_server_inactive.png");
            _cellRenderer.setLeafIcon(_serverIcon);
            _cellRenderer.setOpenIcon(_iceboxServerIcon);
            _cellRenderer.setClosedIcon(_iceboxServerIcon);
        }
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    public void destroy() {
        Node node = (Node)this._parent;
        if (this._ephemeral) {
            node.removeServer(this);
        } else {
            node.removeDescriptor(this._descriptor);
            node.removeServer(this);
            node.getEditable().removeElement(this._id, this._editable, Server.class);
            this.getRoot().updated();
        }
    }

    public Object getDescriptor() {
        return this._descriptor;
    }

    public Object saveDescriptor() {
        return this._descriptor.clone();
    }

    public void restoreDescriptor(Object savedDescriptor) {
        ServerInstanceDescriptor copy = (ServerInstanceDescriptor)savedDescriptor;
        this._descriptor.template = copy.template;
        this._descriptor.parameterValues = copy.parameterValues;
        this._descriptor.propertySet = copy.propertySet;
    }

    ServerInstance(boolean brandNew, TreeNode parent, String serverId, Utils.Resolver resolver, ServerInstanceDescriptor instanceDescriptor, boolean isIceBox) throws UpdateFailedException {
        super(brandNew, parent, serverId);
        this._ephemeral = false;
        this.rebuild(resolver, instanceDescriptor, isIceBox);
    }

    ServerInstance(TreeNode parent, String serverId, ServerInstanceDescriptor instanceDescriptor) {
        block2: {
            super(false, parent, serverId);
            this._ephemeral = true;
            try {
                this.rebuild(null, instanceDescriptor, false);
            }
            catch (UpdateFailedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    void write(XMLWriter writer) throws IOException {
        if (!this._ephemeral) {
            TemplateDescriptor templateDescriptor = this.getRoot().findServerTemplateDescriptor(this._descriptor.template);
            LinkedList attributes = ServerInstance.parameterValuesToAttributes(this._descriptor.parameterValues, templateDescriptor.parameters);
            attributes.addFirst(ServerInstance.createAttribute("template", this._descriptor.template));
            if (this._descriptor.propertySet.references.length == 0 && this._descriptor.propertySet.properties.size() == 0 && this._children.size() == 0) {
                writer.writeElement("server-instance", attributes);
            } else {
                writer.writeStartTag("server-instance", attributes);
                ServerInstance.writePropertySet(writer, this._descriptor.propertySet, null, null);
                Iterator p = this._children.iterator();
                while (p.hasNext()) {
                    PropertySet ps = (PropertySet)p.next();
                    ps.write(writer);
                }
                writer.writeEndTag("server-instance");
            }
        }
    }

    void isIceBox(boolean newValue) {
        if (newValue != this._isIceBox) {
            this._isIceBox = newValue;
            this._children.clear();
            this.getRoot().getTreeModel().nodeStructureChanged(this);
        }
    }

    public Object rebuild(List editables) throws UpdateFailedException {
        ServerInstance newServer;
        Node node = (Node)this._parent;
        Backup backup = new Backup(node.getEditable().save());
        TemplateDescriptor templateDescriptor = this.getRoot().findServerTemplateDescriptor(this._descriptor.template);
        HashSet parameters = new HashSet(templateDescriptor.parameters);
        if (!((Object)parameters).equals(this._descriptor.parameterValues.keySet())) {
            backup.parameterValues = this._descriptor.parameterValues;
            this._descriptor.parameterValues = Editor.makeParameterValues(this._descriptor.parameterValues, templateDescriptor.parameters);
        }
        if (this._id.equals((newServer = node.createServer(false, this._descriptor)).getId())) {
            block9: {
                if (this._editable.isModified()) {
                    newServer.getEditable().markModified();
                }
                node.removeServer(this);
                try {
                    node.insertServer(newServer, true);
                }
                catch (UpdateFailedException e) {
                    if ($assertionsDisabled) break block9;
                    throw new AssertionError();
                }
            }
            if (backup.parameterValues != null) {
                editables.add(newServer.getEditable());
            }
        } else {
            newServer.getEditable().markNew();
            node.removeServer(this);
            node.getEditable().removeElement(this._id, this._editable, Server.class);
            try {
                node.insertServer(newServer, true);
            }
            catch (UpdateFailedException e) {
                this.restore(backup);
                throw e;
            }
        }
        return backup;
    }

    public void restore(Object backupObj) {
        block4: {
            TreeNode badServer;
            Backup backup = (Backup)backupObj;
            Node node = (Node)this._parent;
            node.getEditable().restore(backup.nodeEditable);
            if (backup.parameterValues != null) {
                this._descriptor.parameterValues = backup.parameterValues;
            }
            if ((badServer = node.findChildWithDescriptor(this._descriptor)) != null) {
                node.removeServer(badServer);
            }
            try {
                node.insertServer(this, true);
            }
            catch (UpdateFailedException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    public void tryAdd(String unsubstitutedId, PropertySetDescriptor descriptor) throws UpdateFailedException {
        this.insertPropertySet(new PropertySet(this, Utils.substitute(unsubstitutedId, this._resolver), unsubstitutedId, descriptor), true);
        this._descriptor.servicePropertySets.put(unsubstitutedId, descriptor);
        this._editable.markModified();
    }

    public void tryRename(String oldId, String oldUnresolvedId, String newUnsubstitutedId) throws UpdateFailedException {
        PropertySet oldChild = (PropertySet)this.findChild(oldId);
        if (!$assertionsDisabled && oldChild == null) {
            throw new AssertionError();
        }
        this.removePropertySet(oldChild);
        PropertySetDescriptor descriptor = (PropertySetDescriptor)oldChild.getDescriptor();
        try {
            this.insertPropertySet(new PropertySet(this, Utils.substitute(newUnsubstitutedId, this._resolver), newUnsubstitutedId, descriptor), true);
        }
        catch (UpdateFailedException ex) {
            block5: {
                try {
                    this.insertPropertySet(oldChild, true);
                }
                catch (UpdateFailedException ufe) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError();
                }
            }
            throw ex;
        }
        this._editable.markModified();
        this._descriptor.servicePropertySets.remove(oldUnresolvedId);
        this._descriptor.servicePropertySets.put(newUnsubstitutedId, descriptor);
    }

    public void insertPropertySet(PropertySet nps, boolean fireEvent) throws UpdateFailedException {
        this.insertChild(nps, fireEvent);
    }

    public void removePropertySet(PropertySet nps) {
        this.removeChild(nps);
    }

    public void removeDescriptor(String unsubstitutedId) {
        this._descriptor.servicePropertySets.remove(unsubstitutedId);
    }

    public Editable getEditable() {
        return this._editable;
    }

    Object[] getServiceNames() {
        if (!$assertionsDisabled && !this._isIceBox) {
            throw new AssertionError();
        }
        Communicator.Services services = this.getRoot().findServerTemplate(this._descriptor.template).getServices();
        Object[] result = new Object[services.size()];
        int i = 0;
        Iterator p = services.iterator();
        while (p.hasNext()) {
            TreeNode n = (TreeNode)p.next();
            ServiceInstanceDescriptor d = (ServiceInstanceDescriptor)n.getDescriptor();
            if (d.template.length() > 0) {
                TemplateDescriptor templateDescriptor = this.getRoot().findServiceTemplateDescriptor(d.template);
                if (!$assertionsDisabled && templateDescriptor == null) {
                    throw new AssertionError();
                }
                Utils.Resolver serviceResolver = new Utils.Resolver(this._resolver, d.parameterValues, templateDescriptor.parameterDefaults);
                ServiceDescriptor serviceDescriptor = (ServiceDescriptor)templateDescriptor.descriptor;
                result[i++] = serviceResolver.substitute(serviceDescriptor.name);
                continue;
            }
            result[i++] = this._resolver.substitute(d.descriptor.name);
        }
        return result;
    }

    void rebuild(Utils.Resolver resolver, ServerInstanceDescriptor instanceDescriptor, boolean isIceBox) throws UpdateFailedException {
        this._resolver = resolver;
        this._isIceBox = isIceBox;
        this._descriptor = instanceDescriptor;
        this._children.clear();
        Iterator p = this._descriptor.servicePropertySets.entrySet().iterator();
        while (p.hasNext()) {
            Map.Entry entry = p.next();
            String unsubstitutedId = (String)entry.getKey();
            this.insertPropertySet(new PropertySet(this, Utils.substitute(unsubstitutedId, this._resolver), unsubstitutedId, (PropertySetDescriptor)entry.getValue()), false);
        }
    }

    private void newPropertySet(PropertySetDescriptor descriptor) {
        PropertySet ps;
        block2: {
            String id = this.makeNewChildId("Service");
            ps = new PropertySet(this, id, descriptor);
            try {
                this.insertChild(ps, true);
            }
            catch (UpdateFailedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.getRoot().setSelectedNode(ps);
    }

    Utils.Resolver getResolver() {
        return this._resolver;
    }

    public boolean isEphemeral() {
        return this._ephemeral;
    }

    public String toString() {
        if (this._ephemeral) {
            return super.toString();
        }
        return this._id + ": " + this._descriptor.template + "<>";
    }

    static {
        $assertionsDisabled = !ServerInstance.class.desiredAssertionStatus();
    }

    private static class Backup {
        Editable nodeEditable;
        Map parameterValues;

        Backup(Editable ne) {
            this.nodeEditable = ne;
        }
    }
}

