/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.DNSException;
import Ice.EndpointParseException;
import IceInternal.Acceptor;
import IceInternal.BasicStream;
import IceInternal.Connector;
import IceInternal.EndpointI;
import IceInternal.EndpointIHolder;
import IceInternal.Instance;
import IceInternal.Network;
import IceInternal.TcpAcceptor;
import IceInternal.TcpConnector;
import IceInternal.Transceiver;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Iterator;

final class TcpEndpointI
extends EndpointI {
    static final short TYPE = 1;
    private Instance _instance;
    private String _host;
    private int _port;
    private int _timeout;
    private String _connectionId = "";
    private boolean _compress;
    private boolean _publish;
    private int _hashCode;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TcpEndpointI(Instance instance, String ho, int po, int ti, String conId, boolean co, boolean pub) {
        this._instance = instance;
        this._host = ho;
        this._port = po;
        this._timeout = ti;
        this._connectionId = conId;
        this._compress = co;
        this._publish = pub;
        this.calcHashValue();
    }

    public TcpEndpointI(Instance instance, String str) {
        this._instance = instance;
        this._host = null;
        this._port = 0;
        this._timeout = -1;
        this._compress = false;
        this._publish = true;
        String[] arr = str.split("[ \t\n\r]+");
        int i = 0;
        block10: while (i < arr.length) {
            String option;
            if (arr[i].length() == 0) {
                ++i;
                continue;
            }
            if ((option = arr[i++]).length() != 2 || option.charAt(0) != '-') {
                throw new EndpointParseException("tcp " + str);
            }
            String argument = null;
            if (i < arr.length && arr[i].charAt(0) != '-') {
                argument = arr[i++];
            }
            switch (option.charAt(1)) {
                case 'h': {
                    if (argument == null) {
                        throw new EndpointParseException("tcp " + str);
                    }
                    this._host = argument;
                    continue block10;
                }
                case 'p': {
                    if (argument == null) {
                        throw new EndpointParseException("tcp " + str);
                    }
                    try {
                        this._port = Integer.parseInt(argument);
                    }
                    catch (NumberFormatException ex) {
                        throw new EndpointParseException("tcp " + str);
                    }
                    if (this._port >= 0 && this._port <= 65535) continue block10;
                    throw new EndpointParseException("tcp " + str);
                }
                case 't': {
                    if (argument == null) {
                        throw new EndpointParseException("tcp " + str);
                    }
                    try {
                        this._timeout = Integer.parseInt(argument);
                        continue block10;
                    }
                    catch (NumberFormatException ex) {
                        throw new EndpointParseException("tcp " + str);
                    }
                }
                case 'z': {
                    if (argument != null) {
                        throw new EndpointParseException("tcp " + str);
                    }
                    this._compress = true;
                    continue block10;
                }
            }
            throw new EndpointParseException("tcp " + str);
        }
    }

    public TcpEndpointI(BasicStream s) {
        this._instance = s.instance();
        s.startReadEncaps();
        this._host = s.readString();
        this._port = s.readInt();
        this._timeout = s.readInt();
        this._compress = s.readBool();
        s.endReadEncaps();
        this._publish = true;
        this.calcHashValue();
    }

    public void streamWrite(BasicStream s) {
        s.writeShort((short)1);
        s.startWriteEncaps();
        s.writeString(this._host);
        s.writeInt(this._port);
        s.writeInt(this._timeout);
        s.writeBool(this._compress);
        s.endWriteEncaps();
    }

    public String _toString() {
        String s = "tcp -h " + this._host + " -p " + this._port;
        if (this._timeout != -1) {
            s = s + " -t " + this._timeout;
        }
        if (this._compress) {
            s = s + " -z";
        }
        return s;
    }

    public short type() {
        return 1;
    }

    public int timeout() {
        return this._timeout;
    }

    public EndpointI timeout(int timeout) {
        if (timeout == this._timeout) {
            return this;
        }
        return new TcpEndpointI(this._instance, this._host, this._port, timeout, this._connectionId, this._compress, this._publish);
    }

    public EndpointI connectionId(String connectionId) {
        if (connectionId.equals(this._connectionId)) {
            return this;
        }
        return new TcpEndpointI(this._instance, this._host, this._port, this._timeout, connectionId, this._compress, this._publish);
    }

    public boolean compress() {
        return this._compress;
    }

    public EndpointI compress(boolean compress) {
        if (compress == this._compress) {
            return this;
        }
        return new TcpEndpointI(this._instance, this._host, this._port, this._timeout, this._connectionId, compress, this._publish);
    }

    public boolean datagram() {
        return false;
    }

    public boolean secure() {
        return false;
    }

    public boolean unknown() {
        return false;
    }

    public Transceiver clientTransceiver() {
        return null;
    }

    public Transceiver serverTransceiver(EndpointIHolder endpoint) {
        endpoint.value = this;
        return null;
    }

    public Connector connector() {
        return new TcpConnector(this._instance, this._host, this._port);
    }

    public Acceptor acceptor(EndpointIHolder endpoint, String adapterName) {
        TcpAcceptor p = new TcpAcceptor(this._instance, this._host, this._port);
        endpoint.value = new TcpEndpointI(this._instance, this._host, p.effectivePort(), this._timeout, this._connectionId, this._compress, this._publish);
        return p;
    }

    public ArrayList expand(boolean server) {
        if (this._host == null) {
            this._host = this._instance.defaultsAndOverrides().defaultHost;
            if (this._host == null) {
                this._host = server ? "0.0.0.0" : "127.0.0.1";
            }
        } else if (this._host.equals("*")) {
            this._host = "0.0.0.0";
        }
        ArrayList<TcpEndpointI> endps = new ArrayList<TcpEndpointI>();
        if (this._host.equals("0.0.0.0")) {
            ArrayList hosts = Network.getLocalHosts();
            Iterator iter = hosts.iterator();
            while (iter.hasNext()) {
                String host = (String)iter.next();
                endps.add(new TcpEndpointI(this._instance, host, this._port, this._timeout, this._connectionId, this._compress, hosts.size() == 1 || !host.equals("127.0.0.1")));
            }
        } else {
            this.calcHashValue();
            endps.add(this);
        }
        return endps;
    }

    public boolean publish() {
        return this._publish;
    }

    public boolean equivalent(Transceiver transceiver) {
        return false;
    }

    public boolean equivalent(Acceptor acceptor) {
        TcpAcceptor tcpAcceptor = null;
        try {
            tcpAcceptor = (TcpAcceptor)acceptor;
        }
        catch (ClassCastException ex) {
            return false;
        }
        return tcpAcceptor.equivalent(this._host, this._port);
    }

    public int hashCode() {
        return this._hashCode;
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public int compareTo(Object obj) {
        TcpEndpointI p = null;
        try {
            p = (TcpEndpointI)obj;
        }
        catch (ClassCastException ex) {
            return 1;
        }
        if (this == p) {
            return 0;
        }
        if (this._port < p._port) {
            return -1;
        }
        if (p._port < this._port) {
            return 1;
        }
        if (this._timeout < p._timeout) {
            return -1;
        }
        if (p._timeout < this._timeout) {
            return 1;
        }
        if (!this._connectionId.equals(p._connectionId)) {
            return this._connectionId.compareTo(p._connectionId);
        }
        if (!this._compress && p._compress) {
            return -1;
        }
        if (!p._compress && this._compress) {
            return 1;
        }
        if (!this._host.equals(p._host)) {
            InetSocketAddress laddr = null;
            try {
                laddr = Network.getAddress(this._host, this._port);
            }
            catch (DNSException ex) {
                // empty catch block
            }
            InetSocketAddress raddr = null;
            try {
                raddr = Network.getAddress(p._host, p._port);
            }
            catch (DNSException ex) {
                // empty catch block
            }
            if (laddr == null && raddr != null) {
                return -1;
            }
            if (raddr == null && laddr != null) {
                return 1;
            }
            if (laddr != null && raddr != null) {
                byte[] larr = laddr.getAddress().getAddress();
                byte[] rarr = raddr.getAddress().getAddress();
                if (!$assertionsDisabled && larr.length != rarr.length) {
                    throw new AssertionError();
                }
                for (int i = 0; i < larr.length; ++i) {
                    if (larr[i] < rarr[i]) {
                        return -1;
                    }
                    if (rarr[i] >= larr[i]) continue;
                    return 1;
                }
            }
        }
        return 0;
    }

    public boolean requiresThreadPerConnection() {
        return false;
    }

    private void calcHashValue() {
        try {
            InetSocketAddress addr = Network.getAddress(this._host, this._port);
            this._hashCode = addr.getAddress().getHostAddress().hashCode();
        }
        catch (DNSException ex) {
            this._hashCode = this._host.hashCode();
        }
        this._hashCode = 5 * this._hashCode + this._port;
        this._hashCode = 5 * this._hashCode + this._timeout;
        this._hashCode = 5 * this._hashCode + this._connectionId.hashCode();
        this._hashCode = 5 * this._hashCode + (this._compress ? 1 : 0);
    }

    static {
        $assertionsDisabled = !TcpEndpointI.class.desiredAssertionStatus();
    }
}

