/* cfengine for GNU
 
        Copyright (C) 1995
        Free Software Foundation, Inc.
 
   This file is part of GNU cfengine - written and maintained 
   by Mark Burgess, Dept of Computing and Engineering, Oslo College,
   Dept. of Theoretical physics, University of Oslo
 
   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any
   later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA

*/
 

/*********************************************************************/
/*                                                                   */
/*  Repository handler                                               */
/*                                                                   */
/*********************************************************************/

#include "cf.defs.h"
#include "cf.extern.h"
#include "../pub/global.h"
#include "../pub/md5.h"

/*********************************************************************/

Repository(file)

char *file;

{ char buffer[bufsize];
  char node[maxlinksize];
  struct stat sstat, dstat;
  char *sp;
  struct Image dummy;
  short imagecopy;

if (!IMAGEBACKUP)
   {
   return true;
   }

if (IsItemIn(VREPOSLIST,file))
   {
   return true;
   }

PrependItem(&VREPOSLIST,file,NULL);

if (VREPOSITORY[0] == '\0' || HOMECOPY)
   {
   return false;
   }

Debug2("Repository(%s)\n",file);

strcpy (node,file);

buffer[0] = '\0';

for (sp = node; *sp != '\0'; sp++)
   {
   if (*sp == '/')
      {
      *sp = REPOSCHAR;
      }
   }

strcpy(buffer,VREPOSITORY);
AddSlash(buffer);

if (BufferOverflow(buffer,node))
   {
   printf("culprit: Repository()\n");
   return false;
   }

strcat(buffer,node);

MakeDirectoriesFor(buffer);

if (stat(file,&sstat) == -1)
   {
   Debug2("Repository file %s not there\n",file);
   return true;
   }

stat(buffer,&dstat);

imagecopy = IMAGEBACKUP;   /* without this there would be loop between this */
IMAGEBACKUP = false;       /* and Repository */

dummy.server = "localhost";
dummy.inode_cache = NULL;
dummy.cache = NULL;

CheckForHoles(&sstat,&dummy);

if (CopyReg(file,buffer,sstat,dstat,&dummy))
   {
   IMAGEBACKUP = imagecopy;
   Verbose("%s: Backed up to repository %s\n",VPREFIX,buffer);
   return true;
   }
else
   {
   IMAGEBACKUP = imagecopy;
   return false;
   }
}

