/*
 * MainGame.cs - Main entry point and main window for Mahjongg.
 *
 * Copyright (C) 2003  Southern Storm Software, Pty Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

namespace Mahjongg
{

using System;
using Qt;

public sealed class MainGame : QMainWindow
{
    // Internal state.
    private QMenuBar menubar;
    private QPopupMenu filemenu;
    private QPopupMenu aboutmenu;
    private TileSet tiles;
    private Board board;
    private QColor backgroundColor;
    private QBrush background;
    private ViewBoard viewBoard;

    // Constructor.
    public MainGame() : base(null, null)
	    	{
				// Create the game objects.
				tiles = new TileSet("tiles.png");
				board = new Board();
				backgroundColor = new QColor(0x00, 0x90, 0x00);
				background = new QBrush(backgroundColor);

				// Set up the user interface.
				filemenu = new QPopupMenu(null, "filemenu");
				filemenu.InsertItem("&New Game", this, SLOT ("SlotNewGame()"));
				filemenu.InsertItem("&Quit", qApp, SLOT ("quit()"));
	
				aboutmenu = new QPopupMenu(null, "helpmenu");
				aboutmenu.InsertItem("&About Mahjongg", this, SLOT ("SlotAboutMahjongg()"));
				aboutmenu.InsertSeparator ();
				aboutmenu.InsertItem("About Qt-Sharp", this, SLOT ("SlotAboutQtSharp()"));
				aboutmenu.InsertItem("About Qt", this, SLOT ("SlotAboutQt()"));

				menubar = new QMenuBar(this, "");
				menubar.InsertItem("&File", filemenu);
				menubar.InsertItem("&About", aboutmenu);

				viewBoard = new ViewBoard(this, board, tiles, background);
				viewBoard.SetBackgroundColor(backgroundColor);
				this.SetCentralWidget(viewBoard);

				SetGeometry(0, 0, 600, 500);
				SetMaximumSize(Width(), Height());
	    	}

    public void SlotNewGame ()
			{
				board.Init();
				viewBoard.PerformPaint(null);
			}

    public void SlotAboutMahjongg ()
	    	{
				QMessageBox.Information (this, "About Qt# Mahjongg",
											"(c) 2003 Southern Storm Software, Pty Ltd.  Licensed under the terms of the GNU GPL.\n"
											);
	    	}

    public void SlotAboutQtSharp ()
	    	{
				QMessageBox.Information (this, "About Qt# 0.6",
											"A Qt (http://www.trolltech.com) to C# language binding. \n" +
											"Qt# is compatible with Mono (http://go-mono.org) and\n" +
											"Portable.NET (http://www.southern-storm.com.au/portable_net.html)\n" +
											"(c) 2002 Adam Treat. Licensed under the terms of the GNU GPL.\n"
											);
	    	}

    public void SlotAboutQt ()
	    	{
				QMessageBox.AboutQt (this, "About Qt");
	    	}

    // Main entry point for the application.
    public static void Main(String[] args)
	    	{
				QApplication app = new QApplication (args);
				MainGame main = new MainGame ();
				app.SetMainWidget (main);
				main.SetCaption("Qt# Mahjongg");
				main.Show ();
				app.Exec ();
	    	}

}; // class MainGame

}; // namespace Mahjongg
