/*
 * Tile.cs - List of tiles.
 *
 * Copyright (C) 2003  Southern Storm Software, Pty Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

namespace Mahjongg
{

public enum Tile
{

    // "Character" suit.
    Char_1,
    Char_2,
    Char_3,
    Char_4,
    Char_5,
    Char_6,
    Char_7,
    Char_8,
    Char_9,

    // "Wheel" suit.
    Wheel_1,
    Wheel_2,
    Wheel_3,
    Wheel_4,
    Wheel_5,
    Wheel_6,
    Wheel_7,
    Wheel_8,
    Wheel_9,

    // "Bamboo" suit.
    Bamboo_1,
    Bamboo_2,
    Bamboo_3,
    Bamboo_4,
    Bamboo_5,
    Bamboo_6,
    Bamboo_7,
    Bamboo_8,
    Bamboo_9,

    // Seasons.
    Season_1,
    Season_2,
    Season_3,
    Season_4,

    // Winds.
    Wind_North,
    Wind_South,
    Wind_East,
    Wind_West,

    // Dragons.
    Dragon_Green,
    Dragon_Red,
    Dragon_White,

    // Flowers.
    Flower_1,
    Flower_2,
    Flower_3,
    Flower_4,

    // Special values.
    None,		// "no tile here"
    TilePartLeft,	// Tile to the left of here.
    TilePartUp,		// Tile above here.
    TilePartLeftUp,	// Tile to the left and above.

    // Minimum and maximum values.
    Min = Char_1,
    Max = Flower_4

}; // class Tile

}; // namespace Mahjongg
