.\" Copyright 1999 Oracle and/or its affiliates. All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbGetAutoResetControls __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbGetAutoResetControls \- Gets the current values of the auto-reset controls
.SH SYNOPSIS
.HP
.B Bool XkbGetAutoResetControls
.BI "(\^Display *" "dpy" "\^,"
.BI "unsigned int  *" "auto_ctrls" "\^,"
.BI "unsigned int  *" "auto_values" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- dpy
 connection to X server
.TP
.I \- auto_ctrls
 specifies which bits in auto_values are relevant
.TP
.I \- auto_values
1 bit => corresponding control has auto-reset on
.SH DESCRIPTION
.LP
You can configure the boolean controls to automatically be enabled or 
disabled when a program exits. This capability is controlled via two masks 
maintained in the X server on a per-client basis. There is no client-side Xkb 
data structure corresponding to these masks. Whenever the client exits for 
any reason, any boolean controls specified in the 
.I auto-reset mask 
are set to the corresponding value from the 
.I auto-reset values 
mask. This makes it 
possible for clients to "clean up after themselves" automatically, even if 
abnormally terminated. The bits used in the masks correspond to the 
EnabledControls control bits.

For example, a client that replaces the keyboard bell with some other audible 
cue might want to turn off the AudibleBell control to prevent the server from 
also generating a sound and avoid cacophony. If the client were to exit 
without resetting the AudibleBell control, the user would be left without any 
feedback at all. Setting AudibleBell in both the auto-reset mask and 
auto-reset values guarantees that the audible bell will be turned back on 
when the client exits.

.I XkbGetAutoResetControls 
backfills 
.I auto_ctrls 
and 
.I auto_values 
with the AutoReset control attributes for this particular client. It returns 
True if successful, and False otherwise.
.SH "RETURN VALUES"
.TP 15
True
The 
.I XkbGetAutoResetControls 
function returns True when it successfully backfills 
.I auto_ctrls 
and 
.I auto_values 
with the AutoReset control attributes for this particular client.
.TP 15
False
The 
.I XkbGetAutoResetControls 
function returns False when it does not successfully backfill
.I auto_ctrls 
and 
.I auto_values 
with the AutoReset control attributes for this particular client.
