.\" dpkg manual page - deb-control(5)
.\"
.\" Copyright © 1995 Raul Miller, Ian Jackson, Ian Murdock
.\" Copyright © 1999 Ben Collins <bcollins@debian.org>
.\" Copyright © 2000 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2007-2011, 2013-2015 Guillem Jover <guillem@debian.org>
.\" Copyright © 2008-2012 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH deb\-control 5 %RELEASE_DATE% %VERSION% dpkg\-suite
.nh
.SH NAAM
deb\-control \- Indeling van het hoofdcontrolebestand van de Debian binaire
pakketten
.
.SH OVERZICHT
control
.
.SH BESCHRIJVING
Elk Debian binair pakket bevat een hoofdcontrolebestand \fIcontrol\fP, dat uit
een aantal velden bestaat. Ieder veld begint met een markering, zoals
\fBPackage\fP of \fBVersion\fP (niet hoofdlettergevoelig), gevolgd door een
dubbele punt en de tekstinhoud van het veld. Velden worden enkel door
veldmarkeringen begrensd. De tekstinhoud van het veld kan met andere woorden
verschillende regels lang zijn, maar de installatiegereedschappen zullen bij
het verwerken van de tekstinhoud de regels gewoonlijk samenvoegen (behalve
voor het veld \fBDescription\fP; zie hierna)
.
.SH VELDEN
.TP 
\fBPackage:\fP \fIpakketnaam\fP (verplicht)
De waarde van dit veld bepaalt de pakketnaam en wordt door de meeste
installatiegereedschappen gebruikt om bestandsnamen te genereren.
.TP 
\fBVersion:\fP \fIversie\-tekenreeks\fP (verplicht)
Gewoonlijk is dit het originele versienummer van het pakket, welke vorm de
auteur van het programma er ook aan geeft. Het kan ook een
Debian\-revisienummer bevatten (voor niet uit Debian stammende pakketten). De
exacte indeling en het sorteringsalgoritme worden beschreven in
\fBdeb\-version\fP(5).
.TP 
\fBMaintainer:\fP \fIvolledige\-naam\-en\-e\-mail\fP (aanbevolen)
Moet opgemaakt worden volgens de indeling “Joe Bloggs
<jbloggs@foo.com>”, en is gewoonlijk de persoon die het pakket
maakte, in tegenstelling tot de auteur van de verpakte software.
.TP 
\fBDescription:\fP \fIkorte\-beschrijving\fP (aanbevolen)
.TQ
\fB \fP\fIuitgebreide\-beschrijving\fP
.br
De indeling van een pakketbeschrijving bestaat uit een beknopte korte
samenvatting op de eerste regel (na de veldmarkering \fBDescription\fP) en een
langere meer gedetailleerde beschrijving op de volgende regels. Elke regel
van de uitgebreide beschrijving moet voorafgegaan worden door een spatie, en
lege regels in de uitgebreide beschrijving moeten één enkele ‘\fB.\fP’ bevatten
die volgt op de eraan voorafgaande spatie.
.TP 
\fBSection:\fP\fI sectie\fP
Dit is een veld van algemene aard dat het pakket in een categorie
onderbrengt op basis van de software die het installeert. Enkele
gebruikelijke secties zijn \fButils\fP, \fBnet\fP, \fBmail\fP, \fBtext\fP, \fBx11\fP, enz.
.TP 
\fBPriority:\fP\fI prioriteit\fP
Duidt het belang van dit pakket aan in verhouding tot het gehele
systeem. Gebruikelijke prioriteiten zijn \fBrequired\fP, \fBstandard\fP,
\fBoptional\fP, \fBextra\fP, enz.
.LP
De velden \fBSection\fP en \fBPriority\fP hebben gewoonlijk een welbepaalde set
mogelijke waarden, afhankelijk van de richtlijnen van de distributie.
.
.TP 
\fBInstalled\-Size:\fP grootte
Bij benadering de totale grootte van de door het pakket geïnstalleerde
bestanden, uitgedrukt in KiB.
.
.TP 
\fBEssential:\fP \fByes\fP|\fBno\fP
Meestal is dit veld enkel nodig als het antwoord \fByes\fP is. Het duidt een
pakket aan dat vereist is opdat het systeem behoorlijk zou
functioneren. Dpkg of om het even welk ander installatiegereedschap zal niet
toestaan dat een pakket van het type \fBEssential\fP verwijderd wordt
(tenminste niet zonder dat één van de forceeropties gebruikt wordt).
.TP 
\fBBuild\-Essential:\fP \fByes\fP|\fBno\fP
Meestal is dit veld enkel nodig als het antwoord \fByes\fP is en het wordt
gewoonlijk ingevoegd door de archiefsoftware. Het duidt een pakket aan dat
vereist is voor het bouwen van andere pakketten.
.TP 
\fBArchitecture:\fP \fIarch\fP|\fBall\fP (aanbevolen)
De architectuur geeft aan voor welk type hardware dit pakket gecompileerd
werd. Gebruikelijke architecturen zijn \fBamd64\fP, \fBarmel\fP, \fBi386\fP,
\fBpowerpc\fP, enz. Merk op dat de waarde \fBall\fP bedoeld is voor pakketten die
architectuuronafhankelijk zijn. Enkele voorbeelden hiervan zijn shell\- en
Perl\-scripts en documentatie.
.TP 
\fBOrigin:\fP\fI naam\fP
De naam van de distributie waaruit dit pakket afkomstig is.
.TP 
\fBBugs:\fP\fI URL\fP
De \fIURL\fP van het opvolgingssysteem voor bugs van dit pakket. De indeling
die momenteel gebruikt wordt is \fIbts\-type\fP\fB://\fP\fIbts\-adres\fP, zoals
\fBdebbugs://bugs.debian.org\fP.
.TP 
\fBHomepage:\fP\fI URL\fP
De \fIURL\fP van de homepage van het toeleverend project (upstream).
.TP 
\fBTag:\fP\fI lijst\-van\-markeringen\fP
Lijst van markeringen (tags) die de eigenschappen van het pakket
beschrijven. De beschrijving en de lijst van ondersteunde markeringen/tags
is te vinden in het pakket \fBdebtags\fP.
.TP 
\fBMulti\-Arch:\fP \fBno\fP|\fBsame\fP|\fBforeign\fP|\fBallowed\fP
Dit veld wordt gebruikt om aan te geven hoe dit pakket zich moet gedragen op
een multi\-arch installatie.
.RS
.TP 
\fBno\fP
Dit is de standaardwaarde als dit veld weggelaten werd. Dit veld toevoegen
met een expliciete waarde \fBno\fP is over het algemeen niet nodig.
.TP 
\fBsame\fP
Dit pakket is co\-installeerbaar met zichzelf, maar het kan niet gebruikt
worden om te voldoen aan een vereiste van een pakket dat tot een andere
architectuur behoort.
.TP 
\fBforeign\fP
Dit pakket is niet co\-installeerbaar met zichzelf, maar het mag wel de
toestemming krijgen om te voldoen aan een architectuurkwalificatieloze
vereiste van een pakket dat tot een andere architectuur behoort (indien een
vereiste wel een expliciete architectuurkwalificatie heeft, wordt de waarde
\fBforeign\fP genegeerd).
.TP 
\fBallowed\fP
Dit laat pakketten die dit pakket als vereiste hebben (reverse\-dependencies)
toe om in hun \fBDepends\fP\-veld aan te geven dat ze dit pakket ook van een
andere architectuur aanvaarden door bij de pakketnaam de kwalificatie
\fB:any\fP te vermelden. Anders blijft dit zonder effect.
.RE
.TP 
\fBSource:\fP \fIbroncode\-naam\fP [\fB(\fP\fIbroncode\-versie\fP\fB)\fP]
De naam van het broncodepakket waaruit dit binaire pakket afkomstig is,
indien die verschillend is van de naam van het pakket zelf. Indien de versie
van het broncodepakket verschilt van de versie van het binaire pakket, dan
zal de \fIbroncode\-naam\fP gevolgd worden door een \fIbroncode\-versie\fP tussen
haakjes. Dit kan het geval zijn als de upload een uitsluitend binaire upload
is die niet door de onderhouder uitgevoerd wordt, of wanneer via
«\fBdpkg\-gencontrol \-v\fP» voor het binaire pakket een verschillend
versienummer ingesteld wordt.
.TP 
\fBSubarchitecture:\fP\fI waarde\fP
.TQ
\fBKernel\-Version:\fP\fI waarde\fP
.TQ
\fBInstaller\-Menu\-Item:\fP\fI waarde\fP
Deze velden worden door het installatieprogramma van Debian gebruikt en zijn
meestal niet nodig. Zie voor meer details over deze velden
/usr/share/doc/debian\-installer/devel/modules.txt uit het pakket
\fBdebian\-installer\fP.

.TP 
\fBDepends:\fP\fI pakketlijst\fP
Lijst van de pakketten die dit pakket nodig heeft om meer dan een
onbeduidende functionaliteit te kunnen bieden. Software voor pakketbeheer
zal niet toelaten dat een pakket geïnstalleerd wordt zonder dat de pakketten
die in zijn veld \fBDepends\fP vermeld worden, geïnstalleerd worden (tenminste
niet zonder het gebruik van forceeropties). Tijdens een installatie wordt
het postinst\-script van pakketten die in het veld \fBDepends\fP vermeld worden,
uitgevoerd voor dat van het pakket dat van hen afhankelijk is. Bij het
verwijderen van een dergelijk pakket daarentegen wordt het prerm\-script van
dat pakket uitgevoerd voor die van pakketten die in zijn veld \fBDepends\fP
vermeld staan.
.TP 
\fBPre\-Depends:\fP\fI pakketlijst\fP
Lijst van de pakketten die geïnstalleerd \fBen\fP geconfigureerd moeten zijn
vooraleer dit pakket geïnstalleerd kan worden. Dit wordt meestal gebruikt in
een geval waarin dit pakket een ander pakket nodig heeft om zijn
preinst\-script te kunnen uitvoeren.
.TP 
\fBRecommends:\fP\fI pakketlijst\fP
Bevat een lijst van pakketten die samen met dit pakket aangetroffen worden
op alle behalve ongewone installaties. Software voor pakketbeheer zal de
gebruiker waarschuwen als die een pakket installeert zonder die welke
vermeld worden in zijn veld \fBRecommends\fP.
.TP 
\fBSuggests:\fP\fI pakketlijst\fP
Bevat een lijst van pakketten die gerelateerd zijn aan dit pakket en
mogelijks de  bruikbaarheid ervan kunnen vergroten, hoewel het perfect
acceptabel is om het zonder die pakketten te installeren.
.LP
De syntaxis van de velden \fBDepends\fP, \fBPre\-Depends\fP, \fBRecommends\fP en
\fBSuggests\fP is een lijst van groepen van alternatieve pakketten. Elke groep
is een lijst van pakketten die onderling gescheiden zijn door het symbool
verticale streep (of “pijp”), ‘\fB|\fP’. De groepen worden onderling gescheiden
door komma's. Een komma moet geïnterpreteerd worden als een “AND” en een
pijp als een “OR”, waarbij pijpen de sterkste binding hebben. Elke
pakketnaam kan facultatief gevolgd worden door een architectuurkwalificatie,
die toegevoegd wordt na een dubbele punt ‘\fB:\fP’, facultatief gevolgd door de
aanduiding van een versienummer tussen haakjes.
.LP
De naam van een architectuurkwalificatie kan echte Debian\-architectuurnaam
zijn (sinds dpkg 1.16.5) of \fBany\fP (sinds dpkg 1.16.2). Indien ze weggelaten
is, is ze standaard de architectuur van het huidige binaire pakket. Een
echte Debian\-architectuurnaam komt exact overeen met die architectuur voor
die pakketnaam; \fBany\fP komt overeen met om het even welke architectuur voor
die pakketnaam als het pakket gemarkeerd werd als \fBMulti\-Arch: allowed\fP.
.LP
Een versienummer kan beginnen met een ‘\fB>>\fP’. In dat geval levert
dit met alle latere versies een overeenkomst op. Een versienummer kan al dan
niet ook een Debian\-pakketrevisie bevatten (met een koppelteken tussen
versienummer en Debian\-pakketrevisie). Toegestane versierelaties zijn
‘\fB>>\fP’ voor hoger dan, ‘\fB<<\fP’ voor lager dan, ‘\fB>=\fP’
voor hoger of gelijk aan, ‘\fB<=\fP’ voor lager of gelijk aan en ‘\fB=\fP’
voor gelijk aan.
.TP 
\fBBreaks:\fP\fI pakketlijst\fP
Bevat een lijst van pakketten die door dit pakket defect gemaakt worden,
bijvoorbeeld door ze bloot te stellen aan bugs indien de vermelde pakketten
op dit pakket zouden rekenen. Software voor pakketonderhoud zal het
configureren van defecte pakketten niet toestaan. Meestal bestaat de
oplossing erin de pakketten die in het veld \fBBreaks\fP vermeld worden, op te
waarderen.
.TP 
\fBConflicts:\fP\fI pakketlijst\fP
Bevat een lijst van pakketten die in tegenstrijd/conflict zijn met dit
pakket, bijvoorbeeld omdat ze bestanden met eenzelfde naam
bevatten. Software voor pakketonderhoud zal niet toestaan dat tegenstrijdige
pakketten tegelijkertijd geïnstalleerd zijn. Twee tegenstrijdige pakketten
moeten elk een \fBConflicts\fP\-regel bevatten met daarin de vermelding van het
andere pakket.
.TP 
\fBReplaces:\fP\fI pakketlijst\fP
Lijst van pakketbestanden die door dit pakket vervangen worden. Dit wordt
gebruikt om dit pakket de toelating te geven om bestanden uit een ander
pakket te overschrijven. Het wordt gewoonlijk gebruikt samen met het veld
\fBConflicts\fP om het verwijderen van het andere pakket af te dwingen als dit
pakket dezelfde bestanden bevat als het pakket waarmee dit pakket in
tegenstrijd is.
.LP
De syntaxis van \fBBreaks\fP, \fBConflicts\fP en \fBReplaces\fP is een lijst van met
komma's (en facultatieve witruimte) gescheiden pakketnamen. In de velden
\fBBreaks\fP en \fBConflicts\fP moet de komma geïnterpreteerd worden als een
“OR”. Facultatief kan ook een architectuurkwalificatie toegevoegd worden aan
de pakketnaam volgens dezelfde syntaxis als hierboven beschreven werd, maar
de standaardwaarde is \fBany\fP in plaats van de architectuur van het binaire
pakket. Ook kan bij de velden \fBBreaks\fP, \fBConflicts\fP en \fBReplaces\fP
facultatief een versienummer toegevoegd worden volgens dezelfde syntaxis als
hierboven werd beschreven.
.
.TP 
\fBProvides:\fP\fI pakketlijst\fP
Dit is een lijst van virtuele pakketten waarin door dit pakket voorzien
wordt. Gewoonlijk wordt dit gebruikt in het geval meerdere pakketten
dezelfde dienst leveren. Bijvoorbeeld kunnen sendmail en exim beide als
mailserver fungeren en daarom voorzien zij in een gemeenschappelijk pakket
(“mail\-transport\-agent”) waarvan andere pakketten afhankelijk kunnen
zijn. Dit laat sendmail of exim toe om te fungeren als een geldige optie om
aan die vereiste te voldoen. Hierdoor is het voor pakketten die een
mailserver nodig hebben niet nodig om van alle mailservers de pakketnaam te
kennen en ze, gescheiden door een ‘\fB|\fP’, allemaal te vermelden in een
lijst.
.LP
De syntaxis van \fBProvides\fP is een lijst van pakketnamen door komma's (en
facultatieve witruimte) van elkaar gescheiden. Facultatief kan ook een
architectuurkwalificatie toegevoegd worden aan de pakketnaam volgens
dezelfde syntaxis als hierboven beschreven werd. Indien dit weggelaten werd,
wordt standaard de architectuur genomen van het huidige binaire
pakket. Facultatief kan ook een exact (is gelijk aan) versienummer opgegeven
worden volgens dezelfde syntaxis als hierboven beschreven werd (gehonoreerd
sinds dpkg 1.17.11).
.
.TP 
\fBBuilt\-Using:\fP\fI pakketlijst\fP
Dit veld vermeldt extra broncodepakketten die gebruikt werden bij het bouwen
van dit binaire pakket. Dit is een indicatie voor de software voor
archiefonderhoud dat deze extra broncodepakketten behouden moeten blijven
zolang dit binaire pakket gehandhaafd wordt. Dit veld moet bestaan uit een
lijst van namen van broncodepakketten met een strikte ‘\fB=\fP’
versierelatie. Merk op dat de software voor archiefonderhoud niet geneigd
zal zijn om een upload te aanvaarden van een pakket dat verklaart een
\fBBuilt\-Using\fP\-relatie te hebben waaraan in het archief niet voldaan kan
worden.
.
.TP 
\fBBuilt\-For\-Profiles:\fP\fI profile\-list (obsolete)\fP
This field used to specify a whitespace separated list of build profiles
that this binary packages was built with (since dpkg 1.17.2 until 1.18.18).
The information previously found in this field can now be found in the
\&\fB.buildinfo\fP file, which supersedes it.
.
.TP 
\fBAuto\-Built\-Package:\fP\fI reason\-list\fP
This field specifies a whitespace separated list of reasons why this package
was auto\-generated.  Binary packages marked with this field will not appear
in the \fIdebian/control\fP master source control file.  The only currently
used reason is \fBdebug\-symbols\fP.
.
.SH VOORBEELD
.\" .RS
.nf
# Commentaar
Package: grep
Essential: yes
Priority: required
Section: base
Maintainer: Wichert Akkerman <wakkerma@debian.org>
Architecture: sparc
Version: 2.4\-1
Pre\-Depends: libc6 (>= 2.0.105)
Provides: rgrep
Conflicts: rgrep
Description: GNU grep, egrep en fgrep.
 De GNU familie van grep\-hulpprogramma's is misschien wel de "fastest grep in
 the west". GNU grep is gebaseerd op een snel `lazy\-state deterministic
 matcher' (ongeveer twee keer zo snel als een gewone Unix grep), gekruist met
 een Boyer\-Moore\-Gosper zoekalgoritme voor een vaste tekenreeks, hetgeen
 voorkomt dat niet\-voorkomende tekst wordt meegenomen in de volledige regexp
 zoekopdracht, zonder naar ieder teken te hoeven kijken. Het resultaat is
 gewoonlijk vele malen sneller dan Unix grep of egrep. (Maar reguliere
 expressies met terugverwijzingen zullen trager zijn.
.fi
.\" .RE
.
.SH "ZIE OOK"
\fBdeb\fP(5), \fBdeb\-version\fP(5), \fBdebtags\fP(1), \fBdpkg\fP(1), \fBdpkg\-deb\fP(1).
