#!/bin/sh

# This script is not as friendly as it could, but it should work.
# If you want to submit some changes, please mail me !
# LarryT, <tblksa at users dot sourceforge dot net>.
#

### This function is used to quit the script so the terminal is closed
function quit
{
        #####
        #       Function to ask a yes/no question
        #       Arguments:
        #               1       prompt string (optional)
        #####

        local q=

        while [ "$q" = "" ]; do
                echo -en "$1"
                read q
                case $q in
                        q|Q)    yn=1
                                exit ;;
                        *)      q=
                                echo -n $'\t' "Invalid response - please answer q or Q : "
                                ;;
                esac
        done
        return $yn
}


### What the script is for :
clear
echo $'\n\t\t' "-------------------------------------------------------" $'\n'
echo $'\t\t' "-This script is to be run to copy files from GParted-livecd running to usb stick. If your usb stick is not already mounted, this option will be considered in the next steps. I assume you have a usb stick formatted as FAT (or FAT32), with at least 55 MO free." $'\n'
echo $'\t\t' "-------------------------------------------------------" $'\n' 

### Forcing "yes" or "no" answer

function question
{
	#####
	#	Function to ask a yes/no question
	#	Arguments:
	#		1	prompt string (optional)
	#####

	local yn=

	while [ "$yn" = "" ]; do
		echo -en "$1"
		read yn
		case $yn in
			y|Y)	yn=0 
				echo $'\t' "-To built a Live USB stick we need to copy files to the usb stick." ;;
			n|N)	yn=1 
				echo $'\n\t' "So, we quite !" $'\n\t' "Bye ;)" $'\n'
				echo -n "(Type q + ENTER to quit)"
				quit
				;;
			*)	yn=
				echo -n $'\t' "Invalid response - please answer y or n : "
				;;
		esac
	done
	return $yn
}

echo -n "Is it okay ? (y/n) "$'\a'
question
### If usb stick is not already mounted, we quit ; if it does we copy needed files.
### On livecd running, the path is /mnt/cdrom/
echo $'\n\t' "-Therefor, your usb stick MUST be mounted." 

function mounted
{
	#####
	#	Function to ask a yes/no question
	#	Arguments:
	#		1	prompt string (optional)
	#####

	local yn=

	while [ "$yn" = "" ]; do
		echo -en "$1"
		read yn
		case $yn in
			y|Y)	yn=0 
				MOUNTTRUE=`mount | grep /mnt/usblive | awk '{ printf $3 }'`
				   if [  "$MOUNTTRUE" != "/mnt/usblive" ]
					then echo $'\t' "-You're wrong : nothing is mounted on /mnt/usblive !"
					      echo -n $'\n' "(Type q + ENTER, to quit) "
					      quit
				   fi
				echo $'\n\t' "So, let's copy the needed files to /mnt/usblive ;" $'\n\t' "it may take a minute or so :" $'\n'
				echo cp -f /mnt/cdrom/boot/gparted* /mnt/cdrom/syslinux/* /mnt/cdrom/gparted.dat /mnt/usblive/
				cp -f /mnt/cdrom/boot/gparted* /mnt/cdrom/syslinux/* /mnt/cdrom/gparted.dat /mnt/usblive/
				sync
				;;
			n|N)	yn=1 
				echo $'\n\t' "-Please, run the first script to mount your usb stick on /mnt/usblive !."$'\n'
				echo -n "(Type q + ENTER to quit) "
        			quit
             			;;
			*)	yn=
				echo -n $'\t' "Invalid response - please answer y or n : "
				;;
		esac
	done
	return $yn
}

echo -n $'\n\t' "-Is your USB stick already mounted on /mnt/usblive ? (y/n) "
mounted

### To be able to boot off usb, the key must be bootable :-p. Some users may don't want that, since there usb stick is already bootable.

function dosyslinux
{
	#####
	#	Function to ask a yes/no question
	#	Arguments:
	#		1	prompt string (optional)
	#####

	local yn=

	while [ "$yn" = "" ]; do
		echo -en "$1"
		read yn
		case $yn in
			y|Y)	yn=0 
				bootable ()
				{
				syslinux -s $device
				}
				device=`mount | grep /mnt/usblive | awk '{ print $1 }'`
				echo $'\n\t' "-The device your usb stick is attached to, is : $device ;" $'\n\t' "we now apply syslinux to it :"$'\n'
				echo $'\t\t' "syslinux -s $device"$'\n'
				umount /mnt/usblive
				rm -rf /mnt/usblive
				bootable 
				sleep 2	
				;;
			n|N)	yn=1 
				echo $'\n\t' "-Files have been copied to your usb stick, which have been umounted."$'\n'
				umount /mnt/usblive
				rm -rf /mnt/usblive
				echo -n "(Type q + ENTER, to quit) "
				quit
				;;
			*)	yn=
				echo -n $'\t' "Invalid response - please answer y or n : "
				;;
		esac
	done
	return $yn
}

echo -n $'\n\t' "-Do you want to make your usb stick bootable, if it doesn't ? (y/n) "
dosyslinux

### We end up with cool message ;)!
echo $'\n\t' "All is done ! Your usb stick is ready to be used with GParted-live !"

echo -n $'\n' "(Type q + ENTER, to quit) "
quit
