#!/bin/bash
# This example shows how to clone an image to 5 USB flash drives in a same machine by using Clonezilla live.
# Thanks to T. C. Lin <tclin _at_ mail dfes tpc edu tw> for this idea and testing.
# ///WARNING/// This program is really dangerous! You have to know what you are doing!

# First we assume we save sdb as an image called "usb_4GB_20081217", then we can create another 4 temp images using linking by:
#  create-ocs-tmp-img usb_4GB_20081217 usb_4GB_20081217_sdc sdb sdc
#  create-ocs-tmp-img usb_4GB_20081217 usb_4GB_20081217_sdd sdb sdd
#  create-ocs-tmp-img usb_4GB_20081217 usb_4GB_20081217_sde sdb sde
#  create-ocs-tmp-img usb_4GB_20081217 usb_4GB_20081217_sdf sdb sdf
#
#  //NOTE// the created images are default put in /tmp/, manually move them to /home/partimag by: mv /tmp/usb_4GB_20081217/* /home/partimag/

# Settings:
# To avoid mistake, we comment the target disks first. You have to uncomment it to make the following work.
# dsk="sdb sdc sdd sde sdf"
grub_part_no="4"  # e.g. The grub partition, /dev/sda4
image_name="usb_4GB_20081217"

# Create partition table first. If we do not do this first, sfdisk will wait for the lock to be released, so the 2nd clone won't start in any case.
for i in $dsk; do
  [ -z "$(grep -Ew "$i" /proc/partitions)" ] && continue
  echo "Creating the partition table for $i..."
  sfdisk --force /dev/$i < ${image_name}_${i}/${i}-pt.sf
done

for i in $dsk; do
  [ -z "$(grep -Ew "$i" /proc/partitions)" ] && continue
  echo "Restoring image for disk $i..."
  # use -k to skip sfdisk.
  ocs-sr -g /dev/${i}${grub_part_no} -k -nogui -b -r -p true restoredisk "${image_name}_${i}" "$i" &
done
