﻿// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
//
// Authors:
//        Antonello Provenzano  <antonello@deveel.com>
//        Federico Di Gregorio <fog@initd.org>

namespace System.Linq.Expressions
{
    [Serializable]
	public enum ExpressionType
	{
		Add,
		AddChecked,
		And,
		AndAlso,
		ArrayLength,
		ArrayIndex,
		Call,
		[Obsolete] CallVirtual,
		[Obsolete] Cast,
		Coalesce,
		Conditional,
		Constant,
		Convert,
		ConvertChecked,
		Divide,
		Equal,
		ExclusiveOr,
		Funclet,
		GreaterThan,
		GreaterThanOrEqual,
		Invoke,
		Lambda,
		LeftShift,
		LessThan,
		LessThanOrEqual,
		[Obsolete] Lift,
		[Obsolete] LiftEqual,
		[Obsolete] LiftFalse,
		[Obsolete] LiftNotEqual,
		[Obsolete] LiftTrue,
		ListInit,
		MemberAccess,
		MemberInit,
		Modulo,
		Multiply,
		MultiplyChecked,
		Negate,
		NegateChecked,
		New,
		NewArrayInit,
		NewArrayBounds,
		Not,
		NotEqual,
		Or,
		OrElse,
		Parameter,
		Quote,
		RightShift,
		Subtract,
		SubtractChecked,
		TypeAs,
		TypeIs    
    }
}
