/*
 *  Jajuk
 *  Copyright (C) 2005 The Jajuk Team
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *  $$Revision: 4470 $$
 */
package org.jajuk.ui.actions;

import java.awt.event.ActionEvent;

import javax.swing.SwingUtilities;

import org.jajuk.ui.wizard.AmbienceWizard;
import org.jajuk.util.IconLoader;
import org.jajuk.util.JajukIcons;
import org.jajuk.util.Messages;

/**
 * Action for configure ambiences
 */
public class AmbienceConfigurationAction extends JajukAction {

  private static final long serialVersionUID = 1L;

  AmbienceConfigurationAction() {
    super(Messages.getString("CommandJPanel.19"), IconLoader.getIcon(JajukIcons.STYLE), true);
  }

  @Override
  public void perform(ActionEvent evt) {

    /*
     * Display the ambience wizard in an invokeLater to allow a combo that show
     * it to close its popup
     */
    SwingUtilities.invokeLater(new Runnable() {

      public void run() {
        AmbienceWizard ambience = new AmbienceWizard();
        ambience.show();
      }

    });

  }
}
