%module mei

/*
  This file is part of the "Mathematical Expression Interpreter" library.

  Copyright (C) 2008-2009  EDF

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

%{
#include "mei_node.h"
#include "mei_evaluate.h"
%}

#ifdef SWIGPYTHON

/* Typemap to convert int[] to Python list */
/*-----------------------------------------*/

%typemap(out) int [ANY] {
  int i;
  $result = PyList_New($1_dim0);
  for (i = 0; i < $1_dim0; i++) {
    PyObject *o = PyInt_FromLong((int) $1[i]);
    PyList_SetItem($result,i,o);
  }
}


/* Typemap to convert char** to Python list */
/*------------------------------------------*/

%typemap(out) char ** {
  int len, i;
  len = 0;
  while ($1[len]) len++;
  $result = PyList_New(len);
  for (i = 0; i < len; i++) {
    PyList_SetItem($result, i, PyString_FromString($1[i]));
  }
}


/* Typemap to convert Python lists to char** */
/*-------------------------------------------*/

%typemap(in) char ** {
  int i, size;
  if (PyList_Check($input)) {
    size = PyList_Size($input);
    $1 = (char **) malloc((size+1)*sizeof(char *));
    for (i = 0; i < size; i++) {
      PyObject *o = PyList_GetItem($input,i);
      if (PyString_Check(o)) {
        $1[i] = PyString_AsString(PyList_GetItem($input,i));
      } else {
        PyErr_SetString(PyExc_TypeError, "List must contain strings");
        free($1);
        return NULL;
      }
    }
    $1[i] = 0;
  } else {
    PyErr_SetString(PyExc_TypeError, "Not a python list object");
    return NULL;
  }
}


/* This cleans up the char** array we malloc'd before the function call */
/*----------------------------------------------------------------------*/

%typemap(freearg) char ** {
  free((char *) $1);
}


/* Typemap to convert char** to Python list */
/*------------------------------------------*/

%typemap(out) char **labels {
  int len, i;
  len = 0;
  len = (arg1)->errors;
  /* while ($1[len]) len++; */
  $result = PyList_New(len);
  for (i = 0; i < len; i++) {
    PyList_SetItem($result, i, PyString_FromString($1[i]));
  }
}


/* Typemap to convert int* to Python list */
/*----------------------------------------*/

%typemap(out) int *lines, int *columns {
  int len, i;
  len = 0;
  /* while ($1[len]) len++; */
  len = (arg1)->errors;
  $result = PyList_New(len);
  for (i = 0; i < len; i++) {
    PyList_SetItem($result, i, PyInt_FromLong((int) $1[i]));
  }
}

#endif

%include "mei_hash_table.h"
%include "mei_node.h"
%include "mei_evaluate.h"

/*----------------------------------------------------------------------------*/

